/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.compat.kubejs;

import com.leclowndu93150.chisel.compat.kubejs.KubeJSHandler;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fml.ModList;

public class KubeJSCompat {
    private static final boolean KUBEJS_LOADED = ModList.get().isLoaded("kubejs");
    private static KubeJSHandler handler;

    private static KubeJSHandler getHandler() {
        if (handler == null && KUBEJS_LOADED) {
            handler = new KubeJSHandler();
        }
        return handler;
    }

    @Nullable
    public static Boolean shouldIncludeBlock(TagKey<Block> groupTag, Block block) {
        KubeJSHandler h = KubeJSCompat.getHandler();
        return h != null ? h.shouldIncludeBlock(groupTag, block) : null;
    }

    public static Set<ResourceLocation> getAdditionalBlocks(TagKey<Block> groupTag) {
        KubeJSHandler h = KubeJSCompat.getHandler();
        return h != null ? h.getAdditionalBlocks(groupTag) : Collections.emptySet();
    }

    public static boolean isGroupRemoved(ResourceLocation groupId) {
        KubeJSHandler h = KubeJSCompat.getHandler();
        return h != null && h.isGroupRemoved(groupId);
    }

    @Nullable
    public static TagKey<Block> getGroupForBlock(Block block) {
        KubeJSHandler h = KubeJSCompat.getHandler();
        return h != null ? h.getGroupForBlock(block) : null;
    }

    public static void clearCache() {
        KubeJSHandler h = KubeJSCompat.getHandler();
        if (h != null) {
            h.clearCache();
        }
    }

    public static Map<ResourceLocation, Set<ResourceLocation>> getCustomGroupsForJEI() {
        KubeJSHandler h = KubeJSCompat.getHandler();
        return h != null ? h.getCustomGroupsForJEI() : Collections.emptyMap();
    }

    public static boolean isLoaded() {
        return KUBEJS_LOADED;
    }
}

