/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.data;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LenientExistingFileHelper
extends ExistingFileHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(LenientExistingFileHelper.class);
    private final Set<String> missingResources = new HashSet<String>();

    public LenientExistingFileHelper(Collection<Path> existingPacks, Set<String> existingMods, boolean enable, @Nullable String assetIndex, @Nullable File assetsDir) {
        super(existingPacks, existingMods, enable, assetIndex, assetsDir);
    }

    public boolean exists(ResourceLocation loc, PackType packType) {
        boolean exists = super.exists(loc, packType);
        if (!exists) {
            String key = packType.name() + ":" + loc.toString();
            if (this.missingResources.add(key)) {
                LOGGER.warn("Missing {} resource: {}", (Object)packType.name(), (Object)loc);
            }
            return true;
        }
        return exists;
    }

    public boolean exists(ResourceLocation loc, ExistingFileHelper.IResourceType type) {
        boolean exists = super.exists(loc, type);
        if (!exists) {
            ResourceLocation fullLoc = ResourceLocation.fromNamespaceAndPath((String)loc.m_135827_(), (String)(type.getPrefix() + "/" + loc.m_135815_() + type.getSuffix()));
            String key = type.getPackType().name() + ":" + fullLoc.toString();
            if (this.missingResources.add(key)) {
                LOGGER.warn("Missing {} resource: {} (type: {})", new Object[]{type.getPackType().name(), fullLoc, type.getClass().getSimpleName()});
            }
            return true;
        }
        return exists;
    }

    public boolean exists(ResourceLocation loc, PackType packType, String pathSuffix, String pathPrefix) {
        boolean exists = super.exists(loc, packType, pathSuffix, pathPrefix);
        if (!exists) {
            ResourceLocation fullLoc = ResourceLocation.fromNamespaceAndPath((String)loc.m_135827_(), (String)(pathPrefix + "/" + loc.m_135815_() + pathSuffix));
            String key = packType.name() + ":" + fullLoc.toString();
            if (this.missingResources.add(key)) {
                LOGGER.warn("Missing {} resource: {}", (Object)packType.name(), (Object)fullLoc);
            }
            return true;
        }
        return exists;
    }

    public Set<String> getMissingResources() {
        return new HashSet<String>(this.missingResources);
    }

    public void printMissingSummary() {
        if (!this.missingResources.isEmpty()) {
            LOGGER.warn("========================================");
            LOGGER.warn("MISSING RESOURCES SUMMARY ({} total):", (Object)this.missingResources.size());
            LOGGER.warn("========================================");
            this.missingResources.stream().sorted().forEach(r -> LOGGER.warn("  - {}", r));
            LOGGER.warn("========================================");
        }
    }
}

