/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.data.provider;

import com.leclowndu93150.chisel.Chisel;
import com.leclowndu93150.chisel.api.block.ChiselBlockType;
import com.leclowndu93150.chisel.block.BlockCarvable;
import com.leclowndu93150.chisel.block.BlockCarvableGlass;
import com.leclowndu93150.chisel.init.ChiselBlocks;
import com.leclowndu93150.chisel.init.ChiselItems;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.RegistryObject;

public class ChiselRecipeProvider
extends RecipeProvider {
    public ChiselRecipeProvider(PackOutput output) {
        super(output);
    }

    protected void m_245200_(Consumer<FinishedRecipe> output) {
        this.buildToolRecipes(output);
        this.buildAutoChiselRecipe(output);
        this.buildFactoryRecipes(output);
        this.buildLaboratoryRecipes(output);
        this.buildAntiblockRecipes(output);
        this.buildBrownstoneRecipes(output);
        this.buildVoidstoneRecipes(output);
        this.buildCharcoalRecipes(output);
        this.buildHexplatingRecipes(output);
        this.buildFuturaRecipes(output);
        this.buildValentinesRecipes(output);
        this.buildCustomStoneRecipes(output);
        this.buildWaterstoneRecipes(output);
        this.buildLavastoneRecipes(output);
        this.buildIceRecipes(output);
        this.buildMiscellaneousRecipes(output);
        this.buildGlassRecipes(output);
        this.buildBookshelfRecipes(output);
        this.buildFantasyRecipes(output);
        this.buildWarningRecipes(output);
        this.buildHolystoneRecipes(output);
    }

    private void buildToolRecipes(Consumer<FinishedRecipe> output) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ChiselItems.IRON_CHISEL.get())).m_126130_(" I").m_126130_("S ").m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('S'), Tags.Items.RODS_WOODEN).m_126132_("has_iron", (CriterionTriggerInstance)ChiselRecipeProvider.m_206406_((TagKey)Tags.Items.INGOTS_IRON)).m_176498_(output);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ChiselItems.DIAMOND_CHISEL.get())).m_126130_(" D").m_126130_("S ").m_206416_(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).m_206416_(Character.valueOf('S'), Tags.Items.RODS_WOODEN).m_126132_("has_diamond", (CriterionTriggerInstance)ChiselRecipeProvider.m_206406_((TagKey)Tags.Items.GEMS_DIAMOND)).m_176498_(output);
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ChiselItems.HITECH_CHISEL.get())).m_126209_((ItemLike)ChiselItems.DIAMOND_CHISEL.get()).m_206419_(Tags.Items.INGOTS_GOLD).m_206419_(Tags.Items.DUSTS_REDSTONE).m_126132_("has_diamond_chisel", (CriterionTriggerInstance)ChiselRecipeProvider.m_125977_((ItemLike)((ItemLike)ChiselItems.DIAMOND_CHISEL.get()))).m_176498_(output);
    }

    private void buildAutoChiselRecipe(Consumer<FinishedRecipe> output) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ChiselItems.AUTO_CHISEL.get())).m_126130_("GGG").m_126130_("GRG").m_126130_("III").m_206416_(Character.valueOf('G'), Tags.Items.GLASS).m_206416_(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_126132_("has_redstone", (CriterionTriggerInstance)ChiselRecipeProvider.m_206406_((TagKey)Tags.Items.DUSTS_REDSTONE)).m_176498_(output);
    }

    private void buildFactoryRecipes(Consumer<FinishedRecipe> output) {
        if (ChiselBlocks.FACTORY.getBlock("dots") != null) {
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.FACTORY.getBlock("dots").get()), (int)32).m_126130_("SXS").m_126130_("X X").m_126130_("SXS").m_206416_(Character.valueOf('S'), Tags.Items.STONE).m_206416_(Character.valueOf('X'), Tags.Items.INGOTS_IRON).m_126132_("has_iron", (CriterionTriggerInstance)ChiselRecipeProvider.m_206406_((TagKey)Tags.Items.INGOTS_IRON)).m_126140_(output, Chisel.id("factory/dots"));
        }
    }

    private void buildLaboratoryRecipes(Consumer<FinishedRecipe> output) {
        if (ChiselBlocks.LABORATORY.getBlock("largesteel") != null) {
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.LABORATORY.getBlock("largesteel").get()), (int)8).m_126130_("SSS").m_126130_("SQS").m_126130_("SSS").m_126127_(Character.valueOf('S'), (ItemLike)Blocks.f_50069_).m_126127_(Character.valueOf('Q'), (ItemLike)Items.f_42692_).m_126132_("has_quartz", (CriterionTriggerInstance)ChiselRecipeProvider.m_125977_((ItemLike)Items.f_42692_)).m_126140_(output, Chisel.id("laboratory/largesteel"));
        }
    }

    private void buildAntiblockRecipes(Consumer<FinishedRecipe> output) {
        RegistryObject<BlockCarvable> block = ChiselBlocks.ANTIBLOCK.getBlock("white");
        if (block != null) {
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)block.get()), (int)8).m_126130_(" S ").m_126130_("SGS").m_126130_(" S ").m_206416_(Character.valueOf('S'), Tags.Items.STONE).m_126127_(Character.valueOf('G'), (ItemLike)Blocks.f_50141_).m_126132_("has_glowstone", (CriterionTriggerInstance)ChiselRecipeProvider.m_125977_((ItemLike)Blocks.f_50141_)).m_126140_(output, Chisel.id("antiblock/white"));
        }
    }

    private void buildBrownstoneRecipes(Consumer<FinishedRecipe> output) {
        if (ChiselBlocks.BROWNSTONE.getBlock("default") != null) {
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.BROWNSTONE.getBlock("default").get()), (int)4).m_126130_(" S ").m_126130_("SCS").m_126130_(" S ").m_206416_(Character.valueOf('S'), Tags.Items.SANDSTONE).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42461_).m_126132_("has_clay", (CriterionTriggerInstance)ChiselRecipeProvider.m_125977_((ItemLike)Items.f_42461_)).m_126140_(output, Chisel.id("brownstone/default"));
        }
    }

    private void buildVoidstoneRecipes(Consumer<FinishedRecipe> output) {
        if (ChiselBlocks.VOIDSTONE.getBlock("bevel") != null) {
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.VOIDSTONE.getBlock("bevel").get()), (int)16).m_126130_(" E ").m_126130_("OOO").m_126130_(" E ").m_126127_(Character.valueOf('E'), (ItemLike)Items.f_42545_).m_206416_(Character.valueOf('O'), Tags.Items.OBSIDIAN).m_126132_("has_ender_eye", (CriterionTriggerInstance)ChiselRecipeProvider.m_125977_((ItemLike)Items.f_42545_)).m_126140_(output, Chisel.id("voidstone/bevel_from_obsidian"));
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.VOIDSTONE.getBlock("bevel").get()), (int)48).m_126130_(" P ").m_126130_("PEP").m_126130_(" P ").m_126127_(Character.valueOf('E'), (ItemLike)Items.f_42545_).m_126127_(Character.valueOf('P'), (ItemLike)Blocks.f_50492_).m_126132_("has_purpur", (CriterionTriggerInstance)ChiselRecipeProvider.m_125977_((ItemLike)Blocks.f_50492_)).m_126140_(output, Chisel.id("voidstone/bevel_from_purpur"));
        }
    }

    private void buildCharcoalRecipes(Consumer<FinishedRecipe> output) {
        if (ChiselBlocks.CHARCOAL.getBlock("raw") != null) {
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.CHARCOAL.getBlock("raw").get())).m_126130_("CCC").m_126130_("CCC").m_126130_("CCC").m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42414_).m_126132_("has_charcoal", (CriterionTriggerInstance)ChiselRecipeProvider.m_125977_((ItemLike)Items.f_42414_)).m_126140_(output, Chisel.id("charcoal/raw"));
            ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.f_42414_, (int)9).m_126209_((ItemLike)ChiselBlocks.CHARCOAL.getBlock("raw").get()).m_126132_("has_charcoal_block", (CriterionTriggerInstance)ChiselRecipeProvider.m_125977_((ItemLike)((ItemLike)ChiselBlocks.CHARCOAL.getBlock("raw").get()))).m_126140_(output, Chisel.id("charcoal/raw_uncraft"));
        }
    }

    private void buildHexplatingRecipes(Consumer<FinishedRecipe> output) {
        for (DyeColor color : DyeColor.values()) {
            RegistryObject<BlockCarvable> block;
            ChiselBlockType<BlockCarvable> hexType = ChiselBlocks.HEX_PLATING.get(color);
            if (hexType == null || (block = hexType.getBlock("hexbase")) == null) continue;
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)block.get()), (int)8).m_126130_("SSS").m_126130_("SDS").m_126130_("NNN").m_206416_(Character.valueOf('S'), Tags.Items.STONE).m_206416_(Character.valueOf('D'), color.getTag()).m_206416_(Character.valueOf('N'), Tags.Items.NUGGETS_IRON).m_126132_("has_dye", (CriterionTriggerInstance)ChiselRecipeProvider.m_206406_((TagKey)color.getTag())).m_126140_(output, Chisel.id("hexplating/" + color.m_7912_() + "_hexbase"));
        }
    }

    private void buildFuturaRecipes(Consumer<FinishedRecipe> output) {
        if (ChiselBlocks.FUTURA.getBlock("controller") != null) {
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.FUTURA.getBlock("controller").get()), (int)8).m_126130_("IGI").m_126130_("GRG").m_126130_("IGI").m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_126127_(Character.valueOf('G'), (ItemLike)Blocks.f_50141_).m_206416_(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).m_126132_("has_glowstone", (CriterionTriggerInstance)ChiselRecipeProvider.m_125977_((ItemLike)Blocks.f_50141_)).m_126140_(output, Chisel.id("futura/controller"));
        }
    }

    private void buildValentinesRecipes(Consumer<FinishedRecipe> output) {
        if (ChiselBlocks.VALENTINES.getBlock("companion") != null) {
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.VALENTINES.getBlock("companion").get()), (int)8).m_126130_("WWW").m_126130_("WRW").m_126130_("WWW").m_126127_(Character.valueOf('W'), (ItemLike)Blocks.f_50100_).m_126127_(Character.valueOf('R'), (ItemLike)Blocks.f_50330_).m_126132_("has_redstone_block", (CriterionTriggerInstance)ChiselRecipeProvider.m_125977_((ItemLike)Blocks.f_50330_)).m_126140_(output, Chisel.id("valentines/companion"));
        }
    }

    private void buildCustomStoneRecipes(Consumer<FinishedRecipe> output) {
        if (ChiselBlocks.MARBLE.getBlock("raw") != null) {
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.MARBLE.getBlock("raw").get()), (int)4).m_126130_("SB").m_126130_("BS").m_126127_(Character.valueOf('S'), (ItemLike)Blocks.f_50069_).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42499_).m_126132_("has_bone_meal", (CriterionTriggerInstance)ChiselRecipeProvider.m_125977_((ItemLike)Items.f_42499_)).m_126140_(output, Chisel.id("marble/raw"));
        }
        if (ChiselBlocks.LIMESTONE.getBlock("raw") != null) {
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.LIMESTONE.getBlock("raw").get()), (int)4).m_126130_("SG").m_126130_("GS").m_126127_(Character.valueOf('S'), (ItemLike)Blocks.f_50069_).m_126127_(Character.valueOf('G'), (ItemLike)Blocks.f_49994_).m_126132_("has_gravel", (CriterionTriggerInstance)ChiselRecipeProvider.m_125977_((ItemLike)Blocks.f_49994_)).m_126140_(output, Chisel.id("limestone/raw"));
        }
    }

    private void buildWaterstoneRecipes(Consumer<FinishedRecipe> output) {
        if (ChiselBlocks.WATERSTONE.getBlock("cracked") != null) {
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.WATERSTONE.getBlock("cracked").get()), (int)8).m_126130_("SSS").m_126130_("SWS").m_126130_("SSS").m_206416_(Character.valueOf('S'), Tags.Items.STONE).m_126127_(Character.valueOf('W'), (ItemLike)Items.f_42447_).m_126132_("has_water_bucket", (CriterionTriggerInstance)ChiselRecipeProvider.m_125977_((ItemLike)Items.f_42447_)).m_126140_(output, Chisel.id("waterstone/cracked"));
        }
    }

    private void buildLavastoneRecipes(Consumer<FinishedRecipe> output) {
        if (ChiselBlocks.LAVASTONE.getBlock("cracked") != null) {
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.LAVASTONE.getBlock("cracked").get()), (int)8).m_126130_("SSS").m_126130_("SLS").m_126130_("SSS").m_206416_(Character.valueOf('S'), Tags.Items.STONE).m_126127_(Character.valueOf('L'), (ItemLike)Items.f_42448_).m_126132_("has_lava_bucket", (CriterionTriggerInstance)ChiselRecipeProvider.m_125977_((ItemLike)Items.f_42448_)).m_126140_(output, Chisel.id("lavastone/cracked"));
        }
    }

    private void buildIceRecipes(Consumer<FinishedRecipe> output) {
        if (ChiselBlocks.ICE.getBlock("cube") != null) {
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.ICE.getBlock("cube").get()), (int)8).m_126130_("III").m_126130_("I I").m_126130_("III").m_126127_(Character.valueOf('I'), (ItemLike)Items.f_42201_).m_126132_("has_packed_ice", (CriterionTriggerInstance)ChiselRecipeProvider.m_125977_((ItemLike)Items.f_42201_)).m_126140_(output, Chisel.id("ice/cube"));
        }
        if (ChiselBlocks.ICE_PILLAR.getBlock("plain") != null) {
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.ICE_PILLAR.getBlock("plain").get()), (int)8).m_126130_("III").m_126130_("I I").m_126130_("III").m_126127_(Character.valueOf('I'), (ItemLike)Items.f_41980_).m_126132_("has_ice", (CriterionTriggerInstance)ChiselRecipeProvider.m_125977_((ItemLike)Items.f_41980_)).m_126140_(output, Chisel.id("ice_pillar/plain"));
        }
    }

    private void buildMiscellaneousRecipes(Consumer<FinishedRecipe> output) {
        if (ChiselBlocks.CLOUD.getBlock("cloud") != null) {
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.CLOUD.getBlock("cloud").get()), (int)8).m_126130_("WWW").m_126130_("WPW").m_126130_("WWW").m_126127_(Character.valueOf('W'), (ItemLike)Items.f_41870_).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42714_).m_126132_("has_phantom_membrane", (CriterionTriggerInstance)ChiselRecipeProvider.m_125977_((ItemLike)Items.f_42714_)).m_126140_(output, Chisel.id("cloud/cloud"));
        }
        if (ChiselBlocks.FUTURA.getBlock("screen_metallic") != null) {
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.FUTURA.getBlock("screen_metallic").get()), (int)8).m_126130_("IGI").m_126130_("GRG").m_126130_("IGI").m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_126127_(Character.valueOf('G'), (ItemLike)Blocks.f_50141_).m_206416_(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).m_126132_("has_glowstone", (CriterionTriggerInstance)ChiselRecipeProvider.m_125977_((ItemLike)Blocks.f_50141_)).m_126140_(output, Chisel.id("futura/screen_metallic"));
        }
        if (ChiselBlocks.TECHNICAL.getBlock("scaffold") != null) {
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.TECHNICAL.getBlock("scaffold").get()), (int)16).m_126130_("I I").m_126130_("III").m_126130_("I I").m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_126132_("has_iron", (CriterionTriggerInstance)ChiselRecipeProvider.m_206406_((TagKey)Tags.Items.INGOTS_IRON)).m_126140_(output, Chisel.id("technical/scaffold"));
        }
        if (ChiselBlocks.TYRIAN.getBlock("tyrian") != null) {
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.TYRIAN.getBlock("tyrian").get()), (int)8).m_126130_("SPS").m_126130_("PEP").m_126130_("SPS").m_206416_(Character.valueOf('S'), Tags.Items.STONE).m_126127_(Character.valueOf('P'), (ItemLike)Blocks.f_50492_).m_126127_(Character.valueOf('E'), (ItemLike)Items.f_42545_).m_126132_("has_ender_eye", (CriterionTriggerInstance)ChiselRecipeProvider.m_125977_((ItemLike)Items.f_42545_)).m_126140_(output, Chisel.id("tyrian/tyrian"));
        }
        if (ChiselBlocks.VOIDSTONE_ENERGISED.getBlock("raw") != null) {
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.VOIDSTONE_ENERGISED.getBlock("raw").get()), (int)8).m_126130_("OOO").m_126130_("OGO").m_126130_("OOO").m_206416_(Character.valueOf('O'), Tags.Items.OBSIDIAN).m_126127_(Character.valueOf('G'), (ItemLike)Blocks.f_50141_).m_126132_("has_obsidian", (CriterionTriggerInstance)ChiselRecipeProvider.m_206406_((TagKey)Tags.Items.OBSIDIAN)).m_126140_(output, Chisel.id("energized_voidstone/raw"));
        }
        if (ChiselBlocks.VOIDSTONE_RUNIC.getBlock("raw") != null) {
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.VOIDSTONE_RUNIC.getBlock("raw").get()), (int)8).m_126130_("OOO").m_126130_("OEO").m_126130_("OOO").m_206416_(Character.valueOf('O'), Tags.Items.OBSIDIAN).m_126127_(Character.valueOf('E'), (ItemLike)Items.f_42545_).m_126132_("has_ender_eye", (CriterionTriggerInstance)ChiselRecipeProvider.m_125977_((ItemLike)Items.f_42545_)).m_126140_(output, Chisel.id("runic_voidstone/raw"));
        }
        if (ChiselBlocks.MARBLE_PILLAR.getBlock("pillar") != null) {
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.MARBLE_PILLAR.getBlock("pillar").get()), (int)4).m_126130_("SB").m_126130_("BS").m_126127_(Character.valueOf('S'), (ItemLike)Blocks.f_50069_).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42499_).m_126132_("has_bone_meal", (CriterionTriggerInstance)ChiselRecipeProvider.m_125977_((ItemLike)Items.f_42499_)).m_126140_(output, Chisel.id("marble_pillar/pillar"));
        }
        if (ChiselBlocks.PAPER.getBlock("box") != null) {
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.PAPER.getBlock("box").get())).m_126130_("PPP").m_126130_("PPP").m_126130_("PPP").m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42516_).m_126132_("has_paper", (CriterionTriggerInstance)ChiselRecipeProvider.m_125977_((ItemLike)Items.f_42516_)).m_126140_(output, Chisel.id("paper/box"));
        }
        if (ChiselBlocks.SANDSTONE_SCRIBBLES.getBlock("scribbles") != null) {
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.SANDSTONE_SCRIBBLES.getBlock("scribbles").get()), (int)4).m_126130_("SS").m_126130_("SS").m_206416_(Character.valueOf('S'), Tags.Items.SANDSTONE).m_126132_("has_sandstone", (CriterionTriggerInstance)ChiselRecipeProvider.m_206406_((TagKey)Tags.Items.SANDSTONE)).m_126140_(output, Chisel.id("sandstone_scribbles/scribbles"));
        }
        if (ChiselBlocks.RED_SANDSTONE_SCRIBBLES.getBlock("scribbles") != null) {
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.RED_SANDSTONE_SCRIBBLES.getBlock("scribbles").get()), (int)4).m_126130_("SS").m_126130_("SS").m_126127_(Character.valueOf('S'), (ItemLike)Blocks.f_50394_).m_126132_("has_red_sandstone", (CriterionTriggerInstance)ChiselRecipeProvider.m_125977_((ItemLike)Blocks.f_50394_)).m_126140_(output, Chisel.id("red_sandstone_scribbles/scribbles"));
        }
        if (ChiselBlocks.TEMPLE.getBlock("bricks") != null) {
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.TEMPLE.getBlock("bricks").get()), (int)4).m_126130_("SC").m_126130_("CS").m_126127_(Character.valueOf('S'), (ItemLike)Blocks.f_50222_).m_126127_(Character.valueOf('C'), (ItemLike)Blocks.f_50652_).m_126132_("has_stone_bricks", (CriterionTriggerInstance)ChiselRecipeProvider.m_125977_((ItemLike)Blocks.f_50222_)).m_126140_(output, Chisel.id("temple/bricks"));
        }
        if (ChiselBlocks.TEMPLE_MOSSY.getBlock("bricks") != null) {
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.TEMPLE_MOSSY.getBlock("bricks").get()), (int)4).m_126130_("SC").m_126130_("CS").m_126127_(Character.valueOf('S'), (ItemLike)Blocks.f_50223_).m_126127_(Character.valueOf('C'), (ItemLike)Blocks.f_50079_).m_126132_("has_mossy_stone_bricks", (CriterionTriggerInstance)ChiselRecipeProvider.m_125977_((ItemLike)Blocks.f_50223_)).m_126140_(output, Chisel.id("templemossy/bricks"));
        }
    }

    private void buildGlassRecipes(Consumer<FinishedRecipe> output) {
        for (DyeColor color : DyeColor.values()) {
            RegistryObject<BlockCarvableGlass> baseBlock;
            ChiselBlockType<BlockCarvableGlass> dyedGlassType = ChiselBlocks.GLASS_DYED.get(color);
            if (dyedGlassType == null || (baseBlock = dyedGlassType.getBlock("bubble")) == null) continue;
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)baseBlock.get()), (int)8).m_126130_("GGG").m_126130_("GDG").m_126130_("GGG").m_206416_(Character.valueOf('G'), Tags.Items.GLASS_COLORLESS).m_206416_(Character.valueOf('D'), color.getTag()).m_126132_("has_glass", (CriterionTriggerInstance)ChiselRecipeProvider.m_206406_((TagKey)Tags.Items.GLASS_COLORLESS)).m_126140_(output, Chisel.id("glassdyed/" + color.m_7912_() + "_bubble"));
        }
    }

    private void buildBookshelfRecipes(Consumer<FinishedRecipe> output) {
        String[] woodTypes;
        for (String woodType : woodTypes = new String[]{"spruce", "birch", "jungle", "acacia", "dark_oak", "mangrove", "cherry", "bamboo", "crimson", "warped"}) {
            RegistryObject<BlockCarvable> baseBlock;
            ChiselBlockType<BlockCarvable> bookshelfType = ChiselBlocks.BOOKSHELVES.get(woodType);
            if (bookshelfType == null || (baseBlock = bookshelfType.getBlock("rainbow")) == null) continue;
            Item slab = this.getSlabItem(woodType);
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)baseBlock.get())).m_126130_("SSS").m_126130_("BBB").m_126130_("SSS").m_126127_(Character.valueOf('S'), (ItemLike)slab).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42517_).m_126132_("has_book", (CriterionTriggerInstance)ChiselRecipeProvider.m_125977_((ItemLike)Items.f_42517_)).m_126140_(output, Chisel.id("bookshelf/" + woodType + "_rainbow"));
        }
    }

    private Item getSlabItem(String woodType) {
        return switch (woodType) {
            case "oak" -> Items.f_41914_;
            case "spruce" -> Items.f_41915_;
            case "birch" -> Items.f_41916_;
            case "jungle" -> Items.f_41917_;
            case "acacia" -> Items.f_41918_;
            case "dark_oak" -> Items.f_41919_;
            case "mangrove" -> Items.f_220183_;
            case "cherry" -> Items.f_271349_;
            case "bamboo" -> Items.f_243860_;
            case "crimson" -> Items.f_41920_;
            case "warped" -> Items.f_41921_;
            default -> Items.f_41914_;
        };
    }

    private void buildFantasyRecipes(Consumer<FinishedRecipe> output) {
        if (ChiselBlocks.FANTASY.getBlock("brick") != null) {
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.FANTASY.getBlock("brick").get()), (int)8).m_126130_("SSS").m_126130_("SGS").m_126130_("SSS").m_206416_(Character.valueOf('S'), Tags.Items.STONE).m_206416_(Character.valueOf('G'), Tags.Items.NUGGETS_GOLD).m_126132_("has_gold_nugget", (CriterionTriggerInstance)ChiselRecipeProvider.m_206406_((TagKey)Tags.Items.NUGGETS_GOLD)).m_126140_(output, Chisel.id("fantasy/brick"));
        }
        if (ChiselBlocks.FANTASY2.getBlock("brick") != null && ChiselBlocks.FANTASY.getBlock("brick") != null) {
            ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.FANTASY2.getBlock("brick").get())).m_126209_((ItemLike)ChiselBlocks.FANTASY.getBlock("brick").get()).m_206419_(Tags.Items.DYES_WHITE).m_126132_("has_fantasy", (CriterionTriggerInstance)ChiselRecipeProvider.m_125977_((ItemLike)((ItemLike)ChiselBlocks.FANTASY.getBlock("brick").get()))).m_126140_(output, Chisel.id("fantasy2/brick"));
        }
    }

    private void buildWarningRecipes(Consumer<FinishedRecipe> output) {
        if (ChiselBlocks.WARNING.getBlock("radiation") != null) {
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.WARNING.getBlock("radiation").get()), (int)4).m_126130_("SSS").m_126130_("SIS").m_126130_("SSS").m_206416_(Character.valueOf('S'), Tags.Items.STONE).m_126127_(Character.valueOf('I'), (ItemLike)Items.f_42438_).m_126132_("has_sign", (CriterionTriggerInstance)ChiselRecipeProvider.m_125977_((ItemLike)Items.f_42438_)).m_126140_(output, Chisel.id("warning/radiation"));
        }
    }

    private void buildHolystoneRecipes(Consumer<FinishedRecipe> output) {
        if (ChiselBlocks.HOLYSTONE.getBlock("raw") != null) {
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.HOLYSTONE.getBlock("raw").get()), (int)8).m_126130_("SSS").m_126130_("SFS").m_126130_("SSS").m_206416_(Character.valueOf('S'), Tags.Items.STONE).m_126127_(Character.valueOf('F'), (ItemLike)Items.f_42402_).m_126132_("has_feather", (CriterionTriggerInstance)ChiselRecipeProvider.m_125977_((ItemLike)Items.f_42402_)).m_126140_(output, Chisel.id("holystone/raw"));
        }
    }
}

