/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.event;

import com.leclowndu93150.chisel.api.chunkdata.ChunkData;
import com.leclowndu93150.chisel.api.chunkdata.OffsetData;
import com.leclowndu93150.chisel.network.ChiselNetwork;
import com.leclowndu93150.chisel.network.client.ChunkDataPacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.event.level.ChunkDataEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.ChunkWatchEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="chisel")
public class ChiselChunkEvents {
    @SubscribeEvent
    public static void onChunkSave(ChunkDataEvent.Save event) {
        ChunkAccess chunk = event.getChunk();
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof Level)) {
            return;
        }
        Level level = (Level)levelAccessor;
        if (level.m_5776_()) {
            return;
        }
        ChunkPos chunkPos = chunk.m_7697_();
        OffsetData data = ChunkData.getData(level, chunkPos);
        if (data != null && !data.isEmpty()) {
            CompoundTag tag = new CompoundTag();
            data.writeToNBT(tag);
            event.getData().m_128365_("chisel:offset_data", (Tag)tag);
        }
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkDataEvent.Load event) {
        ChunkAccess chunk = event.getChunk();
        Level level = (Level)event.getLevel();
        if (level == null || level.m_5776_()) {
            return;
        }
        CompoundTag tag = event.getData().m_128469_("chisel:offset_data");
        if (!tag.m_128456_()) {
            OffsetData data = new OffsetData();
            data.readFromNBT(tag);
            ChunkData.setData(level, chunk.m_7697_(), data);
        }
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        ChunkAccess chunk = event.getChunk();
        Level level = (Level)event.getLevel();
        if (level == null) {
            return;
        }
        if (level.m_5776_()) {
            ChunkData.removeData(level, chunk.m_7697_());
        }
    }

    @SubscribeEvent
    public static void onChunkSentToClient(ChunkWatchEvent.Watch event) {
        LevelChunk chunk;
        ChunkPos chunkPos;
        ServerLevel level = event.getLevel();
        OffsetData data = ChunkData.getData((Level)level, chunkPos = (chunk = event.getChunk()).m_7697_());
        if (data != null && !data.isEmpty()) {
            CompoundTag tag = new CompoundTag();
            data.writeToNBT(tag);
            ChiselNetwork.sendToPlayer(event.getPlayer(), new ChunkDataPacket(chunkPos.f_45578_, chunkPos.f_45579_, tag));
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            ChunkData.clearDataForLevel(level);
        }
    }
}

