/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.init;

import com.leclowndu93150.chisel.api.ChiselSound;
import com.leclowndu93150.chisel.api.block.ChiselBlockType;
import com.leclowndu93150.chisel.api.block.VariationData;
import com.leclowndu93150.chisel.block.BlockAutoChisel;
import com.leclowndu93150.chisel.block.BlockBrownstone;
import com.leclowndu93150.chisel.block.BlockCarvable;
import com.leclowndu93150.chisel.block.BlockCarvableGlass;
import com.leclowndu93150.chisel.block.BlockCarvablePane;
import com.leclowndu93150.chisel.block.BlockHolystone;
import com.leclowndu93150.chisel.client.sound.ChiselSoundTypes;
import com.leclowndu93150.chisel.data.ChiselModelTemplates;
import com.leclowndu93150.chisel.data.VariantTemplates;
import com.leclowndu93150.chisel.init.ChiselRegistries;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.registries.RegistryObject;

public class ChiselBlocks {
    public static final List<ChiselBlockType<?>> ALL_BLOCK_TYPES = new ArrayList();
    public static final ChiselBlockType<BlockCarvable> ALUMINUM = ChiselBlocks.registerType(new ChiselBlockType("metals/aluminum").groupName("Aluminum Block").addBlocksFromTag(ChiselBlocks.storageBlockTag("aluminum")).properties(() -> Blocks.f_50075_).mapColor(MapColor.f_283779_).tag((TagKey<Block>)BlockTags.f_13079_).tag((TagKey<Block>)BlockTags.f_144282_).tag((TagKey<Block>)BlockTags.f_144286_).variations(VariantTemplates.METAL).build());
    public static final ChiselBlockType<BlockCarvable> BRONZE = ChiselBlocks.registerType(new ChiselBlockType("metals/bronze").groupName("Bronze Block").addBlocksFromTag(ChiselBlocks.storageBlockTag("bronze")).properties(() -> Blocks.f_50075_).mapColor(MapColor.f_283895_).tag((TagKey<Block>)BlockTags.f_13079_).tag((TagKey<Block>)BlockTags.f_144282_).tag((TagKey<Block>)BlockTags.f_144285_).variations(VariantTemplates.METAL).build());
    public static final ChiselBlockType<BlockCarvable> COBALT = ChiselBlocks.registerType(new ChiselBlockType("metals/cobalt").groupName("Cobalt Block").addBlocksFromTag(ChiselBlocks.storageBlockTag("cobalt")).properties(() -> Blocks.f_50075_).mapColor(MapColor.f_283846_).tag((TagKey<Block>)BlockTags.f_13079_).tag((TagKey<Block>)BlockTags.f_144282_).tag((TagKey<Block>)BlockTags.f_144285_).variations(VariantTemplates.METAL).build());
    public static final ChiselBlockType<BlockCarvable> COPPER = ChiselBlocks.registerType(new ChiselBlockType("metals/copper").groupName("Copper Block").addBlocksFromTag(ChiselBlocks.storageBlockTag("copper")).properties(() -> Blocks.f_152504_).tag((TagKey<Block>)BlockTags.f_13079_).tag((TagKey<Block>)BlockTags.f_144282_).tag((TagKey<Block>)BlockTags.f_144286_).variations(VariantTemplates.METAL).build());
    public static final ChiselBlockType<BlockCarvable> ELECTRUM = ChiselBlocks.registerType(new ChiselBlockType("metals/electrum").groupName("Electrum Block").addBlocksFromTag(ChiselBlocks.storageBlockTag("electrum")).properties(() -> Blocks.f_50075_).mapColor(MapColor.f_283843_).tag((TagKey<Block>)BlockTags.f_13079_).tag((TagKey<Block>)BlockTags.f_144282_).tag((TagKey<Block>)BlockTags.f_144286_).variations(VariantTemplates.METAL).build());
    public static final ChiselBlockType<BlockCarvable> GOLD = ChiselBlocks.registerType(new ChiselBlockType("gold").groupName("Gold Block").addBlocksFromTag(ChiselBlocks.storageBlockTag("gold")).properties(() -> Blocks.f_50074_).mapColor(MapColor.f_283757_).tag((TagKey<Block>)BlockTags.f_13079_).tag((TagKey<Block>)BlockTags.f_144282_).tag((TagKey<Block>)BlockTags.f_144285_).variations(VariantTemplates.METAL).variations(VariantTemplates.METAL_TERRAIN).variation("cart", "Cart", ChiselModelTemplates.cubeBottomTop()).variation("star", "Stars", ChiselModelTemplates.cubeBottomTop()).variation("goldeye", "Goldeye").build());
    public static final ChiselBlockType<BlockCarvable> INVAR = ChiselBlocks.registerType(new ChiselBlockType("metals/invar").groupName("Invar Block").addBlocksFromTag(ChiselBlocks.storageBlockTag("invar")).properties(() -> Blocks.f_50075_).tag((TagKey<Block>)BlockTags.f_13079_).tag((TagKey<Block>)BlockTags.f_144282_).tag((TagKey<Block>)BlockTags.f_144286_).variations(VariantTemplates.METAL).build());
    public static final ChiselBlockType<BlockCarvable> IRON = ChiselBlocks.registerType(new ChiselBlockType("iron").groupName("Iron Block").addBlocksFromTag(ChiselBlocks.storageBlockTag("iron")).properties(() -> Blocks.f_50075_).tag((TagKey<Block>)BlockTags.f_13079_).tag((TagKey<Block>)BlockTags.f_144282_).tag((TagKey<Block>)BlockTags.f_144285_).variations(VariantTemplates.METAL).variations(VariantTemplates.METAL_TERRAIN).variation("moon", "Moon", ChiselModelTemplates.cubeBottomTop()).variation("vents", "Vents", ChiselModelTemplates.cubeColumn()).build());
    public static final ChiselBlockType<BlockCarvable> LEAD = ChiselBlocks.registerType(new ChiselBlockType("metals/lead").groupName("Lead Block").addBlocksFromTag(ChiselBlocks.storageBlockTag("lead")).properties(() -> Blocks.f_50075_).mapColor(MapColor.f_283791_).tag((TagKey<Block>)BlockTags.f_13079_).tag((TagKey<Block>)BlockTags.f_144282_).tag((TagKey<Block>)BlockTags.f_144286_).variations(VariantTemplates.METAL).build());
    public static final ChiselBlockType<BlockCarvable> NICKEL = ChiselBlocks.registerType(new ChiselBlockType("metals/nickel").groupName("Nickel Block").addBlocksFromTag(ChiselBlocks.storageBlockTag("nickel")).properties(() -> Blocks.f_50075_).mapColor(MapColor.f_283791_).tag((TagKey<Block>)BlockTags.f_13079_).tag((TagKey<Block>)BlockTags.f_144282_).tag((TagKey<Block>)BlockTags.f_144286_).variations(VariantTemplates.METAL).build());
    public static final ChiselBlockType<BlockCarvable> PLATINUM = ChiselBlocks.registerType(new ChiselBlockType("metals/platinum").groupName("Platinum Block").addBlocksFromTag(ChiselBlocks.storageBlockTag("platinum")).properties(() -> Blocks.f_50075_).mapColor(MapColor.f_283791_).tag((TagKey<Block>)BlockTags.f_13079_).tag((TagKey<Block>)BlockTags.f_144282_).tag((TagKey<Block>)BlockTags.f_144286_).variations(VariantTemplates.METAL).build());
    public static final ChiselBlockType<BlockCarvable> SILVER = ChiselBlocks.registerType(new ChiselBlockType("metals/silver").groupName("Silver Block").addBlocksFromTag(ChiselBlocks.storageBlockTag("silver")).properties(() -> Blocks.f_50075_).mapColor(MapColor.f_283779_).tag((TagKey<Block>)BlockTags.f_13079_).tag((TagKey<Block>)BlockTags.f_144282_).tag((TagKey<Block>)BlockTags.f_144286_).variations(VariantTemplates.METAL).build());
    public static final ChiselBlockType<BlockCarvable> STEEL = ChiselBlocks.registerType(new ChiselBlockType("metals/steel").groupName("Steel Block").addBlocksFromTag(ChiselBlocks.storageBlockTag("steel")).properties(() -> Blocks.f_50075_).mapColor(MapColor.f_283818_).tag((TagKey<Block>)BlockTags.f_13079_).tag((TagKey<Block>)BlockTags.f_144282_).tag((TagKey<Block>)BlockTags.f_144286_).variations(VariantTemplates.METAL).build());
    public static final ChiselBlockType<BlockCarvable> TIN = ChiselBlocks.registerType(new ChiselBlockType("metals/tin").groupName("Tin Block").addBlocksFromTag(ChiselBlocks.storageBlockTag("tin")).properties(() -> Blocks.f_50075_).mapColor(MapColor.f_283869_).tag((TagKey<Block>)BlockTags.f_13079_).tag((TagKey<Block>)BlockTags.f_144282_).tag((TagKey<Block>)BlockTags.f_144286_).variations(VariantTemplates.METAL).build());
    public static final ChiselBlockType<BlockCarvable> URANIUM = ChiselBlocks.registerType(new ChiselBlockType("metals/uranium").groupName("Uranium Block").addBlocksFromTag(ChiselBlocks.storageBlockTag("uranium")).properties(() -> Blocks.f_50075_).mapColor(MapColor.f_283856_).tag((TagKey<Block>)BlockTags.f_13079_).tag((TagKey<Block>)BlockTags.f_144282_).tag((TagKey<Block>)BlockTags.f_144286_).variations(VariantTemplates.METAL).build());
    public static final ChiselBlockType<BlockCarvable> ANDESITE = ChiselBlocks.registerType(new ChiselBlockType("andesite").addVanillaBlock(Blocks.f_50334_).addVanillaBlock(Blocks.f_50387_).properties(() -> Blocks.f_50334_).tag((TagKey<Block>)BlockTags.f_144282_).variations(VariantTemplates.ROCK).build());
    public static final ChiselBlockType<BlockCarvable> BASALT = ChiselBlocks.registerType(new ChiselBlockType("basalt").addVanillaBlock(Blocks.f_50137_).addVanillaBlock(Blocks.f_50138_).properties(() -> Blocks.f_50137_).tag((TagKey<Block>)BlockTags.f_144282_).variations(VariantTemplates.ROCK).build());
    public static final ChiselBlockType<BlockCarvable> BRICKS = ChiselBlocks.registerType(new ChiselBlockType("bricks").addVanillaBlock(Blocks.f_50076_).properties(() -> Blocks.f_50076_).tag((TagKey<Block>)BlockTags.f_144282_).variations(VariantTemplates.ROCK).build());
    public static final ChiselBlockType<BlockCarvable> COBBLESTONE = ChiselBlocks.registerType(new ChiselBlockType("cobblestone").addVanillaBlock(Blocks.f_50652_).properties(() -> Blocks.f_50652_).tag((TagKey<Block>)BlockTags.f_144282_).variations(VariantTemplates.COBBLESTONE).build());
    public static final ChiselBlockType<BlockCarvable> COBBLESTONE_MOSSY = ChiselBlocks.registerType(new ChiselBlockType("mossy_cobblestone").addVanillaBlock(Blocks.f_50079_).properties(() -> Blocks.f_50079_).tag((TagKey<Block>)BlockTags.f_144282_).variations(VariantTemplates.COBBLESTONE_MOSSY).build());
    public static final ChiselBlockType<BlockCarvable> DIORITE = ChiselBlocks.registerType(new ChiselBlockType("diorite").addVanillaBlock(Blocks.f_50228_).addVanillaBlock(Blocks.f_50281_).properties(() -> Blocks.f_50228_).tag((TagKey<Block>)BlockTags.f_144282_).variations(VariantTemplates.ROCK).build());
    public static final ChiselBlockType<BlockCarvable> ENDSTONE = ChiselBlocks.registerType(new ChiselBlockType("end_stone").addVanillaBlock(Blocks.f_50259_).addVanillaBlock(Blocks.f_50443_).properties(() -> Blocks.f_50259_).tag((TagKey<Block>)BlockTags.f_144282_).tag((TagKey<Block>)BlockTags.f_144286_).variations(VariantTemplates.ROCK).build());
    public static final ChiselBlockType<BlockCarvable> GRANITE = ChiselBlocks.registerType(new ChiselBlockType("granite").addVanillaBlock(Blocks.f_50122_).addVanillaBlock(Blocks.f_50175_).properties(() -> Blocks.f_50122_).tag((TagKey<Block>)BlockTags.f_144282_).variations(VariantTemplates.ROCK).build());
    public static final ChiselBlockType<BlockCarvable> PRISMARINE = ChiselBlocks.registerType(new ChiselBlockType("prismarine").addVanillaBlock(Blocks.f_50377_).addVanillaBlock(Blocks.f_50378_).addVanillaBlock(Blocks.f_50379_).properties(() -> Blocks.f_50377_).tag((TagKey<Block>)BlockTags.f_144282_).variations(VariantTemplates.ROCK).build());
    public static final ChiselBlockType<BlockCarvable> PURPUR = ChiselBlocks.registerType(new ChiselBlockType("purpur").addVanillaBlock(Blocks.f_50492_).addVanillaBlock(Blocks.f_50441_).properties(() -> Blocks.f_50492_).tag((TagKey<Block>)BlockTags.f_144282_).variations(VariantTemplates.ROCK).build());
    public static final ChiselBlockType<BlockCarvable> QUARTZ = ChiselBlocks.registerType(new ChiselBlockType("quartz").addVanillaBlock(Blocks.f_50333_).addVanillaBlock(Blocks.f_50283_).addVanillaBlock(Blocks.f_50282_).addVanillaBlock(Blocks.f_50472_).properties(() -> Blocks.f_50333_).tag((TagKey<Block>)BlockTags.f_144282_).variations(VariantTemplates.ROCK).build());
    public static final ChiselBlockType<BlockCarvable> SANDSTONE = ChiselBlocks.registerType(new ChiselBlockType("sandstone").addVanillaBlock(Blocks.f_50062_).addVanillaBlock(Blocks.f_50063_).addVanillaBlock(Blocks.f_50064_).addVanillaBlock(Blocks.f_50471_).properties(() -> Blocks.f_50062_).tag((TagKey<Block>)BlockTags.f_144282_).variations(VariantTemplates.ROCK).variation("extra/bevel_creeper", "Bevel Creeper").variation("extra/glyphs", "Glyphs").variation("extra/small", "Small").build());
    public static final ChiselBlockType<BlockCarvable> RED_SANDSTONE = ChiselBlocks.registerType(new ChiselBlockType("red_sandstone").addVanillaBlock(Blocks.f_50394_).addVanillaBlock(Blocks.f_50395_).addVanillaBlock(Blocks.f_50396_).addVanillaBlock(Blocks.f_50473_).properties(() -> Blocks.f_50394_).mapColor(MapColor.f_283750_).tag((TagKey<Block>)BlockTags.f_144282_).variations(VariantTemplates.ROCK).variation("extra/bevel_skeleton", "Bevel Skeleton").variation("extra/glyphs", "Glyphs").variation("extra/small", "Small").build());
    public static final ChiselBlockType<BlockCarvable> STONE_BRICKS = ChiselBlocks.registerType(new ChiselBlockType("stone_bricks").addVanillaBlock(Blocks.f_50069_).addVanillaBlock(Blocks.f_50222_).addVanillaBlock(Blocks.f_50225_).addVanillaBlock(Blocks.f_50224_).properties(() -> Blocks.f_50222_).tag((TagKey<Block>)BlockTags.f_144282_).variations(VariantTemplates.ROCK).variation("extra/largeornate", "Large Ornate").variation("extra/poison", "Poison").variation("extra/sunken", "Sunken").build());
    public static final ChiselBlockType<BlockCarvable> TERRACOTTA = ChiselBlocks.registerType(new ChiselBlockType("terracotta").addVanillaBlock(Blocks.f_50352_).properties(() -> Blocks.f_50352_).tag((TagKey<Block>)BlockTags.f_144282_).variations(VariantTemplates.ROCK).build());
    public static final ChiselBlockType<BlockCarvable> LIMESTONE = ChiselBlocks.registerType(new ChiselBlockType("limestone").properties(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283856_).m_60913_(1.0f, 5.0f).m_60918_(SoundType.f_56742_).m_60999_()).tag((TagKey<Block>)BlockTags.f_144282_).variation(VariantTemplates.RAW).variations(VariantTemplates.ROCK).build());
    public static final ChiselBlockType<BlockCarvable> MARBLE = ChiselBlocks.registerType(new ChiselBlockType("marble").properties(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283942_).m_60913_(1.75f, 10.0f).m_60918_(SoundType.f_56742_).m_60999_()).tag((TagKey<Block>)BlockTags.f_144282_).variation(VariantTemplates.RAW).variations(VariantTemplates.ROCK).build());
    public static final ChiselBlockType<BlockCarvable> DIABASE = ChiselBlocks.registerType(new ChiselBlockType("diabase").properties(() -> Blocks.f_50137_).tag((TagKey<Block>)BlockTags.f_144282_).tag((TagKey<Block>)BlockTags.f_144286_).variation(VariantTemplates.RAW).variations(VariantTemplates.ROCK).build());
    public static final ChiselBlockType<BlockCarvable> DIAMOND = ChiselBlocks.registerType(new ChiselBlockType("diamond").groupName("Diamond Block").addVanillaBlock(Blocks.f_50090_).properties(() -> Blocks.f_50090_).tag((TagKey<Block>)BlockTags.f_144282_).tag((TagKey<Block>)BlockTags.f_144285_).tag((TagKey<Block>)BlockTags.f_13079_).variation("terrain_diamond_embossed", "Embossed", ChiselModelTemplates.cubeColumn()).variation("terrain_diamond_gem", "Gem", ChiselModelTemplates.cubeColumn()).variation("terrain_diamond_cells", "Cells").variation("terrain_diamond_space", "Purple Space").variation("terrain_diamond_spaceblack", "Black Space").variation("terrain_diamond_simple", "Simple", ChiselModelTemplates.cubeColumn()).variation("terrain_diamond_bismuth", "Bismuth").variation("terrain_diamond_crushed", "Crushed").variation("terrain_diamond_four", "Tiles").variation("terrain_diamond_fourornate", "Ornate Tiles").variation("terrain_diamond_zelda", "Zelda").variation("terrain_diamond_ornatelayer", "Gold-Encrusted").build());
    public static final ChiselBlockType<BlockCarvable> EMERALD = ChiselBlocks.registerType(new ChiselBlockType("emerald").groupName("Emerald Block").addVanillaBlock(Blocks.f_50268_).properties(() -> Blocks.f_50268_).tag((TagKey<Block>)BlockTags.f_144282_).tag((TagKey<Block>)BlockTags.f_144285_).tag((TagKey<Block>)BlockTags.f_13079_).variation("panel", "Tile").variation("panelclassic", "Panel").variation("smooth", "Raw").variation("chunk", "Cobble").variation("goldborder", "Gold-Encrusted").variation("zelda", "Zelda").variation("cell", "Cell").variation("cellbismuth", "Cell Bismuth").variation("four", "Tiles").variation("fourornate", "Ornate Tiles").variation("ornate", "Ornate").variation("masonryemerald", "Masonry").variation("emeraldcircle", "Circular").variation("emeraldprismatic", "Prism").build());
    public static final ChiselBlockType<BlockCarvable> LAPIS = ChiselBlocks.registerType(new ChiselBlockType("lapis").groupName("Lapis Block").addVanillaBlock(Blocks.f_50060_).properties(() -> Blocks.f_50060_).tag((TagKey<Block>)BlockTags.f_144282_).tag((TagKey<Block>)BlockTags.f_144286_).variation("terrain_lapisblock_chunky", "Cobble").variation("terrain_lapisblock_panel", "Tile").variation("terrain_lapisblock_zelda", "Zelda").variation("terrain_lapisornate", "Wood-Framed").variation("terrain_lapistile", "Panel").variation("a1_blocklapis_panel", "Shiny Panel").variation("a1_blocklapis_smooth", "Raw").variation("a1_blocklapis_ornatelayer", "Gold-Encrusted").variation("masonrylapis", "Masonry").build());
    public static final ChiselBlockType<BlockCarvable> REDSTONE = ChiselBlocks.registerType(new ChiselBlockType("redstone").groupName("Redstone Block").addVanillaBlock(Blocks.f_50330_).properties(() -> Blocks.f_50330_).tag((TagKey<Block>)BlockTags.f_144282_).variations(VariantTemplates.STONE).build());
    public static final ChiselBlockType<BlockCarvable> GLOWSTONE = ChiselBlocks.registerType(new ChiselBlockType("glowstone").addVanillaBlock(Blocks.f_50141_).properties(() -> Blocks.f_50141_).variations(VariantTemplates.STONE).variation("extra/bismuth", "Bismuth").variation("extra/tiles_large_bismuth", "Tiles Large Bismuth").variation("extra/tiles_medium_bismuth", "Tiles Medium Bismuth").variation("extra/neon", "Neon").variation("extra/neon_panel", "Neon Panel").build());
    public static final ChiselBlockType<BlockCarvable> COAL = ChiselBlocks.registerType(new ChiselBlockType("coal").addVanillaBlock(Blocks.f_50353_).properties(() -> Blocks.f_50353_).tag((TagKey<Block>)BlockTags.f_144282_).tag((TagKey<Block>)BlockTags.f_144286_).variation(VariantTemplates.RAW).variations(VariantTemplates.ROCK).build());
    public static final ChiselBlockType<BlockCarvable> CHARCOAL = ChiselBlocks.registerType(new ChiselBlockType("charcoal").properties(() -> Blocks.f_50353_).tag((TagKey<Block>)BlockTags.f_144282_).tag((TagKey<Block>)BlockTags.f_144286_).variation(VariantTemplates.RAW).variations(VariantTemplates.ROCK).build());
    public static final ChiselBlockType<BlockCarvableGlass> ICE = ChiselBlocks.registerType(new ChiselBlockType("ice").addVanillaBlock(Blocks.f_50354_).properties(() -> Blocks.f_50354_).tag((TagKey<Block>)BlockTags.f_144282_).tag((TagKey<Block>)BlockTags.f_13047_).variations(VariantTemplates.ROCK).build());
    public static final ChiselBlockType<BlockCarvableGlass> ICE_PILLAR = ChiselBlocks.registerType(new ChiselBlockType("icepillar").addVanillaBlock(Blocks.f_50126_).properties(() -> Blocks.f_50126_).tag((TagKey<Block>)BlockTags.f_144282_).tag((TagKey<Block>)BlockTags.f_13047_).variations(VariantTemplates.PILLAR).build());
    public static final ChiselBlockType<BlockCarvable> ANTIBLOCK = ChiselBlocks.registerType(new ChiselBlockType("antiblock").properties(() -> Blocks.f_50069_).mapColor(MapColor.f_283913_).tag((TagKey<Block>)BlockTags.f_144282_).variations(VariantTemplates.ANTIBLOCK).build());
    public static final ChiselBlockType<BlockBrownstone> BROWNSTONE = ChiselBlocks.registerType(new ChiselBlockType<BlockBrownstone>("brownstone", (props, data) -> new BlockBrownstone((BlockBehaviour.Properties)props, (VariationData)data, "brownstone")).properties(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_60978_(1.0f)).tag((TagKey<Block>)BlockTags.f_144282_).variation("default", "Raw").variation("block", "Big Tiled").variation("blocks", "Tiled").variation("doubleslab", "Bisected", ChiselModelTemplates.cubeColumn("doubleslab-side", "block")).variation("weathered", "Weathered").variation("weathered_block", "Weathered Big Tile").variation("weathered_doubleslab", "Weathered Bisected", ChiselModelTemplates.cubeColumn("weathered_doubleslab-side", "weathered_block")).variation("weathered_blocks", "Weathered Tiles").variation("weathered_half", "Half-Weathered", ChiselModelTemplates.cubeBottomTop("weathered_half-side", "default", "weathered")).variation("weathered_block_half", "Half-Weathered Big Tile", ChiselModelTemplates.cubeBottomTop("weathered_block_half-side", "block", "weathered_block")).build());
    public static final ChiselBlockType<BlockCarvableGlass> CLOUD = ChiselBlocks.registerType(new ChiselBlockType<BlockCarvableGlass>("cloud", (props, data) -> new BlockCarvableGlass((BlockBehaviour.Properties)props, (VariationData)data, "cloud")).properties(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56745_).m_155956_(0.3f).m_60955_()).defaultModelTemplate(ChiselModelTemplates.simpleBlockCutout()).variation("cloud", "Cloud").variation("large", "Bricks").variation("small", "Small Bricks").variation("vertical", "Vertical Bricks").variation("grid", "Small Tiles").build());
    public static final ChiselBlockType<BlockCarvable> FACTORY = ChiselBlocks.registerType(new ChiselBlockType("factory").properties(() -> Blocks.f_50075_).mapColor(MapColor.f_283774_).sound(ChiselSoundTypes.METAL_SUPPLIER).tag((TagKey<Block>)BlockTags.f_144282_).tag((TagKey<Block>)BlockTags.f_144286_).variation("dots", "Dotted Rusty Plate").variation("rust2", "Rusty Plate").variation("rust", "Rusty Plate").variation("platex", "Slightly Rusty Plate").variation("wireframewhite", "Wireframe").variation("wireframe", "Purple Wireframe").variation("hazard", "Yellow-Black Caution Stripes").variation("hazardorange", "Orange-White Caution Stripes").variation("circuit", "Circuit").variation("metalbox", "Metal Box", ChiselModelTemplates.cubeColumn()).variation("goldplate", "Gold-Plated Circuit").variation("goldplating", "Gold-Framed Purple Plates").variation("grinder", "Grinder").variation("plating", "Old Vents").variation("rustplates", "Segmented Rusty Plates").variation("column", "Metal Column", ChiselModelTemplates.cubeColumn()).variation("frameblue", "Blue-Framed Circuit").variation("iceiceice", "Ice Ice Ice").variation("tilemosaic", "Blue Circuits").variation("vent", "Vents", ChiselModelTemplates.cubeColumn()).variation("wireframeblue", "Blue Wireframe").build());
    public static final ChiselBlockType<BlockCarvable> FUTURA = ChiselBlocks.registerType(new ChiselBlockType("futura").properties(() -> Blocks.f_50069_).mapColor(MapColor.f_283832_).sound(ChiselSoundTypes.METAL_SUPPLIER).tag((TagKey<Block>)BlockTags.f_144282_).variation("screen_metallic", "Gray Screen", ChiselModelTemplates.twoLayerTopShaded("screen_metallic", "screen_discoherent")).variation("screen_cyan", "Cyan Screen", ChiselModelTemplates.twoLayerTopShaded("screen_cyan", "screen_discoherent")).variation("controller", "ME Controller", ChiselModelTemplates.threeLayerTopShaded("controller_particle", "lines_plating", "rainbow_lines", "lines_invalid")).variation("wavy", "Rainbowliciously Wavy", ChiselModelTemplates.twoLayerTopShaded("rainbow_wave_particle", "rainbow_wave_base", "rainbow_wave")).variation("controller_purple", "Purple ME Controller", ChiselModelTemplates.threeLayerTopShaded("controller_unity_particle", "unity_lines_plating", "unity_lines", "lines_invalid")).variation("uber_wavy", "Fabulously Wavy", ChiselModelTemplates.threeLayerTopShaded("orange_frame_particle", "orange_frame", "uber_rainbow", "screen_discoherent")).build());
    public static final ChiselBlockType<BlockCarvable> LABORATORY = ChiselBlocks.registerType(new ChiselBlockType("laboratory").properties(() -> Blocks.f_50069_).mapColor(MapColor.f_283811_).sound(ChiselSoundTypes.METAL_SUPPLIER).tag((TagKey<Block>)BlockTags.f_144282_).variation("wallpanel", "Wall Panel").variation("dottedpanel", "Dotted Panel").variation("roundel", "Roundel").variation("wallvents", "Wall Vents", ChiselModelTemplates.cubeColumn()).variation("largetile", "Large Tile").variation("smalltile", "Small Tile").variation("floortile", "Floor Tile").variation("checkertile", "Checker Tile").variation("fuzzscreen", "Fuzz Screen").variation("largesteel", "Large Steel", ChiselModelTemplates.cubeColumn()).variation("smallsteel", "Small Steel", ChiselModelTemplates.cubeColumn()).variation("directionleft", "Direction Left", ChiselModelTemplates.cubeColumn()).variation("directionright", "Direction Right", ChiselModelTemplates.cubeColumn()).variation("infocon", "Info Console", ChiselModelTemplates.cubeColumn()).build());
    public static final ChiselBlockType<BlockCarvable> TECHNICAL = ChiselBlocks.registerType(new ChiselBlockType("technical").properties(() -> Blocks.f_50075_).mapColor(MapColor.f_283907_).sound(ChiselSoundTypes.METAL_SUPPLIER).tag((TagKey<Block>)BlockTags.f_144282_).tag((TagKey<Block>)BlockTags.f_144286_).variation("scaffold", "Rusty Scaffold").variation("cautiontape", "Caution-Framed Plates").variation("industrialrelic", "Industrial Relic").variation("pipeslarge", "Large Pipes").variation("fanfast", "Fan (Fast)", ChiselModelTemplates.cubeColumn()).variation("pipessmall", "Small Pipes").variation("fanstill", "Fan (Off)", ChiselModelTemplates.cubeColumn()).variation("vent", "Vent").variation("ventglowing", "Glowing Vent").variation("insulationv2", "Insulation").variation("spinningstuffanim", "Gears & Flywheels").variation("cables", "Cables").variation("rustyboltedplates", "Rusty Bolted Plates").variation("grate", "Grate").variation("malfunctionfan", "Fan (Malfunctioning)", ChiselModelTemplates.cubeColumn()).variation("graterusty", "Rusty Grate").variation("scaffoldtransparent", "Rusty Scaffold - Transparent").variation("fanfasttransparent", "Fan (Fast) - Transparent", ChiselModelTemplates.cubeColumn()).variation("fanstilltransparent", "Fan (Still) - Transparent", ChiselModelTemplates.cubeColumn()).variation("massivefan", "Massive Fan").variation("massivehexplating", "Massive Hexagonal Plating").variation("weatheredgreenpanels", "Extremely Corroded Panels").variation("weatheredorangepanels", "Extremely Rusted Panels").variation("sturdy", "Sturdy").variation("megacell", "Megacell Battery", ChiselModelTemplates.cubeBottomTop()).variation("exhaustplating", "Exhaust Plating").variation("makeshiftpanels", "Sloppy Plating").variation("engineering", "Engineer's Pipes").variation("scaffoldlarge", "Large Rusty Scaffold").variation("piping", "Pipes").variation("oldetimeyserveranim", "Oldetimey Server").variation("tapedrive", "Tape Drive").build());
    public static final ChiselBlockType<BlockCarvable> TYRIAN = ChiselBlocks.registerType(new ChiselBlockType("tyrian").properties(() -> Blocks.f_50075_).mapColor(MapColor.f_283846_).sound(ChiselSoundTypes.METAL_SUPPLIER).tag((TagKey<Block>)BlockTags.f_144282_).tag((TagKey<Block>)BlockTags.f_144286_).variation("shining", "Disordered Metal Bits").variation("tyrian", "Metal Plates").variation("chaotic", "Disordered Purple Bits").variation("softplate", "Purple Plates").variation("rust", "Rust").variation("elaborate", "Shiny Plates").variation("routes", "Routes").variation("platform", "Platform").variation("platetiles", "Small Uneven Tiles").variation("diagonal", "Diagonal Plates").variation("dent", "Dent").variation("blueplating", "Blue Plates").variation("black", "Black Scaled Plates").variation("black2", "Black Strips").variation("opening", "Opening").variation("plate", "Shiny Plate").build());
    public static final ChiselBlockType<BlockCarvable> VALENTINES = ChiselBlocks.registerType(new ChiselBlockType("valentines").properties(BlockBehaviour.Properties.m_284310_().m_60913_(1.5f, 20.0f).m_60918_(SoundType.f_56742_)).variation("1", "Pink Marker").variation("2", "Gray Rocky").variation("3", "Pink Heart").variation("4", "Pink Rocky").variation("5", "Pink Tile").variation("6", "Pink Cracks").variation("7", "Pink Studded").variation("8", "Flame").variation("9", "Pink Steel").variation("companion", "Companion Cube").build());
    public static final ChiselBlockType<BlockCarvable> FANTASY = ChiselBlocks.registerType(new ChiselBlockType("fantasy").groupName("Fantasy Block").properties(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60913_(2.0f, 10.0f).m_60918_(SoundType.f_56742_).m_60999_()).tag((TagKey<Block>)BlockTags.f_144282_).variations(VariantTemplates.FANTASY).build());
    public static final ChiselBlockType<BlockCarvable> FANTASY2 = ChiselBlocks.registerType(new ChiselBlockType("fantasy2").groupName("Fantasy Block 2").properties(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283942_).m_60913_(2.0f, 10.0f).m_60918_(SoundType.f_56742_).m_60999_()).tag((TagKey<Block>)BlockTags.f_144282_).variations(VariantTemplates.FANTASY).build());
    public static final ChiselBlockType<BlockCarvable> WARNING = ChiselBlocks.registerType(new ChiselBlockType("warning").groupName("Warning Sign").properties(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283832_).m_60913_(2.0f, 10.0f).m_60918_(SoundType.f_56743_).m_60999_()).tag((TagKey<Block>)BlockTags.f_144282_).variations(VariantTemplates.WARNING).build());
    public static final ChiselBlockType<BlockHolystone> HOLYSTONE = ChiselBlocks.registerType(new ChiselBlockType<BlockHolystone>("holystone", (props, data) -> new BlockHolystone((BlockBehaviour.Properties)props, (VariationData)data, "holystone")).groupName("Holystone").properties(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283942_).m_60913_(2.0f, 10.0f).m_60953_(state -> 4).m_60999_()).sound(ChiselSoundTypes.HOLYSTONE_SUPPLIER).tag((TagKey<Block>)BlockTags.f_144282_).variations(VariantTemplates.HOLYSTONE).build());
    public static final ChiselBlockType<BlockCarvable> VOIDSTONE = ChiselBlocks.registerType(new ChiselBlockType("voidstone").properties(() -> Blocks.f_50080_).tag((TagKey<Block>)BlockTags.f_144282_).tag((TagKey<Block>)BlockTags.f_144286_).variation(VariantTemplates.RAW).variation("quarters", "Medium Tiles").variation("smooth", "Smooth").variation("skulls", "Skulls").variation("rune", "Rune").variation("metalborder", "Metallic").variation("eye", "Eye").variation("bevel", "Bevel").build());
    public static final ChiselBlockType<BlockCarvable> VOIDSTONE_ENERGISED = ChiselBlocks.registerType(new ChiselBlockType("voidstonerunic_anim").groupName("Energised Voidstone").properties(() -> Blocks.f_50080_).tag((TagKey<Block>)BlockTags.f_144282_).tag((TagKey<Block>)BlockTags.f_144286_).variation("raw", "Raw", ChiselModelTemplates.twoLayerTopShaded("raw", "background")).variation("quarters", "Medium Tiles", ChiselModelTemplates.twoLayerTopShaded("quarters", "background")).variation("smooth", "Smooth", ChiselModelTemplates.twoLayerTopShaded("smooth", "background")).variation("skulls", "Skulls", ChiselModelTemplates.twoLayerTopShaded("skulls", "background")).variation("rune", "Rune", ChiselModelTemplates.twoLayerTopShaded("rune", "background")).variation("metalborder", "Metallic", ChiselModelTemplates.twoLayerTopShaded("metalborder", "background")).variation("eye", "Eye", ChiselModelTemplates.twoLayerTopShaded("eye", "background")).variation("bevel", "Bevel", ChiselModelTemplates.twoLayerTopShaded("bevel", "background")).build());
    public static final ChiselBlockType<BlockCarvable> VOIDSTONE_RUNIC = ChiselBlocks.registerType(new ChiselBlockType("voidstonerunic").groupName("Runic Voidstone").properties(() -> Blocks.f_50080_).tag((TagKey<Block>)BlockTags.f_144282_).tag((TagKey<Block>)BlockTags.f_144286_).variation("black", "Black").variation("red", "Red").variation("green", "Green").variation("brown", "Brown").variation("blue", "Blue").variation("purple", "Purple").variation("cyan", "Cyan").variation("lightgray", "Light Gray").variation("pink", "Pink").variation("lime", "Lime").variation("yellow", "Yellow").variation("lightblue", "Light Blue").variation("magenta", "Magenta").variation("orange", "Orange").build());
    public static final ChiselBlockType<BlockCarvable> LAVASTONE = ChiselBlocks.registerType(new ChiselBlockType("lavastone").properties(BlockBehaviour.Properties.m_284310_().m_60913_(4.0f, 50.0f).m_60918_(SoundType.f_56742_).m_60953_(state -> 15)).tag((TagKey<Block>)BlockTags.f_144282_).variations(VariantTemplates.LAVASTONE).build());
    public static final ChiselBlockType<BlockCarvable> WATERSTONE = ChiselBlocks.registerType(new ChiselBlockType("waterstone").properties(BlockBehaviour.Properties.m_284310_().m_60913_(4.0f, 50.0f).m_60918_(SoundType.f_56742_)).tag((TagKey<Block>)BlockTags.f_144282_).tag((TagKey<Block>)BlockTags.f_144286_).variations(VariantTemplates.WATERSTONE).build());
    public static final ChiselBlockType<BlockCarvable> DIRT = ChiselBlocks.registerType(new ChiselBlockType("dirt").addVanillaBlock(Blocks.f_50493_).properties(BlockBehaviour.Properties.m_284310_().m_60913_(0.5f, 0.0f).m_60918_(SoundType.f_56739_)).chiselSound(ChiselSound.DIRT).tag((TagKey<Block>)BlockTags.f_144283_).variation("bricks", "Bricks").variation("netherbricks", "Nether Bricks").variation("bricks3", "Small Bricks").variation("cobble", "Cobble").variation("reinforcedcobbledirt", "Reinforced Cobble").variation("reinforceddirt", "Reinforced Dirt").variation("happy", "Happy Souls").variation("bricks2", "Disordered Bricks").variation("bricks_dirt2", "Brick-Topped Dirt").variation("hor", "Horizontal Streaks", ChiselModelTemplates.cubeColumn("hor-ctmh", "hor-top")).variation("vert", "Vertical Streaks").variation("layers", "Layers").variation("vertical", "Vertical Layers").variation("chunky", "Chunky").variation("horizontal", "Horizontal").variation("plate", "Plate").build());
    public static final ChiselBlockType<BlockCarvableGlass> GLASS = ChiselBlocks.registerType(new ChiselBlockType<BlockCarvableGlass>("glass", (props, data) -> new BlockCarvableGlass((BlockBehaviour.Properties)props, (VariationData)data, "glass")).addVanillaBlock(Blocks.f_50058_).properties(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56744_).m_155956_(0.3f).m_60955_()).defaultModelTemplate(ChiselModelTemplates.simpleBlockCutout()).variation("terrain_glassbubble", "Bubble").variation("japanese", "Japanese").variation("terrain_glassdungeon", "Dungeon").variation("terrain_glasslight", "Light").variation("terrain_glassnoborder", "Gray-Bordered").variation("terrain_glass_ornatesteel", "Ornate Steel").variation("terrain_glass_screen", "Screen").variation("terrain_glassshale", "Shale").variation("terrain_glass_steelframe", "Steel-Framed").variation("terrain_glassstone", "Stone-Framed").variation("terrain_glassstreak", "Streaks").variation("terrain_glass_thickgrid", "Thick Grid").variation("terrain_glass_thingrid", "Thin Grid").variation("a1_glasswindow_ironfencemodern", "Iron Fence").variation("chrono", "Asymmetrical Leaded Glass").variation("chinese2", "Chinese").variation("japanese2", "Japanese 2").build());
    public static final ChiselBlockType<BlockCarvable> MARBLE_PILLAR = ChiselBlocks.registerType(new ChiselBlockType("marblepillar").groupName("Marble Pillar").properties(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283942_).m_60913_(1.75f, 10.0f).m_60918_(SoundType.f_56742_)).tag((TagKey<Block>)BlockTags.f_144282_).variations(VariantTemplates.PILLAR).variation("simple", "Simple Pillar", ChiselModelTemplates.columnPillar()).variation("rough", "Rough", ChiselModelTemplates.columnPillar()).variation("widedecor", "Decor-Capped Wide Pillar", ChiselModelTemplates.columnPillar()).variation("widegreek", "Greek-Capped Wide Pillar", ChiselModelTemplates.columnPillar()).variation("wideplain", "Plain-Capped Wide Pillar", ChiselModelTemplates.columnPillar()).variation("pillar", "Large Pillar", ChiselModelTemplates.columnPillar()).variation("default", "Small-Concaved Pillar", ChiselModelTemplates.columnPillar()).build());
    public static final ChiselBlockType<BlockCarvable> NETHERBRICK = ChiselBlocks.registerType(new ChiselBlockType("netherbrick").addVanillaBlock(Blocks.f_50197_).addVanillaBlock(Blocks.f_50712_).properties(() -> Blocks.f_50197_).tag((TagKey<Block>)BlockTags.f_144282_).variation("a1_netherbrick_brinstar", "Blue").variation("a1_netherbrick_classicspatter", "Blood-Spattered").variation("a1_netherbrick_guts", "Meat Bricks").variation("a1_netherbrick_gutsdark", "Dark Meat Bricks").variation("a1_netherbrick_gutssmall", "Small Meat Bricks").variation("a1_netherbrick_lavabrinstar", "Blue Lava Brick").variation("a1_netherbrick_lavabrown", "Brown Lava Brick").variation("a1_netherbrick_lavaobsidian", "Dark Lava Brick").variation("a1_netherbrick_lavastonedark", "Stone Lava Brick").variation("a1_netherbrick_meat", "Nether Brick made of Meat").variation("a1_netherbrick_meatred", "Red Nether Brick made of Meat").variation("a1_netherbrick_meatredsmall", "Small Nether Brick made of Meat").variation("a1_netherbrick_meatsmall", "Small Red Nether Brick made of Meat").variation("a1_netherbrick_red", "Red Nether Brick").variation("a1_netherbrick_redsmall", "Small Red Nether Brick").variation("netherfancybricks", "Disordered Nether Bricks").build());
    public static final ChiselBlockType<BlockCarvable> NETHERRACK = ChiselBlocks.registerType(new ChiselBlockType("netherrack").addVanillaBlock(Blocks.f_50134_).properties(() -> Blocks.f_50134_).tag((TagKey<Block>)BlockTags.f_144282_).variation("a1_netherrack_bloodgravel", "Streaked").variation("a1_netherrack_bloodrock", "Red Rock").variation("a1_netherrack_bloodrockgrey", "Gray Rock").variation("a1_netherrack_brinstar", "Blue Streaked").variation("a1_netherrack_brinstarshale", "Blue Shale").variation("a1_netherrack_classic", "Rocky").variation("a1_netherrack_classicspatter", "Blood-Splatted Rocky").variation("a1_netherrack_guts", "Raw Guts").variation("a1_netherrack_gutsdark", "Guts").variation("a1_netherrack_meat", "Meat").variation("a1_netherrack_meatred", "Raw Meat").variation("a1_netherrack_meatrock", "Bloody Rock").variation("a1_netherrack_red", "Dark Red").variation("a1_netherrack_wells", "Bloody Blue").build());
    public static final ChiselBlockType<BlockCarvable> OBSIDIAN = ChiselBlocks.registerType(new ChiselBlockType("obsidian").addVanillaBlock(Blocks.f_50080_).properties(BlockBehaviour.Properties.m_284310_().m_60913_(50.0f, 2000.0f).m_60918_(SoundType.f_56742_).m_60999_()).tag((TagKey<Block>)BlockTags.f_13069_).tag((TagKey<Block>)BlockTags.f_144282_).tag((TagKey<Block>)BlockTags.f_144284_).variation("pillar", "Large Pillar", ChiselModelTemplates.cubeColumn()).variation("pillar-quartz", "Pillar", ChiselModelTemplates.cubeColumn()).variation("chiseled", "Chiseled", ChiselModelTemplates.cubeColumn()).variation("panel_shiny", "Shiny Panel").variation("panel", "Panel").variation("chunks", "Chunks").variation("growth", "Organic Chunks").variation("crystal", "Shiny").variation("map-a", "Map (Eastern)").variation("map-b", "Map (Western)").variation("panel_light", "Light Panel").variation("blocks", "Medium Tiles").variation("tiles", "Small Tiles").variation("greek", "Greek", ChiselModelTemplates.cubeColumn()).variation("crate", "Crate", ChiselModelTemplates.cubeBottomTop()).build());
    public static final ChiselBlockType<BlockCarvable> PAPER = ChiselBlocks.registerType(new ChiselBlockType("paper").properties(BlockBehaviour.Properties.m_284310_().m_60913_(1.5f, 0.0f).m_60918_(SoundType.f_56740_)).chiselSound(ChiselSound.WOOD).variation("box", "Box").variation("throughmiddle", "Horizontally Striked").variation("cross", "Crossed").variation("sixsections", "Six-Pack").variation("vertical", "Vertical").variation("horizontal", "Horizontal").variation("floral", "Floral").variation("plain", "Plain").variation("door", "Door").build());
    public static final ChiselBlockType<BlockCarvable> SANDSTONE_SCRIBBLES = ChiselBlocks.registerType(new ChiselBlockType("sandstone_scribbles").groupName("Sandstone Scribbles").properties(() -> Blocks.f_50062_).mapColor(MapColor.f_283832_).tag((TagKey<Block>)BlockTags.f_144282_).variations(VariantTemplates.SCRIBBLES).build());
    public static final ChiselBlockType<BlockCarvable> RED_SANDSTONE_SCRIBBLES = ChiselBlocks.registerType(new ChiselBlockType("sandstonered_scribbles").groupName("Red Sandstone Scribbles").properties(() -> Blocks.f_50394_).mapColor(MapColor.f_283750_).tag((TagKey<Block>)BlockTags.f_144282_).variations(VariantTemplates.SCRIBBLES).build());
    public static final ChiselBlockType<BlockCarvable> TEMPLE = ChiselBlocks.registerType(new ChiselBlockType("temple").properties(BlockBehaviour.Properties.m_284310_().m_60913_(1.5f, 10.0f).m_60918_(SoundType.f_56742_)).tag((TagKey<Block>)BlockTags.f_144282_).tag((TagKey<Block>)BlockTags.f_144286_).variation("cobble", "Cobble").variation("ornate", "Ornate").variation("plate", "Plate").variation("plate_cracked", "Cracked Plate").variation("bricks", "Bricks").variation("large_bricks", "Large Bricks").variation("weared_bricks", "Damaged Bricks").variation("disarray_bricks", "Trodden Bricks").variation("column", "Column", ChiselModelTemplates.cubeColumn()).variation("stand", "Stand", ChiselModelTemplates.cubeColumn()).variation("tiles", "Tiles").variation("smalltiles", "Small Tiles").variation("tiles_light", "Light Medium Tiles").variation("smalltiles_light", "Light Small Tiles").variation("stand_creeper", "Creeper Stand", ChiselModelTemplates.cubeColumn()).variation("stand_mosaic", "Mosaic Stand", ChiselModelTemplates.cubeColumn()).build());
    public static final ChiselBlockType<BlockCarvable> TEMPLE_MOSSY = ChiselBlocks.registerType(new ChiselBlockType("templemossy").groupName("Temple Mossy").properties(BlockBehaviour.Properties.m_284310_().m_60913_(1.5f, 10.0f).m_60918_(SoundType.f_56742_)).tag((TagKey<Block>)BlockTags.f_144282_).tag((TagKey<Block>)BlockTags.f_144286_).variation("cobble", "Cobble").variation("ornate", "Ornate").variation("plate", "Plate").variation("plate_cracked", "Cracked Plate").variation("bricks", "Bricks").variation("large_bricks", "Large Bricks").variation("weared_bricks", "Damaged Bricks").variation("disarray_bricks", "Trodden Bricks").variation("column", "Column", ChiselModelTemplates.cubeColumn()).variation("stand", "Stand", ChiselModelTemplates.cubeColumn()).variation("tiles", "Tiles").variation("smalltiles", "Small Tiles").variation("tiles_light", "Light Medium Tiles").variation("smalltiles_light", "Light Small Tiles").variation("stand_creeper", "Creeper Stand", ChiselModelTemplates.cubeColumn()).variation("stand_mosaic", "Mosaic Stand", ChiselModelTemplates.cubeColumn()).build());
    public static final Map<DyeColor, ChiselBlockType<BlockCarvable>> CONCRETE = ChiselBlocks.createColoredBlocks("concrete", color -> new ChiselBlockType("concrete/" + color.m_7912_()).groupName(ChiselBlocks.toEnglishName(color.m_7912_()) + " Concrete").addVanillaBlock(ChiselBlocks.getConcreteBlock(color)).properties(() -> ChiselBlocks.getConcreteBlock(color)).tag((TagKey<Block>)BlockTags.f_144282_).variations(VariantTemplates.ROCK).build());
    public static final Map<DyeColor, ChiselBlockType<BlockCarvable>> WOOL = ChiselBlocks.createColoredBlocks("wool", color -> new ChiselBlockType("wool/" + color.m_7912_()).groupName(ChiselBlocks.toEnglishName(color.m_7912_()) + " Wool").addVanillaBlock(ChiselBlocks.getWoolBlock(color)).properties(() -> ChiselBlocks.getWoolBlock(color)).tag((TagKey<Block>)BlockTags.f_13089_).variation("legacy", "Legacy").variation("llama", "Llama").build());
    public static final Map<DyeColor, ChiselBlockType<BlockCarvable>> HEX_PLATING = ChiselBlocks.createColoredBlocks("hexplating", color -> new ChiselBlockType("hexplating/" + color.m_7912_()).groupName(ChiselBlocks.toEnglishName(color.m_7912_()) + " Hex Plating").properties(() -> Blocks.f_50069_).tag((TagKey<Block>)BlockTags.f_144282_).tag((TagKey<Block>)BlockTags.f_144286_).variation("hexbase", "Hex Base", ChiselModelTemplates.hexPlate("hexbase")).variation("hexnew", "Hex New", ChiselModelTemplates.hexPlate("hexbase")).build());
    public static final Map<DyeColor, ChiselBlockType<BlockCarvableGlass>> GLASS_STAINED = ChiselBlocks.createColoredBlocks("glass_stained", color -> new ChiselBlockType<BlockCarvableGlass>("glass_stained/" + color.m_7912_(), (props, data) -> new BlockCarvableGlass((BlockBehaviour.Properties)props, (VariationData)data, "glass_stained/" + color.m_7912_())).groupName(ChiselBlocks.toEnglishName(color.m_7912_()) + " Stained Glass").addVanillaBlock(ChiselBlocks.getStainedGlassBlock(color)).properties(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56744_).m_60955_().m_155956_(0.3f)).defaultModelTemplate(ChiselModelTemplates.simpleBlockTranslucent()).variation("panel", "Panel").variation("framed", "Framed").variation("streaks", "Streaks").variation("rough", "Rough").variation("brick", "Brick").build());
    public static final Map<DyeColor, ChiselBlockType<BlockCarvableGlass>> GLASS_DYED = ChiselBlocks.createColoredBlocks("glassdyed", color -> new ChiselBlockType<BlockCarvableGlass>("glassdyed/" + color.m_7912_(), (props, data) -> new BlockCarvableGlass((BlockBehaviour.Properties)props, (VariationData)data, "glassdyed/" + color.m_7912_())).groupName(ChiselBlocks.toEnglishName(color.m_7912_()) + " Dyed Glass").properties(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56744_).m_60955_().m_155956_(0.3f)).defaultModelTemplate(ChiselModelTemplates.simpleBlockTranslucent()).variation("bubble", "Bubble").variation("forestry", "Forestry").variation("panel", "Panel").variation("panel_fancy", "Fancy Panel").variation("transparent", "Transparent").build());
    public static final Map<DyeColor, ChiselBlockType<BlockCarvablePane>> GLASSPANE_DYED = ChiselBlocks.createColoredBlocks("glasspanedyed", color -> new ChiselBlockType<BlockCarvablePane>("glasspanedyed/" + color.m_7912_(), (props, data) -> new BlockCarvablePane((BlockBehaviour.Properties)props, (VariationData)data, "glasspanedyed/" + color.m_7912_())).groupName(ChiselBlocks.toEnglishName(color.m_7912_()) + " Dyed Glass Pane").addVanillaBlock(ChiselBlocks.getStainedGlassPaneBlock(color)).properties(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56744_).m_60955_().m_155956_(0.3f)).variation("bubble", "Bubble", ChiselModelTemplates.paneBlockSideTop()).variation("panel", "Panel", ChiselModelTemplates.paneBlockSideTop()).variation("panel_fancy", "Fancy Panel", ChiselModelTemplates.paneBlockSideTop()).variation("quad", "Quad", ChiselModelTemplates.paneBlockSideTop()).variation("quad_fancy", "Fancy Quad", ChiselModelTemplates.paneBlockSideTop()).variation("transparent", "Transparent", ChiselModelTemplates.paneBlockSideTop()).build());
    private static final List<String> WOOD_TYPES = List.of("oak", "spruce", "birch", "jungle", "acacia", "dark_oak", "crimson");
    private static final List<String> BOOKSHELF_WOOD_TYPES = List.of("oak", "spruce", "birch", "jungle", "acacia", "dark_oak", "mangrove", "cherry", "bamboo", "crimson", "warped");
    public static final Map<String, ChiselBlockType<BlockCarvable>> PLANKS = ChiselBlocks.createWoodBlocks("planks", woodName -> new ChiselBlockType("planks/" + woodName).groupName(ChiselBlocks.toEnglishName(woodName) + " Planks").addVanillaBlock(ChiselBlocks.getPlanksBlock(woodName)).properties(() -> ChiselBlocks.getPlanksBlock(woodName)).chiselSound(ChiselSound.WOOD).tag((TagKey<Block>)BlockTags.f_13090_).tag((TagKey<Block>)BlockTags.f_144280_).variations(VariantTemplates.PLANKS).build());
    public static final Map<String, ChiselBlockType<BlockCarvable>> BOOKSHELVES = ChiselBlocks.createBookshelfBlocks();
    public static final ChiselBlockType<BlockCarvablePane> IRONPANE = ChiselBlocks.registerType(new ChiselBlockType<BlockCarvablePane>("ironpane", (props, data) -> new BlockCarvablePane((BlockBehaviour.Properties)props, (VariationData)data, "ironpane")).groupName("Iron Bars").addVanillaBlock(Blocks.f_50183_).properties(() -> Blocks.f_50183_).tag((TagKey<Block>)BlockTags.f_144282_).tag((TagKey<Block>)BlockTags.f_144285_).variation("borderless", "Frameless", ChiselModelTemplates.ironBars()).variation("borderless-topper", "Frameless Topper", ChiselModelTemplates.ironBars()).variation("barbedwire", "Barbed Wire", ChiselModelTemplates.ironBars()).variation("cage", "Thick Cage", ChiselModelTemplates.ironBars()).variation("thickgrid", "Thick Grid", ChiselModelTemplates.ironBars()).variation("thingrid", "Thin Grid", ChiselModelTemplates.ironBars()).variation("ornatesteel", "Ornate", ChiselModelTemplates.ironBars()).variation("bars", "Straight", ChiselModelTemplates.ironBars()).variation("spikes", "Spikes", ChiselModelTemplates.ironBars()).variation("classic", "Classic", ChiselModelTemplates.ironBars()).variation("classicnew", "Classic Thin", ChiselModelTemplates.ironBars()).variation("fence", "Fence", ChiselModelTemplates.ironBars()).variation("modern", "Modern Fence", ChiselModelTemplates.ironBars()).build());
    public static final RegistryObject<BlockAutoChisel> AUTO_CHISEL = ChiselRegistries.BLOCKS.register("auto_chisel", () -> new BlockAutoChisel(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60978_(2.5f).m_60918_(SoundType.f_56743_).m_60999_().m_60955_()));

    private static TagKey<Block> storageBlockTag(String metalName) {
        return BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("storage_blocks/" + metalName)));
    }

    private static <T extends Block> ChiselBlockType<T> registerType(ChiselBlockType<T> type) {
        ALL_BLOCK_TYPES.add(type);
        return type;
    }

    private static <T extends Block> Map<DyeColor, ChiselBlockType<T>> createColoredBlocks(String baseName, Function<DyeColor, ChiselBlockType<T>> factory) {
        EnumMap<DyeColor, ChiselBlockType<T>> map = new EnumMap<DyeColor, ChiselBlockType<T>>(DyeColor.class);
        for (DyeColor color : DyeColor.values()) {
            ChiselBlockType<T> type = factory.apply(color);
            map.put(color, type);
            ALL_BLOCK_TYPES.add(type);
        }
        return map;
    }

    private static Block getConcreteBlock(DyeColor color) {
        return switch (color) {
            default -> throw new IncompatibleClassChangeError();
            case DyeColor.WHITE -> Blocks.f_50542_;
            case DyeColor.ORANGE -> Blocks.f_50543_;
            case DyeColor.MAGENTA -> Blocks.f_50544_;
            case DyeColor.LIGHT_BLUE -> Blocks.f_50545_;
            case DyeColor.YELLOW -> Blocks.f_50494_;
            case DyeColor.LIME -> Blocks.f_50495_;
            case DyeColor.PINK -> Blocks.f_50496_;
            case DyeColor.GRAY -> Blocks.f_50497_;
            case DyeColor.LIGHT_GRAY -> Blocks.f_50498_;
            case DyeColor.CYAN -> Blocks.f_50499_;
            case DyeColor.PURPLE -> Blocks.f_50500_;
            case DyeColor.BLUE -> Blocks.f_50501_;
            case DyeColor.BROWN -> Blocks.f_50502_;
            case DyeColor.GREEN -> Blocks.f_50503_;
            case DyeColor.RED -> Blocks.f_50504_;
            case DyeColor.BLACK -> Blocks.f_50505_;
        };
    }

    private static Block getWoolBlock(DyeColor color) {
        return switch (color) {
            default -> throw new IncompatibleClassChangeError();
            case DyeColor.WHITE -> Blocks.f_50041_;
            case DyeColor.ORANGE -> Blocks.f_50042_;
            case DyeColor.MAGENTA -> Blocks.f_50096_;
            case DyeColor.LIGHT_BLUE -> Blocks.f_50097_;
            case DyeColor.YELLOW -> Blocks.f_50098_;
            case DyeColor.LIME -> Blocks.f_50099_;
            case DyeColor.PINK -> Blocks.f_50100_;
            case DyeColor.GRAY -> Blocks.f_50101_;
            case DyeColor.LIGHT_GRAY -> Blocks.f_50102_;
            case DyeColor.CYAN -> Blocks.f_50103_;
            case DyeColor.PURPLE -> Blocks.f_50104_;
            case DyeColor.BLUE -> Blocks.f_50105_;
            case DyeColor.BROWN -> Blocks.f_50106_;
            case DyeColor.GREEN -> Blocks.f_50107_;
            case DyeColor.RED -> Blocks.f_50108_;
            case DyeColor.BLACK -> Blocks.f_50109_;
        };
    }

    private static Block getStainedGlassBlock(DyeColor color) {
        return switch (color) {
            default -> throw new IncompatibleClassChangeError();
            case DyeColor.WHITE -> Blocks.f_50147_;
            case DyeColor.ORANGE -> Blocks.f_50148_;
            case DyeColor.MAGENTA -> Blocks.f_50202_;
            case DyeColor.LIGHT_BLUE -> Blocks.f_50203_;
            case DyeColor.YELLOW -> Blocks.f_50204_;
            case DyeColor.LIME -> Blocks.f_50205_;
            case DyeColor.PINK -> Blocks.f_50206_;
            case DyeColor.GRAY -> Blocks.f_50207_;
            case DyeColor.LIGHT_GRAY -> Blocks.f_50208_;
            case DyeColor.CYAN -> Blocks.f_50209_;
            case DyeColor.PURPLE -> Blocks.f_50210_;
            case DyeColor.BLUE -> Blocks.f_50211_;
            case DyeColor.BROWN -> Blocks.f_50212_;
            case DyeColor.GREEN -> Blocks.f_50213_;
            case DyeColor.RED -> Blocks.f_50214_;
            case DyeColor.BLACK -> Blocks.f_50215_;
        };
    }

    private static Block getStainedGlassPaneBlock(DyeColor color) {
        return switch (color) {
            default -> throw new IncompatibleClassChangeError();
            case DyeColor.WHITE -> Blocks.f_50303_;
            case DyeColor.ORANGE -> Blocks.f_50304_;
            case DyeColor.MAGENTA -> Blocks.f_50305_;
            case DyeColor.LIGHT_BLUE -> Blocks.f_50306_;
            case DyeColor.YELLOW -> Blocks.f_50307_;
            case DyeColor.LIME -> Blocks.f_50361_;
            case DyeColor.PINK -> Blocks.f_50362_;
            case DyeColor.GRAY -> Blocks.f_50363_;
            case DyeColor.LIGHT_GRAY -> Blocks.f_50364_;
            case DyeColor.CYAN -> Blocks.f_50365_;
            case DyeColor.PURPLE -> Blocks.f_50366_;
            case DyeColor.BLUE -> Blocks.f_50367_;
            case DyeColor.BROWN -> Blocks.f_50368_;
            case DyeColor.GREEN -> Blocks.f_50369_;
            case DyeColor.RED -> Blocks.f_50370_;
            case DyeColor.BLACK -> Blocks.f_50371_;
        };
    }

    private static <T extends Block> Map<String, ChiselBlockType<T>> createWoodBlocks(String baseName, Function<String, ChiselBlockType<T>> factory) {
        LinkedHashMap<String, ChiselBlockType<T>> map = new LinkedHashMap<String, ChiselBlockType<T>>();
        for (String woodName : WOOD_TYPES) {
            ChiselBlockType<T> type = factory.apply(woodName);
            map.put(woodName, type);
            ALL_BLOCK_TYPES.add(type);
        }
        return map;
    }

    private static Block getPlanksBlock(String woodName) {
        return switch (woodName) {
            case "oak" -> Blocks.f_50705_;
            case "spruce" -> Blocks.f_50741_;
            case "birch" -> Blocks.f_50742_;
            case "jungle" -> Blocks.f_50743_;
            case "acacia" -> Blocks.f_50744_;
            case "dark_oak" -> Blocks.f_50745_;
            case "mangrove" -> Blocks.f_220865_;
            case "cherry" -> Blocks.f_271304_;
            case "bamboo" -> Blocks.f_244477_;
            case "crimson" -> Blocks.f_50655_;
            case "warped" -> Blocks.f_50656_;
            default -> Blocks.f_50705_;
        };
    }

    private static Block getBookshelfBlock(String woodName) {
        return switch (woodName) {
            case "birch" -> Blocks.f_50078_;
            case "jungle" -> Blocks.f_50078_;
            case "acacia" -> Blocks.f_50078_;
            case "dark_oak" -> Blocks.f_50078_;
            case "mangrove" -> Blocks.f_50078_;
            case "cherry" -> Blocks.f_50078_;
            case "bamboo" -> Blocks.f_50078_;
            case "crimson" -> Blocks.f_50078_;
            case "warped" -> Blocks.f_50078_;
            default -> Blocks.f_50078_;
        };
    }

    private static Map<String, ChiselBlockType<BlockCarvable>> createBookshelfBlocks() {
        LinkedHashMap<String, ChiselBlockType<BlockCarvable>> map = new LinkedHashMap<String, ChiselBlockType<BlockCarvable>>();
        for (String woodName : BOOKSHELF_WOOD_TYPES) {
            ChiselBlockType builder = new ChiselBlockType("bookshelf/" + woodName).groupName(ChiselBlocks.toEnglishName(woodName) + " Bookshelf").properties(() -> ChiselBlocks.getBookshelfBlock(woodName)).chiselSound(ChiselSound.WOOD).tag((TagKey<Block>)BlockTags.f_144280_).variations(VariantTemplates.bookshelfForWood(woodName));
            if (woodName.equals("oak")) {
                builder.addVanillaBlock(Blocks.f_50078_);
            }
            ChiselBlockType type = builder.build();
            map.put(woodName, type);
            ALL_BLOCK_TYPES.add(type);
        }
        return map;
    }

    private static String toEnglishName(String name) {
        StringBuilder builder = new StringBuilder();
        boolean capitalizeNext = true;
        for (char c : name.toCharArray()) {
            if (c == '_') {
                builder.append(' ');
                capitalizeNext = true;
                continue;
            }
            builder.append(capitalizeNext ? Character.toUpperCase(c) : c);
            capitalizeNext = false;
        }
        return builder.toString();
    }

    public static List<RegistryObject<?>> getAllBlocks() {
        return ALL_BLOCK_TYPES.stream().flatMap(type -> type.getAllBlocks().stream()).collect(Collectors.toList());
    }

    public static void init() {
    }
}

