/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.init;

import com.leclowndu93150.chisel.component.ChiselData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class ChiselDataComponents {
    private static final String CHISEL_DATA_KEY = "ChiselData";
    private static final String MODE_KEY = "mode";
    private static final String PREVIEW_TYPE_KEY = "preview_type";
    private static final String SELECTION_SLOT_KEY = "selection_slot";
    private static final String TARGET_SLOT_KEY = "target_slot";
    private static final String ROTATE_KEY = "rotate";
    private static final String TARGET_KEY = "target";
    public static final ChiselDataRegistryObject CHISEL_DATA = new ChiselDataRegistryObject();

    public static void init() {
    }

    public static class ChiselDataRegistryObject {
        private final ChiselDataComponent component = new ChiselDataComponent();

        public ChiselDataComponent get() {
            return this.component;
        }
    }

    public static class ChiselDataComponent {
        public ChiselData get(ItemStack stack) {
            if (!stack.m_41782_()) {
                return ChiselData.DEFAULT;
            }
            CompoundTag tag = stack.m_41783_();
            if (!tag.m_128441_(ChiselDataComponents.CHISEL_DATA_KEY)) {
                return ChiselData.DEFAULT;
            }
            CompoundTag data = tag.m_128469_(ChiselDataComponents.CHISEL_DATA_KEY);
            String mode = data.m_128441_(ChiselDataComponents.MODE_KEY) ? data.m_128461_(ChiselDataComponents.MODE_KEY) : "single";
            int previewType = data.m_128441_(ChiselDataComponents.PREVIEW_TYPE_KEY) ? data.m_128451_(ChiselDataComponents.PREVIEW_TYPE_KEY) : 0;
            int selectionSlot = data.m_128441_(ChiselDataComponents.SELECTION_SLOT_KEY) ? data.m_128451_(ChiselDataComponents.SELECTION_SLOT_KEY) : -1;
            int targetSlot = data.m_128441_(ChiselDataComponents.TARGET_SLOT_KEY) ? data.m_128451_(ChiselDataComponents.TARGET_SLOT_KEY) : -1;
            boolean rotate = data.m_128441_(ChiselDataComponents.ROTATE_KEY) && data.m_128471_(ChiselDataComponents.ROTATE_KEY);
            ItemStack target = ItemStack.f_41583_;
            if (data.m_128441_(ChiselDataComponents.TARGET_KEY)) {
                target = ItemStack.m_41712_((CompoundTag)data.m_128469_(ChiselDataComponents.TARGET_KEY));
            }
            return new ChiselData(mode, previewType, selectionSlot, targetSlot, rotate, target);
        }

        public void set(ItemStack stack, ChiselData chiselData) {
            CompoundTag tag = stack.m_41784_();
            CompoundTag data = new CompoundTag();
            data.m_128359_(ChiselDataComponents.MODE_KEY, chiselData.mode());
            data.m_128405_(ChiselDataComponents.PREVIEW_TYPE_KEY, chiselData.previewType());
            data.m_128405_(ChiselDataComponents.SELECTION_SLOT_KEY, chiselData.selectionSlot());
            data.m_128405_(ChiselDataComponents.TARGET_SLOT_KEY, chiselData.targetSlot());
            data.m_128379_(ChiselDataComponents.ROTATE_KEY, chiselData.rotate());
            if (!chiselData.target().m_41619_()) {
                CompoundTag targetTag = new CompoundTag();
                chiselData.target().m_41739_(targetTag);
                data.m_128365_(ChiselDataComponents.TARGET_KEY, (Tag)targetTag);
            }
            tag.m_128365_(ChiselDataComponents.CHISEL_DATA_KEY, (Tag)data);
        }
    }
}

