/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.inventory;

import com.leclowndu93150.chisel.api.IChiselItem;
import com.leclowndu93150.chisel.block.entity.AutoChiselBlockEntity;
import com.leclowndu93150.chisel.carving.CarvingHelper;
import com.leclowndu93150.chisel.init.ChiselBlocks;
import com.leclowndu93150.chisel.init.ChiselMenus;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class AutoChiselMenu
extends AbstractContainerMenu {
    public static final int ACTIVE = 0;
    public static final int PROGRESS = 1;
    public static final int MAX_PROGRESS = 2;
    public static final int ENERGY = 3;
    public static final int MAX_ENERGY = 4;
    public static final int ENERGY_USE = 5;
    public final Inventory playerInventory;
    public final int chiselSlot;
    public final int targetSlot;
    private final int beginInputSlots;
    private final int endInputSlots;
    private final int beginOutputSlots;
    private final int endOutputSlots;
    private final int beginPlayerSlots;
    private final int endPlayerSlots;
    private final ContainerData data;
    private final ContainerLevelAccess access;

    public AutoChiselMenu(int containerId, Inventory playerInv, FriendlyByteBuf buf) {
        this(containerId, playerInv, (IItemHandler)new ItemStackHandler(1), (IItemHandler)new ItemStackHandler(1), (IItemHandler)new ItemStackHandler(12), (IItemHandler)new ItemStackHandler(12), (ContainerData)new SimpleContainerData(6), ContainerLevelAccess.f_39287_);
    }

    public AutoChiselMenu(int containerId, Inventory playerInv, AutoChiselBlockEntity blockEntity, ContainerData data, ContainerLevelAccess access) {
        this(containerId, playerInv, (IItemHandler)blockEntity.getChiselSlot(), (IItemHandler)blockEntity.getTargetSlot(), (IItemHandler)blockEntity.getInputInv(), (IItemHandler)blockEntity.getOutputInv(), data, access);
    }

    public AutoChiselMenu(int containerId, Inventory playerInv, IItemHandler chisel, IItemHandler target, IItemHandler input, IItemHandler output, ContainerData data, ContainerLevelAccess access) {
        super((MenuType)ChiselMenus.AUTO_CHISEL_MENU.get(), containerId);
        int y;
        int x;
        int i;
        this.playerInventory = playerInv;
        this.data = data;
        this.access = access;
        int yStart = 19;
        this.chiselSlot = 0;
        this.m_38897_((Slot)new SlotItemHandler(chisel, 0, 80, yStart + 9){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41720_() instanceof IChiselItem;
            }
        });
        this.targetSlot = 1;
        this.m_38897_((Slot)new SlotItemHandler(target, 0, 80, 54 + yStart - 9){

            public boolean m_5857_(ItemStack stack) {
                return CarvingHelper.canChisel(stack);
            }
        });
        this.beginInputSlots = this.f_38839_.size();
        for (i = 0; i < input.getSlots(); ++i) {
            x = 8 + 18 * (i % 3);
            y = yStart + 18 * (i / 3);
            this.m_38897_((Slot)new SlotItemHandler(input, i, x, y){

                public boolean m_5857_(ItemStack stack) {
                    return CarvingHelper.canChisel(stack);
                }
            });
        }
        this.endInputSlots = this.beginOutputSlots = this.f_38839_.size();
        for (i = 0; i < output.getSlots(); ++i) {
            x = 116 + 18 * (i % 3);
            y = yStart + 18 * (i / 3);
            this.m_38897_((Slot)new SlotItemHandler(output, i, x, y){

                public boolean m_5857_(ItemStack stack) {
                    return false;
                }
            });
        }
        this.beginPlayerSlots = this.endOutputSlots = this.f_38839_.size();
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInv, col + row * 9 + 9, 8 + col * 18, 118 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInv, col, 8 + col * 18, 176));
        }
        this.endPlayerSlots = this.f_38839_.size();
        this.m_38884_(data);
    }

    public boolean m_6875_(Player player) {
        return AutoChiselMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)ChiselBlocks.AUTO_CHISEL.get()));
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack result = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            result = slotStack.m_41777_();
            if (index >= this.beginOutputSlots && index < this.endOutputSlots) {
                if (!this.m_38903_(slotStack, this.beginPlayerSlots, this.endPlayerSlots, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(slotStack, result);
            } else if (index >= this.beginPlayerSlots ? (CarvingHelper.canChisel(slotStack) ? !this.m_38903_(slotStack, this.targetSlot, this.targetSlot + 1, false) && !this.m_38903_(slotStack, this.beginInputSlots, this.endInputSlots, false) : (slotStack.m_41720_() instanceof IChiselItem ? !this.m_38903_(slotStack, this.chiselSlot, this.chiselSlot + 1, false) : (index >= this.beginPlayerSlots && index < this.endPlayerSlots - 9 ? !this.m_38903_(slotStack, this.endPlayerSlots - 9, this.endPlayerSlots, false) : index >= this.endPlayerSlots - 9 && index < this.endPlayerSlots && !this.m_38903_(slotStack, this.beginPlayerSlots, this.endPlayerSlots - 9, false)))) : !this.m_38903_(slotStack, this.beginPlayerSlots, this.endPlayerSlots, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == result.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
        }
        return result;
    }

    public boolean isActive() {
        return this.data.m_6413_(0) > 0;
    }

    public int getProgressScaled(int barLength) {
        int progress = this.data.m_6413_(1);
        int maxProgress = this.data.m_6413_(2);
        return maxProgress > 0 ? (int)((float)progress / (float)maxProgress * (float)barLength) : 0;
    }

    public boolean hasEnergy() {
        return this.getEnergy() > 0;
    }

    public int getEnergy() {
        return this.data.m_6413_(3);
    }

    public int getMaxEnergy() {
        return this.data.m_6413_(4);
    }

    public int getEnergyScaled(int barLength) {
        int energy = this.data.m_6413_(3);
        int maxEnergy = this.data.m_6413_(4);
        return maxEnergy > 0 ? (int)((float)energy / (float)maxEnergy * (float)barLength) : 0;
    }

    public int getUsagePerTick() {
        return this.data.m_6413_(5);
    }
}

