/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.inventory;

import com.leclowndu93150.chisel.api.IChiselItem;
import com.leclowndu93150.chisel.carving.CarvingHelper;
import com.leclowndu93150.chisel.inventory.ChiselMenu;
import com.leclowndu93150.chisel.inventory.InventoryChiselSelection;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class SlotChiselSelection
extends Slot {
    private final ChiselMenu container;

    public SlotChiselSelection(ChiselMenu container, InventoryChiselSelection inv, int slot, int x, int y) {
        super((Container)inv, slot, x, y);
        this.container = container;
    }

    public boolean m_5857_(ItemStack stack) {
        return false;
    }

    public boolean m_8010_(Player player) {
        return player.f_36096_.m_142621_().m_41619_();
    }

    public static ItemStack craft(ChiselMenu container, Player player, ItemStack target, boolean simulate) {
        ItemStack source = container.getInventoryChisel().getStackInSpecialSlot();
        ItemStack chisel = container.getChisel();
        if (simulate) {
            target = target.m_41777_();
            source = source.m_41619_() ? ItemStack.f_41583_ : source.m_41777_();
            chisel = chisel.m_41777_();
        }
        ItemStack result = ItemStack.f_41583_;
        if (!chisel.m_41619_() && !source.m_41619_()) {
            Item item = chisel.m_41720_();
            if (!(item instanceof IChiselItem)) {
                return result;
            }
            IChiselItem chiselItem = (IChiselItem)item;
            if (!chiselItem.canChisel(player.m_9236_(), player, chisel, target)) {
                return result;
            }
            EquipmentSlot equipSlot = container.getHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
            result = chiselItem.craftItem(chisel, source, target, player, equipSlot);
            if (!simulate) {
                container.getInventoryChisel().setStackInSpecialSlot(source.m_41619_() ? ItemStack.f_41583_ : source);
                container.onChiselSlotChanged();
                Block targetBlock = Blocks.f_50016_;
                Item item2 = target.m_41720_();
                if (item2 instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)item2;
                    targetBlock = blockItem.m_40614_();
                }
                chiselItem.onChisel(player.m_9236_(), player, chisel, targetBlock);
                if (chisel.m_41619_() || chisel.m_41613_() == 0) {
                    container.getInventoryPlayer().m_6836_(container.getChiselSlot(), ItemStack.f_41583_);
                }
                if (!source.m_41619_() && !chiselItem.canChisel(player.m_9236_(), player, chisel, target)) {
                    container.onChiselBroken();
                }
                container.getInventoryChisel().updateItems();
                container.m_38946_();
            }
        }
        return result;
    }

    public void m_142406_(Player player, ItemStack stack) {
        ItemStack chisel = this.container.getChisel().m_41777_();
        ItemStack result = SlotChiselSelection.craft(this.container, player, stack, false);
        if (!result.m_41619_()) {
            Block targetBlock = Blocks.f_50016_;
            Item item = stack.m_41720_();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                targetBlock = blockItem.m_40614_();
            }
            CarvingHelper.playChiselSound(player.m_9236_(), player, targetBlock);
            ClickType clickType = this.container.getCurrentClickType();
            if (clickType != null) {
                switch (clickType) {
                    case PICKUP: 
                    case PICKUP_ALL: 
                    case QUICK_CRAFT: 
                    case QUICK_MOVE: {
                        this.container.m_142503_(result);
                        break;
                    }
                    case SWAP: 
                    case THROW: {
                        stack.m_41764_(result.m_41613_());
                        break;
                    }
                }
            } else {
                this.container.m_142503_(result);
            }
        } else {
            stack.m_41764_(0);
        }
    }
}

