/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.network;

import com.leclowndu93150.chisel.network.client.AutoChiselFXPacket;
import com.leclowndu93150.chisel.network.client.ChunkDataPacket;
import com.leclowndu93150.chisel.network.server.ChiselButtonPacket;
import com.leclowndu93150.chisel.network.server.ChiselModePacket;
import com.leclowndu93150.chisel.network.server.HitechSettingsPacket;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class ChiselNetwork {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("chisel", "main"), () -> "1", "1"::equals, "1"::equals);
    private static int packetId = 0;

    private static int id() {
        return packetId++;
    }

    public static void register() {
        CHANNEL.messageBuilder(ChiselModePacket.class, ChiselNetwork.id(), NetworkDirection.PLAY_TO_SERVER).encoder(ChiselModePacket::encode).decoder(ChiselModePacket::decode).consumerMainThread(ChiselModePacket::handle).add();
        CHANNEL.messageBuilder(ChiselButtonPacket.class, ChiselNetwork.id(), NetworkDirection.PLAY_TO_SERVER).encoder(ChiselButtonPacket::encode).decoder(ChiselButtonPacket::decode).consumerMainThread(ChiselButtonPacket::handle).add();
        CHANNEL.messageBuilder(HitechSettingsPacket.class, ChiselNetwork.id(), NetworkDirection.PLAY_TO_SERVER).encoder(HitechSettingsPacket::encode).decoder(HitechSettingsPacket::decode).consumerMainThread(HitechSettingsPacket::handle).add();
        CHANNEL.messageBuilder(AutoChiselFXPacket.class, ChiselNetwork.id(), NetworkDirection.PLAY_TO_CLIENT).encoder(AutoChiselFXPacket::encode).decoder(AutoChiselFXPacket::decode).consumerMainThread((packet, ctx) -> {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> ChiselNetwork.lambda$register$2(packet, (Supplier)ctx));
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        }).add();
        CHANNEL.messageBuilder(ChunkDataPacket.class, ChiselNetwork.id(), NetworkDirection.PLAY_TO_CLIENT).encoder(ChunkDataPacket::encode).decoder(ChunkDataPacket::decode).consumerMainThread((packet, ctx) -> {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> ChiselNetwork.lambda$register$5(packet, (Supplier)ctx));
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        }).add();
    }

    public static void sendToServer(Object message) {
        CHANNEL.sendToServer(message);
    }

    public static void sendToPlayer(ServerPlayer player, Object message) {
        CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    public static void sendToAllTrackingChunk(LevelChunk chunk, Object message) {
        CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), message);
    }

    private static /* synthetic */ Runnable lambda$register$5(ChunkDataPacket packet, Supplier ctx) {
        return () -> ChiselNetwork.lambda$register$4(packet, (Supplier)ctx);
    }

    private static /* synthetic */ void lambda$register$4(ChunkDataPacket packet, Supplier ctx) {
        ChunkDataPacket.handleClient(packet, ctx);
    }

    private static /* synthetic */ Runnable lambda$register$2(AutoChiselFXPacket packet, Supplier ctx) {
        return () -> ChiselNetwork.lambda$register$1(packet, (Supplier)ctx);
    }

    private static /* synthetic */ void lambda$register$1(AutoChiselFXPacket packet, Supplier ctx) {
        AutoChiselFXPacket.handleClient(packet, ctx);
    }
}

