/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.network.client;

import com.leclowndu93150.chisel.api.chunkdata.ChunkData;
import com.leclowndu93150.chisel.api.chunkdata.OffsetData;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class ChunkDataPacket {
    private final int chunkX;
    private final int chunkZ;
    private final CompoundTag data;

    public ChunkDataPacket(int chunkX, int chunkZ, CompoundTag data) {
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.data = data != null ? data : new CompoundTag();
    }

    public static void encode(ChunkDataPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.chunkX);
        buf.writeInt(packet.chunkZ);
        buf.m_130079_(packet.data);
    }

    public static ChunkDataPacket decode(FriendlyByteBuf buf) {
        int chunkX = buf.readInt();
        int chunkZ = buf.readInt();
        CompoundTag data = buf.m_130260_();
        return new ChunkDataPacket(chunkX, chunkZ, data);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleClient(ChunkDataPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ != null) {
                ChunkPos chunkPos = new ChunkPos(packet.chunkX, packet.chunkZ);
                if (packet.data.m_128456_()) {
                    ChunkData.removeData((Level)mc.f_91073_, chunkPos);
                } else {
                    OffsetData offsetData = new OffsetData();
                    offsetData.readFromNBT(packet.data);
                    ChunkData.setData((Level)mc.f_91073_, chunkPos, offsetData);
                }
                int minSection = mc.f_91073_.m_151560_();
                int maxSection = mc.f_91073_.m_151561_();
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        for (int sectionY = minSection; sectionY <= maxSection; ++sectionY) {
                            mc.f_91060_.m_109770_(packet.chunkX + dx, sectionY, packet.chunkZ + dz);
                        }
                    }
                }
            }
        });
    }
}

