/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.network.server;

import com.leclowndu93150.chisel.api.IChiselItem;
import com.leclowndu93150.chisel.carving.CarvingHelper;
import com.leclowndu93150.chisel.inventory.HitechChiselMenu;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.network.NetworkEvent;

public class ChiselButtonPacket {
    private final int[] slotIds;

    public ChiselButtonPacket(int[] slotIds) {
        this.slotIds = slotIds;
    }

    public static void encode(ChiselButtonPacket packet, FriendlyByteBuf buf) {
        buf.m_130089_(packet.slotIds);
    }

    public static ChiselButtonPacket decode(FriendlyByteBuf buf) {
        return new ChiselButtonPacket(buf.m_130100_());
    }

    public static void handle(ChiselButtonPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                ChiselButtonPacket.chiselAll((Player)player, packet.slotIds);
            }
        });
        context.setPacketHandled(true);
    }

    public static void chiselAll(Player player, int[] slots) {
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (!(abstractContainerMenu instanceof HitechChiselMenu)) {
            return;
        }
        HitechChiselMenu menu = (HitechChiselMenu)abstractContainerMenu;
        ItemStack chisel = menu.getChisel();
        ItemStack target = menu.getTargetItem();
        if (!(chisel.m_41720_() instanceof IChiselItem)) {
            return;
        }
        if (chisel.m_41619_() || target.m_41619_()) {
            return;
        }
        TagKey<Item> targetGroup = CarvingHelper.getCarvingGroupForItem(target);
        if (targetGroup == null) {
            return;
        }
        boolean chiseledAny = false;
        for (int menuSlotIndex : slots) {
            TagKey<Item> stackGroup;
            Slot slot;
            ItemStack stack;
            if (menuSlotIndex < 0 || menuSlotIndex >= menu.f_38839_.size() || (stack = (slot = menu.m_38853_(menuSlotIndex)).m_7993_()).m_41619_() || (stackGroup = CarvingHelper.getCarvingGroupForItem(stack)) == null || !stackGroup.equals(targetGroup)) continue;
            int toChisel = stack.m_41613_();
            if (chisel.m_41763_()) {
                int durabilityLeft = chisel.m_41776_() - chisel.m_41773_();
                if ((toChisel = Math.min(toChisel, durabilityLeft)) <= 0) break;
                chisel.m_41721_(chisel.m_41773_() + toChisel);
            }
            ItemStack result = new ItemStack((ItemLike)target.m_41720_(), toChisel);
            slot.m_5852_(result);
            chiseledAny = true;
            if (!chisel.m_41763_() || chisel.m_41773_() < chisel.m_41776_()) continue;
            chisel.m_41774_(1);
            break;
        }
        if (chiseledAny) {
            Block block;
            Item item = target.m_41720_();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                block = blockItem.m_40614_();
            } else {
                block = Blocks.f_50016_;
            }
            Block targetBlock = block;
            CarvingHelper.playChiselSound(player.m_9236_(), player, targetBlock);
        }
    }
}

