/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.network.server;

import com.leclowndu93150.chisel.api.IChiselItem;
import com.leclowndu93150.chisel.api.carving.IChiselMode;
import com.leclowndu93150.chisel.carving.ChiselMode;
import com.leclowndu93150.chisel.carving.ChiselModeRegistry;
import com.leclowndu93150.chisel.item.ItemChisel;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ChiselModePacket {
    private final int slot;
    private final String modeName;

    public ChiselModePacket(int slot, String modeName) {
        this.slot = slot;
        this.modeName = modeName;
    }

    public ChiselModePacket(int slot, IChiselMode mode) {
        this(slot, mode.name());
    }

    public static void encode(ChiselModePacket packet, FriendlyByteBuf buf) {
        buf.m_130130_(packet.slot);
        buf.m_130070_(packet.modeName);
    }

    public static ChiselModePacket decode(FriendlyByteBuf buf) {
        return new ChiselModePacket(buf.m_130242_(), buf.m_130277_());
    }

    public static void handle(ChiselModePacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                Item patt1966$temp;
                IChiselItem chiselItem;
                Item patt1841$temp;
                ItemStack stack = player.m_150109_().m_8020_(packet.slot);
                IChiselMode mode = ChiselModeRegistry.INSTANCE.getModeByName(packet.modeName);
                if (mode == null) {
                    mode = ChiselMode.SINGLE;
                }
                if ((patt1841$temp = stack.m_41720_()) instanceof IChiselItem && (chiselItem = (IChiselItem)patt1841$temp).supportsMode((Player)player, stack, mode) && (patt1966$temp = stack.m_41720_()) instanceof ItemChisel) {
                    ItemChisel itemChisel = (ItemChisel)patt1966$temp;
                    itemChisel.setMode(stack, mode);
                }
            }
        });
        context.setPacketHandled(true);
    }
}

