/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.starwars;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.mcreator.starwars.network.LoadPlayerAnimationMessage;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class StarwarsModPlayerAnimationAPI {
    public static final Map<String, PlayerAnimation> animations = new Object2ObjectOpenHashMap();
    public static final Map<Player, PlayerAnimation> active_animations = new Object2ObjectOpenHashMap();
    public static final Map<UUID, Boolean> initialized = new HashMap<UUID, Boolean>();

    public static void loadAnimationFile(JsonObject file) {
        JsonObject animationsObject = file.get("animations").getAsJsonObject();
        for (int i = 0; i < animationsObject.size(); ++i) {
            String animationName = (String)animationsObject.keySet().stream().toList().get(i);
            JsonObject animationObject = animationsObject.get(animationName).getAsJsonObject();
            PlayerAnimation animation = new PlayerAnimation(animationObject);
            animations.put(animationName, animation);
        }
    }

    public static class PlayerAnimation {
        public final float length;
        public boolean loop = false;
        public boolean hold_on_last_frame = false;
        public final Map<String, PlayerBone> bones;

        public PlayerAnimation(JsonObject animation) {
            this.length = animation.has("animation_length") ? animation.get("animation_length").getAsFloat() : 0.0f;
            if (animation.has("loop")) {
                JsonElement loopType = animation.get("loop");
                if (loopType.isJsonPrimitive() && loopType.getAsJsonPrimitive().isBoolean()) {
                    this.loop = loopType.getAsBoolean();
                } else if (loopType.isJsonPrimitive()) {
                    this.hold_on_last_frame = true;
                }
            }
            this.bones = new HashMap<String, PlayerBone>();
            if (animation.has("bones")) {
                JsonObject bonesObj = animation.getAsJsonObject("bones");
                for (String boneName : bonesObj.keySet()) {
                    this.bones.put(boneName, new PlayerBone(bonesObj.getAsJsonObject(boneName)));
                }
            }
        }
    }

    @EventBusSubscriber
    private static class AnimationLoader {
        private AnimationLoader() {
        }

        @SubscribeEvent
        public static void loadAnimations(PlayerEvent.PlayerLoggedInEvent event) {
            Player player;
            if (initialized.get(event.getEntity().getUUID()) == null && (player = event.getEntity()) instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ServerLevel level = (ServerLevel)player2.level();
                ArrayList<JsonObject> jsons = new ArrayList<JsonObject>();
                ArrayList<String> namespaces = new ArrayList<String>();
                class Output
                implements PackResources.ResourceOutput {
                    private List<JsonObject> jsonObjects;
                    private PackResources packResources;
                    private List<String> namespaces;

                    public Output(List<JsonObject> jsonObjects, List<String> namespaces) {
                        this.jsonObjects = jsonObjects;
                        this.namespaces = namespaces;
                    }

                    public void setPackResources(PackResources packResources) {
                        this.packResources = packResources;
                    }

                    public void accept(ResourceLocation resourceLocation, IoSupplier<InputStream> ioSupplier) {
                        try {
                            JsonObject jsonObject = (JsonObject)new Gson().fromJson(new BufferedReader(new InputStreamReader((InputStream)ioSupplier.get(), StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n")), JsonObject.class);
                            this.jsonObjects.add(jsonObject);
                            this.namespaces.add(resourceLocation.getNamespace());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                Output output = new Output(jsons, namespaces);
                ResourceManager rm = level.getServer().getResourceManager();
                rm.listPacks().forEach(resource -> {
                    for (String namespace : resource.getNamespaces(PackType.SERVER_DATA)) {
                        output.setPackResources((PackResources)resource);
                        resource.listResources(PackType.SERVER_DATA, namespace, "bedrock_animations", (PackResources.ResourceOutput)output);
                    }
                });
                AnimationLoader.sendAnimationsInBatches(player2, jsons, namespaces);
                initialized.put(player2.getUUID(), true);
            }
        }

        private static void sendAnimationsInBatches(ServerPlayer player, List<JsonObject> jsons, List<String> namespaces) {
            int MAX_CHARS = 30000;
            int ANIMATIONS_WRAPPER_OVERHEAD = "{\"animations\":{}}".length();
            JsonObject currentBatch = new JsonObject();
            JsonObject animationsObject = new JsonObject();
            currentBatch.add("animations", (JsonElement)animationsObject);
            int currentSize = ANIMATIONS_WRAPPER_OVERHEAD;
            int animationCount = 0;
            int namespaceIndex = 0;
            for (JsonObject animationJson : jsons) {
                JsonObject sourceAnimations = animationJson.getAsJsonObject("animations");
                if (sourceAnimations != null) {
                    for (Map.Entry entry : sourceAnimations.entrySet()) {
                        JsonElement animationData;
                        String animationName = namespaces.get(namespaceIndex) + ":" + (String)entry.getKey();
                        String animationString = "\"" + animationName + "\":" + (animationData = (JsonElement)entry.getValue()).toString();
                        int animationSize = animationString.length() + 1;
                        if (currentSize + animationSize > 30000 && animationCount > 0) {
                            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new LoadPlayerAnimationMessage(currentBatch.toString()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                            currentBatch = new JsonObject();
                            animationsObject = new JsonObject();
                            currentBatch.add("animations", (JsonElement)animationsObject);
                            currentSize = ANIMATIONS_WRAPPER_OVERHEAD;
                            animationCount = 0;
                        }
                        animationsObject.add(animationName, animationData);
                        currentSize += animationSize;
                        ++animationCount;
                    }
                }
                ++namespaceIndex;
            }
            if (animationCount > 0) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new LoadPlayerAnimationMessage(currentBatch.toString()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static class PlayerBone {
        public final List<Keyframe> rotations;
        public final List<Keyframe> positions;
        public final List<Keyframe> scales;

        public PlayerBone(JsonObject bone) {
            this.rotations = this.parseTransform(bone, "rotation");
            this.positions = this.parseTransform(bone, "position");
            this.scales = this.parseTransform(bone, "scale");
        }

        private List<Keyframe> parseTransform(JsonObject bone, String key) {
            ArrayList<Keyframe> result = new ArrayList<Keyframe>();
            if (!bone.has(key)) {
                return result;
            }
            JsonElement element = bone.get(key);
            if (element.isJsonArray()) {
                result.add(new Keyframe(0.0f, this.parseValue(element), null, null, false));
            } else if (element.isJsonPrimitive()) {
                result.add(new Keyframe(0.0f, this.parseValue(element), null, null, false));
            } else if (element.isJsonObject()) {
                JsonObject keyframes = element.getAsJsonObject();
                for (String timeStr : keyframes.keySet()) {
                    float time = Float.parseFloat(timeStr);
                    JsonElement frameValue = keyframes.get(timeStr);
                    if (frameValue.isJsonArray() || frameValue.isJsonPrimitive()) {
                        result.add(new Keyframe(time, this.parseValue(frameValue), null, null, false));
                        continue;
                    }
                    if (!frameValue.isJsonObject()) continue;
                    JsonObject frameObj = frameValue.getAsJsonObject();
                    KeyframeValue value = frameObj.has("post") ? this.parseValue(frameObj.get("post")) : this.parseValue(frameValue);
                    KeyframeValue pre = frameObj.has("pre") ? this.parseValue(frameObj.get("pre")) : null;
                    KeyframeValue post = frameObj.has("post") ? this.parseValue(frameObj.get("post")) : null;
                    boolean catmullrom = frameObj.has("lerp_mode") && frameObj.get("lerp_mode").getAsString().equalsIgnoreCase("catmullrom");
                    result.add(new Keyframe(time, value, pre, post, catmullrom));
                }
            }
            return result;
        }

        private KeyframeValue parseValue(JsonElement element) {
            if (element.isJsonArray()) {
                JsonArray array = element.getAsJsonArray();
                boolean hasMolang = false;
                StringBuilder molangArray = new StringBuilder("[");
                for (int i = 0; i < array.size(); ++i) {
                    JsonElement elem;
                    if (i > 0) {
                        molangArray.append(",");
                    }
                    if (!(elem = array.get(i)).isJsonPrimitive()) continue;
                    JsonPrimitive prim = elem.getAsJsonPrimitive();
                    if (prim.isString()) {
                        hasMolang = true;
                        molangArray.append(prim.getAsString());
                        continue;
                    }
                    molangArray.append(prim.getAsFloat());
                }
                molangArray.append("]");
                if (hasMolang) {
                    return new KeyframeValue(molangArray.toString());
                }
                float x = array.size() > 0 && array.get(0).isJsonPrimitive() ? array.get(0).getAsFloat() : 0.0f;
                float y = array.size() > 1 && array.get(1).isJsonPrimitive() ? array.get(1).getAsFloat() : 0.0f;
                float z = array.size() > 2 && array.get(2).isJsonPrimitive() ? array.get(2).getAsFloat() : 0.0f;
                return new KeyframeValue(new Vec3((double)x, (double)y, (double)z));
            }
            if (element.isJsonPrimitive()) {
                JsonPrimitive prim = element.getAsJsonPrimitive();
                if (prim.isString()) {
                    return new KeyframeValue(prim.getAsString());
                }
                float value = prim.getAsFloat();
                return new KeyframeValue(new Vec3((double)value, (double)value, (double)value));
            }
            return new KeyframeValue(Vec3.ZERO);
        }

        public static Vec3 interpolate(List<Keyframe> keyframes, float time) {
            Vec3 v2;
            Vec3 postVec;
            if (keyframes.isEmpty()) {
                return null;
            }
            if (keyframes.size() == 1) {
                Keyframe kf = keyframes.get(0);
                return kf.value.isMolang() ? PlayerBone.evalMolang(kf.value.molang, time) : kf.value.vector;
            }
            Keyframe lastKf = null;
            Keyframe nextKf = null;
            int lastIdx = -1;
            for (int i = 0; i < keyframes.size(); ++i) {
                Keyframe kf = keyframes.get(i);
                if (time >= kf.time) {
                    lastKf = kf;
                    lastIdx = i;
                }
                if (!(time < kf.time)) continue;
                nextKf = kf;
                break;
            }
            if (lastKf == null) {
                return null;
            }
            Vec3 vec3 = postVec = lastKf.post.isMolang() ? PlayerBone.evalMolang(lastKf.post.molang, time) : lastKf.post.vector;
            if (nextKf == null) {
                return postVec;
            }
            float t1 = lastKf.time;
            float t2_ = nextKf.time;
            if (t1 == t2_) {
                return postVec;
            }
            float alpha = (time - t1) / (t2_ - t1);
            Vec3 v1 = postVec;
            Vec3 vec32 = v2 = nextKf.pre.isMolang() ? PlayerBone.evalMolang(nextKf.pre.molang, time) : nextKf.pre.vector;
            if (lastKf.catmullrom) {
                KeyframeValue kv;
                Vec3 p0 = v1;
                Vec3 p1 = v1;
                Vec3 p2 = v2;
                Vec3 p3 = v2;
                if (lastIdx > 0) {
                    kv = keyframes.get((int)(lastIdx - 1)).post;
                    Vec3 vec33 = p0 = kv.isMolang() ? PlayerBone.evalMolang(kv.molang, time) : kv.vector;
                }
                if (lastIdx + 1 < keyframes.size() - 1) {
                    kv = keyframes.get((int)(lastIdx + 2)).pre;
                    p3 = kv.isMolang() ? PlayerBone.evalMolang(kv.molang, time) : kv.vector;
                }
                float t = alpha;
                float t2 = t * t;
                float t3 = t2 * t;
                return new Vec3(0.5 * (2.0 * p1.x + (-p0.x + p2.x) * (double)t + (2.0 * p0.x - 5.0 * p1.x + 4.0 * p2.x - p3.x) * (double)t2 + (-p0.x + 3.0 * p1.x - 3.0 * p2.x + p3.x) * (double)t3), 0.5 * (2.0 * p1.y + (-p0.y + p2.y) * (double)t + (2.0 * p0.y - 5.0 * p1.y + 4.0 * p2.y - p3.y) * (double)t2 + (-p0.y + 3.0 * p1.y - 3.0 * p2.y + p3.y) * (double)t3), 0.5 * (2.0 * p1.z + (-p0.z + p2.z) * (double)t + (2.0 * p0.z - 5.0 * p1.z + 4.0 * p2.z - p3.z) * (double)t2 + (-p0.z + 3.0 * p1.z - 3.0 * p2.z + p3.z) * (double)t3));
            }
            return new Vec3(v1.x + (v2.x - v1.x) * (double)alpha, v1.y + (v2.y - v1.y) * (double)alpha, v1.z + (v2.z - v1.z) * (double)alpha);
        }

        private static Vec3 evalMolang(String expr, float time) {
            expr = expr.replace("query.anim_time", String.valueOf(time));
            try {
                if (expr.trim().startsWith("[") && expr.trim().endsWith("]")) {
                    String inner = expr.trim().substring(1, expr.trim().length() - 1);
                    String[] parts = inner.split(",");
                    return new Vec3(parts.length > 0 ? (double)PlayerBone.evalFloat(parts[0].trim(), time) : 0.0, parts.length > 1 ? (double)PlayerBone.evalFloat(parts[1].trim(), time) : 0.0, parts.length > 2 ? (double)PlayerBone.evalFloat(parts[2].trim(), time) : 0.0);
                }
                float val = PlayerBone.evalFloat(expr, time);
                return new Vec3((double)val, (double)val, (double)val);
            }
            catch (Exception e) {
                return Vec3.ZERO;
            }
        }

        private static float evalFloat(String expr, float time) {
            char c;
            int i;
            String lower = (expr = expr.replace("query.anim_time", String.valueOf(time)).trim().replace(" ", "")).toLowerCase();
            if (lower.startsWith("math.sin(") && lower.endsWith(")")) {
                return (float)Math.sin(Math.toRadians(PlayerBone.evalFloat(expr.substring(9, expr.length() - 1), time)));
            }
            if (lower.startsWith("math.cos(") && lower.endsWith(")")) {
                return (float)Math.cos(Math.toRadians(PlayerBone.evalFloat(expr.substring(9, expr.length() - 1), time)));
            }
            int depth = 0;
            for (i = expr.length() - 1; i >= 0; --i) {
                c = expr.charAt(i);
                if (c == ')') {
                    ++depth;
                    continue;
                }
                if (c == '(') {
                    --depth;
                    continue;
                }
                if (depth != 0 || c != '+' && (c != '-' || i <= 0)) continue;
                return c == '+' ? PlayerBone.evalFloat(expr.substring(0, i), time) + PlayerBone.evalFloat(expr.substring(i + 1), time) : PlayerBone.evalFloat(expr.substring(0, i), time) - PlayerBone.evalFloat(expr.substring(i + 1), time);
            }
            depth = 0;
            for (i = expr.length() - 1; i >= 0; --i) {
                c = expr.charAt(i);
                if (c == ')') {
                    ++depth;
                    continue;
                }
                if (c == '(') {
                    --depth;
                    continue;
                }
                if (depth != 0 || c != '*' && c != '/') continue;
                return c == '*' ? PlayerBone.evalFloat(expr.substring(0, i), time) * PlayerBone.evalFloat(expr.substring(i + 1), time) : PlayerBone.evalFloat(expr.substring(0, i), time) / PlayerBone.evalFloat(expr.substring(i + 1), time);
            }
            if (expr.startsWith("-")) {
                return -PlayerBone.evalFloat(expr.substring(1), time);
            }
            return Float.parseFloat(expr);
        }

        public static class Keyframe {
            public final float time;
            public final KeyframeValue value;
            public final KeyframeValue pre;
            public final KeyframeValue post;
            public final boolean catmullrom;

            public Keyframe(float time, KeyframeValue value, KeyframeValue pre, KeyframeValue post, boolean catmullrom) {
                this.time = time;
                this.value = value;
                this.pre = pre != null ? pre : value;
                this.post = post != null ? post : value;
                this.catmullrom = catmullrom;
            }
        }

        public static class KeyframeValue {
            public final Vec3 vector;
            public final String molang;

            public KeyframeValue(Vec3 vector) {
                this.vector = vector;
                this.molang = null;
            }

            public KeyframeValue(String molang) {
                this.molang = molang;
                this.vector = null;
            }

            public boolean isMolang() {
                return this.molang != null;
            }
        }
    }
}

