/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.starwars.jei_recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class RollingmachinerecipesRecipe
implements Recipe<RecipeInput> {
    private final List<ItemStack> output;
    private final NonNullList<Ingredient> recipeItems;

    public RollingmachinerecipesRecipe(List<ItemStack> output, NonNullList<Ingredient> recipeItems) {
        this.output = output;
        this.recipeItems = recipeItems;
    }

    public boolean matches(RecipeInput pContainer, Level pLevel) {
        if (pLevel.isClientSide()) {
            return false;
        }
        return false;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.recipeItems;
    }

    public ItemStack assemble(RecipeInput input, HolderLookup.Provider holder) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public List<ItemStack> getResultItems() {
        return this.output;
    }

    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Type
    implements RecipeType<RollingmachinerecipesRecipe> {
        public static final RecipeType<RollingmachinerecipesRecipe> INSTANCE = new Type();

        private Type() {
        }
    }

    public static class Serializer
    implements RecipeSerializer<RollingmachinerecipesRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        private static final MapCodec<RollingmachinerecipesRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ItemStack.OPTIONAL_CODEC.listOf().fieldOf("outputs").forGetter(recipe -> recipe.output), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(ingredients -> {
            Object[] aingredient = (Ingredient[])ingredients.toArray(Ingredient[]::new);
            if (aingredient.length == 0) {
                return DataResult.error(() -> "No ingredients found in custom recipe");
            }
            return DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])aingredient));
        }, DataResult::success).forGetter(recipe -> recipe.recipeItems)).apply((Applicative)builder, RollingmachinerecipesRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, RollingmachinerecipesRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<RollingmachinerecipesRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, RollingmachinerecipesRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static RollingmachinerecipesRecipe fromNetwork(RegistryFriendlyByteBuf buf) {
            NonNullList inputs = NonNullList.withSize((int)buf.readVarInt(), (Object)Ingredient.EMPTY);
            inputs.replaceAll(ingredients -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf));
            NonNullList outputs = NonNullList.withSize((int)buf.readVarInt(), (Object)ItemStack.EMPTY);
            outputs.replaceAll(results -> (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf));
            return new RollingmachinerecipesRecipe((List<ItemStack>)outputs, (NonNullList<Ingredient>)inputs);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buf, RollingmachinerecipesRecipe recipe) {
            buf.writeVarInt(recipe.getIngredients().size());
            for (Ingredient ing : recipe.getIngredients()) {
                if (ing.getItems()[0].getItem() == Items.AIR) {
                    Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)Ingredient.EMPTY);
                    continue;
                }
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)ing);
            }
            buf.writeVarInt(recipe.getResultItems().size());
            for (ItemStack itemstack : recipe.getResultItems()) {
                ItemStack.STREAM_CODEC.encode((Object)buf, (Object)itemstack);
            }
        }
    }
}

