/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.starwars.network;

import net.mcreator.starwars.StarwarsMod;
import net.mcreator.starwars.procedures.TPGeonosisgalaxyProcedure;
import net.mcreator.starwars.procedures.TPMustafargalaxyProcedure;
import net.mcreator.starwars.procedures.TPScarifGalaxyProcedure;
import net.mcreator.starwars.procedures.TPYavin4GalaxyProcedure;
import net.mcreator.starwars.procedures.TPearthgalaxyProcedure;
import net.mcreator.starwars.procedures.TPendorgalaxyProcedure;
import net.mcreator.starwars.procedures.TPhothgalaxyProcedure;
import net.mcreator.starwars.procedures.TPtatooinegalaxyProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber
public record GalaxyguiButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<GalaxyguiButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"starwars", (String)"galaxygui_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, GalaxyguiButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new GalaxyguiButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<GalaxyguiButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(GalaxyguiButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> GalaxyguiButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            TPearthgalaxyProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            TPhothgalaxyProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            TPendorgalaxyProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            TPtatooinegalaxyProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            TPMustafargalaxyProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 5) {
            TPGeonosisgalaxyProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 6) {
            TPScarifGalaxyProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 7) {
            TPYavin4GalaxyProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        StarwarsMod.addNetworkMessage(TYPE, STREAM_CODEC, GalaxyguiButtonMessage::handleData);
    }
}

