/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.starwars.network;

import net.mcreator.starwars.StarwarsMod;
import net.mcreator.starwars.procedures.TestInvisOnKeyPressedProcedure;
import net.mcreator.starwars.procedures.TestInvisOnKeyReleasedProcedure;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber
public record TestInvisMessage(int eventType, int pressedms) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<TestInvisMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"starwars", (String)"key_test_invis"));
    public static final StreamCodec<RegistryFriendlyByteBuf, TestInvisMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.eventType);
        buffer.writeInt(message.pressedms);
    }, buffer -> new TestInvisMessage(buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<TestInvisMessage> type() {
        return TYPE;
    }

    public static void handleData(TestInvisMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> TestInvisMessage.pressAction(context.player(), message.eventType, message.pressedms)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void pressAction(Player entity, int type, int pressedms) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        if (!world.hasChunkAt(entity.blockPosition())) {
            return;
        }
        if (type == 0) {
            TestInvisOnKeyPressedProcedure.execute((Entity)entity);
        }
        if (type == 1) {
            TestInvisOnKeyReleasedProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        StarwarsMod.addNetworkMessage(TYPE, STREAM_CODEC, TestInvisMessage::handleData);
    }
}

