/*
 * Decompiled with CFR 0.152.
 */
package net.dialingspoon.partialhearts;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.dialingspoon.partialhearts.rendering.DynamicCustomUniforms;
import net.dialingspoon.partialhearts.rendering.HeartMaskRenderState;
import net.minecraft.class_1059;
import net.minecraft.class_10725;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_7764;

public class PatternManager {
    public static final String ORIGINAL_PATTERN = "original";
    public static final String RANDOM_PATTERN = "random";
    private static String selectedPatternName = "original";
    private static int[] selectedPattern;
    private static int[] usedPixels;
    public static float displayHealthFloat;
    public static float health;
    public static ArrayList<HeartMaskRenderState> heartUniformQueue;
    public static final DynamicCustomUniforms ubo;
    private static final Gson GSON;

    public static int[] getUsedPixels() {
        return (int[])usedPixels.clone();
    }

    public static String getSelectedPatternName() {
        return selectedPatternName;
    }

    public static void setSelectedPattern(int[] selectedPattern) {
        PatternManager.selectedPattern = selectedPattern;
    }

    public static void savePatterns(Map<String, int[]> patterns, String selectedName, int[] selectedPattern) {
        try {
            selectedPatternName = selectedName;
            PatternManager.selectedPattern = selectedPattern;
            File configFile = new File(class_310.method_1551().field_1697, "config/partialhearts.json");
            configFile.getParentFile().mkdirs();
            configFile.createNewFile();
            HashMap<String, int[]> savePatterns = new HashMap<String, int[]>(patterns);
            savePatterns.remove(ORIGINAL_PATTERN);
            savePatterns.remove(RANDOM_PATTERN);
            PatternsConfig value = new PatternsConfig(savePatterns, selectedPatternName);
            try (FileWriter writer = new FileWriter(configFile);){
                GSON.toJson((Object)value, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Map<String, int[]> loadPatterns() {
        File configFile = new File(class_310.method_1551().field_1697, "config/partialhearts.json");
        HashMap<String, int[]> patterns = new HashMap<String, int[]>();
        patterns.put(ORIGINAL_PATTERN, PatternManager.createOriginalPattern());
        patterns.put(RANDOM_PATTERN, PatternManager.createRandomPattern());
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                PatternsConfig loadedConfig = (PatternsConfig)GSON.fromJson((Reader)reader, PatternsConfig.class);
                patterns.putAll(loadedConfig.patterns);
                selectedPatternName = loadedConfig.selectedPattern;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        selectedPattern = (int[])patterns.get(selectedPatternName);
        return patterns;
    }

    public static int[] createOriginalPattern() {
        int[] resultArray = PatternManager.getUsedPixels();
        int value = 1;
        for (int col = 8; col >= 0; --col) {
            for (int row = 0; row < 9; ++row) {
                int index = row * 9 + col;
                if (resultArray[index] != -1) continue;
                resultArray[index] = value++;
            }
        }
        return resultArray;
    }

    public static int[] createRandomPattern() {
        int[] resultArray = PatternManager.getUsedPixels();
        long visibleCount = Arrays.stream(resultArray).filter(value -> value == -1).count();
        ArrayList<Integer> randomValues = new ArrayList<Integer>();
        int i = 1;
        while ((long)i <= visibleCount) {
            randomValues.add(i);
            ++i;
        }
        Collections.shuffle(randomValues);
        int randomIndex = 0;
        for (int col = 8; col >= 0; --col) {
            for (int row = 0; row < 9; ++row) {
                int index = row * 9 + col;
                if (resultArray[index] != -1) continue;
                resultArray[index] = (Integer)randomValues.get(randomIndex++);
            }
        }
        return resultArray;
    }

    public static int[] createMaskBits(float health) {
        int[] pixelOrder = selectedPattern;
        int[] bits = new int[3];
        int usedIndicesCount = Arrays.stream(pixelOrder).max().orElse(0);
        double lastHeartFraction = 1.0 - (double)(health % 2.0f) / 2.0;
        lastHeartFraction = lastHeartFraction == 1.0 ? 0.0 : lastHeartFraction;
        int fullPixelsToRemove = (int)Math.ceil(lastHeartFraction * (double)(usedIndicesCount + 1));
        for (int i = 0; i < pixelOrder.length; ++i) {
            int idx = pixelOrder[i];
            if (idx >= fullPixelsToRemove || idx == 0) continue;
            int bucket = i / 27;
            int bitPos = i % 27;
            int n = bucket;
            bits[n] = bits[n] | 1 << bitPos;
        }
        return bits;
    }

    public static List<GpuBufferSlice> getUniformSlices() {
        ubo.reset();
        GpuBufferSlice[] gpuBufferSlices = ubo.writeHeartUniforms((HeartMaskRenderState[])heartUniformQueue.toArray(HeartMaskRenderState[]::new));
        heartUniformQueue.clear();
        return List.of(gpuBufferSlices);
    }

    public static void onResourceManagerReload() {
        ArrayList<class_2960> hearts = new ArrayList<class_2960>();
        for (class_329.class_6411 heartType : class_329.class_6411.values()) {
            if (heartType == class_329.class_6411.field_33944) continue;
            hearts.add(heartType.method_52705(false, false, false));
            hearts.add(heartType.method_52705(true, false, false));
            hearts.add(heartType.method_52705(false, false, true));
            hearts.add(heartType.method_52705(true, false, false));
        }
        class_1059 guiSprites = class_310.method_1551().method_72703().method_73025(class_10725.field_56385);
        int[] usedArray = new int[81];
        Arrays.fill(usedArray, 0);
        for (class_2960 heartLocation : hearts) {
            class_7764 sprite = guiSprites.method_4608(heartLocation).method_45851();
            sprite.method_45817().forEach(frame -> {
                for (int i = 0; i < 81; ++i) {
                    if (sprite.method_45810(frame, i % 9, i / 9)) continue;
                    usedArray[i] = -1;
                }
            });
            usedPixels = usedArray;
        }
        PatternManager.loadPatterns();
    }

    static {
        displayHealthFloat = -1.0f;
        health = -1.0f;
        heartUniformQueue = new ArrayList();
        ubo = new DynamicCustomUniforms();
        GSON = new GsonBuilder().setPrettyPrinting().create();
    }

    public record PatternsConfig(Map<String, int[]> patterns, String selectedPattern) {
    }
}

