/*
 * Decompiled with CFR 0.152.
 */
package net.dialingspoon.partialhearts;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.dialingspoon.partialhearts.PartialHearts;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiSpriteManager;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.resources.ResourceLocation;

public class PatternManager {
    public static final String ORIGINAL_PATTERN = "original";
    public static final String RANDOM_PATTERN = "random";
    private static String selectedPatternName = "original";
    private static int[] selectedPattern;
    private static int[] usedPixels;
    public static float displayHealthFloat;
    public static float health;
    private static final Gson GSON;

    public static int[] getUsedPixels() {
        return (int[])usedPixels.clone();
    }

    public static String getSelectedPatternName() {
        return selectedPatternName;
    }

    public static void setSelectedPattern(int[] selectedPattern) {
        PatternManager.selectedPattern = selectedPattern;
    }

    public static void savePatterns(Map<String, int[]> patterns, String selectedName, int[] selectedPattern) {
        try {
            selectedPatternName = selectedName;
            PatternManager.selectedPattern = selectedPattern;
            File configFile = new File(Minecraft.m_91087_().f_91069_, "config/partialhearts.json");
            configFile.getParentFile().mkdirs();
            configFile.createNewFile();
            HashMap<String, int[]> savePatterns = new HashMap<String, int[]>(patterns);
            savePatterns.remove(ORIGINAL_PATTERN);
            savePatterns.remove(RANDOM_PATTERN);
            PatternsConfig value = new PatternsConfig(savePatterns, selectedPatternName);
            try (FileWriter writer = new FileWriter(configFile);){
                GSON.toJson((Object)value, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Map<String, int[]> loadPatterns() {
        File configFile = new File(Minecraft.m_91087_().f_91069_, "config/partialhearts.json");
        HashMap<String, int[]> patterns = new HashMap<String, int[]>();
        patterns.put(ORIGINAL_PATTERN, PatternManager.createOriginalPattern());
        patterns.put(RANDOM_PATTERN, PatternManager.createRandomPattern());
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                PatternsConfig loadedConfig = (PatternsConfig)GSON.fromJson((Reader)reader, PatternsConfig.class);
                patterns.putAll(loadedConfig.patterns);
                selectedPatternName = loadedConfig.selectedPattern;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        selectedPattern = (int[])patterns.get(selectedPatternName);
        return patterns;
    }

    public static int[] createOriginalPattern() {
        int[] resultArray = PatternManager.getUsedPixels();
        int value = 1;
        for (int col = 8; col >= 0; --col) {
            for (int row = 0; row < 9; ++row) {
                int index = row * 9 + col;
                if (resultArray[index] != -1) continue;
                resultArray[index] = value++;
            }
        }
        return resultArray;
    }

    public static int[] createRandomPattern() {
        int[] resultArray = PatternManager.getUsedPixels();
        long visibleCount = Arrays.stream(resultArray).filter(value -> value == -1).count();
        ArrayList<Integer> randomValues = new ArrayList<Integer>();
        int i = 1;
        while ((long)i <= visibleCount) {
            randomValues.add(i);
            ++i;
        }
        Collections.shuffle(randomValues);
        int randomIndex = 0;
        for (int col = 8; col >= 0; --col) {
            for (int row = 0; row < 9; ++row) {
                int index = row * 9 + col;
                if (resultArray[index] != -1) continue;
                resultArray[index] = (Integer)randomValues.get(randomIndex++);
            }
        }
        return resultArray;
    }

    public static Supplier<ShaderInstance> getShader(float health, float u0, float u1, float v0, float v1) {
        return () -> {
            ShaderInstance shader = PartialHearts.SHADER;
            shader.m_173356_("UVStart").m_7971_(u0, v0);
            shader.m_173356_("UVEnd").m_7971_(u1, v1);
            shader.m_173356_("Mask").m_5941_(PatternManager.createMask(health));
            return shader;
        };
    }

    public static float[] createMask(float health) {
        int[] pixelOrder = selectedPattern;
        float[] mask = new float[81];
        long usedIndicesCount = Arrays.stream(pixelOrder).max().getAsInt();
        double lastHeartFraction = 1.0 - (double)(health % 2.0f) / 2.0;
        lastHeartFraction = lastHeartFraction == 1.0 ? 0.0 : lastHeartFraction;
        int fullPixelsToRemove = (int)Math.ceil(lastHeartFraction * (double)(usedIndicesCount + 1L));
        for (int i = 0; i < pixelOrder.length; ++i) {
            if (pixelOrder[i] >= fullPixelsToRemove || pixelOrder[i] == 0) continue;
            mask[i] = 1.0f;
        }
        return mask;
    }

    public static void onResourceManagerReload() {
        ArrayList<ResourceLocation> hearts = new ArrayList<ResourceLocation>();
        for (Gui.HeartType heartType : Gui.HeartType.values()) {
            if (heartType == Gui.HeartType.CONTAINER) continue;
            hearts.add(heartType.m_295491_(false, false, false));
            hearts.add(heartType.m_295491_(true, false, false));
            hearts.add(heartType.m_295491_(false, false, true));
            hearts.add(heartType.m_295491_(true, false, false));
        }
        GuiSpriteManager guiSprites = Minecraft.m_91087_().m_292761_();
        int[] usedArray = new int[81];
        Arrays.fill(usedArray, 0);
        for (ResourceLocation heartLocation : hearts) {
            SpriteContents sprite = guiSprites.m_118901_(heartLocation).m_245424_();
            sprite.m_245638_().forEach(frame -> {
                for (int i = 0; i < 81; ++i) {
                    if (sprite.m_245970_(frame, i % 9, i / 9)) continue;
                    usedArray[i] = -1;
                }
            });
            usedPixels = usedArray;
        }
        PatternManager.loadPatterns();
    }

    static {
        displayHealthFloat = -1.0f;
        health = -1.0f;
        GSON = new GsonBuilder().setPrettyPrinting().create();
    }

    public record PatternsConfig(Map<String, int[]> patterns, String selectedPattern) {
    }
}

