/*
 * Decompiled with CFR 0.152.
 */
package net.dialingspoon.partialhearts.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.dialingspoon.partialhearts.gui.PatternListScreen;
import net.dialingspoon.partialhearts.mixin.ScreenAccessor;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class PatternEditScreen
extends Screen {
    private static final int GRID_SIZE = 9;
    private static final int MAX_VALUE = 81;
    private static final int BUTTON_SIZE = 16;
    private final PatternListScreen parent;
    private final String oldName;
    private final int[] oldData;
    private final List<Gui.HeartType> backgroundSprites = new ArrayList<Gui.HeartType>();
    private int spriteIndex = 0;
    private EditBox nameField;
    private List<NumberButton> buttons;
    private int topOffset;
    private int leftOffset;
    private boolean mouseDown = false;
    private NumberButton hoveredButton;
    private String currentInput = "";

    public PatternEditScreen(PatternListScreen parent) {
        this(parent, null, null);
    }

    public PatternEditScreen(PatternListScreen parent, String oldName, int[] oldData) {
        super((Component)Component.m_237115_((String)"pattern_edit_screen.title"));
        this.parent = parent;
        this.oldName = oldName;
        this.oldData = oldData;
    }

    protected void m_7856_() {
        NumberButton btn;
        this.topOffset = 50;
        this.leftOffset = (this.f_96543_ - 144) / 2;
        ImageWidget infoSprite = ImageWidget.m_294506_((int)5, (int)5, (ResourceLocation)new ResourceLocation("partialhearts", "info"));
        infoSprite.m_264152_((this.f_96547_.m_92852_((FormattedText)this.f_96539_) + this.f_96543_) / 2 + 2, 2);
        infoSprite.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"pattern_edit_screen.info")));
        this.m_142416_((GuiEventListener)infoSprite);
        this.nameField = new EditBox(this.f_96547_, this.f_96543_ / 2 - 100, 20, 200, 20, (Component)Component.m_237119_());
        this.nameField.m_94199_(100);
        this.m_142416_((GuiEventListener)this.nameField);
        WidgetSprites sprites = new WidgetSprites(new ResourceLocation("partialhearts", "scroll_left"), new ResourceLocation("partialhearts", "scroll_left_highlighted"));
        this.m_142416_((GuiEventListener)new ArrowButton(this.f_96543_ / 2 - 96 - 32, this.topOffset + 64 - 16, 32, 32, sprites, b -> this.decrementSpriteIndex()));
        sprites = new WidgetSprites(new ResourceLocation("partialhearts", "scroll_right"), new ResourceLocation("partialhearts", "scroll_right_highlighted"));
        this.m_142416_((GuiEventListener)new ArrowButton(this.f_96543_ / 2 + 96, this.topOffset + 64 - 16, 32, 32, sprites, b -> this.incrementSpriteIndex()));
        this.buttons = new ArrayList<NumberButton>();
        for (int y = 0; y < 9; ++y) {
            for (int x = 0; x < 9; ++x) {
                btn = new NumberButton(this.leftOffset + x * 16, this.topOffset + y * 16, 16, 16, this::onButtonClick);
                this.buttons.add(btn);
                this.m_142416_((GuiEventListener)btn);
            }
        }
        if (this.oldName != null && this.oldData != null) {
            this.nameField.m_94144_(this.oldName);
            for (int i = 0; i < this.oldData.length && i < 81; ++i) {
                int val = this.oldData[i];
                if (val <= 0) continue;
                btn = this.buttons.get(i);
                btn.setValue(val);
            }
        }
        for (Gui.HeartType type : Gui.HeartType.values()) {
            if (type == Gui.HeartType.CONTAINER || this.backgroundSprites.contains(type)) continue;
            this.backgroundSprites.add(type);
        }
        int buttonY = this.topOffset + 144 + 16;
        Button cancelButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.cancel"), b -> this.m_7379_()).m_252794_(this.f_96543_ / 2 - 55, buttonY).m_253046_(50, 20).m_253136_();
        Button saveButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.done"), b -> this.onSave()).m_252794_(this.f_96543_ / 2 + 5, buttonY).m_253046_(50, 20).m_253136_();
        this.m_142416_((GuiEventListener)saveButton);
        this.m_142416_((GuiEventListener)cancelButton);
    }

    public void incrementSpriteIndex() {
        ++this.spriteIndex;
        if (this.spriteIndex >= this.backgroundSprites.size() * 4) {
            this.spriteIndex = 0;
        }
    }

    public void decrementSpriteIndex() {
        --this.spriteIndex;
        if (this.spriteIndex < 0) {
            this.spriteIndex = this.backgroundSprites.size() * 4 - 1;
        }
    }

    private void onButtonClick(NumberButton btn) {
        if (!btn.isPressed()) {
            int lowest = this.getLowestUnused();
            this.currentInput = String.valueOf(lowest);
            btn.setValue(lowest);
        } else {
            this.currentInput = "";
            btn.setValue(0);
        }
    }

    public int getLowestUnused() {
        boolean[] present = new boolean[81];
        for (NumberButton button : this.buttons) {
            if (!button.isPressed()) continue;
            present[button.getValue() - 1] = true;
        }
        for (int i = 1; i <= 81; ++i) {
            if (present[i - 1]) continue;
            return i;
        }
        return 81;
    }

    private void onSave() {
        String newName = this.nameField.m_94155_().trim();
        if (newName.isEmpty()) {
            newName = "new pattern";
        }
        int[] values = new int[81];
        for (int i = 0; i < this.buttons.size() && i < 81; ++i) {
            NumberButton btn = this.buttons.get(i);
            values[i] = btn.isPressed() ? btn.getValue() : 0;
        }
        this.parent.onPatternSaved(this.oldName, newName, values);
        this.f_96541_.m_91152_((Screen)this.parent);
    }

    public void m_7379_() {
        this.parent.onPatternEditCanceled();
        this.f_96541_.m_91152_((Screen)this.parent);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.mouseDown = true;
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.mouseDown = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    public void m_94757_(double mouseX, double mouseY) {
        boolean buttonHovered = false;
        for (NumberButton btn : this.buttons) {
            if (!btn.m_5953_(mouseX, mouseY)) continue;
            buttonHovered = true;
            if (this.hoveredButton == btn) break;
            this.finalizeNumber();
            this.hoveredButton = btn;
            if (this.mouseDown) {
                btn.m_5716_(mouseX, mouseY);
            }
            this.currentInput = btn.isPressed() ? String.valueOf(btn.getValue()) : "";
            break;
        }
        if (!buttonHovered) {
            this.finalizeNumber();
            this.hoveredButton = null;
            this.currentInput = "";
        }
    }

    private void finalizeNumber() {
        if (this.hoveredButton == null) {
            return;
        }
        int val = this.parseSafe(this.currentInput);
        if (val < 1 || val > 81) {
            this.hoveredButton.setValue(0);
        } else {
            this.hoveredButton.setValue(val);
        }
        this.currentInput = "";
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.hoveredButton != null && keyCode >= 48 && keyCode <= 57) {
            this.nameField.m_93692_(false);
            int digit = keyCode - 48;
            this.handleDigitInput(digit);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private void handleDigitInput(int digit) {
        Object newInput = this.currentInput + digit;
        int val = this.parseSafe((String)newInput);
        while (val > 81) {
            newInput = ((String)newInput).length() > 1 ? ((String)newInput).substring(1) : "";
            val = this.parseSafe((String)newInput);
        }
        if (val == 0) {
            this.currentInput = "";
            return;
        }
        this.currentInput = newInput;
    }

    private int parseSafe(String input) {
        if (input == null || input.isEmpty()) {
            return 0;
        }
        try {
            return Integer.parseInt(input);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public void m_88315_(GuiGraphics gg, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(gg, mouseX, mouseY, partialTicks);
        Gui.HeartType heartType = this.backgroundSprites.get(this.spriteIndex / 4);
        boolean hardcore = this.spriteIndex / 2 % 2 == 1;
        boolean blinking = this.spriteIndex % 2 == 1;
        gg.m_292816_(heartType.m_295491_(hardcore, false, blinking), this.leftOffset, this.topOffset, 144, 144);
        for (Renderable renderable : ((ScreenAccessor)((Object)this)).getRenderables()) {
            renderable.m_88315_(gg, mouseX, mouseY, partialTicks);
        }
        gg.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 5, 0xFFFFFF);
        this.nameField.m_88315_(gg, mouseX, mouseY, partialTicks);
    }

    public class ArrowButton
    extends Button {
        private final WidgetSprites sprites;

        public ArrowButton(int i, int j, int k, int l, WidgetSprites widgetSprites, Button.OnPress onPress) {
            super(i, j, k, l, CommonComponents.f_237098_, onPress, f_252438_);
            this.sprites = widgetSprites;
        }

        public void m_87963_(GuiGraphics guiGraphics, int i, int j, float f) {
            ResourceLocation resourceLocation = this.sprites.m_295557_(this.m_142518_(), this.f_93622_ && PatternEditScreen.this.mouseDown);
            guiGraphics.m_292816_(resourceLocation, this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_);
        }
    }

    class NumberButton
    extends AbstractWidget {
        private int value;
        private final Consumer<NumberButton> onPress;

        public NumberButton(int x, int y, int width, int height, Consumer<NumberButton> onPress) {
            super(x, y, width, height, (Component)Component.m_237119_());
            this.value = 0;
            this.onPress = onPress;
        }

        public void m_5716_(double mouseX, double mouseY) {
            this.onPress.accept(this);
        }

        protected void m_168797_(NarrationElementOutput narrationElementOutput) {
            narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)this.m_5646_());
            narrationElementOutput.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237113_((String)String.valueOf(this.value)));
        }

        public void m_87963_(GuiGraphics gg, int mouseX, int mouseY, float partialTicks) {
            int color = -2139062144;
            int displayNumber = this.value;
            if (this == PatternEditScreen.this.hoveredButton) {
                displayNumber = PatternEditScreen.this.parseSafe(PatternEditScreen.this.currentInput);
            }
            if (displayNumber > 0) {
                color = -2143272896;
            }
            gg.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, color);
            if (displayNumber > 0) {
                String numStr = String.valueOf(displayNumber);
                int textWidth = PatternEditScreen.this.f_96547_.m_92895_(numStr);
                int textX = this.m_252754_() + (this.f_93618_ - textWidth) / 2;
                int n = this.m_252907_();
                Objects.requireNonNull(PatternEditScreen.this.f_96547_);
                int textY = n + (this.f_93619_ - 9) / 2;
                gg.m_280056_(PatternEditScreen.this.f_96547_, numStr, textX, textY, -1, false);
            }
        }

        public boolean isPressed() {
            return this.value > 0;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }
}

