/*
 * Decompiled with CFR 0.152.
 */
package net.dialingspoon.partialhearts.gui;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.dialingspoon.partialhearts.PatternManager;
import net.dialingspoon.partialhearts.gui.PatternEditScreen;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class PatternListScreen
extends Screen {
    private final Screen parent;
    private String selectedPatternName = PatternManager.getSelectedPatternName();
    private final Map<String, int[]> patterns;
    private PatternList patternList;
    private long initTime;

    public PatternListScreen(Screen parent) {
        super((Component)Component.m_237115_((String)"patternlist.title"));
        this.parent = parent;
        this.patterns = PatternManager.loadPatterns();
    }

    protected void m_7856_() {
        this.initTime = Util.m_137550_();
        this.patternList = new PatternList(this.f_96541_, this.f_96543_, 175, 30, 22);
        this.m_142416_((GuiEventListener)this.patternList);
        int buttonY = this.f_96544_ - 26;
        Button newButton = Button.m_253074_((Component)Component.m_237115_((String)"patternlist.new"), b -> this.f_96541_.m_91152_((Screen)new PatternEditScreen(this))).m_252794_(this.f_96543_ / 2 - 100, buttonY).m_253046_(60, 20).m_253136_();
        Button doneButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.done"), b -> this.m_7379_()).m_252794_(this.f_96543_ / 2 + 40, buttonY).m_253046_(60, 20).m_253136_();
        this.m_142416_((GuiEventListener)newButton);
        this.m_142416_((GuiEventListener)doneButton);
    }

    public void m_88315_(GuiGraphics gg, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(gg, mouseX, mouseY, partialTicks);
        gg.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 10, 0xFFFFFF);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean result = super.m_6375_(mouseX, mouseY, button);
        PatternEntry selected = (PatternEntry)this.patternList.m_93511_();
        if (selected != null) {
            this.selectedPatternName = selected.getName();
        }
        return result;
    }

    public void m_7379_() {
        PatternManager.savePatterns(this.patterns, this.selectedPatternName, this.patterns.get(this.selectedPatternName));
        this.f_96541_.m_91152_(this.parent);
    }

    public void onPatternSaved(String oldName, String newName, int[] newData) {
        if (oldName != null) {
            this.patterns.remove(oldName);
        }
        while (this.patterns.containsKey(newName)) {
            newName = this.incrementName(newName);
        }
        this.patterns.put(newName, newData);
        this.selectedPatternName = newName;
        this.m_232761_();
    }

    public void onPatternEditCanceled() {
        this.m_232761_();
    }

    private void deletePattern(String name) {
        this.patterns.remove(name);
        if (this.selectedPatternName.equals(name)) {
            this.selectedPatternName = "original";
        }
        this.m_232761_();
    }

    private void duplicatePattern(String name) {
        int[] data = this.patterns.get(name);
        String newName = this.incrementName(name);
        while (this.patterns.containsKey(newName)) {
            newName = this.incrementName(newName);
        }
        int[] newData = Arrays.copyOf(data, data.length);
        this.patterns.put(newName, newData);
        this.m_232761_();
    }

    private String incrementName(String name) {
        int numberVal;
        int len;
        int lastDigitStart = len = name.length();
        for (int i = len - 1; i >= 0; --i) {
            if (Character.isDigit(name.charAt(i))) continue;
            lastDigitStart = i + 1;
            break;
        }
        if (lastDigitStart == len) {
            return name + "2";
        }
        String prefix = name.substring(0, lastDigitStart);
        String numberStr = name.substring(lastDigitStart);
        try {
            numberVal = Integer.parseInt(numberStr);
        }
        catch (NumberFormatException e) {
            numberVal = 1;
        }
        return prefix + ++numberVal;
    }

    class PatternList
    extends ContainerObjectSelectionList<PatternEntry> {
        public PatternList(Minecraft minecraft, int width, int height, int y, int itemHeight) {
            super(minecraft, width, height, y, y + height, itemHeight);
            this.addEntry(new PatternEntry("original", PatternListScreen.this.patterns.get("original"), true));
            this.addEntry(new PatternEntry("random", PatternListScreen.this.patterns.get("random"), true));
            List sortedEntries = PatternListScreen.this.patterns.entrySet().stream().filter(e -> !((String)e.getKey()).equals("original") && !((String)e.getKey()).equals("random")).sorted(Map.Entry.comparingByKey()).toList();
            for (Map.Entry entry : sortedEntries) {
                this.addEntry(new PatternEntry((String)entry.getKey(), (int[])entry.getValue(), false));
            }
        }

        public int m_5759_() {
            return this.f_93388_ - 60;
        }

        public boolean m_93696_() {
            return PatternListScreen.this.m_7222_() == this;
        }

        protected int addEntry(PatternEntry entry) {
            this.m_6702_().add(entry);
            if (entry.getName().equals(PatternListScreen.this.selectedPatternName)) {
                this.m_6987_((AbstractSelectionList.Entry)entry);
            }
            return this.m_6702_().size() - 1;
        }
    }

    class PatternEntry
    extends ContainerObjectSelectionList.Entry<PatternEntry> {
        private final String name;
        private final int[] data;
        private final boolean special;
        private final CheckButton selectButton;
        private Button editButton;
        private Button duplicateButton;
        private Button deleteButton;

        public PatternEntry(String name, int[] data, boolean special) {
            this.name = name;
            this.data = data;
            this.special = special;
            this.selectButton = new CheckButton(PatternListScreen.this.f_96543_ / 2 - 5, 0, 20, this);
            PatternListScreen.this.m_7787_((GuiEventListener)this.selectButton);
            if (!special) {
                this.editButton = Button.m_253074_((Component)Component.m_237115_((String)"patternlist.edit"), b -> this.onEdit()).m_253046_(40, 20).m_253136_();
                this.duplicateButton = Button.m_253074_((Component)Component.m_237115_((String)"patternlist.duplicate"), b -> this.onDuplicate()).m_253046_(60, 20).m_253136_();
                this.deleteButton = Button.m_253074_((Component)Component.m_237115_((String)"patternlist.delete"), b -> this.onDelete()).m_253046_(50, 20).m_253136_();
            }
        }

        public String getName() {
            return this.name;
        }

        public void m_6311_(GuiGraphics gg, int index, int top, int left, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float partialTick) {
            PatternManager.setSelectedPattern(PatternListScreen.this.patterns.get(this.name));
            gg.m_292816_(Gui.HeartType.CONTAINER.m_295491_(false, false, false), left - 20, top + 7, 18, 18);
            PatternManager.health = 2.0f - (float)(Util.m_137550_() - PatternListScreen.this.initTime) / 500.0f % 20.0f / 10.0f;
            gg.m_292816_(Gui.HeartType.NORMAL.m_295491_(false, false, false), left - 20, top + 7, 18, 18);
            PatternEntry.drawScrollableText(gg, PatternListScreen.this.f_96547_, (Component)Component.m_237113_((String)this.name), left += 5, top + 5, 160, 20, 0xFFFFFF);
            this.selectButton.m_264152_(left += rowWidth / 2, top);
            this.selectButton.m_88315_(gg, mouseX, mouseY, partialTick);
            left += rowWidth > 367 ? 30 : rowWidth / 12;
            if (!this.special) {
                this.editButton.m_264152_(left, top);
                this.editButton.m_88315_(gg, mouseX, mouseY, partialTick);
                this.duplicateButton.m_264152_(left += rowWidth > 367 ? 45 : rowWidth / 8, top);
                this.duplicateButton.m_88315_(gg, mouseX, mouseY, partialTick);
                this.deleteButton.m_264152_(left += rowWidth > 367 ? 65 : (int)((float)rowWidth / 5.5f), top);
                this.deleteButton.m_88315_(gg, mouseX, mouseY, partialTick);
            }
        }

        protected static void drawScrollableText(GuiGraphics context, Font textRenderer, Component text, int startX, int startY, int width, int height, int color) {
            int endX = startX + width;
            int endY = startY + height;
            int i = textRenderer.m_92852_((FormattedText)text);
            int var10000 = startY + endY;
            Objects.requireNonNull(textRenderer);
            int j = (var10000 - 9) / 2 + 1;
            int k = endX - startX;
            if (i > k) {
                int l = i - k;
                double d = (double)Util.m_137550_() / 250.0;
                double e = Math.max((double)l * 0.5, 3.0);
                double f = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d / e)) / 2.0 + 0.5;
                double g = Mth.m_14139_((double)f, (double)0.0, (double)l);
                context.m_280588_(startX, startY, endX, endY);
                context.m_280430_(textRenderer, text, startX - (int)g, j, color);
                context.m_280618_();
            } else {
                context.m_280430_(textRenderer, text, startX, j, color);
            }
        }

        @NotNull
        public List<? extends GuiEventListener> m_6702_() {
            if (this.special) {
                return Collections.emptyList();
            }
            return ImmutableList.of((Object)this.editButton, (Object)this.duplicateButton, (Object)this.deleteButton);
        }

        @NotNull
        public List<? extends NarratableEntry> m_142437_() {
            if (this.special) {
                return Collections.emptyList();
            }
            return ImmutableList.of((Object)this.editButton, (Object)this.duplicateButton, (Object)this.deleteButton);
        }

        private void onEdit() {
            PatternListScreen.this.f_96541_.m_91152_((Screen)new PatternEditScreen(PatternListScreen.this, this.name, this.data));
        }

        private void onDuplicate() {
            PatternListScreen.this.duplicatePattern(this.name);
        }

        private void onDelete() {
            PatternListScreen.this.deletePattern(this.name);
        }
    }

    class CheckButton
    extends AbstractWidget {
        private final WidgetSprites sprites;
        private final PatternEntry parent;

        public CheckButton(int i, int j, int k, PatternEntry parent) {
            super(i, j, k, k, CommonComponents.f_237098_);
            this.sprites = new WidgetSprites(new ResourceLocation("widget/checkbox_selected"), new ResourceLocation("widget/checkbox"), new ResourceLocation("widget/checkbox_selected_highlighted"), new ResourceLocation("widget/checkbox_highlighted"));
            this.parent = parent;
        }

        public void m_168797_(NarrationElementOutput narrationElementOutput) {
            this.m_168802_(narrationElementOutput);
        }

        protected void m_87963_(GuiGraphics guiGraphics, int i, int j, float f) {
            guiGraphics.m_292816_(this.sprites.m_295557_(PatternListScreen.this.patternList.m_93511_() == this.parent, this.f_93622_), this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_);
        }

        public void m_5716_(double d, double e) {
            PatternListScreen.this.patternList.m_6987_((AbstractSelectionList.Entry)this.parent);
        }
    }
}

