/*
 * Decompiled with CFR 0.152.
 */
package net.dialingspoon.partialhearts;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.dialingspoon.partialhearts.PartialHearts;
import net.dialingspoon.partialhearts.PlatformSpecific;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5944;
import terrails.colorfulhearts.CColorfulHearts;

public class PatternManager {
    public static final String ORIGINAL_PATTERN = "original";
    public static final String RANDOM_PATTERN = "random";
    private static String selectedPatternName = "original";
    private static int[] selectedPattern;
    private static int[] usedPixels;
    public static float displayHealthFloat;
    public static float health;
    private static final Gson GSON;

    public static int[] getUsedPixels() {
        return (int[])usedPixels.clone();
    }

    public static String getSelectedPatternName() {
        return selectedPatternName;
    }

    public static void setSelectedPattern(int[] selectedPattern) {
        PatternManager.selectedPattern = selectedPattern;
    }

    public static void savePatterns(Map<String, int[]> patterns, String selectedName, int[] selectedPattern) {
        try {
            selectedPatternName = selectedName;
            PatternManager.selectedPattern = selectedPattern;
            File configFile = new File(class_310.method_1551().field_1697, "config/partialhearts.json");
            configFile.getParentFile().mkdirs();
            configFile.createNewFile();
            HashMap<String, int[]> savePatterns = new HashMap<String, int[]>(patterns);
            savePatterns.remove(ORIGINAL_PATTERN);
            savePatterns.remove(RANDOM_PATTERN);
            PatternsConfig value = new PatternsConfig(savePatterns, selectedPatternName);
            try (FileWriter writer = new FileWriter(configFile);){
                GSON.toJson((Object)value, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Map<String, int[]> loadPatterns() {
        File configFile = new File(class_310.method_1551().field_1697, "config/partialhearts.json");
        HashMap<String, int[]> patterns = new HashMap<String, int[]>();
        patterns.put(ORIGINAL_PATTERN, PatternManager.createOriginalPattern());
        patterns.put(RANDOM_PATTERN, PatternManager.createRandomPattern());
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                PatternsConfig loadedConfig = (PatternsConfig)GSON.fromJson((Reader)reader, PatternsConfig.class);
                patterns.putAll(loadedConfig.patterns);
                selectedPatternName = loadedConfig.selectedPattern;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        selectedPattern = (int[])patterns.get(selectedPatternName);
        return patterns;
    }

    public static int[] createOriginalPattern() {
        int[] resultArray = PatternManager.getUsedPixels();
        int value = 1;
        for (int col = 8; col >= 0; --col) {
            for (int row = 0; row < 9; ++row) {
                int index = row * 9 + col;
                if (resultArray[index] != -1) continue;
                resultArray[index] = value++;
            }
        }
        return resultArray;
    }

    public static int[] createRandomPattern() {
        int[] resultArray = PatternManager.getUsedPixels();
        long visibleCount = Arrays.stream(resultArray).filter(value -> value == -1).count();
        ArrayList<Integer> randomValues = new ArrayList<Integer>();
        int i = 1;
        while ((long)i <= visibleCount) {
            randomValues.add(i);
            ++i;
        }
        Collections.shuffle(randomValues);
        int randomIndex = 0;
        for (int col = 8; col >= 0; --col) {
            for (int row = 0; row < 9; ++row) {
                int index = row * 9 + col;
                if (resultArray[index] != -1) continue;
                resultArray[index] = (Integer)randomValues.get(randomIndex++);
            }
        }
        return resultArray;
    }

    public static Supplier<class_5944> getShader(float health, float u0, float u1, float v0, float v1) {
        return PatternManager.getShader(false, health, u0, u1, v0, v1);
    }

    public static Supplier<class_5944> getShader(boolean color, float health, float u0, float u1, float v0, float v1) {
        return () -> {
            class_5944 shader = color ? PartialHearts.COLOR_SHADER : PartialHearts.SHADER;
            shader.method_35785("UVStart").method_1255(u0, v0);
            shader.method_35785("UVEnd").method_1255(u1, v1);
            shader.method_35785("Mask").method_1253(PatternManager.createMask(health));
            return shader;
        };
    }

    public static float[] createMask(float health) {
        int[] pixelOrder = selectedPattern;
        float[] mask = new float[81];
        long usedIndicesCount = Arrays.stream(pixelOrder).max().getAsInt();
        double lastHeartFraction = 1.0 - (double)(health % 2.0f) / 2.0;
        lastHeartFraction = lastHeartFraction == 1.0 ? 0.0 : lastHeartFraction;
        int fullPixelsToRemove = (int)Math.ceil(lastHeartFraction * (double)(usedIndicesCount + 1L));
        for (int i = 0; i < pixelOrder.length; ++i) {
            if (pixelOrder[i] >= fullPixelsToRemove || pixelOrder[i] == 0) continue;
            mask[i] = 1.0f;
        }
        return mask;
    }

    public static void onResourceManagerReload(class_3300 resourceManager) {
        class_1011 image;
        int[] yPositions;
        int[] xPositions;
        class_2960 original;
        if (PlatformSpecific.isModLoaded("colorfulhearts")) {
            original = CColorfulHearts.HEALTH_ICONS_LOCATION;
            xPositions = new int[]{0, 18, 36, 54};
            yPositions = new int[]{0, 9, 18, 36, 45, 54};
        } else {
            original = new class_2960("textures/gui/icons.png");
            xPositions = Arrays.stream(class_329.class_6411.values()).filter(heartType -> heartType != class_329.class_6411.field_33944).flatMapToInt(type -> IntStream.of(type.method_37302(false, false), type.method_37302(false, true), type.method_37302(true, false), type.method_37302(true, true))).toArray();
            yPositions = new int[]{0, 45};
        }
        try {
            class_3298 resource = resourceManager.getResourceOrThrow(original);
            InputStream inputStream = resource.method_14482();
            image = class_1011.method_4309((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        class_1011 cellImage = new class_1011(9, 9, true);
        int[] usedArray = new int[81];
        Arrays.fill(usedArray, 0);
        for (int x : xPositions) {
            for (int y : yPositions) {
                image.method_47594(cellImage, x, y, 0, 0, 9, 9, false, false);
                for (int i = 0; i < 81; ++i) {
                    int pixel = cellImage.method_4315(i % 9, i / 9);
                    if (pixel >>> 24 == 0) continue;
                    usedArray[i] = -1;
                }
            }
        }
        usedPixels = usedArray;
        cellImage.close();
        image.close();
        PatternManager.loadPatterns();
    }

    static {
        displayHealthFloat = -1.0f;
        health = -1.0f;
        GSON = new GsonBuilder().setPrettyPrinting().create();
    }

    public static final class PatternsConfig {
        private final Map<String, int[]> patterns;
        private final String selectedPattern;

        public PatternsConfig(Map<String, int[]> patterns, String selectedPattern) {
            this.patterns = Map.copyOf(patterns);
            this.selectedPattern = selectedPattern;
        }
    }
}

