/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.vulnerablevillages;

import net.mcreator.vulnerablevillages.AiSystem;
import net.mcreator.vulnerablevillages.configuration.VulnerableVillagesServerConfigConfiguration;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.pathfinder.Path;

public class CreeperSuicideSystem
implements AiSystem {
    private static final int MAX_STUCK_TICKS = 60;
    private static final double MIN_DISTANCE = 2.5;

    @Override
    public boolean applies(Entity entity) {
        return entity instanceof Creeper && (Boolean)VulnerableVillagesServerConfigConfiguration.CAN_CREEPERS_EXPLODE.get() != false;
    }

    @Override
    public void tick(Entity entity) {
        Creeper creeper = (Creeper)entity;
        if (creeper.m_9236_().f_46443_) {
            return;
        }
        LivingEntity target = creeper.m_5448_();
        if (target == null || !target.m_6084_()) {
            try {
                GoalSelector selector = creeper.f_21346_;
                NearestAttackableTargetGoal goal = new NearestAttackableTargetGoal((Mob)creeper, LivingEntity.class, 10, false, false, e -> e instanceof Villager);
                selector.m_25352_(1, (Goal)goal);
            }
            catch (Exception selector) {
                // empty catch block
            }
            return;
        }
        if ((double)creeper.m_20270_((Entity)target) < 2.5) {
            return;
        }
        int stuck = creeper.getPersistentData().m_128451_("CreeperStuckTicks");
        Path path = creeper.m_21573_().m_26570_();
        stuck = path == null || path.m_77392_() || !this.canReach(creeper, target) ? ++stuck : 0;
        creeper.getPersistentData().m_128405_("CreeperStuckTicks", stuck);
        if (stuck > 60) {
            creeper.m_32312_();
            creeper.getPersistentData().m_128405_("CreeperStuckTicks", 0);
        }
    }

    private boolean canReach(Creeper creeper, LivingEntity target) {
        return creeper.m_21573_().m_6570_((Entity)target, 0) != null;
    }
}

