/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.vulnerablevillages;

import java.util.HashSet;
import java.util.Set;
import net.mcreator.vulnerablevillages.AiSystem;
import net.mcreator.vulnerablevillages.configuration.VulnerableVillagesServerConfigConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class TorchBreakSystem
implements AiSystem {
    private static final String KEY_BROKEN = "BrokenTorchPositions";
    private static final int COOLDOWN_TICKS = 100;

    @Override
    public boolean applies(Entity entity) {
        return entity instanceof Zombie || entity instanceof Husk && (Boolean)VulnerableVillagesServerConfigConfiguration.CAN_BREAK_LIGHT_SOURCES.get() != false;
    }

    @Override
    public void tick(Entity entity) {
        Zombie zombie = (Zombie)entity;
        if (zombie.m_9236_().m_5776_()) {
            return;
        }
        Level world = zombie.m_9236_();
        BlockPos zombiePos = zombie.m_20183_();
        CompoundTag nbt = zombie.getPersistentData();
        Set<BlockPos> broken = this.getBrokenPositions(nbt);
        broken.removeIf(pos -> zombie.f_19797_ - this.getTimestamp(nbt, (BlockPos)pos) > 100);
        int range = 3;
        for (int x = -range; x <= range; ++x) {
            for (int y = -1; y <= 2; ++y) {
                for (int z = -range; z <= range; ++z) {
                    BlockState state;
                    BlockPos target = zombiePos.m_7918_(x, y, z);
                    if (broken.contains(target) || !this.isLightSource(state = world.m_8055_(target))) continue;
                    world.m_46961_(target, false);
                    broken.add(target);
                    this.setTimestamp(nbt, target, zombie.f_19797_);
                    this.saveBrokenPositions(nbt, broken);
                    return;
                }
            }
        }
    }

    private boolean isLightSource(BlockState state) {
        return state.m_60713_(Blocks.f_50081_) || state.m_60713_(Blocks.f_50082_) || state.m_60713_(Blocks.f_50681_) || state.m_60713_(Blocks.f_50139_) || state.m_60713_(Blocks.f_50140_) || state.m_60713_(Blocks.f_50682_);
    }

    private Set<BlockPos> getBrokenPositions(CompoundTag nbt) {
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        if (nbt.m_128441_(KEY_BROKEN)) {
            long[] arr;
            for (long l : arr = nbt.m_128467_(KEY_BROKEN)) {
                set.add(BlockPos.m_122022_((long)l));
            }
        }
        return set;
    }

    private void saveBrokenPositions(CompoundTag nbt, Set<BlockPos> set) {
        long[] arr = set.stream().mapToLong(BlockPos::m_121878_).toArray();
        nbt.m_128388_(KEY_BROKEN, arr);
    }

    private int getTimestamp(CompoundTag nbt, BlockPos pos) {
        return nbt.m_128451_("TS_" + pos.m_121878_());
    }

    private void setTimestamp(CompoundTag nbt, BlockPos pos, int tick) {
        nbt.m_128405_("TS_" + pos.m_121878_(), tick);
    }
}

