/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.client.render.AbstractMonolithRenderer;
import com.Polarice3.Goety.client.render.ModModelLayer;
import com.Polarice3.Goety.client.render.model.MonolithModel;
import com.Polarice3.Goety.common.entities.hostile.servants.ObsidianMonolith;
import com.Polarice3.Goety.common.entities.neutral.AbstractMonolith;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class ObsidianMonolithRenderer<T extends AbstractMonolith>
extends AbstractMonolithRenderer<T>
implements RenderLayerParent<T, MonolithModel<T>> {
    private static final ResourceLocation TEXTURE_LOCATION = Goety.location("textures/entity/monolith/obsidian_monolith.png");
    private static final RenderType RENDER_TYPE = RenderType.m_110488_((ResourceLocation)Goety.location("textures/entity/monolith/obsidian_monolith_glow.png"));
    private static final Map<AbstractMonolith.Crackiness, ResourceLocation> resourceLocations = ImmutableMap.of((Object)((Object)AbstractMonolith.Crackiness.LOW), (Object)Goety.location("textures/entity/monolith/obsidian_monolith_crack_1.png"), (Object)((Object)AbstractMonolith.Crackiness.MEDIUM), (Object)Goety.location("textures/entity/monolith/obsidian_monolith_crack_2.png"), (Object)((Object)AbstractMonolith.Crackiness.HIGH), (Object)Goety.location("textures/entity/monolith/obsidian_monolith_crack_3.png"));
    private static final ResourceLocation RESOURCE_LOCATION = Goety.location("textures/entity/monolith/obsidian_monolith_beam.png");
    private static final RenderType BEAM_RENDER_TYPE = RenderType.m_110458_((ResourceLocation)RESOURCE_LOCATION);
    private final RenderLayer<T, MonolithModel<T>> layer;

    public ObsidianMonolithRenderer(EntityRendererProvider.Context p_i47208_1_) {
        super(p_i47208_1_);
        this.layer = new OMShieldLayer(this, p_i47208_1_.m_174027_());
    }

    @Override
    public RenderType getActivatedTextureLocation(AbstractMonolith monolith) {
        return RENDER_TYPE;
    }

    @Override
    public Map<AbstractMonolith.Crackiness, ResourceLocation> cracknessLocation() {
        return resourceLocations;
    }

    private Vec3 getPosition(LivingEntity p_114803_, double p_114804_, float p_114805_) {
        double d0 = Mth.m_14139_((double)p_114805_, (double)p_114803_.f_19790_, (double)p_114803_.m_20185_());
        double d1 = Mth.m_14139_((double)p_114805_, (double)p_114803_.f_19791_, (double)p_114803_.m_20186_()) + p_114804_;
        double d2 = Mth.m_14139_((double)p_114805_, (double)p_114803_.f_19792_, (double)p_114803_.m_20189_());
        return new Vec3(d0, d1, d2);
    }

    @Override
    public void render(T pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        super.render(pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
        LivingEntity livingentity = ((Owned)pEntity).getTrueOwner();
        if (livingentity != null && !((AbstractMonolith)pEntity).isEmerging()) {
            float f1 = (float)((AbstractMonolith)pEntity).f_19797_ + pPartialTicks;
            float f2 = f1 * 0.5f % 1.0f;
            float f3 = pEntity.m_20192_();
            pMatrixStack.m_85836_();
            pMatrixStack.m_252880_(0.0f, f3, 0.0f);
            Vec3 vec3 = this.getPosition(livingentity, (double)livingentity.m_20206_() * 0.5, pPartialTicks);
            Vec3 vec31 = this.getPosition((LivingEntity)pEntity, f3, pPartialTicks);
            Vec3 vec32 = vec3.m_82546_(vec31);
            float f4 = (float)(vec32.m_82553_() + 1.0);
            vec32 = vec32.m_82541_();
            float f5 = (float)Math.acos(vec32.f_82480_);
            float f6 = (float)Math.atan2(vec32.f_82481_, vec32.f_82479_);
            pMatrixStack.m_252781_(Axis.f_252436_.m_252977_((1.5707964f - f6) * 57.295776f));
            pMatrixStack.m_252781_(Axis.f_252529_.m_252977_(f5 * 57.295776f));
            float f7 = f1 * 0.05f * -1.5f;
            int j = 0;
            int k = 0;
            int l = 0;
            float f9 = 0.2f;
            float f10 = 0.282f;
            float f11 = Mth.m_14089_((float)(f7 + 2.3561945f)) * f10;
            float f12 = Mth.m_14031_((float)(f7 + 2.3561945f)) * f10;
            float f13 = Mth.m_14089_((float)(f7 + 0.7853982f)) * f10;
            float f14 = Mth.m_14031_((float)(f7 + 0.7853982f)) * f10;
            float f15 = Mth.m_14089_((float)(f7 + 3.926991f)) * f10;
            float f16 = Mth.m_14031_((float)(f7 + 3.926991f)) * f10;
            float f17 = Mth.m_14089_((float)(f7 + 5.4977875f)) * f10;
            float f18 = Mth.m_14031_((float)(f7 + 5.4977875f)) * f10;
            float f19 = Mth.m_14089_((float)(f7 + (float)Math.PI)) * f9;
            float f20 = Mth.m_14031_((float)(f7 + (float)Math.PI)) * f9;
            float f21 = Mth.m_14089_((float)(f7 + 0.0f)) * f9;
            float f22 = Mth.m_14031_((float)(f7 + 0.0f)) * f9;
            float f23 = Mth.m_14089_((float)(f7 + 1.5707964f)) * f9;
            float f24 = Mth.m_14031_((float)(f7 + 1.5707964f)) * f9;
            float f25 = Mth.m_14089_((float)(f7 + 4.712389f)) * f9;
            float f26 = Mth.m_14031_((float)(f7 + 4.712389f)) * f9;
            float f27 = 0.0f;
            float f28 = 0.4999f;
            float f29 = -1.0f + f2;
            float f30 = f4 * 2.5f + f29;
            VertexConsumer vertexconsumer = pBuffer.m_6299_(BEAM_RENDER_TYPE);
            PoseStack.Pose posestack$pose = pMatrixStack.m_85850_();
            Matrix4f matrix4f = posestack$pose.m_252922_();
            Matrix3f matrix3f = posestack$pose.m_252943_();
            ObsidianMonolithRenderer.vertex(vertexconsumer, matrix4f, matrix3f, f19, f4, f20, j, k, l, f28, f30);
            ObsidianMonolithRenderer.vertex(vertexconsumer, matrix4f, matrix3f, f19, f27, f20, j, k, l, f28, f29);
            ObsidianMonolithRenderer.vertex(vertexconsumer, matrix4f, matrix3f, f21, f27, f22, j, k, l, f27, f29);
            ObsidianMonolithRenderer.vertex(vertexconsumer, matrix4f, matrix3f, f21, f4, f22, j, k, l, f27, f30);
            ObsidianMonolithRenderer.vertex(vertexconsumer, matrix4f, matrix3f, f23, f4, f24, j, k, l, f28, f30);
            ObsidianMonolithRenderer.vertex(vertexconsumer, matrix4f, matrix3f, f23, f27, f24, j, k, l, f28, f29);
            ObsidianMonolithRenderer.vertex(vertexconsumer, matrix4f, matrix3f, f25, f27, f26, j, k, l, f27, f29);
            ObsidianMonolithRenderer.vertex(vertexconsumer, matrix4f, matrix3f, f25, f4, f26, j, k, l, f27, f30);
            float f31 = 0.0f;
            if (((AbstractMonolith)pEntity).f_19797_ % 2 == 0) {
                f31 = 0.5f;
            }
            float f32 = 0.5f;
            float f33 = 1.0f;
            ObsidianMonolithRenderer.vertex(vertexconsumer, matrix4f, matrix3f, f11, f4, f12, j, k, l, f32, f31 + f32);
            ObsidianMonolithRenderer.vertex(vertexconsumer, matrix4f, matrix3f, f13, f4, f14, j, k, l, f33, f31 + f32);
            ObsidianMonolithRenderer.vertex(vertexconsumer, matrix4f, matrix3f, f17, f4, f18, j, k, l, f33, f31);
            ObsidianMonolithRenderer.vertex(vertexconsumer, matrix4f, matrix3f, f15, f4, f16, j, k, l, f32, f31);
            pMatrixStack.m_85849_();
        }
        this.layer.m_6494_(pMatrixStack, pBuffer, pPackedLight, pEntity, 0.0f, 0.0f, pPartialTicks, 0.0f, 0.0f, 0.0f);
    }

    private static void vertex(VertexConsumer consumer, Matrix4f matrix4f, Matrix3f matrix3f, float x, float y, float z, int red, int green, int blue, float u, float v) {
        consumer.m_252986_(matrix4f, x, y, z).m_6122_(red, green, blue, 255).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public ResourceLocation getTextureLocation(AbstractMonolith pEntity) {
        return TEXTURE_LOCATION;
    }

    public MonolithModel<T> getModel() {
        return this.model;
    }

    public static class OMShieldLayer<T extends AbstractMonolith>
    extends RenderLayer<T, MonolithModel<T>> {
        private static final ResourceLocation TEXTURE = Goety.location("textures/entity/monolith/obsidian_monolith_shield.png");
        private final MonolithModel<T> model;

        public OMShieldLayer(RenderLayerParent<T, MonolithModel<T>> p_116967_, EntityModelSet p_174555_) {
            super(p_116967_);
            this.model = new MonolithModel(p_174555_.m_171103_(ModModelLayer.MONOLITH));
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T monolith, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (monolith instanceof ObsidianMonolith) {
                ObsidianMonolith monolith1 = (ObsidianMonolith)monolith;
                int shieldTime = monolith1.shieldTime;
                if (shieldTime > 0) {
                    matrixStackIn.m_85836_();
                    matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(monolith.m_146908_()));
                    matrixStackIn.m_85841_(-1.0f, -1.0f, 1.0f);
                    matrixStackIn.m_85837_(0.0, 0.05, 0.0);
                    matrixStackIn.m_85841_(1.05f, 1.025f, 1.05f);
                    float alpha = (float)shieldTime / 10.0f;
                    float f = ((float)((AbstractMonolith)monolith).f_19797_ + partialTicks) * 0.6f;
                    this.model.m_6839_((Entity)monolith, limbSwing, limbSwingAmount, partialTicks);
                    ((MonolithModel)this.m_117386_()).m_102624_(this.model);
                    RenderType renderType = RenderType.m_110436_((ResourceLocation)TEXTURE, (float)(f * 0.02f % 1.0f), (float)(f * 0.01f % 1.0f));
                    VertexConsumer vertexconsumer = bufferIn.m_6299_(renderType);
                    float f1 = Math.min(AbstractMonolith.getEmergingTime(), (float)((AbstractMonolith)monolith).getAge());
                    this.model.setupAnim(monolith, f1, 0.0f, partialTicks, monolith.m_146908_(), monolith.m_146909_());
                    this.model.m_7695_(matrixStackIn, vertexconsumer, packedLightIn, OverlayTexture.f_118083_, alpha, alpha, alpha, 1.0f);
                    matrixStackIn.m_85849_();
                }
            }
        }
    }
}

