/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render.model;

import com.Polarice3.Goety.client.render.animation.IceGolemAnimations;
import com.Polarice3.Goety.common.entities.ally.golem.IceGolem;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class IceGolemModel<T extends IceGolem>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart head;

    public IceGolemModel(ModelPart root) {
        this.root = root;
        this.head = root.m_171324_("body").m_171324_("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(45, 0).m_171480_().m_171488_(8.0f, -8.0f, -5.0f, 7.0f, 10.0f, 9.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(45, 0).m_171488_(-15.0f, -8.0f, -5.0f, 7.0f, 10.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(0, 14).m_171488_(-8.0f, -9.0f, -7.0f, 16.0f, 20.0f, 13.0f, new CubeDeformation(0.0f)).m_171514_(78, 38).m_171488_(-4.5f, 11.0f, -3.0f, 9.0f, 4.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -4.0f, -6.0f, 8.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)-7.0f));
        PartDefinition frost2 = head.m_171599_("frost2", CubeListBuilder.m_171558_().m_171514_(45, 50).m_171488_(-4.0f, 0.0f, -6.0f, 8.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition frost = body.m_171599_("frost", CubeListBuilder.m_171558_().m_171514_(96, 51).m_171488_(-15.0f, -2.0f, -5.0f, 7.0f, 4.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(96, 51).m_171480_().m_171488_(8.0f, -2.0f, -5.0f, 7.0f, 4.0f, 9.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 47).m_171488_(-8.0f, -3.0f, -7.0f, 16.0f, 4.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-10.0f, (float)0.0f));
        PartDefinition right_arm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-12.0f, (float)-7.0f, (float)0.0f));
        PartDefinition upper_right = right_arm.m_171599_("upper_right", CubeListBuilder.m_171558_().m_171514_(58, 19).m_171480_().m_171488_(-2.0f, -2.0f, -3.0f, 4.0f, 16.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)1.5f, (float)0.0f));
        PartDefinition bottom_right = right_arm.m_171599_("bottom_right", CubeListBuilder.m_171558_().m_171514_(77, 0).m_171480_().m_171488_(-4.0f, 0.0f, -4.0f, 8.0f, 16.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)13.5f, (float)0.0f));
        PartDefinition frost3 = bottom_right.m_171599_("frost3", CubeListBuilder.m_171558_().m_171514_(73, 48).m_171480_().m_171488_(-4.0f, -4.0f, -4.0f, 8.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)12.0f, (float)-7.0f, (float)0.0f));
        PartDefinition upper_left = left_arm.m_171599_("upper_left", CubeListBuilder.m_171558_().m_171514_(58, 19).m_171488_(-2.0f, -2.0f, -3.0f, 4.0f, 16.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.5f, (float)0.0f));
        PartDefinition bottom_left = left_arm.m_171599_("bottom_left", CubeListBuilder.m_171558_().m_171514_(77, 0).m_171488_(-4.0f, 0.0f, -4.0f, 8.0f, 16.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)13.5f, (float)0.0f));
        PartDefinition frost4 = bottom_left.m_171599_("frost4", CubeListBuilder.m_171558_().m_171514_(73, 48).m_171488_(-4.0f, -4.0f, -4.0f, 8.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(102, 17).m_171480_().m_171488_(-3.5f, 0.0f, -4.0f, 6.0f, 16.0f, 7.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-4.0f, (float)8.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(102, 17).m_171488_(-2.5f, 0.0f, -4.0f, 6.0f, 16.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)8.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (!entity.m_21224_()) {
            this.animateHeadLookTarget(netHeadYaw, headPitch);
        }
        Vec3 velocity = entity.m_20184_();
        float groundSpeed = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
        this.m_233381_(((IceGolem)entity).idleAnimationState, IceGolemAnimations.IDLE, ageInTicks);
        this.m_233385_(((IceGolem)entity).walkAnimationState, IceGolemAnimations.WALK, ageInTicks, groundSpeed * 25.0f);
        this.m_233381_(((IceGolem)entity).attackAnimationState, IceGolemAnimations.ATTACK, ageInTicks);
        this.m_233381_(((IceGolem)entity).smashAnimationState, IceGolemAnimations.SMASH, ageInTicks);
    }

    private void animateHeadLookTarget(float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

