/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks;

import com.Polarice3.Goety.common.blocks.ModBlocks;
import com.Polarice3.Goety.common.blocks.entities.DarkAltarBlockEntity;
import com.Polarice3.Goety.init.ModSounds;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.extensions.IForgeBlock;
import net.minecraftforge.items.IItemHandler;

public class DarkAltarBlock
extends BaseEntityBlock
implements IForgeBlock,
SimpleWaterloggedBlock {
    public static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)13.0, (double)15.0);
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty OCCUPIED = BlockStateProperties.f_61445_;

    public DarkAltarBlock() {
        this(ModBlocks.ShadeStoneProperties().m_60955_());
    }

    public DarkAltarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).m_61124_((Property)LIT, (Comparable)Boolean.FALSE)).m_61124_((Property)OCCUPIED, (Comparable)Boolean.FALSE));
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, world, pos, blockIn, fromPos, isMoving);
        world.m_183326_().m_183588_(pos, (Object)this);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity instanceof DarkAltarBlockEntity) {
            DarkAltarBlockEntity darkAltarTile = (DarkAltarBlockEntity)tileEntity;
            if (darkAltarTile.itemStackHandler.isPresent()) {
                IItemHandler handler = (IItemHandler)darkAltarTile.itemStackHandler.orElseThrow(RuntimeException::new);
                ItemStack itemStack = handler.getStackInSlot(0);
                if (!itemStack.m_41619_()) {
                    darkAltarTile.removeItem((LivingEntity)player);
                    return InteractionResult.SUCCESS;
                }
                if (!player.m_21120_(hand).m_41619_()) {
                    return darkAltarTile.activate(world, pos, player, hand, hit.m_82434_()) ? InteractionResult.SUCCESS : InteractionResult.PASS;
                }
                if (player.m_6047_()) {
                    darkAltarTile.setShowArea(!darkAltarTile.isShowArea());
                    world.m_5594_(null, pos, (SoundEvent)ModSounds.CAST_SPELL.get(), SoundSource.BLOCKS, 0.25f, 2.0f);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.m_60713_(pNewState.m_60734_())) {
            BlockEntity tileentity = pLevel.m_7702_(pPos);
            if (tileentity instanceof DarkAltarBlockEntity) {
                ((DarkAltarBlockEntity)tileentity).stopRitual(false);
                tileentity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> DarkAltarBlock.dropInventoryItems(tileentity.m_58904_(), tileentity.m_58899_(), handler));
            }
            super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }

    public static void dropInventoryItems(Level worldIn, BlockPos pos, IItemHandler itemHandler) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            Containers.m_18992_((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)itemHandler.getStackInSlot(i));
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_7952_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return SHAPE;
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockPos blockpos;
        Level iworld = pContext.m_43725_();
        boolean flag = iworld.m_6425_(blockpos = pContext.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public boolean m_7361_(LevelAccessor pLevel, BlockPos pPos, BlockState pState, FluidState pFluidState) {
        if (!((Boolean)pState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() && pFluidState.m_76152_() == Fluids.f_76193_) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.TRUE), 3);
            pLevel.m_186469_(pPos, pFluidState.m_76152_(), pFluidState.m_76152_().m_6718_((LevelReader)pLevel));
            return true;
        }
        return false;
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{LIT, WATERLOGGED, OCCUPIED});
    }

    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return new DarkAltarBlockEntity(p_153215_, p_153216_);
    }

    @Nullable
    public <T extends BlockEntity> GameEventListener m_214009_(ServerLevel p_222092_, T p_222093_) {
        return p_222093_ instanceof DarkAltarBlockEntity ? (DarkAltarBlockEntity)p_222093_ : null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> type) {
        return (world, pos, state, blockEntity) -> {
            if (blockEntity instanceof DarkAltarBlockEntity) {
                DarkAltarBlockEntity altarBlock = (DarkAltarBlockEntity)blockEntity;
                altarBlock.tick();
            }
        };
    }
}

