/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks;

import com.Polarice3.Goety.api.items.magic.ITotem;
import com.Polarice3.Goety.common.blocks.entities.SoulMenderBlockEntity;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SoulMenderBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;

    public SoulMenderBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60913_(5.0f, 1200.0f).m_60918_(SoundType.f_56742_).m_60953_(SoulMenderBlock.litBlockEmission()).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).m_61124_((Property)LIT, (Comparable)Boolean.FALSE));
    }

    private static ToIntFunction<BlockState> litBlockEmission() {
        return state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? 10 : 0;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity tileentity = pLevel.m_7702_(pPos);
        if (tileentity instanceof SoulMenderBlockEntity) {
            SoulMenderBlockEntity blockEntity = (SoulMenderBlockEntity)tileentity;
            ItemStack itemstack = pPlayer.m_21120_(pHand);
            if (itemstack.m_41768_() && itemstack.isRepairable() || itemstack.m_41720_() instanceof ITotem) {
                if (!pLevel.f_46443_ && blockEntity.placeItem(pPlayer.m_150110_().f_35937_ ? itemstack.m_41777_() : itemstack)) {
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.CONSUME;
            }
            if (itemstack.m_41619_() || itemstack == blockEntity.m_8020_(0)) {
                ItemStack repaired;
                if (!pLevel.f_46443_ && !(repaired = blockEntity.m_8020_(0).m_278832_()).m_41619_()) {
                    if (itemstack.m_41619_()) {
                        pPlayer.m_21008_(pHand, repaired);
                        pLevel.m_5594_(null, pPos, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    } else if (!pPlayer.m_36356_(repaired)) {
                        SoulMenderBlock.dropItemStack(pLevel, pPlayer.m_20183_(), repaired);
                    }
                    blockEntity.markUpdated();
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public static void dropItemStack(Level pLevel, BlockPos pPos, ItemStack pStack) {
        double d0 = EntityType.f_20461_.m_20678_();
        double d1 = 1.0 - d0;
        double d2 = d0 / 2.0;
        double d3 = Math.floor(pPos.m_123341_()) + pLevel.f_46441_.m_188500_() * d1 + d2;
        double d4 = Math.floor(pPos.m_123342_()) + pLevel.f_46441_.m_188500_() * d1;
        double d5 = Math.floor(pPos.m_123343_()) + pLevel.f_46441_.m_188500_() * d1 + d2;
        while (!pStack.m_41619_()) {
            ItemEntity itementity = new ItemEntity(pLevel, d3, d4, d5, pStack.m_41620_(pLevel.f_46441_.m_188503_(21) + 10));
            float f = 0.05f;
            itementity.m_20334_(pLevel.f_46441_.m_188583_() * (double)f, pLevel.f_46441_.m_188583_() * (double)f + (double)0.2f, pLevel.f_46441_.m_188583_() * (double)f);
            pLevel.m_7967_((Entity)itementity);
        }
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.m_60713_(pNewState.m_60734_())) {
            BlockEntity tileentity = pLevel.m_7702_(pPos);
            if (tileentity instanceof SoulMenderBlockEntity) {
                SoulMenderBlock.dropItemStack(pLevel, pPos, ((SoulMenderBlockEntity)tileentity).m_8020_(0));
            }
            super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockPos blockpos;
        Level iworld = pContext.m_43725_();
        boolean flag = iworld.m_6425_(blockpos = pContext.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public boolean m_7361_(LevelAccessor pLevel, BlockPos pPos, BlockState pState, FluidState pFluidState) {
        if (!((Boolean)pState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() && pFluidState.m_76152_() == Fluids.f_76193_) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.TRUE), 3);
            pLevel.m_186469_(pPos, pFluidState.m_76152_(), pFluidState.m_76152_().m_6718_((LevelReader)pLevel));
            return true;
        }
        return false;
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{WATERLOGGED, LIT});
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return new SoulMenderBlockEntity(p_153215_, p_153216_);
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level p_152755_, BlockState p_152756_, BlockEntityType<T> p_152757_) {
        return (world, pos, state, blockEntity) -> {
            if (blockEntity instanceof SoulMenderBlockEntity) {
                SoulMenderBlockEntity arcaBlock = (SoulMenderBlockEntity)blockEntity;
                arcaBlock.tick();
            }
        };
    }
}

