/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks.entities;

import com.Polarice3.Goety.api.blocks.entities.IBarrack;
import com.Polarice3.Goety.api.entities.ITrainable;
import com.Polarice3.Goety.common.blocks.entities.OwnedBlockEntity;
import com.Polarice3.Goety.init.ModTags;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class BarracksBlockEntity
extends OwnedBlockEntity
implements GameEventListener,
IBarrack {
    public static String TRAIN_LIST = "trainList";
    public static String CLEAR = "Clear";
    public static String RAIN = "Rain";
    public static String STORM = "Storm";
    private final BlockPositionSource blockPosSource;
    public List<UUID> uuids;
    public List<Mob> trainingMobs;
    public String currentWeather;
    public String currentMob;
    public int updateVariant;
    public int mobCountO;
    public int mobCount;
    public boolean showArea;
    public CompoundTag entityTrainTo;

    public BarracksBlockEntity(BlockEntityType<?> p_155228_, BlockPos p_155229_, BlockState p_155230_) {
        super(p_155228_, p_155229_, p_155230_);
        this.blockPosSource = new BlockPositionSource(this.f_58858_);
        this.uuids = new ArrayList<UUID>();
        this.trainingMobs = new ArrayList<Mob>();
        this.currentWeather = CLEAR;
        this.currentMob = "None";
        this.mobCountO = 0;
        this.mobCount = 0;
        this.entityTrainTo = new CompoundTag();
    }

    public static void clientTick(Level level, BlockPos blockPos, BlockState blockState, BarracksBlockEntity blockEntity) {
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, BarracksBlockEntity blockEntity) {
        if (level instanceof ServerLevel) {
            EntityType<? extends Mob> entityType;
            ServerLevel serverLevel = (ServerLevel)level;
            if (serverLevel.m_46471_()) {
                if (serverLevel.m_46470_()) {
                    if (!Objects.equals(blockEntity.currentWeather, STORM)) {
                        blockEntity.currentWeather = STORM;
                        blockEntity.updateVariant = 5;
                    }
                } else if (!Objects.equals(blockEntity.currentWeather, RAIN)) {
                    blockEntity.currentWeather = RAIN;
                    blockEntity.updateVariant = 5;
                }
            } else if (!Objects.equals(blockEntity.currentWeather, CLEAR)) {
                blockEntity.currentWeather = CLEAR;
                blockEntity.updateVariant = 5;
            }
            if (blockEntity.updateVariant > 0) {
                --blockEntity.updateVariant;
                blockEntity.setVariant(level, blockPos);
            }
            if ((entityType = blockEntity.getTrainedMob((Level)serverLevel, blockPos)) != null) {
                if (!Objects.equals(blockEntity.currentMob, entityType.m_20675_())) {
                    blockEntity.setCurrentMob(entityType.m_20675_());
                }
                if (serverLevel.m_46467_() % 10L == 0L) {
                    if (!blockEntity.uuids.isEmpty()) {
                        ArrayList<UUID> toRemove = new ArrayList<UUID>();
                        for (UUID uuid : blockEntity.uuids) {
                            Mob mob2;
                            if (uuid == null) continue;
                            Entity entity = serverLevel.m_8791_(uuid);
                            if (entity instanceof Mob && (mob2 = (Mob)entity) instanceof ITrainable) {
                                if (!mob2.m_213877_()) {
                                    if (blockEntity.trainingMobs.contains(mob2)) continue;
                                    blockEntity.trainingMobs.add(mob2);
                                    continue;
                                }
                                toRemove.add(uuid);
                                continue;
                            }
                            toRemove.add(uuid);
                        }
                        if (!toRemove.isEmpty()) {
                            blockEntity.uuids.removeAll(toRemove);
                        }
                    }
                    if (!blockEntity.trainingMobs.isEmpty()) {
                        blockEntity.trainingMobs.removeIf(mob -> {
                            if (!(mob instanceof ITrainable)) {
                                blockEntity.uuids.remove(mob.m_20148_());
                                return true;
                            }
                            ITrainable trainable = (ITrainable)mob;
                            if (!mob.m_6084_() || mob.f_19853_.m_46472_() != serverLevel.m_46472_() || trainable.isTrained() || !blockEntity.checkEligibility((Mob)mob, (Level)serverLevel, blockPos)) {
                                blockEntity.uuids.remove(mob.m_20148_());
                                return true;
                            }
                            return false;
                        });
                    }
                }
                blockEntity.trainMobs(level, blockPos);
            } else if (!Objects.equals(blockEntity.currentMob, "None")) {
                blockEntity.setCurrentMob("None");
            }
            blockEntity.mobCountO = blockEntity.amountTraining(level, blockPos);
            if (blockEntity.mobCountO != blockEntity.mobCount) {
                blockEntity.mobCount = blockEntity.mobCountO;
                blockEntity.markUpdated();
            }
        }
        if (blockState.m_61138_((Property)BlockStateProperties.f_61448_)) {
            level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(blockEntity.getTrainedMob(level, blockPos) != null)), 3);
        }
    }

    public boolean autoMode() {
        return false;
    }

    public void setEntityType(EntityType<?> entityType) {
        if (entityType == null) {
            this.entityTrainTo = new CompoundTag();
        } else {
            ResourceLocation location = ForgeRegistries.ENTITY_TYPES.getKey(entityType);
            this.entityTrainTo.m_128359_("id", location != null ? location.toString() : "minecraft:pig");
        }
    }

    public void setEntityType(CompoundTag tag) {
        if (tag == null) {
            this.entityTrainTo = new CompoundTag();
        } else {
            ResourceLocation resourcelocation = ResourceLocation.m_135820_((String)tag.m_128461_("id"));
            this.entityTrainTo.m_128359_("id", resourcelocation != null ? resourcelocation.toString() : "minecraft:pig");
        }
    }

    public CompoundTag getEntityTrainTo() {
        return this.entityTrainTo;
    }

    public void setVariant(Level level, BlockPos blockPos) {
    }

    @Override
    public void addTrainable(Mob mob) {
        if (mob != null && this.uuids.size() < this.trainLimit() && !this.uuids.contains(mob.m_20148_())) {
            this.uuids.add(mob.m_20148_());
        }
    }

    @Override
    public List<Mob> getTrainableList(Level level, BlockPos blockPos) {
        if (this.autoMode()) {
            return this.getMobsInRange(level, blockPos);
        }
        return this.trainingMobs;
    }

    @Override
    @Nullable
    public EntityType<? extends Mob> getTrainedMob(Level level, BlockPos blockPos) {
        EntityType entityType;
        Entity entity;
        if (EntityType.m_20637_((CompoundTag)this.getEntityTrainTo()).isPresent() && (entity = (entityType = (EntityType)EntityType.m_20637_((CompoundTag)this.getEntityTrainTo()).get()).m_20615_(level)) instanceof Mob) {
            return entityType;
        }
        return null;
    }

    @Override
    public int getCurrentAmount() {
        return this.mobCount;
    }

    @Override
    public void readNetwork(CompoundTag tag) {
        super.readNetwork(tag);
        if (tag.m_128441_("showArea")) {
            this.showArea = tag.m_128471_("showArea");
        }
        if (tag.m_128441_("CurrentWeather")) {
            this.currentWeather = tag.m_128461_("CurrentWeather");
        }
        if (tag.m_128441_("CurrentMob")) {
            this.currentMob = tag.m_128461_("CurrentMob");
        }
        if (tag.m_128441_("MobCount")) {
            this.mobCount = tag.m_128451_("MobCount");
        }
        if (tag.m_128441_("EntityTrainTo")) {
            this.entityTrainTo = tag.m_128469_("EntityTrainTo");
        }
        if (tag.m_128441_(TRAIN_LIST)) {
            ListTag list = tag.m_128437_(TRAIN_LIST, 8);
            for (int i = 0; i < list.size(); ++i) {
                this.uuids.add(UUID.fromString(list.m_128778_(i)));
            }
        }
    }

    @Override
    public CompoundTag writeNetwork(CompoundTag tag) {
        CompoundTag tag1 = super.writeNetwork(tag);
        tag1.m_128379_("showArea", this.showArea);
        tag1.m_128359_("CurrentWeather", this.currentWeather);
        tag1.m_128359_("CurrentMob", this.currentMob);
        tag1.m_128405_("MobCount", this.getCurrentAmount());
        tag1.m_128365_("EntityTrainTo", (Tag)this.entityTrainTo);
        ArrayList<String> list = new ArrayList<String>();
        if (tag.m_128441_(TRAIN_LIST)) {
            for (int i = 0; i < tag.m_128437_(TRAIN_LIST, 8).size(); ++i) {
                list.add(tag.m_128437_(TRAIN_LIST, 8).m_128778_(i));
            }
        }
        if (!this.uuids.isEmpty()) {
            for (UUID uuid : this.uuids) {
                if (list.contains(uuid.toString())) continue;
                ListTag nbttaglist = new ListTag();
                if (tag.m_128441_(TRAIN_LIST)) {
                    nbttaglist = tag.m_128437_(TRAIN_LIST, 8);
                }
                nbttaglist.add((Object)StringTag.m_129297_((String)uuid.toString()));
                tag.m_128365_(TRAIN_LIST, (Tag)nbttaglist);
            }
        }
        return tag1;
    }

    public PositionSource m_142460_() {
        return this.blockPosSource;
    }

    public GameEventListener.DeliveryMode m_247514_() {
        return GameEventListener.DeliveryMode.BY_DISTANCE;
    }

    public int m_142078_() {
        return this.getRange();
    }

    public boolean m_214068_(ServerLevel p_222777_, GameEvent p_282184_, GameEvent.Context p_283014_, Vec3 p_282350_) {
        if (!this.m_58901_() && p_282184_.m_204528_(ModTags.GameEvents.BLOCK_EVENTS)) {
            this.updateVariant = 5;
            return true;
        }
        return false;
    }

    public boolean isShowArea() {
        return this.showArea;
    }

    public void setShowArea(boolean showArea) {
        this.showArea = showArea;
        this.markUpdated();
    }

    @Override
    public String getCurrentMob() {
        return this.currentMob;
    }

    public void setCurrentMob(String string) {
        this.currentMob = string;
        this.markUpdated();
    }

    public void markUpdated() {
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }
}

