/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks.entities;

import com.Polarice3.Goety.api.items.magic.ITotem;
import com.Polarice3.Goety.common.blocks.ModBlocks;
import com.Polarice3.Goety.common.blocks.SoulMenderBlock;
import com.Polarice3.Goety.common.blocks.entities.CursedCageBlockEntity;
import com.Polarice3.Goety.common.blocks.entities.ModBlockEntities;
import com.Polarice3.Goety.common.blocks.entities.ModBlockEntity;
import com.Polarice3.Goety.config.MainConfig;
import com.Polarice3.Goety.utils.MathHelper;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.Containers;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SoulMenderBlockEntity
extends ModBlockEntity
implements Clearable,
WorldlyContainer {
    private static final int[] SLOTS = new int[]{0};
    private ItemStack itemStack = ItemStack.f_41583_;
    private CursedCageBlockEntity cursedCageTile;

    public SoulMenderBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)ModBlockEntities.SOUL_MENDER.get(), p_155229_, p_155230_);
    }

    public void tick() {
        boolean flag = this.checkCage();
        if (this.f_58857_ != null) {
            if (!this.f_58857_.f_46443_ && flag) {
                if (!this.itemStack.m_41619_()) {
                    int i = 1;
                    if (!this.itemStack.getAllEnchantments().isEmpty()) {
                        i += this.itemStack.getAllEnchantments().size();
                    }
                    if (this.cursedCageTile.getSouls() > (Integer)MainConfig.SoulMenderCost.get() * i) {
                        this.makeWorkParticles();
                    }
                }
                this.work();
            }
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)SoulMenderBlock.LIT, (Comparable)Boolean.valueOf(flag)), 3);
        }
    }

    private void work() {
        if (this.f_58857_ != null && !this.itemStack.m_41619_()) {
            int i = 1;
            if (!this.itemStack.getAllEnchantments().isEmpty()) {
                i += this.itemStack.getAllEnchantments().size();
            }
            if (this.cursedCageTile.getSouls() > (Integer)MainConfig.SoulMenderCost.get() * i) {
                if (this.itemStack.m_41720_() instanceof ITotem) {
                    if (!ITotem.isFull(this.itemStack)) {
                        if (this.f_58857_.m_46467_() % (long)(MathHelper.secondsToTicks(((Double)MainConfig.SoulMenderSeconds.get()).floatValue()) + 1) == 0L) {
                            ITotem.increaseSouls(this.itemStack, 1);
                            this.cursedCageTile.decreaseSouls(1);
                        }
                        if (this.f_58857_.f_46441_.m_188503_(24) == 0) {
                            this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11936_, SoundSource.BLOCKS, 1.0f + this.f_58857_.f_46441_.m_188501_(), this.f_58857_.f_46441_.m_188501_() * 0.7f + 0.3f);
                        }
                    } else {
                        BlockPos blockpos = this.m_58899_();
                        Containers.m_18992_((Level)this.f_58857_, (double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), (ItemStack)this.itemStack);
                        this.itemStack.m_41774_(1);
                        this.finishParticles();
                        this.markUpdated();
                    }
                } else if (this.itemStack.m_41768_()) {
                    if (this.f_58857_.m_46467_() % (long)(MathHelper.secondsToTicks(((Double)MainConfig.SoulMenderSeconds.get()).floatValue()) + 1) == 0L) {
                        this.itemStack.m_41721_(this.itemStack.m_41773_() - 1);
                        this.cursedCageTile.decreaseSouls((Integer)MainConfig.SoulMenderCost.get() * i);
                    }
                    if (this.f_58857_.f_46441_.m_188503_(24) == 0) {
                        this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11936_, SoundSource.BLOCKS, 1.0f + this.f_58857_.f_46441_.m_188501_(), this.f_58857_.f_46441_.m_188501_() * 0.7f + 0.3f);
                    }
                } else {
                    BlockPos blockpos = this.m_58899_();
                    Containers.m_18992_((Level)this.f_58857_, (double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), (ItemStack)this.itemStack);
                    this.itemStack.m_41774_(1);
                    this.finishParticles();
                    this.markUpdated();
                }
            }
        }
    }

    public boolean m_7983_() {
        return this.itemStack.m_41619_();
    }

    public int m_6643_() {
        return 1;
    }

    public ItemStack m_8020_(int pIndex) {
        return this.itemStack;
    }

    public ItemStack m_7407_(int pIndex, int pCount) {
        return ItemStack.f_41583_;
    }

    public ItemStack m_8016_(int pIndex) {
        return ItemStack.f_41583_;
    }

    public void m_6836_(int pIndex, ItemStack pStack) {
        if (pStack.m_41768_() && pStack.isRepairable()) {
            this.placeItem(pStack);
        }
    }

    public boolean m_6542_(Player pPlayer) {
        if (this.f_58857_ == null || this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return pPlayer.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    private void finishParticles() {
        BlockPos blockpos = this.m_58899_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            ServerLevel serverWorld = (ServerLevel)this.f_58857_;
            serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123755_, (double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.5, (double)blockpos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            for (int p = 0; p < 6; ++p) {
                double d0 = (double)blockpos.m_123341_() + serverWorld.f_46441_.m_188500_();
                double d1 = (double)blockpos.m_123342_() + serverWorld.f_46441_.m_188500_();
                double d2 = (double)blockpos.m_123343_() + serverWorld.f_46441_.m_188500_();
                serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123745_, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
                serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private void makeWorkParticles() {
        ServerLevel serverLevel;
        long t;
        BlockPos blockpos = this.m_58899_();
        Level level = this.f_58857_;
        if (level instanceof ServerLevel && (t = (serverLevel = (ServerLevel)level).m_46467_()) % 20L == 0L) {
            for (int p = 0; p < 6; ++p) {
                double d0 = (double)blockpos.m_123341_() + serverLevel.f_46441_.m_188500_();
                double d1 = (double)blockpos.m_123342_() + serverLevel.f_46441_.m_188500_();
                double d2 = (double)blockpos.m_123343_() + serverLevel.f_46441_.m_188500_();
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123745_, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean placeItem(ItemStack pStack) {
        if (this.f_58857_ != null && this.itemStack.m_41619_()) {
            this.itemStack = pStack.m_41620_(1);
            this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11669_, SoundSource.BLOCKS, 1.0f, 0.5f);
            this.markUpdated();
            return true;
        }
        return false;
    }

    private boolean checkCage() {
        BlockEntity tileentity;
        BlockPos pos;
        BlockState blockState;
        if (this.f_58857_ != null && (blockState = this.f_58857_.m_8055_(pos = new BlockPos(this.m_58899_().m_123341_(), this.m_58899_().m_123342_() - 1, this.m_58899_().m_123343_()))).m_60713_((Block)ModBlocks.CURSED_CAGE_BLOCK.get()) && (tileentity = this.f_58857_.m_7702_(pos)) instanceof CursedCageBlockEntity) {
            this.cursedCageTile = (CursedCageBlockEntity)tileentity;
            return !this.cursedCageTile.getItem().m_41619_();
        }
        return false;
    }

    @Override
    public void readNetwork(CompoundTag compoundNBT) {
        this.itemStack = ItemStack.m_41712_((CompoundTag)compoundNBT.m_128469_("Item"));
    }

    @Override
    public CompoundTag writeNetwork(CompoundTag pCompound) {
        this.saveMetadataAndItems(pCompound);
        return pCompound;
    }

    private CompoundTag saveMetadataAndItems(CompoundTag pCompound) {
        pCompound.m_128365_("Item", (Tag)this.itemStack.m_41739_(new CompoundTag()));
        return pCompound;
    }

    public void m_6211_() {
        this.itemStack.m_41774_(1);
    }

    public int[] m_7071_(Direction pSide) {
        return SLOTS;
    }

    public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        if (!(pItemStack.m_41768_() && pItemStack.isRepairable() || pItemStack.m_41720_() instanceof ITotem)) {
            return false;
        }
        if (this.cursedCageTile == null) {
            return false;
        }
        return this.f_58857_ != null && !this.f_58857_.f_46443_ && this.placeItem(pItemStack);
    }

    public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
        return false;
    }
}

