/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks.entities;

import com.Polarice3.Goety.common.blocks.entities.ModBlockEntities;
import com.Polarice3.Goety.common.blocks.entities.ModBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.ForgeEventFactory;

public class SpiderMotherDenBlockEntity
extends ModBlockEntity {
    private int spawnDelay = 20;
    private int minSpawnDelay = 200;
    private int maxSpawnDelay = 800;

    public SpiderMotherDenBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)ModBlockEntities.SPIDER_MOTHER_DEN.get(), p_155229_, p_155230_);
    }

    private boolean isNearPlayer(Level pLevel, BlockPos pPos) {
        return pLevel.m_45914_((double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5, 16.0);
    }

    public void tick() {
        ServerLevel serverLevel;
        if (this.f_58857_ == null) {
            return;
        }
        Level level = this.f_58857_;
        if (level instanceof ServerLevel && this.isNearPlayer((Level)(serverLevel = (ServerLevel)level), this.f_58858_) && serverLevel.m_46749_(this.f_58858_)) {
            if (this.spawnDelay == -1) {
                this.delay((Level)serverLevel);
            }
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            } else {
                boolean flag = false;
                if (serverLevel.m_46469_().m_46207_(GameRules.f_46134_)) {
                    for (int i = 0; i < serverLevel.m_213780_().m_188503_(4) + 1; ++i) {
                        BlockPos blockpos;
                        double d2;
                        double d1;
                        double d0 = (double)this.f_58858_.m_123341_() + (serverLevel.m_213780_().m_188500_() - serverLevel.m_213780_().m_188500_()) * 4.0 + 0.5;
                        if (!serverLevel.m_45772_(EntityType.f_20479_.m_20585_(d0, d1 = (double)(this.f_58858_.m_123342_() + serverLevel.m_213780_().m_188503_(3) - 1), d2 = (double)this.f_58858_.m_123343_() + (serverLevel.m_213780_().m_188500_() - serverLevel.m_213780_().m_188500_()) * 4.0 + 0.5)) || !SpawnPlacements.m_217074_((EntityType)EntityType.f_20479_, (ServerLevelAccessor)serverLevel, (MobSpawnType)MobSpawnType.SPAWNER, (BlockPos)(blockpos = BlockPos.m_274561_((double)d0, (double)d1, (double)d2)), (RandomSource)serverLevel.m_213780_())) continue;
                        Entity entity = EntityType.f_20479_.m_20615_((Level)serverLevel);
                        if (serverLevel.m_213780_().m_188503_(4) == 0) {
                            entity = EntityType.f_20554_.m_20615_((Level)serverLevel);
                        }
                        if (entity == null) {
                            this.delay((Level)serverLevel);
                            return;
                        }
                        int k = this.f_58857_.m_45976_(entity.getClass(), new AABB((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (double)(this.f_58858_.m_123341_() + 1), (double)(this.f_58858_.m_123342_() + 1), (double)(this.f_58858_.m_123343_() + 1)).m_82400_(4.0)).size();
                        if (k >= 6) {
                            this.delay((Level)serverLevel);
                            return;
                        }
                        entity.m_7678_((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), serverLevel.m_213780_().m_188501_() * 360.0f, 0.0f);
                        if (entity instanceof Mob) {
                            Mob mob = (Mob)entity;
                            ForgeEventFactory.onFinalizeSpawn((Mob)mob, (ServerLevelAccessor)serverLevel, (DifficultyInstance)serverLevel.m_6436_(this.f_58858_), (MobSpawnType)MobSpawnType.SPAWNER, null, null);
                            mob.m_21373_();
                        }
                        if (!serverLevel.m_8860_(entity)) {
                            this.delay((Level)serverLevel);
                            return;
                        }
                        serverLevel.m_46796_(2004, this.f_58858_, 0);
                        serverLevel.m_142346_(entity, GameEvent.f_157810_, blockpos);
                        flag = true;
                    }
                    if (flag) {
                        this.delay((Level)serverLevel);
                    }
                }
            }
        }
    }

    private void delay(Level p_151351_) {
        RandomSource randomsource = p_151351_.f_46441_;
        this.spawnDelay = this.maxSpawnDelay <= this.minSpawnDelay ? this.minSpawnDelay : this.minSpawnDelay + randomsource.m_188503_(this.maxSpawnDelay - this.minSpawnDelay);
    }

    @Override
    public void readNetwork(CompoundTag compoundNBT) {
        this.spawnDelay = compoundNBT.m_128448_("Delay");
        if (compoundNBT.m_128441_("MinSpawnDelay")) {
            this.minSpawnDelay = compoundNBT.m_128448_("MinSpawnDelay");
        }
        if (compoundNBT.m_128441_("MaxSpawnDelay")) {
            this.maxSpawnDelay = compoundNBT.m_128448_("MaxSpawnDelay");
        }
    }

    @Override
    public CompoundTag writeNetwork(CompoundTag pCompound) {
        pCompound.m_128376_("Delay", (short)this.spawnDelay);
        pCompound.m_128376_("MinSpawnDelay", (short)this.minSpawnDelay);
        pCompound.m_128376_("MaxSpawnDelay", (short)this.maxSpawnDelay);
        return pCompound;
    }
}

