/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks.entities;

import com.Polarice3.Goety.client.particles.MagicAshSmokeParticle;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.blocks.VoidVaultBlock;
import com.Polarice3.Goety.common.blocks.entities.ModBlockEntities;
import com.Polarice3.Goety.common.blocks.entities.void_vault.VoidVaultClientData;
import com.Polarice3.Goety.common.blocks.entities.void_vault.VoidVaultConfig;
import com.Polarice3.Goety.common.blocks.entities.void_vault.VoidVaultServerData;
import com.Polarice3.Goety.common.blocks.entities.void_vault.VoidVaultSharedData;
import com.Polarice3.Goety.common.blocks.entities.void_vault.VoidVaultState;
import com.Polarice3.Goety.common.blocks.properties.ModStateProperties;
import com.Polarice3.Goety.init.ModSounds;
import com.google.common.annotations.VisibleForTesting;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class VoidVaultBlockEntity
extends BlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final VoidVaultServerData serverData = new VoidVaultServerData();
    public final VoidVaultSharedData sharedData = new VoidVaultSharedData();
    public final VoidVaultClientData clientData = new VoidVaultClientData();
    private VoidVaultConfig config = VoidVaultConfig.DEFAULT;

    public VoidVaultBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)ModBlockEntities.VOID_VAULT.get(), p_155229_, p_155230_);
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128365_("config", VoidVaultBlockEntity.encodeValue(VoidVaultConfig.CODEC, this.config));
        compoundTag.m_128365_("shared_data", VoidVaultBlockEntity.encodeValue(VoidVaultSharedData.CODEC, this.sharedData));
        compoundTag.m_128365_("server_data", VoidVaultBlockEntity.encodeValue(VoidVaultServerData.CODEC, this.serverData));
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        if (compoundTag.m_128441_("server_data")) {
            VoidVaultServerData.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)compoundTag.m_128423_("server_data")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(this.serverData::copyFrom);
        }
        if (compoundTag.m_128441_("config")) {
            VoidVaultConfig.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)compoundTag.m_128423_("config")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(config -> {
                this.config = config;
            });
        }
        if (compoundTag.m_128441_("shared_data")) {
            VoidVaultSharedData.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)compoundTag.m_128423_("shared_data")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(this.sharedData::copyFrom);
        }
    }

    private static <T> Tag encodeValue(Codec<T> codec, T value) {
        return (Tag)Util.m_260975_((DataResult)codec.encodeStart((DynamicOps)NbtOps.f_128958_, value), IllegalStateException::new);
    }

    @Nullable
    public VoidVaultServerData getServerData() {
        return this.f_58857_ != null && !this.f_58857_.f_46443_ ? this.serverData : null;
    }

    public VoidVaultSharedData getSharedData() {
        return this.sharedData;
    }

    public VoidVaultClientData getClientData() {
        return this.clientData;
    }

    public VoidVaultConfig getConfig() {
        return this.config;
    }

    @VisibleForTesting
    public void setConfig(VoidVaultConfig config) {
        this.config = config;
    }

    public CompoundTag m_5995_() {
        return (CompoundTag)Util.m_137469_((Object)new CompoundTag(), nbt -> nbt.m_128365_("shared_data", VoidVaultBlockEntity.encodeValue(VoidVaultSharedData.CODEC, this.sharedData)));
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public static final class Server {
        public static void tick(ServerLevel world, BlockPos pos, BlockState state, VoidVaultConfig config, VoidVaultServerData serverData, VoidVaultSharedData sharedData) {
            VoidVaultState vaultState = (VoidVaultState)((Object)state.m_61143_(VoidVaultBlock.STATE));
            if (Server.shouldUpdateDisplayItem(world.m_46467_(), vaultState)) {
                Server.updateDisplayItem(world, vaultState, config, sharedData, pos);
            }
            BlockState blockState = state;
            if (world.m_46467_() >= serverData.getStateUpdatingResumeTime() && !state.equals(blockState = (BlockState)state.m_61124_(VoidVaultBlock.STATE, (Comparable)((Object)vaultState.update(world, pos, config, serverData, sharedData))))) {
                Server.changeVaultState(world, pos, state, blockState, config, sharedData);
            }
            if (serverData.dirty || sharedData.dirty) {
                VoidVaultBlockEntity.m_155232_((Level)((Level)world), (BlockPos)pos, (BlockState)state);
                if (sharedData.dirty) {
                    world.m_7260_(pos, state, blockState, 2);
                }
                serverData.dirty = false;
                sharedData.dirty = false;
            }
        }

        public static void tryUnlock(ServerLevel world, BlockPos pos, BlockState state, VoidVaultConfig config, VoidVaultServerData serverData, VoidVaultSharedData sharedData, Player player, ItemStack stack) {
            VoidVaultState vaultState = (VoidVaultState)((Object)state.m_61143_(VoidVaultBlock.STATE));
            if (Server.canBeUnlocked(config, vaultState)) {
                if (!Server.isValidKey(config, stack)) {
                    Server.playFailedUnlockSound(world, serverData, pos, (SoundEvent)ModSounds.VOID_VAULT_INSERT_FAIL.get());
                } else if (serverData.hasRewardedPlayer(player)) {
                    Server.playFailedUnlockSound(world, serverData, pos, (SoundEvent)ModSounds.VOID_VAULT_REJECT.get());
                } else {
                    List<ItemStack> list = Server.generateLoot(world, config, pos, player);
                    if (!list.isEmpty()) {
                        player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                        if (!player.m_7500_()) {
                            stack.m_41774_(config.keyItem().m_41613_());
                        }
                        Server.unlock(world, state, pos, config, serverData, sharedData, list);
                        serverData.markPlayerAsRewarded(player);
                        sharedData.updateConnectedPlayers(world, pos, serverData, config, config.deactivationRange());
                    }
                }
            }
        }

        static void changeVaultState(ServerLevel world, BlockPos pos, BlockState oldState, BlockState newState, VoidVaultConfig config, VoidVaultSharedData sharedData) {
            VoidVaultState vaultState = (VoidVaultState)((Object)oldState.m_61143_(VoidVaultBlock.STATE));
            VoidVaultState vaultState2 = (VoidVaultState)((Object)newState.m_61143_(VoidVaultBlock.STATE));
            world.m_7731_(pos, newState, 3);
            vaultState.onStateChange(world, pos, vaultState2, config, sharedData);
        }

        public static void updateDisplayItem(ServerLevel world, VoidVaultState state, VoidVaultConfig config, VoidVaultSharedData sharedData, BlockPos pos) {
            if (!Server.canBeUnlocked(config, state)) {
                sharedData.setDisplayItem(ItemStack.f_41583_);
            } else {
                ItemStack itemStack = Server.generateDisplayItem(world, pos, config.overrideLootTableToDisplay().orElse(config.lootTable()));
                sharedData.setDisplayItem(itemStack);
            }
        }

        private static ItemStack generateDisplayItem(ServerLevel world, BlockPos pos, ResourceLocation lootTable) {
            LootParams.Builder lootContextParameterSet;
            LootParams lootParams;
            LootTable lootTable2 = world.m_7654_().m_278653_().m_278676_(lootTable);
            ObjectArrayList list = lootTable2.m_287195_(lootParams = (lootContextParameterSet = new LootParams.Builder(world).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos))).m_287235_(LootContextParamSets.f_81411_));
            return list.isEmpty() ? ItemStack.f_41583_ : (ItemStack)Util.m_214621_((List)list, (RandomSource)world.m_213780_());
        }

        private static void unlock(ServerLevel world, BlockState state, BlockPos pos, VoidVaultConfig config, VoidVaultServerData serverData, VoidVaultSharedData sharedData, List<ItemStack> itemsToEject) {
            serverData.setItemsToEject(itemsToEject);
            sharedData.setDisplayItem(serverData.getItemToDisplay());
            serverData.setStateUpdatingResumeTime(world.m_46467_() + 14L);
            Server.changeVaultState(world, pos, state, (BlockState)state.m_61124_(ModStateProperties.VOID_VAULT_STATE, (Comparable)((Object)VoidVaultState.UNLOCKING)), config, sharedData);
        }

        private static List<ItemStack> generateLoot(ServerLevel world, VoidVaultConfig config, BlockPos pos, Player player) {
            LootTable lootTable = world.m_7654_().m_278653_().m_278676_(config.lootTable());
            LootParams.Builder lootContextParameterSet = new LootParams.Builder(world).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_287239_(player.m_36336_()).m_287286_(LootContextParams.f_81455_, (Object)player);
            LootParams lootParams = lootContextParameterSet.m_287235_(LootContextParamSets.f_81411_);
            return lootTable.m_287195_(lootParams);
        }

        private static boolean canBeUnlocked(VoidVaultConfig config, VoidVaultState state) {
            return config.lootTable() != LootTable.f_79105_.getLootTableId() && !config.keyItem().m_41619_() && state != VoidVaultState.INACTIVE;
        }

        private static boolean isValidKey(VoidVaultConfig config, ItemStack stack) {
            return ItemStack.m_150942_((ItemStack)stack, (ItemStack)config.keyItem()) && stack.m_41613_() >= config.keyItem().m_41613_();
        }

        private static boolean shouldUpdateDisplayItem(long time, VoidVaultState state) {
            return time % 20L == 0L && state == VoidVaultState.ACTIVE;
        }

        private static void playFailedUnlockSound(ServerLevel world, VoidVaultServerData serverData, BlockPos pos, SoundEvent soundEvent) {
            if (world.m_46467_() >= serverData.getLastFailedUnlockTime() + 15L) {
                world.m_247517_(null, pos, soundEvent, SoundSource.BLOCKS);
                serverData.setLastFailedUnlockTime(world.m_46467_());
            }
        }
    }

    public static final class Client {
        public static void tick(Level world, BlockPos pos, BlockState state, VoidVaultClientData clientData, VoidVaultSharedData sharedData) {
            clientData.rotateDisplay();
            if (world.m_46467_() % 20L == 0L) {
                Client.spawnConnectedParticles(world, pos, state, sharedData);
            }
            Client.spawnAmbientParticles(world, pos, sharedData);
            Client.playAmbientSound(world, pos, sharedData);
        }

        public static void spawnActivateParticles(Level world, BlockPos pos, BlockState state, VoidVaultSharedData sharedData) {
            Client.spawnConnectedParticles(world, pos, state, sharedData);
            RandomSource random = world.f_46441_;
            for (int i = 0; i < 20; ++i) {
                Vec3 vec3d = Client.getRegularParticlesPos(pos, random);
                if (world instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)world;
                    serverLevel.m_8767_((ParticleOptions)new MagicAshSmokeParticle.Option(3802679, 6886773), vec3d.m_7096_(), vec3d.m_7098_(), vec3d.m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.SMALL_END_FIRE.get()), vec3d.m_7096_(), vec3d.m_7098_(), vec3d.m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
                    continue;
                }
                world.m_7106_((ParticleOptions)new MagicAshSmokeParticle.Option(3802679, 6886773), vec3d.m_7096_(), vec3d.m_7098_(), vec3d.m_7094_(), 0.0, 0.0, 0.0);
                world.m_7106_((ParticleOptions)ModParticleTypes.SMALL_END_FIRE.get(), vec3d.m_7096_(), vec3d.m_7098_(), vec3d.m_7094_(), 0.0, 0.0, 0.0);
            }
        }

        public static void spawnDeactivateParticles(Level world, BlockPos pos) {
            RandomSource random = world.f_46441_;
            for (int i = 0; i < 20; ++i) {
                Vec3 vec3d = Client.getDeactivateParticlesPos(pos, random);
                Vec3 vec3d2 = new Vec3(random.m_188583_() * 0.02, random.m_188583_() * 0.02, random.m_188583_() * 0.02);
                if (world instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)world;
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.SMALL_END_FIRE.get()), vec3d.m_7096_(), vec3d.m_7098_(), vec3d.m_7094_(), 0, vec3d2.m_7096_(), vec3d2.m_7098_(), vec3d2.m_7094_(), 0.5);
                    continue;
                }
                world.m_7106_((ParticleOptions)ModParticleTypes.SMALL_END_FIRE.get(), vec3d.m_7096_(), vec3d.m_7098_(), vec3d.m_7094_(), vec3d2.m_7096_(), vec3d2.m_7098_(), vec3d2.m_7094_());
            }
        }

        private static void spawnAmbientParticles(Level world, BlockPos pos, VoidVaultSharedData sharedData) {
            RandomSource random = world.m_213780_();
            if (random.m_188501_() <= 0.5f) {
                Vec3 vec3d = Client.getRegularParticlesPos(pos, random);
                if (world instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)world;
                    serverLevel.m_8767_((ParticleOptions)new MagicAshSmokeParticle.Option(3802679, 6886773), vec3d.m_7096_(), vec3d.m_7098_(), vec3d.m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
                    if (Client.hasDisplayItem(sharedData)) {
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.SMALL_END_FIRE.get()), vec3d.m_7096_(), vec3d.m_7098_(), vec3d.m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                } else {
                    world.m_7106_((ParticleOptions)new MagicAshSmokeParticle.Option(3802679, 6886773), vec3d.m_7096_(), vec3d.m_7098_(), vec3d.m_7094_(), 0.0, 0.0, 0.0);
                    if (Client.hasDisplayItem(sharedData)) {
                        world.m_7106_((ParticleOptions)ModParticleTypes.SMALL_END_FIRE.get(), vec3d.m_7096_(), vec3d.m_7098_(), vec3d.m_7094_(), 0.0, 0.0, 0.0);
                    }
                }
            }
        }

        private static void spawnConnectedParticlesFor(Level world, Vec3 pos, Player player) {
            RandomSource random = world.f_46441_;
            Vec3 vec3d = pos.m_82505_(player.m_20182_().m_82520_(0.0, (double)(player.m_20206_() / 2.0f), 0.0));
            int i = Mth.m_216271_((RandomSource)random, (int)2, (int)5);
            for (int j = 0; j < i; ++j) {
                Vec3 vec3d2 = vec3d.m_272010_(random, 1.0f);
                world.m_7106_((ParticleOptions)ModParticleTypes.VOID_VAULT_CONNECT.get(), pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), vec3d2.m_7096_(), vec3d2.m_7098_(), vec3d2.m_7094_());
            }
        }

        private static void spawnConnectedParticles(Level world, BlockPos pos, BlockState state, VoidVaultSharedData sharedData) {
            Set<UUID> set = sharedData.getConnectedPlayers();
            if (!set.isEmpty()) {
                Vec3 vec3d = Client.getConnectedParticlesOrigin(pos, (Direction)state.m_61143_((Property)VoidVaultBlock.FACING));
                for (UUID uUID : set) {
                    Player playerEntity = world.m_46003_(uUID);
                    if (playerEntity == null || !Client.isPlayerWithinConnectedParticlesRange(pos, sharedData, playerEntity)) continue;
                    Client.spawnConnectedParticlesFor(world, vec3d, playerEntity);
                }
            }
        }

        private static boolean isPlayerWithinConnectedParticlesRange(BlockPos pos, VoidVaultSharedData sharedData, Player player) {
            return player.m_20183_().m_123331_((Vec3i)pos) <= Mth.m_144952_((double)sharedData.getConnectedParticlesRange());
        }

        private static void playAmbientSound(Level world, BlockPos pos, VoidVaultSharedData sharedData) {
            RandomSource random;
            if (Client.hasDisplayItem(sharedData) && (random = world.m_213780_()).m_188501_() <= 0.02f) {
                world.m_245747_(pos, (SoundEvent)ModSounds.VOID_VAULT_AMBIENT.get(), SoundSource.BLOCKS, random.m_188501_() * 0.25f + 0.75f, random.m_188501_() + 0.5f, false);
            }
        }

        public static boolean hasDisplayItem(VoidVaultSharedData sharedData) {
            return sharedData.hasDisplayItem();
        }

        private static Vec3 getDeactivateParticlesPos(BlockPos pos, RandomSource random) {
            return Vec3.m_82528_((Vec3i)pos).m_82520_(Mth.m_216263_((RandomSource)random, (double)0.4, (double)0.6), Mth.m_216263_((RandomSource)random, (double)0.4, (double)0.6), Mth.m_216263_((RandomSource)random, (double)0.4, (double)0.6));
        }

        private static Vec3 getRegularParticlesPos(BlockPos pos, RandomSource random) {
            return Vec3.m_82528_((Vec3i)pos).m_82520_(Mth.m_216263_((RandomSource)random, (double)0.1, (double)0.9), Mth.m_216263_((RandomSource)random, (double)0.25, (double)0.75), Mth.m_216263_((RandomSource)random, (double)0.1, (double)0.9));
        }

        private static Vec3 getConnectedParticlesOrigin(BlockPos pos, Direction direction) {
            return Vec3.m_82539_((Vec3i)pos).m_82520_((double)direction.m_122429_() * 0.5, 1.75, (double)direction.m_122431_() * 0.5);
        }
    }
}

