/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks.fluids;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class EndMudFluidType
extends FluidType {
    public static final ResourceLocation FLUID_STILL = Goety.location("block/end_mud_still");
    public static final ResourceLocation FLUID_FLOWING = Goety.location("block/end_mud_flow");
    public static final ResourceLocation OVERLAY = Goety.location("textures/gui/under_end_mud.png");

    public EndMudFluidType() {
        super(FluidType.Properties.create().descriptionId("block.goety.end_mud_fluid").canSwim(true).canDrown(true).canConvertToSource(true).supportsBoating(true).canExtinguish(true).motionScale((double)0.005f).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).pathType(BlockPathTypes.OPEN).adjacentPathType(BlockPathTypes.OPEN).fallDistanceModifier(0.0f).viscosity(1400));
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return FLUID_STILL;
            }

            public ResourceLocation getFlowingTexture() {
                return FLUID_FLOWING;
            }

            public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                return OVERLAY;
            }

            @NotNull
            public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                return new Vector3f(0.54901963f, 0.54901963f, 0.54901963f);
            }

            public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                LivingEntity livingEntity;
                Entity entity = camera.m_90592_();
                if (entity.m_5833_()) {
                    nearDistance = -8.0f;
                    farDistance = renderDistance * 0.5f;
                } else if (entity instanceof LivingEntity && CuriosFinder.hasVoidRobe(livingEntity = (LivingEntity)entity)) {
                    nearDistance = 0.0f;
                    farDistance = 3.0f;
                } else {
                    nearDistance = 0.25f;
                    farDistance = 1.0f;
                }
                RenderSystem.setShaderFogStart((float)nearDistance);
                RenderSystem.setShaderFogEnd((float)farDistance);
                RenderSystem.setShaderFogShape((FogShape)shape);
            }
        });
    }
}

