/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.effects.brew.block;

import com.Polarice3.Goety.common.effects.brew.BrewEffect;
import com.Polarice3.Goety.config.BrewConfig;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.IPlantable;

public class HarvestBlockEffect
extends BrewEffect {
    public HarvestBlockEffect() {
        super("harvest", (int)((Integer)BrewConfig.HarvestCost.get()), MobEffectCategory.NEUTRAL, 6791460);
    }

    @Override
    public void applyBlockEffect(Level pLevel, BlockPos pPos, LivingEntity pSource, int pAmplifier, int pAreaOfEffect) {
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            for (BlockPos blockPos : this.getSpherePos(pPos, pAreaOfEffect + 4)) {
                BlockState state = serverLevel.m_8055_(blockPos);
                if (!HarvestBlockEffect.isMatureAndValid(state)) continue;
                if (HarvestBlockEffect.resetState(state) != state) {
                    serverLevel.m_46597_(blockPos, HarvestBlockEffect.resetState(state));
                    HarvestBlockEffect.dropStacks(state, serverLevel, blockPos, pAmplifier, (Entity)pSource);
                    continue;
                }
                serverLevel.m_46953_(blockPos, true, (Entity)pSource);
            }
        }
    }

    private static boolean isMatureAndValid(BlockState state) {
        if (state.m_60734_() instanceof CocoaBlock) {
            return (Integer)state.m_61143_((Property)CocoaBlock.f_51736_) >= 2;
        }
        Block block = state.m_60734_();
        if (block instanceof CropBlock) {
            CropBlock cropBlock = (CropBlock)block;
            return cropBlock.m_52307_(state);
        }
        if (state.m_60734_() instanceof NetherWartBlock) {
            return (Integer)state.m_61143_((Property)NetherWartBlock.f_54967_) >= 3;
        }
        return state.m_60734_() instanceof IPlantable;
    }

    private static BlockState resetState(BlockState state) {
        if (state.m_60734_() instanceof CocoaBlock) {
            return (BlockState)state.m_61124_((Property)CocoaBlock.f_51736_, (Comparable)Integer.valueOf(0));
        }
        Block block = state.m_60734_();
        if (block instanceof CropBlock) {
            CropBlock cropBlock = (CropBlock)block;
            return cropBlock.m_52289_(0);
        }
        if (state.m_60734_() instanceof NetherWartBlock) {
            return (BlockState)state.m_61124_((Property)NetherWartBlock.f_54967_, (Comparable)Integer.valueOf(0));
        }
        return state;
    }

    private static void dropStacks(BlockState state, ServerLevel world, BlockPos pos, int pAmplifier, Entity entity) {
        Item oldPlant = state.m_60734_().m_7397_((BlockGetter)world, pos, state).m_41720_();
        AtomicBoolean removedReplant = new AtomicBoolean(false);
        ItemStack fakeHoe = new ItemStack((ItemLike)Items.f_42387_);
        if (pAmplifier > 0) {
            fakeHoe.m_41663_(Enchantments.f_44987_, pAmplifier);
        }
        Block.m_49874_((BlockState)state, (ServerLevel)world, (BlockPos)pos, null, (Entity)entity, (ItemStack)fakeHoe).forEach(stack -> {
            if (!removedReplant.get() && stack.m_41720_() == oldPlant) {
                stack.m_41764_(stack.m_41613_() - 1);
                removedReplant.set(true);
            }
            Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)stack);
        });
        state.m_222967_(world, pos, fakeHoe, true);
    }
}

