/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ai;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.pathfinder.BlockPathTypes;

public class FollowMobClassGoal
extends Goal {
    private final Mob mob;
    private final Predicate<Mob> followPredicate;
    @Nullable
    private Mob followingMob;
    private final double speedModifier;
    private final PathNavigation navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private float oldWaterCost;
    private final float areaSize;

    public FollowMobClassGoal(Mob p_25271_, double p_25272_, float p_25273_, float p_25274_, Predicate<Mob> predicate) {
        this.mob = p_25271_;
        this.followPredicate = predicate;
        this.speedModifier = p_25272_;
        this.navigation = p_25271_.m_21573_();
        this.stopDistance = p_25273_;
        this.areaSize = p_25274_;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(p_25271_.m_21573_() instanceof GroundPathNavigation) && !(p_25271_.m_21573_() instanceof FlyingPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowMobGoal");
        }
    }

    public boolean m_8036_() {
        List list = this.mob.f_19853_.m_6443_(Mob.class, this.mob.m_20191_().m_82400_((double)this.areaSize), this.followPredicate);
        if (!list.isEmpty()) {
            for (Mob mob : list) {
                if (mob.m_20145_()) continue;
                this.followingMob = mob;
                return true;
            }
        }
        return false;
    }

    public boolean m_8045_() {
        return this.followingMob != null && !this.navigation.m_26571_() && this.mob.m_20280_((Entity)this.followingMob) > (double)(this.stopDistance * this.stopDistance);
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.mob.m_21439_(BlockPathTypes.WATER);
        this.mob.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.followingMob = null;
        this.navigation.m_26573_();
        this.mob.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        if (this.followingMob != null && !this.mob.m_21523_()) {
            this.mob.m_21563_().m_24960_((Entity)this.followingMob, 10.0f, (float)this.mob.m_8132_());
            if (--this.timeToRecalcPath <= 0) {
                double d2;
                double d1;
                this.timeToRecalcPath = this.m_183277_(10);
                double d0 = this.mob.m_20185_() - this.followingMob.m_20185_();
                double d3 = d0 * d0 + (d1 = this.mob.m_20186_() - this.followingMob.m_20186_()) * d1 + (d2 = this.mob.m_20189_() - this.followingMob.m_20189_()) * d2;
                if (!(d3 <= (double)(this.stopDistance * this.stopDistance))) {
                    this.navigation.m_5624_((Entity)this.followingMob, this.speedModifier);
                } else {
                    this.navigation.m_26573_();
                    LookControl lookcontrol = this.followingMob.m_21563_();
                    if (d3 <= (double)this.stopDistance || lookcontrol.m_24969_() == this.mob.m_20185_() && lookcontrol.m_24970_() == this.mob.m_20186_() && lookcontrol.m_24971_() == this.mob.m_20189_()) {
                        double d4 = this.followingMob.m_20185_() - this.mob.m_20185_();
                        double d5 = this.followingMob.m_20189_() - this.mob.m_20189_();
                        this.navigation.m_26519_(this.mob.m_20185_() - d4, this.mob.m_20186_(), this.mob.m_20189_() - d5, this.speedModifier);
                    }
                }
            }
        }
    }
}

