/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally;

import com.Polarice3.Goety.api.entities.IAutoRideable;
import com.Polarice3.Goety.api.items.magic.IWand;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.AnimalSummon;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.config.MobsConfig;
import com.Polarice3.Goety.init.ModMobType;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BearServant
extends AnimalSummon
implements PlayerRideable,
IAutoRideable {
    private static final EntityDataAccessor<Boolean> DATA_STANDING_ID = SynchedEntityData.m_135353_(BearServant.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_CAVE = SynchedEntityData.m_135353_(BearServant.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> AUTO_MODE = SynchedEntityData.m_135353_(BearServant.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private float clientSideStandAnimationO;
    private float clientSideStandAnimation;
    private int warningSoundTicks;

    public BearServant(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BearMeleeAttackGoal());
        this.f_21345_.m_25352_(2, (Goal)new AnimalSummon.BreedGoal(this, 1.0));
        this.f_21345_.m_25352_(5, new Summoned.WanderGoal<BearServant>(this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Override
    public void targetSelectGoal() {
        super.targetSelectGoal();
        this.f_21346_.m_25352_(4, new Summoned.NaturalAttackGoal<Fox>(this, Fox.class, 10, true, true, null));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.BearServantHealth.get()).doubleValue()).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.BearServantArmor.get()).doubleValue()).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.BearServantDamage.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.BearServantHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.BearServantArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.BearServantDamage.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_STANDING_ID, (Object)false);
        this.f_19804_.m_135372_(DATA_CAVE, (Object)false);
        this.f_19804_.m_135372_(AUTO_MODE, (Object)false);
    }

    protected SoundEvent m_7515_() {
        return this.m_6162_() ? SoundEvents.f_12281_ : SoundEvents.f_12280_;
    }

    protected SoundEvent m_7975_(DamageSource p_29559_) {
        return SoundEvents.f_12283_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12282_;
    }

    protected void m_7355_(BlockPos p_29545_, BlockState p_29546_) {
        this.m_5496_(SoundEvents.f_12284_, 0.15f, 1.0f);
    }

    protected void playWarningSound() {
        if (this.warningSoundTicks <= 0) {
            this.m_5496_(SoundEvents.f_12285_, 1.0f, this.m_6100_());
            this.warningSoundTicks = 40;
        }
    }

    public MobType m_6336_() {
        return ModMobType.NATURAL;
    }

    public void setBearCave() {
        this.setCave(true);
        this.f_19853_.m_7605_((Entity)this, (byte)10);
    }

    public void setCave(boolean cave) {
        this.f_19804_.m_135381_(DATA_CAVE, (Object)cave);
    }

    public boolean isCave() {
        return (Boolean)this.f_19804_.m_135370_(DATA_CAVE);
    }

    @Override
    public void setAutonomous(boolean autonomous) {
        this.f_19804_.m_135381_(AUTO_MODE, (Object)autonomous);
        if (autonomous) {
            this.m_216990_(SoundEvents.f_11686_);
            if (!this.isWandering()) {
                this.setWandering(true);
                this.setStaying(false);
            }
        }
    }

    @Override
    public boolean isAutonomous() {
        return (Boolean)this.f_19804_.m_135370_(AUTO_MODE);
    }

    @Override
    public void m_7380_(CompoundTag p_33353_) {
        super.m_7380_(p_33353_);
        p_33353_.m_128379_("Cave", this.isCave());
        p_33353_.m_128379_("AutoMode", this.isAutonomous());
    }

    @Override
    public void m_7378_(CompoundTag p_33344_) {
        super.m_7378_(p_33344_);
        if (p_33344_.m_128441_("Cave")) {
            this.setCave(p_33344_.m_128471_("Cave"));
        }
        if (p_33344_.m_128441_("AutoMode")) {
            this.setAutonomous(p_33344_.m_128471_("AutoMode"));
        }
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        if (this.m_20183_().m_123342_() <= 64 && !pLevel.m_45527_(this.m_20183_())) {
            this.setBearCave();
        }
        return pSpawnData;
    }

    @Override
    @Nullable
    public AnimalSummon getBreedOffspring(ServerLevel p_146743_, AnimalSummon p_146744_) {
        AnimalSummon entity = super.getBreedOffspring(p_146743_, p_146744_);
        if (entity instanceof BearServant) {
            BearServant bearServant = (BearServant)entity;
            if (this.isCave()) {
                bearServant.setBearCave();
            }
        }
        return entity;
    }

    @Nullable
    public LivingEntity m_6688_() {
        if (!this.m_21525_()) {
            Entity entity = this.m_146895_();
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                if (((Boolean)MobsConfig.ServantRideAutonomous.get()).booleanValue()) {
                    return null;
                }
                return mob;
            }
            if (entity instanceof LivingEntity && !this.isAutonomous()) {
                return (LivingEntity)entity;
            }
        }
        return null;
    }

    public boolean m_6109_() {
        return this.m_21515_();
    }

    public void m_19956_(Entity rider, Entity.MoveFunction p_19958_) {
        if (this.m_20363_(rider)) {
            float radius = -0.07f * this.clientSideStandAnimation;
            float angle = (float)(Math.PI / 180 * (double)this.f_20883_);
            double x = radius * Mth.m_14031_((float)((float)Math.PI + angle));
            double z = radius * Mth.m_14089_((float)angle);
            rider.m_6034_(this.m_20185_() + x, this.m_20186_() + this.m_6048_() + rider.m_6049_(), this.m_20189_() + z);
        }
    }

    public double m_6048_() {
        float f = Math.min(0.25f, this.f_267362_.m_267731_());
        float f1 = this.f_267362_.m_267756_();
        float standAdd = 0.07f * this.clientSideStandAnimation;
        return (double)this.m_20206_() - 0.3 + (double)(0.12f * Mth.m_14089_((float)(f1 * 0.7f)) * 0.7f * f) + (double)standAdd;
    }

    protected void doPlayerRide(Player player) {
        if (!this.f_19853_.f_46443_) {
            player.m_146922_(this.m_146908_());
            player.m_146926_(this.m_146909_());
            player.m_20329_((Entity)this);
        }
    }

    @Override
    public boolean isFood(ItemStack p_29565_) {
        return p_29565_.m_150930_(Items.f_42784_);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            if (this.clientSideStandAnimation != this.clientSideStandAnimationO) {
                this.m_6210_();
            }
            this.clientSideStandAnimationO = this.clientSideStandAnimation;
            this.clientSideStandAnimation = this.isStanding() ? Mth.m_14036_((float)(this.clientSideStandAnimation + 1.0f), (float)0.0f, (float)6.0f) : Mth.m_14036_((float)(this.clientSideStandAnimation - 1.0f), (float)0.0f, (float)6.0f);
        }
        if (this.warningSoundTicks > 0) {
            --this.warningSoundTicks;
        }
    }

    @Override
    public void lifeSpanDamage() {
        if (!this.f_19853_.f_46443_) {
            for (int i = 0; i < this.f_19853_.f_46441_.m_188503_(35) + 10; ++i) {
                ServerParticleUtil.smokeParticles((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20188_(), this.m_20189_(), this.f_19853_);
            }
        }
        this.m_146870_();
    }

    public EntityDimensions m_6972_(Pose p_29531_) {
        if (this.clientSideStandAnimation > 0.0f) {
            float f = this.clientSideStandAnimation / 6.0f;
            float f1 = 1.0f + f;
            return super.m_6972_(p_29531_).m_20390_(1.0f, f1);
        }
        return super.m_6972_(p_29531_);
    }

    public boolean isStanding() {
        return (Boolean)this.f_19804_.m_135370_(DATA_STANDING_ID);
    }

    public void setStanding(boolean p_29568_) {
        this.f_19804_.m_135381_(DATA_STANDING_ID, (Object)p_29568_);
    }

    public float getStandingAnimationScale(float p_29570_) {
        return Mth.m_14179_((float)p_29570_, (float)this.clientSideStandAnimationO, (float)this.clientSideStandAnimation) / 6.0f;
    }

    protected float m_6108_() {
        return 0.98f;
    }

    @Override
    public EntityType<?> getVariant(Level level, BlockPos blockPos) {
        EntityType entityType = (EntityType)ModEntityType.BEAR_SERVANT.get();
        if (level.m_204166_(blockPos).m_203656_(Tags.Biomes.IS_COLD_OVERWORLD)) {
            entityType = (EntityType)ModEntityType.POLAR_BEAR_SERVANT.get();
        }
        return entityType;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_7023_(@NotNull Vec3 pTravelVector) {
        if (!this.m_6084_()) return;
        LivingEntity rider = this.m_6688_();
        if (this.m_20160_() && rider instanceof Player) {
            Player player = (Player)rider;
            if (!this.isAutonomous()) {
                this.m_146922_(rider.m_146908_());
                this.f_19859_ = this.m_146908_();
                this.m_146926_(rider.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20885_ = this.f_20883_ = this.m_146908_();
                float speed = this.m_245547_(player);
                float f = rider.f_20900_ * speed;
                float f1 = rider.f_20902_ * speed;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                }
                if (this.m_20069_() && this.getFluidTypeHeight((FluidType)ForgeMod.WATER_TYPE.get()) > this.m_20204_() || this.m_20077_() || this.isInFluidType((fluidType, height) -> this.canSwimInFluidType((FluidType)fluidType) && height > this.m_20204_())) {
                    Vec3 vector3d = this.m_20184_();
                    this.m_20334_(vector3d.f_82479_, 0.04f, vector3d.f_82481_);
                    this.f_19812_ = true;
                    if (f1 > 0.0f) {
                        float f2 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                        float f3 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                        this.m_20256_(this.m_20184_().m_82520_((double)(-0.4f * f2 * 0.04f), 0.0, (double)(0.4f * f3 * 0.04f)));
                    }
                }
                this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
                super.m_7023_(new Vec3((double)f, pTravelVector.f_82480_, (double)f1));
                this.f_20903_ = 0;
                this.m_267651_(false);
                return;
            }
        }
        super.m_7023_(pTravelVector);
    }

    @Override
    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        if (!this.f_19853_.f_46443_) {
            ItemStack itemstack = pPlayer.m_21120_(pHand);
            if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner()) {
                if (itemstack.m_204117_(ItemTags.f_13156_) && this.m_21223_() < this.m_21233_()) {
                    FoodProperties foodProperties = itemstack.getFoodProperties((LivingEntity)this);
                    if (foodProperties != null) {
                        this.m_5634_(foodProperties.m_38744_());
                        if (!pPlayer.m_150110_().f_35937_) {
                            itemstack.m_41774_(1);
                        }
                        this.m_146852_(GameEvent.f_157806_, (Entity)this);
                        this.m_5584_(this.f_19853_, itemstack);
                        Level level = this.f_19853_;
                        if (level instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            for (int i = 0; i < 7; ++i) {
                                double d0 = this.f_19796_.m_188583_() * 0.02;
                                double d1 = this.f_19796_.m_188583_() * 0.02;
                                double d2 = this.f_19796_.m_188583_() * 0.02;
                                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.HEAL_EFFECT.get()), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                            }
                        }
                        pPlayer.m_6674_(pHand);
                        return InteractionResult.CONSUME;
                    }
                } else if (!pPlayer.m_6047_() && !this.m_6162_()) {
                    if (this.m_146895_() != null && this.m_146895_() != pPlayer) {
                        this.m_146895_().m_8127_();
                        return InteractionResult.SUCCESS;
                    }
                    if (!(pPlayer.m_21120_(pHand).m_41720_() instanceof IWand)) {
                        this.doPlayerRide(pPlayer);
                        return InteractionResult.SUCCESS;
                    }
                }
            }
        }
        return super.m_6071_(pPlayer, pHand);
    }

    @Override
    public boolean m_7327_(Entity entityIn) {
        boolean flag = super.m_7327_(entityIn);
        if (flag && this.isUpgraded() && entityIn instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entityIn;
            livingEntity.m_147207_(new MobEffectInstance((MobEffect)GoetyEffects.SAPPED.get(), MathHelper.secondsToTicks(5), 0), (Entity)this);
        }
        return flag;
    }

    @Override
    public void setUpgraded(boolean upgraded) {
        super.setUpgraded(upgraded);
        AttributeInstance health = this.m_21051_(Attributes.f_22276_);
        AttributeInstance attack = this.m_21051_(Attributes.f_22281_);
        AttributeInstance armor = this.m_21051_(Attributes.f_22284_);
        AttributeInstance knockback = this.m_21051_(Attributes.f_22278_);
        if (health != null && attack != null && armor != null && knockback != null) {
            if (upgraded) {
                health.m_22100_((Double)AttributesConfig.BearServantHealth.get() * 1.5);
                armor.m_22100_((Double)AttributesConfig.BearServantArmor.get() + 2.0);
                attack.m_22100_((Double)AttributesConfig.BearServantDamage.get() + 1.0);
                knockback.m_22100_(1.0);
            } else {
                health.m_22100_(((Double)AttributesConfig.BearServantHealth.get()).doubleValue());
                armor.m_22100_(((Double)AttributesConfig.BearServantArmor.get()).doubleValue());
                attack.m_22100_(((Double)AttributesConfig.BearServantDamage.get()).doubleValue());
                knockback.m_22100_(0.0);
            }
        }
        this.m_21153_(this.m_21233_());
    }

    @Override
    public void m_7822_(byte pId) {
        if (pId == 10) {
            this.setCave(true);
        } else {
            super.m_7822_(pId);
        }
    }

    class BearMeleeAttackGoal
    extends MeleeAttackGoal {
        public BearMeleeAttackGoal() {
            super((PathfinderMob)BearServant.this, 1.25, true);
        }

        public boolean m_8036_() {
            if (!BearServant.this.m_6162_()) {
                return super.m_8036_();
            }
            return false;
        }

        protected void m_6739_(LivingEntity p_29589_, double p_29590_) {
            double d0 = this.m_6639_(p_29589_);
            if (p_29590_ <= d0 && this.m_25564_()) {
                this.m_25563_();
                this.f_25540_.m_7327_((Entity)p_29589_);
                BearServant.this.setStanding(false);
            } else if (p_29590_ <= d0 * 2.0) {
                if (this.m_25564_()) {
                    BearServant.this.setStanding(false);
                    this.m_25563_();
                }
                if (this.m_25565_() <= 10) {
                    BearServant.this.setStanding(true);
                    BearServant.this.playWarningSound();
                }
            } else {
                this.m_25563_();
                BearServant.this.setStanding(false);
            }
        }

        public void m_8041_() {
            BearServant.this.setStanding(false);
            super.m_8041_();
        }

        protected double m_6639_(LivingEntity p_29587_) {
            return 4.0f + p_29587_.m_20205_();
        }
    }
}

