/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.illager;

import com.Polarice3.Goety.api.entities.ITrainable;
import com.Polarice3.Goety.api.entities.ally.illager.ILooter;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.blocks.entities.OminousPyreBlockEntity;
import com.Polarice3.Goety.common.effects.brew.BrewEffectInstance;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ai.IllagerLootFoodChestGoal;
import com.Polarice3.Goety.common.entities.ai.IllagerPutFoodChestGoal;
import com.Polarice3.Goety.common.entities.ai.IllagerPutLootChestGoal;
import com.Polarice3.Goety.common.entities.ally.illager.AllyTrampler;
import com.Polarice3.Goety.common.entities.ally.illager.ModRavager;
import com.Polarice3.Goety.common.entities.ally.illager.Neollager;
import com.Polarice3.Goety.common.entities.ally.illager.PillagerServant;
import com.Polarice3.Goety.common.entities.ally.illager.RaiderServant;
import com.Polarice3.Goety.common.entities.ally.illager.Ravaged;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.items.WaystoneItem;
import com.Polarice3.Goety.config.MobsConfig;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.BrewUtils;
import com.Polarice3.Goety.utils.DummyTeam;
import com.Polarice3.Goety.utils.ItemHelper;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.ServantUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractIllagerServant
extends RaiderServant
implements ITrainable,
ILooter {
    protected static final EntityDataAccessor<String> CURRENT_TRAIN = SynchedEntityData.m_135353_(AbstractIllagerServant.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    protected static final EntityDataAccessor<Optional<BlockPos>> TRAIN_POS = SynchedEntityData.m_135353_(AbstractIllagerServant.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    protected static final EntityDataAccessor<Optional<BlockPos>> STORED_TRAIN_POS = SynchedEntityData.m_135353_(AbstractIllagerServant.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    protected int trainTime;
    protected int trainCheck;
    protected int trainCompleted = 0;
    private int breedCool;
    private int eatCool;
    private int eatenFoodLevel;
    private int foodLevel;
    public int cantDo;
    @Nullable
    public BlockPos chestPos;
    public String chestDim = Level.f_46428_.m_135782_().toString();
    @Nullable
    public BlockPos dumpChestPos;
    public String dumpChestDim = Level.f_46428_.m_135782_().toString();
    private final SimpleContainer inventory = new SimpleContainer(8);

    public AbstractIllagerServant(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.throwGoal();
        this.chestGoal();
        this.f_21345_.m_25352_(2, (Goal)new RaiderOpenDoorGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new MakeLove(this));
    }

    @Override
    public void targetSelectGoal() {
        super.targetSelectGoal();
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal(this, new Class[]{RaiderServant.class}){

            public boolean m_8036_() {
                return super.m_8036_() && (AbstractIllagerServant.this.isHostile() || AbstractIllagerServant.this.isNatural());
            }
        }.m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false, livingEntity -> this.isHostile() && !livingEntity.m_6162_()).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false, livingEntity -> this.isHostile()));
    }

    public void throwGoal() {
        this.f_21345_.m_25352_(3, (Goal)new GiveExcessFoodGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new ThrowRottenFleshGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new FeedRottenFleshGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new ThrowLootGoal(this));
    }

    public void chestGoal() {
        this.f_21345_.m_25352_(2, new IllagerPutFoodChestGoal<AbstractIllagerServant>(this));
        this.f_21345_.m_25352_(4, new IllagerPutLootChestGoal<AbstractIllagerServant>(this));
        this.f_21345_.m_25352_(7, new IllagerLootFoodChestGoal<AbstractIllagerServant>(this));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CURRENT_TRAIN, (Object)"None");
        this.f_19804_.m_135372_(TRAIN_POS, Optional.empty());
        this.f_19804_.m_135372_(STORED_TRAIN_POS, Optional.empty());
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("BreedCool", this.breedCool);
        compound.m_128405_("EatCool", this.eatCool);
        compound.m_128405_("EatenFoodLevel", this.eatenFoodLevel);
        this.saveLooterData(compound);
        this.saveTrainableData(compound);
        this.m_252802_(compound);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("BreedCool")) {
            this.breedCool = compound.m_128451_("BreedCool");
        }
        if (compound.m_128441_("EatCool")) {
            this.eatCool = compound.m_128451_("EatCool");
        }
        if (compound.m_128441_("EatenFoodLevel")) {
            this.eatenFoodLevel = compound.m_128451_("EatenFoodLevel");
        }
        this.readLooterData(compound);
        this.readTrainableData(compound);
        this.m_253224_(compound);
    }

    public SimpleContainer m_35311_() {
        return this.inventory;
    }

    public SlotAccess m_141942_(int p_149995_) {
        int i = p_149995_ - 300;
        return i >= 0 && i < this.inventory.m_6643_() ? SlotAccess.m_147292_((Container)this.inventory, (int)i) : super.m_141942_(p_149995_);
    }

    public MobType m_6336_() {
        return MobType.f_21643_;
    }

    @Override
    @Nullable
    public Team m_5647_() {
        if (super.m_5647_() != null) {
            return super.m_5647_();
        }
        return new DummyTeam();
    }

    @NotNull
    public Component m_5446_() {
        return AbstractIllagerServant.formatNameForTeam(this.m_5647_(), this.m_7755_()).m_130938_(p_185975_ -> p_185975_.m_131144_(this.m_20190_()).m_131138_(this.m_20149_()));
    }

    public static MutableComponent formatNameForTeam(@Nullable Team p_83349_, Component p_83350_) {
        return p_83349_ == null || p_83349_ instanceof DummyTeam ? p_83350_.m_6881_() : p_83349_.m_6870_(p_83350_);
    }

    @Override
    public boolean canBeLeader() {
        return !this.isTraining();
    }

    @Override
    public boolean canJoinPatrol() {
        return !this.isTraining();
    }

    @Override
    public boolean canCommandToBlock(Level level, BlockPos blockPos) {
        return super.canCommandToBlock(level, blockPos) || level.m_7702_(blockPos) instanceof OminousPyreBlockEntity;
    }

    @Override
    public void setCommandPos(BlockPos blockPos) {
        BlockEntity blockEntity;
        super.setCommandPos(blockPos);
        if (blockPos != null && (blockEntity = this.f_19853_.m_7702_(blockPos)) instanceof OminousPyreBlockEntity) {
            OminousPyreBlockEntity pyre = (OminousPyreBlockEntity)blockEntity;
            EntityType<? extends Mob> entityType = pyre.getTrainedMob(this.f_19853_, blockPos);
            if (pyre.capacityAvailable(this.f_19853_, blockPos) && entityType != null && pyre.trainingRequirements(this.f_19853_, blockPos).test((Mob)this) && pyre.getTrueOwner() == this.getTrueOwner()) {
                this.setStoredTrainPos(blockPos);
            }
        }
    }

    @Override
    public int getTotalTrainTime() {
        return MathHelper.secondsToTicks((Integer)MobsConfig.IllagerServantTrainTime.get());
    }

    @Override
    public Optional<BlockPos> getTrainPos() {
        return (Optional)this.f_19804_.m_135370_(TRAIN_POS);
    }

    @Override
    public void setTrainPos(@Nullable BlockPos trainPos) {
        this.f_19804_.m_135381_(TRAIN_POS, Optional.ofNullable(trainPos));
    }

    @Override
    public Optional<BlockPos> getStoredTrainPos() {
        return (Optional)this.f_19804_.m_135370_(STORED_TRAIN_POS);
    }

    @Override
    public void setStoredTrainPos(@Nullable BlockPos blockPos) {
        this.f_19804_.m_135381_(STORED_TRAIN_POS, Optional.ofNullable(blockPos));
    }

    @Override
    public String getCurrentTrain() {
        return (String)this.f_19804_.m_135370_(CURRENT_TRAIN);
    }

    @Override
    public void setCurrentTrain(String train) {
        this.f_19804_.m_135381_(CURRENT_TRAIN, (Object)train);
    }

    @Override
    public int getTrainTime() {
        return this.trainTime;
    }

    @Override
    public void setTrainTime(int time) {
        this.trainTime = time;
    }

    @Override
    public int getTrainCheck() {
        return this.trainCheck;
    }

    @Override
    public void setTrainCheck(int check) {
        this.trainCheck = check;
    }

    @Override
    public boolean canTrain(Level level, BlockPos blockPos, EntityType<? extends Mob> entityType) {
        boolean flag = true;
        if (!((Boolean)MobsConfig.IllagerServantAutoTrain.get()).booleanValue()) {
            boolean bl = flag = this.getStoredTrainPos().isPresent() && BlockFinder.samePos(this.getStoredTrainPos().get(), blockPos);
        }
        if (flag) {
            this.setTrainCheck(10);
            return true;
        }
        return false;
    }

    public boolean canOpenDoors() {
        return (Boolean)MobsConfig.IllagerServantAllOpenDoors.get();
    }

    protected void m_8024_() {
        if (this.canOpenDoors() && !this.m_21525_() && GoalUtils.m_26894_((Mob)this)) {
            boolean flag = this.isRaiding();
            ((GroundPathNavigation)this.m_21573_()).m_26477_(flag);
        }
        super.m_8024_();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        RaiderServant raiderServant = this.getLeader();
        if (raiderServant instanceof AbstractIllagerServant) {
            AbstractIllagerServant servant = (AbstractIllagerServant)raiderServant;
            if (!BlockFinder.samePos(this.getDumpChestPos(), servant.getDumpChestPos())) {
                this.setDumpChestPos(servant.getDumpChestPos());
                if (servant.getDumpChestLevel() != null) {
                    this.setDumpChestDim(servant.getDumpChestLevel());
                }
            }
            if (!BlockFinder.samePos(this.getChestPos(), servant.getChestPos())) {
                this.setChestPos(servant.getChestPos());
                if (servant.getChestLevel() != null) {
                    this.setChestDim(servant.getChestLevel());
                }
            }
        }
        if (this.cantDo > 0) {
            --this.cantDo;
        }
        if (!this.f_19853_.f_46443_) {
            if (this.breedCool > 0) {
                --this.breedCool;
            }
            if (this.eatCool > 0) {
                --this.eatCool;
            }
            if (this.trainCompleted > 0) {
                --this.trainCompleted;
            }
            this.trainTick();
            if (this.eatenFoodLevel > 0 && this.f_19797_ % 20 == 0) {
                --this.eatenFoodLevel;
                this.m_5634_(1.0f);
            }
        }
    }

    @Override
    public void healServant() {
        super.healServant();
        if (!this.f_19853_.f_46443_ && this.eatenFoodLevel <= 0 && this.m_21223_() < this.m_21233_() && this.countFoodPointsInInventory() != 0) {
            for (int i = 0; i < this.m_35311_().m_6643_(); ++i) {
                Integer integer;
                ItemStack itemstack = this.m_35311_().m_8020_(i);
                if (itemstack.m_41619_() || (integer = this.getFoodPoints().get(itemstack.m_41720_())) == null) continue;
                FoodProperties foodProperties = itemstack.getFoodProperties((LivingEntity)this);
                if (foodProperties != null && !foodProperties.m_38749_().isEmpty()) {
                    for (Pair level : foodProperties.m_38749_()) {
                        if (level.getFirst() == null || !(this.m_217043_().m_188501_() < ((Float)level.getSecond()).floatValue())) continue;
                        this.m_7292_(new MobEffectInstance((MobEffectInstance)level.getFirst()));
                    }
                }
                if (!BrewUtils.isEmpty(itemstack)) {
                    if (!PotionUtils.m_43547_((ItemStack)itemstack).isEmpty()) {
                        for (MobEffectInstance mobEffectInstance : PotionUtils.m_43547_((ItemStack)itemstack)) {
                            if (mobEffectInstance.m_19544_().m_8093_()) {
                                mobEffectInstance.m_19544_().m_19461_((Entity)this, (Entity)this, (LivingEntity)this, mobEffectInstance.m_19564_(), 1.0);
                                continue;
                            }
                            this.m_7292_(new MobEffectInstance(mobEffectInstance));
                        }
                    }
                    if (!BrewUtils.getBrewEffects(itemstack).isEmpty()) {
                        for (BrewEffectInstance brewEffectInstance : BrewUtils.getBrewEffects(itemstack)) {
                            brewEffectInstance.getEffect().drinkBlockEffect((Entity)this, (Entity)this, (LivingEntity)this, brewEffectInstance.getAmplifier(), BrewUtils.getAreaOfEffect(itemstack));
                        }
                    }
                }
                this.eatenFoodLevel = integer;
                this.m_216990_(SoundEvents.f_11912_);
                Level level = this.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    ServerParticleUtil.addParticlesAroundMiddleSelf(serverLevel, (ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemstack), (Entity)this);
                }
                this.m_35311_().m_7407_(i, 1);
                break;
            }
        }
    }

    @Override
    public double getCommandSpeed() {
        return 1.0;
    }

    @Override
    public List<ItemStack> itemsInInv(Predicate<ItemStack> predicate) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        SimpleContainer simplecontainer = this.m_35311_();
        int i = simplecontainer.m_6643_();
        for (int j = 0; j < i; ++j) {
            ItemStack itemStack = simplecontainer.m_8020_(j);
            if (!predicate.test(itemStack)) continue;
            list.add(itemStack);
        }
        return list;
    }

    public boolean inventoryFull() {
        int i = 0;
        for (int j = 0; j < this.m_35311_().m_6643_(); ++j) {
            ItemStack itemStack = this.m_35311_().m_8020_(j);
            if (!itemStack.m_41619_()) continue;
            ++i;
        }
        return i == 0;
    }

    public int getBreedCool() {
        return this.breedCool;
    }

    public void setBreedCool(int cool) {
        this.breedCool = cool;
    }

    public boolean canBreed() {
        boolean flag = true;
        if (!((Boolean)MobsConfig.IllagerServantAllBreed.get()).booleanValue()) {
            flag = this.m_6095_() == ModEntityType.NEOLLAGER.get();
        }
        return flag && this.foodLevel + this.countFoodPointsInInventory() >= 12 && !this.m_5803_() && this.breedCool <= 0 && this.f_20916_ <= 0 && this.m_5448_() == null && !this.isFollowing() && !this.isCelebrating() && !this.isRaiding() && !this.m_6162_();
    }

    @Override
    @Nullable
    public BlockPos getChestPos() {
        return this.chestPos;
    }

    @Override
    public void setChestPos(@Nullable BlockPos chestPos) {
        this.chestPos = chestPos;
    }

    @Override
    public String getChestDim() {
        return this.chestDim;
    }

    @Override
    public void setChestDim(String string) {
        this.chestDim = string;
    }

    @Override
    @Nullable
    public BlockPos getDumpChestPos() {
        return this.dumpChestPos;
    }

    @Override
    public void setDumpChestPos(@Nullable BlockPos chestPos) {
        this.dumpChestPos = chestPos;
    }

    @Override
    public String getDumpChestDim() {
        return this.dumpChestDim;
    }

    @Override
    public void setDumpChestDim(String string) {
        this.dumpChestDim = string;
    }

    private boolean hungry() {
        return this.foodLevel < 12;
    }

    private void eatUntilFull() {
        if (this.hungry() && this.countFoodPointsInInventory() != 0) {
            for (int i = 0; i < this.m_35311_().m_6643_(); ++i) {
                int j;
                Integer integer;
                ItemStack itemstack = this.m_35311_().m_8020_(i);
                if (itemstack.m_41619_() || (integer = this.getFoodPoints().get(itemstack.m_41720_())) == null) continue;
                for (int k = j = itemstack.m_41613_(); k > 0; --k) {
                    this.foodLevel += integer.intValue();
                    this.m_35311_().m_7407_(i, 1);
                    if (this.hungry()) continue;
                    return;
                }
            }
        }
    }

    private void digestFood(int p_35549_) {
        this.foodLevel -= p_35549_;
    }

    public void eatAndDigestFood() {
        this.eatUntilFull();
        this.digestFood(12);
    }

    public int countFoodPointsInInventory() {
        SimpleContainer simplecontainer = this.m_35311_();
        return this.getFoodPoints().entrySet().stream().mapToInt(entry -> simplecontainer.m_18947_((Item)entry.getKey()) * (Integer)entry.getValue()).sum();
    }

    public int countFoodInInventory() {
        SimpleContainer simplecontainer = this.m_35311_();
        return this.getFoodPoints().keySet().stream().mapToInt(arg_0 -> ((SimpleContainer)simplecontainer).m_18947_(arg_0)).sum();
    }

    public boolean validFood(ItemStack itemStack) {
        FoodProperties foodProperties = itemStack.getFoodProperties((LivingEntity)this);
        if (foodProperties == null) {
            return false;
        }
        if (foodProperties.m_38746_() && foodProperties.m_38744_() <= 3) {
            return false;
        }
        return foodProperties.m_38749_().isEmpty() || itemStack.m_150930_(Items.f_42583_);
    }

    public boolean validLootToStore(ItemStack itemStack) {
        return !itemStack.m_41619_() && !this.validFood(itemStack);
    }

    public boolean canEat(ItemStack itemStack) {
        return !itemStack.m_150930_(Items.f_42583_);
    }

    public Map<Item, Integer> getFoodPoints() {
        SimpleContainer simplecontainer = this.m_35311_();
        int i = simplecontainer.m_6643_();
        HashMap<Item, Integer> foodPoints = new HashMap<Item, Integer>();
        for (int j = 0; j < i; ++j) {
            FoodProperties foodProperties;
            ItemStack itemStack = simplecontainer.m_8020_(j);
            if (itemStack.getFoodProperties((LivingEntity)this) == null || (foodProperties = itemStack.getFoodProperties((LivingEntity)this)) == null || !this.validFood(itemStack) || !this.canEat(itemStack)) continue;
            foodPoints.put(itemStack.m_41720_(), foodProperties.m_38744_());
        }
        return foodPoints;
    }

    public boolean hasExcessFood() {
        return this.countFoodInInventory() > 24;
    }

    public boolean canHaveMoreFood() {
        return this.countFoodPointsInInventory() < 64;
    }

    public boolean wantsMoreFood() {
        return this.countFoodPointsInInventory() < 12;
    }

    protected void addParticlesAroundSelf(ParticleOptions p_35288_) {
        for (int i = 0; i < 5; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.f_19853_.m_7106_(p_35288_, this.m_20208_(1.0), this.m_20187_() + 1.0, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    @NotNull
    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    public Vec3 m_7398_(float p_35318_) {
        float f = Mth.m_14179_((float)p_35318_, (float)this.f_20884_, (float)this.f_20883_) * ((float)Math.PI / 180);
        Vec3 vec3 = new Vec3(0.0, this.m_20191_().m_82376_() - 1.0, 0.2);
        return this.m_20318_(p_35318_).m_82549_(vec3.m_82524_(-f));
    }

    protected void m_7581_(ItemEntity itemEntity) {
        boolean flag;
        ItemStack itemstack = itemEntity.m_32055_();
        boolean bl = flag = (this.getMarked() != null || this.isRaiding()) && !this.isLeader();
        if (flag && this.getLeader() == null && !this.getLeaderBannerInstance().m_41619_() && ItemHelper.sameBanner(itemstack, this.getBannerPatternInstance())) {
            ItemStack itemstack1 = this.m_6844_(EquipmentSlot.HEAD);
            double d0 = this.m_21519_(EquipmentSlot.HEAD);
            if (!itemstack1.m_41619_() && (double)Math.max(this.f_19796_.m_188501_() - 0.1f, 0.0f) < d0) {
                this.m_19983_(itemstack1);
            }
            this.m_21053_(itemEntity);
            this.m_8061_(EquipmentSlot.HEAD, itemstack);
            this.m_21508_(EquipmentSlot.HEAD);
            this.m_7938_((Entity)itemEntity, itemstack.m_41613_());
            itemEntity.m_146870_();
        } else {
            InventoryCarrier.m_219611_((Mob)this, (InventoryCarrier)this, (ItemEntity)itemEntity);
        }
    }

    public boolean m_21531_() {
        return (Boolean)MobsConfig.IllagerServantPickUpDrops.get();
    }

    public boolean m_7243_(ItemStack itemStack) {
        return (Boolean)MobsConfig.IllagerServantPickUpDrops.get() != false && this.validFood(itemStack) && this.canHaveMoreFood() && this.m_35311_().m_19183_(itemStack);
    }

    @Nullable
    public AbstractIllagerServant getBreedOffspring(ServerLevel serverLevel, AbstractIllagerServant illager) {
        Neollager neollager = new Neollager((EntityType<? extends Owned>)((EntityType)ModEntityType.NEOLLAGER.get()), (Level)serverLevel);
        neollager.copyTrueOwner(this);
        ForgeEventFactory.onFinalizeSpawn((Mob)neollager, (ServerLevelAccessor)serverLevel, (DifficultyInstance)serverLevel.m_6436_(this.m_20183_()), (MobSpawnType)MobSpawnType.BREEDING, null, null);
        if (illager.isGuardingArea()) {
            neollager.setBoundPos(illager.getBoundPos());
            neollager.setBoundDim(illager.getBoundLevel());
        }
        neollager.setWandering(illager.isWandering());
        neollager.setStaying(illager.isStaying());
        return neollager;
    }

    @Override
    public int trainSpeed(EntityType<? extends Mob> entityType) {
        int i = this.m_6162_() ? 2 : 1;
        Mob mob = (Mob)entityType.m_20615_(this.f_19853_);
        if (mob instanceof PillagerServant) {
            i *= 2;
        }
        List list = this.f_19853_.m_45971_(AbstractIllagerServant.class, TargetingConditions.m_148353_().m_26883_(8.0).m_148355_().m_26893_().m_26888_(livingEntity -> {
            AbstractIllagerServant illager;
            return livingEntity instanceof AbstractIllagerServant && (illager = (AbstractIllagerServant)livingEntity).getTrueOwner() == this.getTrueOwner() && illager.m_6095_() == entityType;
        }), (LivingEntity)this, this.m_20191_().m_82400_(8.0));
        return i += Mth.m_14045_((int)list.size(), (int)0, (int)((Integer)MobsConfig.IllagerServantMaxMentors.get()));
    }

    @Override
    public void train(EntityType<? extends Mob> entityType) {
        if (Objects.equals(this.getCurrentTrain(), entityType.m_20675_())) {
            if (this.getTrainTime() < this.getTotalTrainTime()) {
                Level level;
                if (this.getTrainTime() % 1000 == 0 && (level = this.f_19853_) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    ServerParticleUtil.addParticlesAroundMiddleSelf(serverLevel, (ParticleOptions)ParticleTypes.f_123748_, (Entity)this);
                }
                this.setTrainTime(this.getTrainTime() + this.trainSpeed(entityType));
            } else {
                this.completeTraining(entityType);
            }
        } else {
            this.setTrainTime(0);
            this.setCurrentTrain(entityType.m_20675_());
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ServerParticleUtil.addParticlesAroundMiddleSelf(serverLevel, (ParticleOptions)ParticleTypes.f_123748_, (Entity)this);
            }
        }
        this.setTrainCheck(10);
    }

    @Override
    public boolean isTrained() {
        return this.trainCompleted > 0;
    }

    @Override
    public void completeTraining(EntityType<? extends Mob> entityType) {
        if (!this.isTrained()) {
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ServerParticleUtil.addParticlesAroundMiddleSelf(serverLevel, (ParticleOptions)ParticleTypes.f_123744_, (Entity)this);
            }
            ITrainable.super.completeTraining(entityType);
            this.trainCompleted = 10;
        }
    }

    public void m_7822_(byte p_35391_) {
        if (p_35391_ == 9) {
            this.cantDo = 40;
        } else if (p_35391_ == 12) {
            this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123750_);
        } else {
            super.m_7822_(p_35391_);
        }
    }

    public IllagerServantArmPose getArmPose() {
        return IllagerServantArmPose.CROSSED;
    }

    protected void m_5907_() {
        this.dropAllInventory();
    }

    protected void dropAllInventory() {
        for (int i = 0; i < this.m_35311_().m_6643_(); ++i) {
            ItemStack itemstack = this.m_35311_().m_8020_(i);
            if (itemstack.m_41619_()) continue;
            if (EnchantmentHelper.m_44924_((ItemStack)itemstack)) {
                this.m_35311_().m_8016_(i);
                continue;
            }
            this.m_19983_(itemstack);
        }
    }

    public boolean isWithinDistance(Entity entity, double distance) {
        if (entity == null) {
            return false;
        }
        BlockPos blockpos = entity.m_20183_();
        BlockPos blockpos1 = this.m_20183_();
        return blockpos1.m_123314_((Vec3i)blockpos, distance);
    }

    public boolean isWithinThrowingDistance(Entity entity) {
        return this.isWithinDistance(entity, 5.0);
    }

    public void addDrops(Collection<ItemEntity> items) {
        List<ItemStack> drops = items.stream().filter(Objects::nonNull).map(ItemEntity::m_32055_).filter(itemStack -> !itemStack.m_41619_()).toList();
        for (ItemStack itemStack2 : drops) {
            if (this.m_35311_().m_19183_(itemStack2)) {
                this.m_35311_().m_19173_(itemStack2);
                continue;
            }
            this.m_19983_(itemStack2);
        }
    }

    @Override
    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        Item item = itemstack.m_41720_();
        if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner()) {
            if (this.validFood(itemstack)) {
                if (this.canHaveMoreFood() && this.m_35311_().m_19183_(itemstack)) {
                    this.m_35311_().m_19173_(itemstack.m_255036_(1));
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    this.m_5496_(SoundEvents.f_12019_, 1.0f, 1.0f);
                    Level level = this.f_19853_;
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        for (int i = 0; i < 7; ++i) {
                            double d0 = this.f_19796_.m_188583_() * 0.02;
                            double d1 = this.f_19796_.m_188583_() * 0.02;
                            double d2 = this.f_19796_.m_188583_() * 0.02;
                            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                        }
                    }
                    return InteractionResult.SUCCESS;
                }
            } else {
                if (item instanceof ArmorItem) {
                    return ServantUtil.equipServantArmor(pPlayer, this, itemstack, super.m_6071_(pPlayer, pHand));
                }
                if (pPlayer.m_21205_().m_150930_((Item)ModItems.WAYSTONE.get())) {
                    ChestBlockEntity chestBlock;
                    BlockEntity i;
                    if (WaystoneItem.isSameDimension((LivingEntity)this, pPlayer.m_21205_()) && (i = WaystoneItem.getBlockEntity(pPlayer.m_21205_(), this.f_19853_)) instanceof ChestBlockEntity && (chestBlock = (ChestBlockEntity)i).m_7525_(pPlayer) && !this.f_19853_.f_46443_) {
                        BlockPos blockPos = WaystoneItem.getBlockPos(pPlayer.m_21205_());
                        if (blockPos != null) {
                            this.m_5496_(SoundEvents.f_11686_, 1.0f, 0.45f);
                            Level level = this.f_19853_;
                            if (level instanceof ServerLevel) {
                                ServerLevel serverLevel = (ServerLevel)level;
                                for (int i2 = 0; i2 < 7; ++i2) {
                                    double d0 = this.f_19796_.m_188583_() * 0.02;
                                    double d1 = this.f_19796_.m_188583_() * 0.02;
                                    double d2 = this.f_19796_.m_188583_() * 0.02;
                                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                                }
                            }
                            if (chestBlock.m_58900_().m_204336_(ModTags.Blocks.RAIDING_CHESTS)) {
                                this.setDumpChestPos(blockPos);
                                this.setDumpChestDim(this.f_19853_.m_46472_());
                            } else {
                                this.setChestPos(blockPos);
                                this.setChestDim(this.f_19853_.m_46472_());
                            }
                            if (this.isLeader()) {
                                for (RaiderServant servant : this.getNearbyCompanions()) {
                                    if (!(servant instanceof AbstractIllagerServant)) continue;
                                    AbstractIllagerServant servant1 = (AbstractIllagerServant)servant;
                                    if (chestBlock.m_58900_().m_204336_(ModTags.Blocks.RAIDING_CHESTS)) {
                                        servant1.setDumpChestPos(blockPos);
                                        servant1.setDumpChestDim(this.f_19853_.m_46472_());
                                        continue;
                                    }
                                    servant1.setChestPos(blockPos);
                                    servant1.setChestDim(this.f_19853_.m_46472_());
                                }
                            }
                            return InteractionResult.SUCCESS;
                        }
                        return InteractionResult.FAIL;
                    }
                } else {
                    if (itemstack.m_150930_(Items.f_42747_) && this.m_21206_().m_41619_()) {
                        this.m_8061_(EquipmentSlot.OFFHAND, itemstack.m_255036_(1));
                        if (!pPlayer.m_150110_().f_35937_) {
                            itemstack.m_41774_(1);
                        }
                        if (this.getCelebrateSound() != null) {
                            this.m_5496_(this.getCelebrateSound(), 1.0f, 1.0f);
                        }
                        this.m_5496_(SoundEvents.f_12019_, 1.0f, 1.0f);
                        Level blockPos = this.f_19853_;
                        if (blockPos instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)blockPos;
                            for (int i = 0; i < 7; ++i) {
                                double d0 = this.f_19796_.m_188583_() * 0.02;
                                double d1 = this.f_19796_.m_188583_() * 0.02;
                                double d2 = this.f_19796_.m_188583_() * 0.02;
                                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                            }
                        }
                        return InteractionResult.SUCCESS;
                    }
                    if (itemstack.m_150930_(Items.f_42398_) && this.m_21206_().m_150930_(Items.f_42747_)) {
                        ItemStack totem = this.m_21206_();
                        this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                        this.dropEquipment(EquipmentSlot.OFFHAND, totem);
                        this.m_5496_(SoundEvents.f_184214_, 1.0f, 1.0f);
                        return InteractionResult.SUCCESS;
                    }
                }
            }
        }
        return super.m_6071_(pPlayer, pHand);
    }

    protected class RaiderOpenDoorGoal
    extends OpenDoorGoal {
        public RaiderOpenDoorGoal(RaiderServant p_32128_) {
            super((Mob)p_32128_, false);
        }

        public boolean m_8036_() {
            return super.m_8036_() && AbstractIllagerServant.this.isRaiding() && AbstractIllagerServant.this.canOpenDoors();
        }
    }

    public static class MakeLove
    extends Goal {
        private final AbstractIllagerServant illager;
        @Nullable
        protected AbstractIllagerServant partner;
        private int loveTime;
        private boolean hasBred;

        public MakeLove(AbstractIllagerServant illager) {
            this.illager = illager;
        }

        public boolean m_8036_() {
            if (!this.illager.canBreed()) {
                return false;
            }
            this.partner = this.getFreePartner();
            return this.partner != null && this.hasVacantBed();
        }

        public boolean m_8045_() {
            return this.partner != null && this.partner.m_6084_() && this.hasVacantBed() && (int)this.illager.f_19853_.m_46467_() <= this.loveTime && this.illager.canBreed() && this.partner.canBreed();
        }

        public void m_8056_() {
            this.hasBred = false;
            int i = 275 + this.illager.f_19853_.m_213780_().m_188503_(50);
            this.loveTime = (int)(this.illager.f_19853_.m_46467_() + (long)i);
        }

        public void m_8041_() {
            this.partner = null;
            this.loveTime = 0;
        }

        public void m_8037_() {
            if (this.partner == null) {
                this.m_8041_();
            }
            this.illager.m_21563_().m_24960_((Entity)this.partner, 10.0f, (float)this.illager.m_8132_());
            this.illager.m_21573_().m_5624_((Entity)this.partner, 0.5);
            if ((int)this.illager.f_19853_.m_46467_() >= this.loveTime && this.illager.m_20280_((Entity)this.partner) <= 5.0) {
                this.partner.eatAndDigestFood();
                this.illager.eatAndDigestFood();
                this.breed();
            } else if (this.illager.f_19853_.m_213780_().m_188503_(35) == 0) {
                this.illager.f_19853_.m_7605_((Entity)this.illager, (byte)12);
                this.illager.f_19853_.m_7605_((Entity)this.partner, (byte)12);
            }
        }

        public void breed() {
            ServerLevel serverLevel;
            AbstractIllagerServant baby;
            this.illager.breedCool = 6000;
            if (this.partner == null || this.hasBred) {
                return;
            }
            this.partner.breedCool = 6000;
            Level level = this.illager.f_19853_;
            if (level instanceof ServerLevel && (baby = this.illager.getBreedOffspring(serverLevel = (ServerLevel)level, this.partner)) != null) {
                baby.m_7678_(this.illager.m_20185_(), this.illager.m_20186_(), this.illager.m_20189_(), 0.0f, 0.0f);
                baby.m_6863_(true);
                if (this.illager.f_19853_.m_7967_((Entity)baby)) {
                    this.illager.f_19853_.m_7605_((Entity)baby, (byte)12);
                    this.hasBred = true;
                }
            }
        }

        @Nullable
        private AbstractIllagerServant getFreePartner() {
            List list = this.illager.f_19853_.m_45976_(AbstractIllagerServant.class, this.illager.m_20191_().m_82400_(16.0));
            list.sort(Comparator.comparingDouble(arg_0 -> ((AbstractIllagerServant)this.illager).m_20280_(arg_0)));
            AbstractIllagerServant illagerServant = null;
            for (AbstractIllagerServant servant : list) {
                if (servant == this.illager || servant.getTrueOwner() != this.illager.getTrueOwner() || !servant.canBreed() || !this.illager.canBreed() || !this.illager.m_142582_((Entity)servant)) continue;
                illagerServant = servant;
            }
            return illagerServant;
        }

        public boolean hasVacantBed() {
            Level level = this.illager.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Optional<BlockPos> optional = this.getVacantBed(serverLevel);
                return optional.isPresent() && this.canReach(optional.get());
            }
            return false;
        }

        public Optional<BlockPos> getVacantBed(ServerLevel serverLevel) {
            return serverLevel.m_8904_().m_27186_(holder -> holder.m_203565_(PoiTypes.f_218060_), blockPos -> true, this.illager.m_20183_(), 8, PoiManager.Occupancy.HAS_SPACE);
        }

        public boolean canReach(BlockPos p_217502_) {
            Path path = this.illager.m_21573_().m_7864_(p_217502_, 1);
            return path != null && path.m_77403_();
        }

        public boolean m_183429_() {
            return true;
        }
    }

    public static class GiveExcessFoodGoal
    extends ThrowItemGoal {
        public GiveExcessFoodGoal(AbstractIllagerServant illager) {
            super(illager);
            this.predicate = ItemStack::m_41614_;
            this.targetPredicate = living -> {
                AbstractIllagerServant servant1;
                return living instanceof AbstractIllagerServant && (servant1 = (AbstractIllagerServant)living).getTrueOwner() == illager.getTrueOwner() && servant1.wantsMoreFood() && !servant1.m_6162_();
            };
        }

        @Override
        public boolean m_8036_() {
            if (this.illager.hasExcessFood()) {
                return super.m_8036_();
            }
            return false;
        }

        @Override
        public boolean isWithinThrowingDistance() {
            if (this.target == null) {
                return false;
            }
            if (this.target instanceof InventoryCarrier) {
                return this.illager.isWithinDistance((Entity)this.target, 2.0);
            }
            return super.isWithinThrowingDistance();
        }

        @Override
        public void throwItem() {
            if (this.target == null) {
                this.m_8041_();
            }
            SimpleContainer simpleContainer = this.illager.m_35311_();
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (int i = 0; i < simpleContainer.m_6643_(); ++i) {
                ItemStack itemstack1 = simpleContainer.m_8020_(i);
                Item item = itemstack1.m_41720_();
                if (itemstack1.m_41619_() || !item.m_41472_()) continue;
                int j = 0;
                if (itemstack1.m_41613_() > itemstack1.m_41741_() / 2) {
                    j = itemstack1.m_41613_() / 2;
                }
                if (itemstack1.m_41613_() > 24) {
                    j = itemstack1.m_41613_() - 24;
                }
                if (j <= 0) continue;
                list.add(itemstack1.m_41620_(j));
            }
            if (!list.isEmpty()) {
                for (ItemStack itemStack : list) {
                    LivingEntity livingEntity = this.target;
                    if (livingEntity instanceof InventoryCarrier) {
                        InventoryCarrier carrier = (InventoryCarrier)livingEntity;
                        if (!carrier.m_35311_().m_19183_(itemStack)) continue;
                        carrier.m_35311_().m_19173_(itemStack.m_278832_());
                        this.target.m_216990_(SoundEvents.f_12019_);
                        continue;
                    }
                    BehaviorUtils.m_22613_((LivingEntity)this.illager, (ItemStack)itemStack.m_278832_(), (Vec3)this.target.m_20182_());
                }
            }
        }
    }

    public static class ThrowRottenFleshGoal
    extends ThrowItemGoal {
        public ThrowRottenFleshGoal(AbstractIllagerServant illager) {
            super(illager);
            this.predicate = itemStack -> itemStack.m_150930_(Items.f_42583_);
            this.targetPredicate = living -> {
                Ravaged ravaged;
                return living instanceof Ravaged && (ravaged = (Ravaged)living).getTrueOwner() == illager.getTrueOwner() && ravaged.f_20916_ <= 0 && ravaged.m_5448_() == null && !ravaged.isConverting();
            };
        }
    }

    public static class FeedRottenFleshGoal
    extends ThrowItemGoal {
        public FeedRottenFleshGoal(AbstractIllagerServant illager) {
            super(illager);
            this.predicate = itemStack -> itemStack.m_150930_(Items.f_42583_);
            this.targetPredicate = living -> {
                RaiderServant servant;
                return living instanceof RaiderServant && ((servant = (RaiderServant)living) instanceof ModRavager || servant instanceof AllyTrampler) && servant.getTrueOwner() == illager.getTrueOwner() && !servant.isRaiding() && !servant.isCelebrating() && servant.getMarked() == null && servant.m_21223_() < servant.m_21233_() && servant.m_5448_() == null;
            };
        }

        @Override
        public void m_8041_() {
            super.m_8041_();
            if (this.illager.m_21205_().m_150930_(Items.f_42583_)) {
                this.illager.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
            } else if (this.illager.m_21206_().m_150930_(Items.f_42583_)) {
                this.illager.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
            }
        }

        @Override
        public void m_8037_() {
            if (this.target == null) {
                this.m_8041_();
            }
            this.illager.m_21563_().m_24960_((Entity)this.target, 10.0f, (float)this.illager.m_8132_());
            if (!this.illager.itemsInInv(this.predicate).isEmpty()) {
                Optional optional = this.illager.itemsInInv(this.predicate).stream().findFirst();
                if (optional.isPresent()) {
                    ItemStack itemStack = (ItemStack)optional.get();
                    if (!itemStack.m_41619_()) {
                        FoodProperties foodProperties = itemStack.getFoodProperties(this.target);
                        if (foodProperties != null) {
                            if (this.illager.m_21205_().m_41619_()) {
                                this.illager.m_8061_(EquipmentSlot.MAINHAND, itemStack.m_255036_(1));
                            } else if (this.illager.m_21206_().m_41619_()) {
                                this.illager.m_8061_(EquipmentSlot.OFFHAND, itemStack.m_255036_(1));
                            }
                            if (this.illager.isWithinThrowingDistance((Entity)this.target)) {
                                this.illager.m_21573_().m_26573_();
                                ++this.throwTime;
                                if (this.throwTime > 20) {
                                    this.target.m_5634_((float)foodProperties.m_38744_());
                                    this.target.m_5496_(SoundEvents.f_11912_, 1.0f, 0.5f);
                                    this.target.m_146852_(GameEvent.f_157806_, (Entity)this.target);
                                    this.throwTime = 0;
                                    itemStack.m_41774_(1);
                                    Level level = this.target.f_19853_;
                                    if (level instanceof ServerLevel) {
                                        ServerLevel serverLevel = (ServerLevel)level;
                                        for (int i = 0; i < 7; ++i) {
                                            double d0 = this.target.m_217043_().m_188583_() * 0.02;
                                            double d1 = this.target.m_217043_().m_188583_() * 0.02;
                                            double d2 = this.target.m_217043_().m_188583_() * 0.02;
                                            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.HEAL_EFFECT.get()), this.target.m_20208_(1.0), this.target.m_20187_() + 0.5, this.target.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                                        }
                                    }
                                }
                            } else {
                                this.illager.m_21573_().m_5624_((Entity)this.target, (double)0.6f);
                            }
                        } else {
                            this.m_8041_();
                        }
                    } else {
                        this.m_8041_();
                    }
                } else {
                    this.m_8041_();
                }
            } else {
                this.m_8041_();
            }
        }
    }

    public static class ThrowLootGoal
    extends ThrowItemGoal {
        public ThrowLootGoal(AbstractIllagerServant illager) {
            super(illager);
            this.predicate = this.illager::validLootToStore;
            this.targetPredicate = livingEntity -> illager.getTrueOwner() != null && livingEntity == illager.getTrueOwner();
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_();
        }

        @Override
        @Nullable
        public LivingEntity getThrowTarget() {
            return this.illager.getTrueOwner();
        }
    }

    public static enum IllagerServantArmPose {
        CROSSED,
        ATTACKING,
        SPELLCASTING,
        BOW_AND_ARROW,
        CROSSBOW_HOLD,
        CROSSBOW_CHARGE,
        CELEBRATING,
        NEUTRAL;

    }

    public static abstract class ThrowItemGoal
    extends Goal {
        public AbstractIllagerServant illager;
        public LivingEntity target;
        public Predicate<ItemStack> predicate = itemStack -> false;
        public Predicate<LivingEntity> targetPredicate = living -> false;
        public int throwTime;

        public ThrowItemGoal(AbstractIllagerServant illager) {
            this.illager = illager;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.illager.m_5448_() == null && this.illager.getMarked() == null && !this.illager.isCommanded() && !this.illager.isRaiding() && !this.illager.isCelebrating() && this.hasItem()) {
                this.target = this.getThrowTarget();
                if (this.target != null) {
                    if (this.illager.isStaying()) {
                        return this.illager.isWithinThrowingDistance((Entity)this.target) && this.illager.m_142582_((Entity)this.target);
                    }
                    return (double)this.target.m_20270_((Entity)this.illager) <= 8.0 && this.illager.m_142582_((Entity)this.target);
                }
            }
            return false;
        }

        public void m_8041_() {
            this.target = null;
            this.throwTime = 0;
        }

        public boolean isWithinThrowingDistance() {
            if (this.target == null) {
                return false;
            }
            return this.illager.isWithinThrowingDistance((Entity)this.target);
        }

        public void m_8037_() {
            LivingEntity livingEntity;
            if (this.target == null) {
                this.m_8041_();
            }
            this.illager.m_21563_().m_24960_((Entity)this.target, 10.0f, (float)this.illager.m_8132_());
            if (this.isWithinThrowingDistance()) {
                this.illager.m_21573_().m_26573_();
                ++this.throwTime;
                if (this.throwTime > 20) {
                    this.throwItem();
                    this.throwTime = 0;
                }
            } else {
                this.illager.m_21573_().m_5624_((Entity)this.target, (double)0.6f);
            }
            if ((livingEntity = this.target) instanceof Mob) {
                Mob mob = (Mob)livingEntity;
                mob.m_21563_().m_148051_((Entity)this.illager);
                mob.m_21573_().m_26573_();
            }
        }

        public void throwItem() {
            if (this.target == null) {
                this.m_8041_();
            }
            for (ItemStack itemstack : this.illager.itemsInInv(this.predicate)) {
                BehaviorUtils.m_22613_((LivingEntity)this.illager, (ItemStack)itemstack.m_278832_(), (Vec3)this.target.m_20182_());
            }
        }

        public boolean hasItem() {
            return !this.illager.itemsInInv(this.predicate).isEmpty();
        }

        @Nullable
        public LivingEntity getThrowTarget() {
            List list = this.illager.f_19853_.m_45976_(LivingEntity.class, this.illager.m_20191_().m_82400_(16.0));
            list.sort(Comparator.comparingDouble(arg_0 -> ((AbstractIllagerServant)this.illager).m_20280_(arg_0)));
            LivingEntity illagerServant = null;
            for (LivingEntity servant : list) {
                if (servant == this.illager || !this.targetPredicate.test(servant) || !this.illager.m_142582_((Entity)servant)) continue;
                illagerServant = servant;
            }
            return illagerServant;
        }

        public boolean m_183429_() {
            return true;
        }
    }
}

