/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.illager;

import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ai.AvoidTargetGoal;
import com.Polarice3.Goety.common.entities.ally.illager.AllyVex;
import com.Polarice3.Goety.common.entities.ally.illager.RaiderServant;
import com.Polarice3.Goety.common.entities.ally.illager.SpellcasterIllagerServant;
import com.Polarice3.Goety.common.entities.ally.undead.bound.BoundEvoker;
import com.Polarice3.Goety.common.entities.projectiles.Fangs;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.research.ResearchList;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.config.MobsConfig;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MiscCapHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.SEHelper;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;

public class EvokerServant
extends SpellcasterIllagerServant {
    @Nullable
    private Sheep wololoTarget;
    @Nullable
    private Mob ravageTarget;
    private int ravageCool;

    public EvokerServant(EntityType<? extends EvokerServant> p_32627_, Level p_32628_) {
        super(p_32627_, p_32628_);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new EvokerCastingSpellGoal());
        this.f_21345_.m_25352_(2, new AvoidTargetGoal<LivingEntity>(this, LivingEntity.class, 8.0f, 0.6, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new EvokerSummonSpellGoal());
        this.f_21345_.m_25352_(5, (Goal)new EvokerAttackSpellGoal());
        this.f_21345_.m_25352_(6, (Goal)new EvokerWololoSpellGoal());
        this.f_21345_.m_25352_(6, (Goal)new EvokerRavagingSpellGoal());
    }

    @Override
    public void miscGoal() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(8, new RaiderServant.RaiderWanderGoal<EvokerServant>(this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22277_, ((Double)AttributesConfig.EvokerServantFollowRange.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.EvokerServantArmor.get()).doubleValue()).m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.EvokerServantHealth.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.EvokerServantHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.EvokerServantArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22277_), (Double)AttributesConfig.EvokerServantFollowRange.get());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.ravageCool = compound.m_128451_("RavageCool");
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("RavageCool", this.ravageCool);
    }

    @Override
    public int xpReward() {
        return 10;
    }

    @Override
    public void m_6667_(DamageSource pCause) {
        BoundEvoker servant;
        if (!this.f_19853_.f_46443_ && this.getIdol() == null && this.getTrueOwner() != null && CuriosFinder.hasNamelessSet(this.getTrueOwner()) && (servant = (BoundEvoker)this.m_21406_((EntityType)ModEntityType.BOUND_EVOKER.get(), true)) != null) {
            servant.setTrueOwner(this.getTrueOwner());
            ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)servant);
            if (!this.m_20067_()) {
                this.f_19853_.m_5898_((Player)null, 1026, this.m_20183_(), 0);
            }
        }
        super.m_6667_(pCause);
    }

    @Override
    public SoundEvent getCelebrateSound() {
        return SoundEvents.f_11863_;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11861_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11864_;
    }

    protected SoundEvent m_7975_(DamageSource p_32654_) {
        return SoundEvents.f_11866_;
    }

    void setWololoTarget(@Nullable Sheep p_32635_) {
        this.wololoTarget = p_32635_;
    }

    @Nullable
    Sheep getWololoTarget() {
        return this.wololoTarget;
    }

    void setRavageTarget(@Nullable Mob p_32635_) {
        this.ravageTarget = p_32635_;
    }

    @Nullable
    Mob getRavageTarget() {
        return this.ravageTarget;
    }

    @Override
    public boolean validLootToStore(ItemStack itemStack) {
        return super.validLootToStore(itemStack) && !itemStack.m_150930_((Item)ModItems.OMINOUS_SADDLE.get());
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.ravageCool > 0) {
            --this.ravageCool;
        }
    }

    @Override
    protected SoundEvent getCastingSoundEvent() {
        return SoundEvents.f_11862_;
    }

    class EvokerCastingSpellGoal
    extends SpellcasterIllagerServant.SpellcasterCastingSpellGoal {
        EvokerCastingSpellGoal() {
            super(EvokerServant.this);
        }

        @Override
        public void m_8037_() {
            if (EvokerServant.this.m_5448_() != null) {
                EvokerServant.this.m_21563_().m_24960_((Entity)EvokerServant.this.m_5448_(), (float)EvokerServant.this.m_8085_(), (float)EvokerServant.this.m_8132_());
            } else if (EvokerServant.this.getWololoTarget() != null) {
                EvokerServant.this.m_21563_().m_24960_((Entity)EvokerServant.this.getWololoTarget(), (float)EvokerServant.this.m_8085_(), (float)EvokerServant.this.m_8132_());
            }
        }
    }

    class EvokerSummonSpellGoal
    extends SpellcasterIllagerServant.SpellcasterUseSpellGoal {
        private final TargetingConditions vexCountTargeting;

        EvokerSummonSpellGoal() {
            super(EvokerServant.this);
            this.vexCountTargeting = TargetingConditions.m_148353_().m_26883_(16.0).m_148355_().m_26893_();
        }

        @Override
        public boolean m_8036_() {
            if (!super.m_8036_()) {
                return false;
            }
            int i = EvokerServant.this.f_19853_.m_45971_(AllyVex.class, this.vexCountTargeting, (LivingEntity)EvokerServant.this, EvokerServant.this.m_20191_().m_82400_(16.0)).size();
            return EvokerServant.this.f_19796_.m_188503_(8) + 1 > i;
        }

        @Override
        protected int getCastingTime() {
            return 100;
        }

        @Override
        protected int getCastingInterval() {
            return 340;
        }

        @Override
        protected void performSpellCasting() {
            ServerLevel serverlevel = (ServerLevel)EvokerServant.this.f_19853_;
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos = EvokerServant.this.m_20183_().m_7918_(-2 + EvokerServant.this.f_19796_.m_188503_(5), 1, -2 + EvokerServant.this.f_19796_.m_188503_(5));
                AllyVex vex = (AllyVex)((EntityType)ModEntityType.ALLY_VEX.get()).m_20615_(EvokerServant.this.m_9236_());
                if (vex == null) continue;
                vex.m_20035_(blockpos, 0.0f, 0.0f);
                vex.m_6518_((ServerLevelAccessor)serverlevel, EvokerServant.this.f_19853_.m_6436_(blockpos), MobSpawnType.MOB_SUMMONED, null, null);
                vex.setTrueOwner((LivingEntity)EvokerServant.this);
                vex.setBoundOrigin(blockpos);
                vex.setLimitedLife(20 * (30 + EvokerServant.this.f_19796_.m_188503_(90)));
                serverlevel.m_47205_((Entity)vex);
            }
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11868_;
        }

        @Override
        protected SpellcasterIllagerServant.IllagerServantSpell getSpell() {
            return SpellcasterIllagerServant.IllagerServantSpell.SUMMON_VEX;
        }
    }

    class EvokerAttackSpellGoal
    extends SpellcasterIllagerServant.SpellcasterUseSpellGoal {
        EvokerAttackSpellGoal() {
            super(EvokerServant.this);
        }

        @Override
        public boolean m_8036_() {
            LivingEntity livingentity = EvokerServant.this.m_5448_();
            if (super.m_8036_() && livingentity != null) {
                if (livingentity.m_20270_((Entity)EvokerServant.this) <= 12.5f) {
                    return true;
                }
                EvokerServant.this.m_21573_().m_5624_((Entity)livingentity, 0.75);
            }
            return false;
        }

        @Override
        protected int getCastingTime() {
            return 40;
        }

        @Override
        protected int getCastingInterval() {
            return 100;
        }

        @Override
        protected void performSpellCasting() {
            LivingEntity livingentity = EvokerServant.this.m_5448_();
            if (livingentity == null) {
                return;
            }
            double d0 = Math.min(livingentity.m_20186_(), EvokerServant.this.m_20186_());
            double d1 = Math.max(livingentity.m_20186_(), EvokerServant.this.m_20186_()) + 1.0;
            float f = (float)Mth.m_14136_((double)(livingentity.m_20189_() - EvokerServant.this.m_20189_()), (double)(livingentity.m_20185_() - EvokerServant.this.m_20185_()));
            if (EvokerServant.this.m_20280_((Entity)livingentity) < 9.0) {
                for (int i = 0; i < 5; ++i) {
                    float f1 = f + (float)i * (float)Math.PI * 0.4f;
                    this.createSpellEntity(EvokerServant.this.m_20185_() + (double)Mth.m_14089_((float)f1) * 1.5, EvokerServant.this.m_20189_() + (double)Mth.m_14031_((float)f1) * 1.5, d0, d1, f1, 0);
                }
                for (int k = 0; k < 8; ++k) {
                    float f2 = f + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    this.createSpellEntity(EvokerServant.this.m_20185_() + (double)Mth.m_14089_((float)f2) * 2.5, EvokerServant.this.m_20189_() + (double)Mth.m_14031_((float)f2) * 2.5, d0, d1, f2, 3);
                }
            } else {
                for (int l = 0; l < 16; ++l) {
                    double d2 = 1.25 * (double)(l + 1);
                    this.createSpellEntity(EvokerServant.this.m_20185_() + (double)Mth.m_14089_((float)f) * d2, EvokerServant.this.m_20189_() + (double)Mth.m_14031_((float)f) * d2, d0, d1, f, l);
                }
            }
        }

        private void createSpellEntity(double p_32673_, double p_32674_, double p_32675_, double p_32676_, float p_32677_, int p_32678_) {
            BlockPos blockpos = BlockPos.m_274561_((double)p_32673_, (double)p_32676_, (double)p_32674_);
            boolean flag = false;
            double d0 = 0.0;
            do {
                BlockState blockstate1;
                VoxelShape voxelshape;
                BlockPos blockpos1;
                BlockState blockstate;
                if (!(blockstate = EvokerServant.this.f_19853_.m_8055_(blockpos1 = blockpos.m_7495_())).m_60783_((BlockGetter)EvokerServant.this.f_19853_, blockpos1, Direction.UP)) continue;
                if (!EvokerServant.this.f_19853_.m_46859_(blockpos) && !(voxelshape = (blockstate1 = EvokerServant.this.f_19853_.m_8055_(blockpos)).m_60812_((BlockGetter)EvokerServant.this.f_19853_, blockpos)).m_83281_()) {
                    d0 = voxelshape.m_83297_(Direction.Axis.Y);
                }
                flag = true;
                break;
            } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)p_32675_) - 1);
            if (flag) {
                EvokerServant.this.f_19853_.m_7967_((Entity)new Fangs(EvokerServant.this.f_19853_, p_32673_, (double)blockpos.m_123342_() + d0, p_32674_, p_32677_, p_32678_, (LivingEntity)EvokerServant.this));
            }
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11867_;
        }

        @Override
        protected SpellcasterIllagerServant.IllagerServantSpell getSpell() {
            return SpellcasterIllagerServant.IllagerServantSpell.FANGS;
        }
    }

    public class EvokerWololoSpellGoal
    extends SpellcasterIllagerServant.SpellcasterUseSpellGoal {
        private final TargetingConditions wololoTargeting;

        public EvokerWololoSpellGoal() {
            super(EvokerServant.this);
            this.wololoTargeting = TargetingConditions.m_148353_().m_26883_(16.0).m_26888_(p_32710_ -> ((Sheep)p_32710_).m_29874_() == DyeColor.BLUE);
        }

        @Override
        public boolean m_8036_() {
            if (EvokerServant.this.m_5448_() != null) {
                return false;
            }
            if (EvokerServant.this.isCastingSpell()) {
                return false;
            }
            if (EvokerServant.this.f_19797_ < this.nextAttackTickCount) {
                return false;
            }
            if (!ForgeEventFactory.getMobGriefingEvent((Level)EvokerServant.this.f_19853_, (Entity)EvokerServant.this)) {
                return false;
            }
            List list = EvokerServant.this.f_19853_.m_45971_(Sheep.class, this.wololoTargeting, (LivingEntity)EvokerServant.this, EvokerServant.this.m_20191_().m_82377_(16.0, 4.0, 16.0));
            if (list.isEmpty()) {
                return false;
            }
            EvokerServant.this.setWololoTarget((Sheep)list.get(EvokerServant.this.f_19796_.m_188503_(list.size())));
            return true;
        }

        @Override
        public boolean m_8045_() {
            return EvokerServant.this.getWololoTarget() != null && this.attackWarmupDelay > 0;
        }

        public void m_8041_() {
            super.m_8041_();
            EvokerServant.this.setWololoTarget(null);
        }

        @Override
        protected void performSpellCasting() {
            Sheep sheep = EvokerServant.this.getWololoTarget();
            if (sheep != null && sheep.m_6084_()) {
                sheep.m_29855_(DyeColor.RED);
            }
        }

        @Override
        protected int getCastWarmupTime() {
            return 40;
        }

        @Override
        protected int getCastingTime() {
            return 60;
        }

        @Override
        protected int getCastingInterval() {
            return 140;
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11869_;
        }

        @Override
        protected SpellcasterIllagerServant.IllagerServantSpell getSpell() {
            return SpellcasterIllagerServant.IllagerServantSpell.WOLOLO;
        }
    }

    public class EvokerRavagingSpellGoal
    extends SpellcasterIllagerServant.SpellcasterUseSpellGoal {
        private final TargetingConditions ravageTargeting;

        public EvokerRavagingSpellGoal() {
            super(EvokerServant.this);
            this.ravageTargeting = TargetingConditions.m_148353_().m_26883_(16.0).m_26888_(p_32710_ -> p_32710_.m_6095_().m_204039_(ModTags.EntityTypes.VILLAGERS));
        }

        @Override
        public boolean m_8036_() {
            if (!EvokerServant.this.isLeader()) {
                return false;
            }
            if (EvokerServant.this.m_5448_() != null) {
                return false;
            }
            if (EvokerServant.this.isCastingSpell()) {
                return false;
            }
            if (EvokerServant.this.f_19797_ < this.nextAttackTickCount) {
                return false;
            }
            if (EvokerServant.this.ravageCool > 0) {
                return false;
            }
            if (EvokerServant.this.getNearbyCompanions().isEmpty()) {
                return false;
            }
            if (this.otherEvokers().size() < 2) {
                return false;
            }
            LivingEntity livingEntity = EvokerServant.this.getTrueOwner();
            if (livingEntity instanceof Player) {
                Villager villager;
                Player player = (Player)livingEntity;
                if (!SEHelper.hasResearch(player, ResearchList.RAVAGING)) {
                    return false;
                }
                if (SEHelper.getGrudgeEntityTypes(player).contains(EntityType.f_20492_)) {
                    List list = EvokerServant.this.f_19853_.m_45971_(Mob.class, this.ravageTargeting, (LivingEntity)EvokerServant.this, EvokerServant.this.m_20191_().m_82377_(16.0, 4.0, 16.0));
                    if (list.isEmpty()) {
                        return false;
                    }
                    EvokerServant.this.setRavageTarget((Mob)list.get(EvokerServant.this.f_19796_.m_188503_(list.size())));
                    return true;
                }
                LivingEntity livingEntity2 = EvokerServant.this.getCommandPosEntity();
                if (livingEntity2 instanceof Villager && (double)(villager = (Villager)livingEntity2).m_20270_((Entity)EvokerServant.this) <= 16.0) {
                    EvokerServant.this.setRavageTarget((Mob)villager);
                    return true;
                }
                return false;
            }
            return false;
        }

        @Override
        public boolean m_8045_() {
            return EvokerServant.this.getRavageTarget() != null && EvokerServant.this.getRavageTarget().m_6084_() && this.otherEvokers().size() >= 2 && EvokerServant.this.m_5448_() == null && this.attackWarmupDelay > 0;
        }

        @Override
        public void m_8037_() {
            super.m_8037_();
            Mob victim = EvokerServant.this.getRavageTarget();
            if (victim != null && victim.m_6084_()) {
                Level level;
                MobUtil.instaLook((Mob)EvokerServant.this, (Entity)victim);
                MiscCapHelper.setShakeTime((LivingEntity)victim, 20);
                victim.m_6703_((LivingEntity)EvokerServant.this);
                victim.m_21573_().m_26573_();
                victim.m_21566_().m_24988_(0.0f, 0.0f);
                if (victim.f_19797_ % 20 == 0 && (level = victim.f_19853_) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    ServerParticleUtil.addParticlesAroundSelf(serverLevel, (ParticleOptions)ParticleTypes.f_123809_, (Entity)victim);
                }
                Vec3 offset = new Vec3(2.0, 0.0, 0.0);
                Vec3 at = this.groundOf(victim.m_20182_().m_82549_(offset));
                EvokerServant.this.m_21573_().m_26519_(at.f_82479_, at.f_82480_, at.f_82481_, 0.75);
                for (int i = 0; i < this.otherEvokers().size(); ++i) {
                    EvokerServant evokerServant = this.otherEvokers().get(i);
                    float f = (float)(i + 1) / (float)(this.otherEvokers().size() + 1);
                    Vec3 offset2 = new Vec3(2.0, 0.0, 0.0).m_82524_(f * ((float)Math.PI * 2));
                    Vec3 at2 = this.groundOf(victim.m_20182_().m_82549_(offset2));
                    evokerServant.m_21573_().m_26519_(at2.f_82479_, at2.f_82480_, at2.f_82481_, 0.75);
                    MobUtil.instaLook((Mob)evokerServant, (Entity)victim);
                    evokerServant.setIsCastingSpell(SpellcasterIllagerServant.IllagerServantSpell.RAVAGING);
                    evokerServant.spellCastingTickCount = 20;
                }
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.attackWarmupDelay = 0;
            EvokerServant.this.spellCastingTickCount = 0;
            EvokerServant.this.setIsCastingSpell(SpellcasterIllagerServant.IllagerServantSpell.NONE);
            EvokerServant.this.setRavageTarget(null);
        }

        private Vec3 groundOf(Vec3 in) {
            BlockPos origin = BlockPos.m_274446_((Position)in);
            BlockPos.MutableBlockPos blockPos = origin.m_122032_();
            while (!EvokerServant.this.f_19853_.m_46859_((BlockPos)blockPos) && blockPos.m_123342_() < EvokerServant.this.f_19853_.m_151558_()) {
                blockPos.m_122184_(0, 1, 0);
            }
            while (EvokerServant.this.f_19853_.m_46859_(blockPos.m_7495_()) && blockPos.m_123342_() > EvokerServant.this.f_19853_.m_141937_()) {
                blockPos.m_122184_(0, -1, 0);
            }
            return new Vec3(in.f_82479_, (double)blockPos.m_123342_(), in.f_82481_);
        }

        @Override
        protected void performSpellCasting() {
            Mob victim = EvokerServant.this.getRavageTarget();
            if (victim != null && victim.m_6084_()) {
                Entity entity;
                Player player = null;
                LivingEntity livingEntity = EvokerServant.this.getTrueOwner();
                if (livingEntity instanceof Player) {
                    Player player1;
                    player = player1 = (Player)livingEntity;
                }
                if ((entity = MobUtil.convertTo((Entity)victim, (EntityType)ModEntityType.RAVAGED.get(), true, player)) instanceof Mob) {
                    Mob mob = (Mob)entity;
                    mob.m_5616_(victim.m_6080_());
                    mob.m_146922_(victim.m_146908_());
                    mob.m_21373_();
                }
                EvokerServant.this.ravageCool = MathHelper.secondsToTicks((Integer)MobsConfig.EvokerServantRavagedCooldown.get());
                for (EvokerServant evokerServant : this.otherEvokers()) {
                    evokerServant.ravageCool = MathHelper.secondsToTicks((Integer)MobsConfig.EvokerServantRavagedCooldown.get());
                }
            }
        }

        public List<EvokerServant> otherEvokers() {
            ArrayList<EvokerServant> servants = new ArrayList<EvokerServant>();
            for (RaiderServant raider : EvokerServant.this.getNearbyCompanions()) {
                if (!(raider instanceof EvokerServant)) continue;
                EvokerServant evokerServant = (EvokerServant)raider;
                if (evokerServant.ravageCool > 0 || evokerServant.m_5448_() != null || evokerServant.isCastingSpell() && evokerServant.getCurrentSpell() != SpellcasterIllagerServant.IllagerServantSpell.RAVAGING) continue;
                servants.add(evokerServant);
            }
            return servants;
        }

        public boolean m_183429_() {
            return true;
        }

        @Override
        protected int getCastWarmupTime() {
            return MathHelper.secondsToTicks(30);
        }

        @Override
        protected int getCastingTime() {
            return MathHelper.secondsToTicks(31);
        }

        @Override
        protected int getCastingInterval() {
            return 140;
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11869_;
        }

        @Override
        protected SpellcasterIllagerServant.IllagerServantSpell getSpell() {
            return SpellcasterIllagerServant.IllagerServantSpell.RAVAGING;
        }
    }
}

