/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.undead.bound;

import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ai.AvoidTargetGoal;
import com.Polarice3.Goety.common.entities.ally.illager.RaiderServant;
import com.Polarice3.Goety.common.entities.ally.undead.bound.AbstractBoundIllager;
import com.Polarice3.Goety.common.entities.neutral.AbstractMonolith;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class BoundGeomancer
extends AbstractBoundIllager {
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(BoundGeomancer.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int spellCool;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState walkAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();

    public BoundGeomancer(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, new AvoidTargetGoal<LivingEntity>(this, LivingEntity.class, 8.0f, 1.0, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new GeomancyGoal(this));
    }

    @Override
    public void miscGoal() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(8, new RaiderServant.RaiderWanderGoal<BoundGeomancer>(this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22280_, 0.15).m_22268_(Attributes.f_22277_, ((Double)AttributesConfig.GeomancerServantFollowRange.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.GeomancerServantArmor.get()).doubleValue()).m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.GeomancerServantHealth.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.GeomancerServantHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.GeomancerServantArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22277_), (Double)AttributesConfig.GeomancerServantFollowRange.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIM_STATE, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("SpellCool", this.spellCool);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("SpellCool")) {
            this.spellCool = compound.m_128451_("SpellCool");
        }
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "idle")) {
            return 1;
        }
        if (Objects.equals(animation, "attack")) {
            return 2;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.idleAnimationState);
        list.add(this.attackAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public int getCurrentAnimation() {
        return (Integer)this.f_19804_.m_135370_(ANIM_STATE);
    }

    public void m_7350_(EntityDataAccessor<?> accessor) {
        if (ANIM_STATE.equals(accessor) && this.f_19853_.f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    break;
                }
                case 1: {
                    this.idleAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.idleAnimationState);
                    break;
                }
                case 2: {
                    this.attackAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.attackAnimationState);
                }
            }
        }
    }

    public boolean isAttacking() {
        return this.getCurrentAnimation() == this.getAnimationState("attack");
    }

    @Override
    public int xpReward() {
        return 10;
    }

    @Override
    public SoundEvent getCelebrateSound() {
        return (SoundEvent)ModSounds.GEOMANCER_AMBIENT.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.GEOMANCER_ATTACK.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.GEOMANCER_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource p_32654_) {
        return (SoundEvent)ModSounds.GEOMANCER_HURT.get();
    }

    public float m_6100_() {
        return 0.45f;
    }

    @Override
    public void m_8119_() {
        if (this.f_19853_.m_5776_()) {
            this.idleAnimationState.m_246184_(this.getCurrentAnimation() != this.getAnimationState("attack") && !this.f_267362_.m_267780_(), this.f_19797_);
            for (int i = 0; i < 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123796_, this.m_20208_(0.5), this.m_20186_() + 0.5, this.m_20262_(0.5), (0.5 - this.f_19796_.m_188500_()) * 0.15, (double)0.01f, (0.5 - this.f_19796_.m_188500_()) * 0.15);
            }
        }
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && this.spellCool > 0) {
            --this.spellCool;
        }
    }

    @Override
    protected SoundEvent getCastingSoundEvent() {
        return null;
    }

    public static class GeomancyGoal
    extends Goal {
        public BoundGeomancer geomancer;
        public int spellTick;

        public GeomancyGoal(BoundGeomancer geomancer) {
            this.geomancer = geomancer;
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (this.geomancer.m_5448_() != null && (double)this.geomancer.m_20270_((Entity)this.geomancer.m_5448_()) <= this.geomancer.m_21133_(Attributes.f_22277_)) {
                return this.geomancer.spellCool <= 0;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.geomancer.m_5448_() != null && this.spellTick < 39;
        }

        public void m_8056_() {
            super.m_8056_();
            this.spellTick = 0;
            this.geomancer.m_5496_((SoundEvent)ModSounds.GEOMANCER_PRE_ATTACK.get(), 0.55f, 0.8f);
            this.geomancer.m_21573_().m_26573_();
            this.geomancer.setAnimationState("attack");
        }

        public void m_8041_() {
            super.m_8041_();
            this.spellTick = 0;
            this.geomancer.setAnimationState("idle");
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity target = this.geomancer.m_5448_();
            if (target != null) {
                MobUtil.instaLook((Mob)this.geomancer, (Entity)target);
                this.geomancer.m_21573_().m_26573_();
                ++this.spellTick;
                if (this.spellTick == 13) {
                    this.geomancer.m_5496_((SoundEvent)ModSounds.GEOMANCER_ATTACK.get(), 0.55f, 0.8f);
                    int trueCooldown = MathHelper.secondsToTicks(3);
                    float chance = 0.25f;
                    if (this.geomancer.f_19796_.m_188499_()) {
                        if (this.geomancer.f_19796_.m_188501_() <= chance) {
                            WandUtil.summonQuadOffensiveTrap((LivingEntity)this.geomancer, (Entity)target, (EntityType<? extends AbstractMonolith>)((EntityType)ModEntityType.TOTEMIC_BOMB.get()), 0);
                            trueCooldown += MathHelper.secondsToTicks(3);
                        } else {
                            int xShift = this.geomancer.m_217043_().m_216339_(-1, 1);
                            int zShift = this.geomancer.m_217043_().m_216339_(-1, 1);
                            WandUtil.summonMonolith((LivingEntity)this.geomancer, (Entity)target, (EntityType<? extends AbstractMonolith>)((EntityType)ModEntityType.TOTEMIC_BOMB.get()), (double)xShift, (double)zShift, 0);
                            trueCooldown += MathHelper.secondsToTicks(2);
                        }
                    } else {
                        int random = this.geomancer.f_19796_.m_188503_(3);
                        if (random == 0) {
                            int[] rowToRemove = (int[])Util.m_214670_((Object[])WandUtil.CONFIG_1_ROWS, (RandomSource)this.geomancer.m_217043_());
                            Direction direction = Direction.m_122364_((double)target.m_6080_());
                            switch (direction) {
                                case NORTH: {
                                    rowToRemove = WandUtil.CONFIG_1_NORTH_ROW;
                                    break;
                                }
                                case SOUTH: {
                                    rowToRemove = WandUtil.CONFIG_1_SOUTH_ROW;
                                    break;
                                }
                                case WEST: {
                                    rowToRemove = WandUtil.CONFIG_1_WEST_ROW;
                                    break;
                                }
                                case EAST: {
                                    rowToRemove = WandUtil.CONFIG_1_EAST_ROW;
                                }
                            }
                            WandUtil.summonSquareTrap((LivingEntity)this.geomancer, (Entity)target, (EntityType<? extends AbstractMonolith>)((EntityType)ModEntityType.TOTEMIC_WALL.get()), rowToRemove, 0);
                        } else if (random == 1) {
                            WandUtil.summonWallTrap((LivingEntity)this.geomancer, (Entity)target, (EntityType<? extends AbstractMonolith>)((EntityType)ModEntityType.TOTEMIC_WALL.get()), 0);
                        } else {
                            WandUtil.summonRandomPillarsTrap((LivingEntity)this.geomancer, (Entity)target, (EntityType<? extends AbstractMonolith>)((EntityType)ModEntityType.TOTEMIC_WALL.get()), 0);
                        }
                    }
                    this.geomancer.spellCool = trueCooldown;
                }
            }
        }
    }
}

