/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.undead.skeleton;

import com.Polarice3.Goety.api.items.magic.IWand;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ai.CreatureBowAttackGoal;
import com.Polarice3.Goety.common.entities.ai.ModMeleeAttackGoal;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.projectiles.GhostArrow;
import com.Polarice3.Goety.common.research.ResearchList;
import com.Polarice3.Goety.compat.serene_seasons.SSeasonsIntegration;
import com.Polarice3.Goety.compat.serene_seasons.SSeasonsLoaded;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.ItemHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.SEHelper;
import com.Polarice3.Goety.utils.ServantUtil;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.common.Tags;

public abstract class AbstractSkeletonServant
extends Summoned
implements RangedAttackMob {
    private final CreatureBowAttackGoal<AbstractSkeletonServant> bowGoal = new CreatureBowAttackGoal<AbstractSkeletonServant>(this, 1.0, 20, 15.0f);
    public final ModMeleeAttackGoal meleeGoal = new ModMeleeAttackGoal(this, 1.2, false){

        @Override
        public void m_8041_() {
            super.m_8041_();
            AbstractSkeletonServant.this.m_21561_(false);
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            AbstractSkeletonServant.this.m_21561_(true);
        }
    };
    public double arrowPower = 0.0;

    public AbstractSkeletonServant(EntityType<? extends Summoned> type, Level worldIn) {
        super(type, worldIn);
        this.reassessWeaponGoal();
    }

    @Override
    protected boolean isSunSensitive() {
        return true;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.addBehaviourGoals();
    }

    protected void addBehaviourGoals() {
        this.f_21345_.m_25352_(8, new Summoned.WanderGoal<AbstractSkeletonServant>(this, 1.0, 10.0f));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.SkeletonServantHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.SkeletonServantArmor.get()).doubleValue()).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.SkeletonServantDamage.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.SkeletonServantHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.SkeletonServantArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.SkeletonServantDamage.get());
    }

    public double getBaseRangeDamage() {
        return (Double)AttributesConfig.SkeletonServantRangeDamage.get();
    }

    public void reassessWeaponGoal() {
        if (!this.f_19853_.f_46443_) {
            this.f_21345_.m_25363_((Goal)this.meleeGoal);
            this.f_21345_.m_25363_(this.bowGoal);
            ItemStack itemstack = this.m_21205_();
            ItemStack itemstack2 = this.m_21206_();
            if (itemstack.m_41720_() instanceof BowItem || itemstack2.m_41720_() instanceof BowItem) {
                int i = 20;
                if (!this.isUpgraded()) {
                    i = 40;
                }
                this.bowGoal.setMinAttackInterval(i);
                this.f_21345_.m_25352_(4, this.bowGoal);
            } else {
                this.f_21345_.m_25352_(4, (Goal)this.meleeGoal);
            }
        }
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.arrowPower = pCompound.m_128451_("arrowPower");
        this.reassessWeaponGoal();
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (pCompound.m_128441_("arrowPower")) {
            pCompound.m_128347_("arrowPower", this.arrowPower);
        }
    }

    @Override
    public Predicate<Entity> summonPredicate() {
        return entity -> entity instanceof AbstractSkeletonServant;
    }

    @Override
    public int getSummonLimit(LivingEntity owner) {
        return (Integer)SpellConfig.SkeletonLimit.get();
    }

    public void m_8061_(EquipmentSlot pSlot, ItemStack pStack) {
        super.m_8061_(pSlot, pStack);
        if (!this.f_19853_.f_46443_) {
            this.reassessWeaponGoal();
        }
    }

    public void m_6083_() {
        super.m_6083_();
        if (this.m_20202_() instanceof PathfinderMob) {
            PathfinderMob pathfindermob = (PathfinderMob)this.m_20202_();
            this.f_20883_ = pathfindermob.f_20883_;
        }
    }

    protected abstract SoundEvent getStepSound();

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    @Override
    protected void m_213945_(RandomSource randomSource, DifficultyInstance difficulty) {
        super.m_213945_(randomSource, difficulty);
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
    }

    public double getArrowPower() {
        return this.arrowPower;
    }

    public void setArrowPower(int arrowPower) {
        this.arrowPower += (double)arrowPower;
    }

    @Override
    public EntityType<?> getVariant(@Nullable Player player, Level level, BlockPos blockPos) {
        EntityType entityType = (EntityType)ModEntityType.SKELETON_SERVANT.get();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (level.m_204166_(blockPos).m_203656_(Tags.Biomes.IS_COLD_OVERWORLD) && level.m_45527_(blockPos)) {
                entityType = (EntityType)ModEntityType.STRAY_SERVANT.get();
            } else if (BlockFinder.findStructure(serverLevel, blockPos, (ResourceKey<Structure>)BuiltinStructures.f_209845_)) {
                entityType = (EntityType)ModEntityType.SKELETON_PILLAGER_SERVANT.get();
            } else if (player != null && BlockFinder.findStructure(serverLevel, blockPos, ModTags.Structures.CAN_SUMMON_WITHER_SKELETONS) && SEHelper.hasResearch(player, ResearchList.BYGONE)) {
                entityType = (EntityType)ModEntityType.WITHER_SKELETON_SERVANT.get();
            } else if (level.m_204166_(blockPos).m_203656_(BiomeTags.f_207610_) && level.f_46441_.m_188499_()) {
                entityType = (EntityType)ModEntityType.MOSSY_SKELETON_SERVANT.get();
            } else if (level.m_46801_(blockPos)) {
                entityType = (EntityType)ModEntityType.SUNKEN_SKELETON_SERVANT.get();
            }
            if (SSeasonsLoaded.SERENE_SEASONS.isLoaded() && SSeasonsIntegration.summonSnowVariant(level, blockPos)) {
                entityType = (EntityType)ModEntityType.STRAY_SERVANT.get();
            }
        }
        return entityType;
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.reassessWeaponGoal();
        this.m_213945_(worldIn.m_213780_(), difficultyIn);
        this.m_213946_(worldIn.m_213780_(), difficultyIn);
        if (this.isNatural()) {
            this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Wolf.class, 6.0f, 1.0, 1.2));
        }
        if (this.m_6844_(EquipmentSlot.HEAD).m_41619_()) {
            LocalDate localdate = LocalDate.now();
            int i = localdate.get(ChronoField.DAY_OF_MONTH);
            int j = localdate.get(ChronoField.MONTH_OF_YEAR);
            if (j == 10 && i == 31 && this.f_19796_.m_188501_() < 0.25f) {
                this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)(this.f_19796_.m_188501_() < 0.1f ? Blocks.f_50144_ : Blocks.f_50143_)));
                this.f_21348_[EquipmentSlot.HEAD.m_20749_()] = 0.0f;
            }
        }
        return spawnDataIn;
    }

    public SoundEvent getShootSound() {
        return SoundEvents.f_12382_;
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        ItemStack itemstack = this.m_6298_(this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
        AbstractArrow abstractarrowentity = this.getMobArrow(itemstack, distanceFactor);
        if (this.m_21205_().m_41720_() instanceof BowItem) {
            abstractarrowentity = ((BowItem)this.m_21205_().m_41720_()).customArrow(abstractarrowentity);
            ItemHelper.hurtAndBreak(this.m_21205_(), 1, this);
        }
        abstractarrowentity.m_36781_(abstractarrowentity.m_36789_() + this.getArrowPower() + this.getBaseRangeDamage());
        double d0 = target.m_20185_() - this.m_20185_();
        double d1 = target.m_20227_(0.3333333333333333) - abstractarrowentity.m_20186_();
        double d2 = target.m_20189_() - this.m_20189_();
        double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
        abstractarrowentity.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.f_19853_.m_46791_().m_19028_() * 4));
        if (this.getShootSound() != null) {
            this.m_5496_(this.getShootSound(), 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        }
        this.f_19853_.m_7967_((Entity)abstractarrowentity);
    }

    protected AbstractArrow getMobArrow(ItemStack arrowStack, float distanceFactor) {
        AbstractArrow abstractarrowentity = ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)arrowStack, (float)distanceFactor);
        if (this.isUpgraded()) {
            abstractarrowentity = AbstractSkeletonServant.getGhostArrow((LivingEntity)this, arrowStack, distanceFactor);
        }
        return abstractarrowentity;
    }

    public static AbstractArrow getGhostArrow(LivingEntity living, ItemStack stack, float distanceFactor) {
        GhostArrow arrow = new GhostArrow(living.m_9236_(), living);
        arrow.m_36745_(living, distanceFactor);
        arrow.m_36878_(stack);
        return arrow;
    }

    public boolean m_5886_(ProjectileWeaponItem p_230280_1_) {
        return p_230280_1_ == Items.f_42411_;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 1.74f;
    }

    public double m_6049_() {
        return -0.6;
    }

    public boolean isShaking() {
        return this.m_146890_();
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        Item item = itemstack.m_41720_();
        ItemStack itemstack2 = this.m_21205_();
        if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner()) {
            if (item == Items.f_42500_ && this.m_21223_() < this.m_21233_()) {
                if (!pPlayer.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_5496_(SoundEvents.f_12383_, 1.0f, 1.25f);
                this.m_5634_(2.0f);
                Level level = this.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    for (int i = 0; i < 7; ++i) {
                        double d0 = this.f_19796_.m_188583_() * 0.02;
                        double d1 = this.f_19796_.m_188583_() * 0.02;
                        double d2 = this.f_19796_.m_188583_() * 0.02;
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.HEAL_EFFECT.get()), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                    }
                }
                return InteractionResult.SUCCESS;
            }
            if (!(pPlayer.m_21206_().m_41720_() instanceof IWand)) {
                if (item instanceof SwordItem) {
                    this.m_5496_(SoundEvents.f_11675_, 1.0f, 1.0f);
                    this.m_8061_(EquipmentSlot.MAINHAND, itemstack.m_255036_(1));
                    this.dropEquipment(EquipmentSlot.MAINHAND, itemstack2);
                    this.m_21508_(EquipmentSlot.MAINHAND);
                    for (int i = 0; i < 7; ++i) {
                        double d0 = this.f_19796_.m_188583_() * 0.02;
                        double d1 = this.f_19796_.m_188583_() * 0.02;
                        double d2 = this.f_19796_.m_188583_() * 0.02;
                        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
                    }
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (item instanceof BowItem) {
                    this.m_5496_(SoundEvents.f_11675_, 1.0f, 1.0f);
                    this.m_8061_(EquipmentSlot.MAINHAND, itemstack.m_255036_(1));
                    this.dropEquipment(EquipmentSlot.MAINHAND, itemstack2);
                    this.m_21508_(EquipmentSlot.MAINHAND);
                    for (int i = 0; i < 7; ++i) {
                        double d0 = this.f_19796_.m_188583_() * 0.02;
                        double d1 = this.f_19796_.m_188583_() * 0.02;
                        double d2 = this.f_19796_.m_188583_() * 0.02;
                        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
                    }
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (this instanceof CrossbowAttackMob && item instanceof CrossbowItem) {
                    this.m_5496_(SoundEvents.f_11675_, 1.0f, 1.0f);
                    this.m_8061_(EquipmentSlot.MAINHAND, itemstack.m_255036_(1));
                    this.dropEquipment(EquipmentSlot.MAINHAND, itemstack2);
                    this.m_21508_(EquipmentSlot.MAINHAND);
                    for (int i = 0; i < 7; ++i) {
                        double d0 = this.f_19796_.m_188583_() * 0.02;
                        double d1 = this.f_19796_.m_188583_() * 0.02;
                        double d2 = this.f_19796_.m_188583_() * 0.02;
                        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
                    }
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
            }
            return ServantUtil.equipServantArmor(pPlayer, this, itemstack, super.m_6071_(pPlayer, pHand));
        }
        return super.m_6071_(pPlayer, pHand);
    }
}

