/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.hostile.ender;

import com.Polarice3.Goety.client.particles.CircleExplodeParticleOption;
import com.Polarice3.Goety.client.particles.MagicSmokeParticle;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.client.particles.VerticalCircleExplodeParticleOption;
import com.Polarice3.Goety.common.blocks.entities.VoidFrameBlockEntity;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.ally.ender.WatchlingServant;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.entities.neutral.ender.AbstractEnderling;
import com.Polarice3.Goety.common.entities.util.CameraShake;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.ModServerBossInfo;
import com.Polarice3.Goety.common.network.server.SInstaLookPacket;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.config.MainConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MiscCapHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.ParticleUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;

public class Endersent
extends AbstractEnderling
implements Enemy {
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(Endersent.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> EYE_TYPE = SynchedEntityData.m_135353_(Endersent.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(Endersent.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UUID TELEPORT_ATTACK_MODIFIER_UUID = UUID.fromString("0134e91f-a8c4-4d38-94d6-7201dae924b7");
    private static final AttributeModifier TELEPORT_ATTACK_MODIFIER = new AttributeModifier(TELEPORT_ATTACK_MODIFIER_UUID, "Teleport Attack Bonus", 1.15, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private static final UUID DE_ATTACK_MODIFIER_UUID = UUID.fromString("b9788c05-ee1b-4c1d-9701-f681c5d89fd1");
    private static final AttributeModifier DE_ATTACK_MODIFIER = new AttributeModifier(DE_ATTACK_MODIFIER_UUID, "Deadly Escape Attack Bonus", 1.85, AttributeModifier.Operation.MULTIPLY_TOTAL);
    public static String IDLE = "idle";
    public static String ATTACK = "attack";
    public static String SWIPE = "swipe";
    public static String DEADLY_ESCAPE = "deadly_escape";
    public static String TELEPORT_IN = "teleport_in";
    public static String TELEPORT_OUT = "teleport_out";
    public static String DEATH = "death";
    public static int SEARING_EYE = 1;
    public static int HALLOWED_EYE = 2;
    public static int TWISTED_EYE = 3;
    public static int DREADFUL_EYE = 4;
    @Nullable
    private BlockPos voidFrame;
    public int idleTime = 0;
    public int teleportHideTime = MathHelper.secondsToTicks(5);
    public int deadlyEscapeCool = 0;
    public int projectileHit = 0;
    public int meleeHit = 0;
    public int recentHitTime = 0;
    public int attackTick;
    public int deathTime = 0;
    private final ModServerBossInfo bossInfo;
    public DamageSource deathBlow = this.m_269291_().m_269264_();
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState swipeAnimationState = new AnimationState();
    public AnimationState deadlyEscapeAnimationState = new AnimationState();
    public AnimationState teleportInAnimationState = new AnimationState();
    public AnimationState teleportOutAnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();

    public Endersent(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
        this.bossInfo = new ModServerBossInfo((Mob)this, BossEvent.BossBarColor.PURPLE, false, false);
        this.setHostile(true);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(4, (Goal)new AttackGoal(1.0));
        this.f_21345_.m_25352_(5, (Goal)new Summoned.WanderGoal<Endersent>(this, 1.0){

            @Override
            @Nullable
            protected Vec3 m_7037_() {
                BlockEntity blockEntity = Endersent.this.getVoidFrame();
                if (blockEntity instanceof VoidFrameBlockEntity) {
                    VoidFrameBlockEntity voidFrameBlock = (VoidFrameBlockEntity)blockEntity;
                    Vec3 vec3 = null;
                    int range = 16;
                    for (int i = 0; i < 10; ++i) {
                        BlockPos blockPos = voidFrameBlock.m_58899_().m_7918_(((Endersent)this.summonedEntity).m_217043_().m_216332_(-range, range), ((Endersent)this.summonedEntity).m_217043_().m_216332_(-range, range), ((Endersent)this.summonedEntity).m_217043_().m_216332_(-range, range));
                        BlockPos blockPos1 = LandRandomPos.m_148518_((PathfinderMob)this.summonedEntity, (BlockPos)blockPos);
                        if (blockPos1 == null) continue;
                        vec3 = Vec3.m_82539_((Vec3i)blockPos1);
                        break;
                    }
                    return vec3;
                }
                return super.m_7037_();
            }
        });
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.EndersentHealth.get()).doubleValue()).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.EndersentDamage.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.EndersentArmor.get()).doubleValue()).m_22268_(Attributes.f_22278_, 1.0).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0).m_22268_(Attributes.f_22282_, 2.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    @Override
    public void setConfigurableAttributes() {
        if (!this.hasEye()) {
            MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.EndersentHealth.get());
        }
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.EndersentArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.EndersentDamage.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(EYE_TYPE, (Object)0);
        this.f_19804_.m_135372_(ANIM_STATE, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.voidFrame != null) {
            compound.m_128405_("FrameX", this.voidFrame.m_123341_());
            compound.m_128405_("FrameY", this.voidFrame.m_123342_());
            compound.m_128405_("FrameZ", this.voidFrame.m_123343_());
        }
        compound.m_128405_("DeadlyEscapeCool", this.deadlyEscapeCool);
        compound.m_128405_("ProjectileHit", this.projectileHit);
        compound.m_128405_("MeleeHit", this.meleeHit);
        compound.m_128405_("RecentlyHit", this.recentHitTime);
        compound.m_128405_("EyeType", this.getEyeType());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("FrameX")) {
            this.voidFrame = new BlockPos(compound.m_128451_("FrameX"), compound.m_128451_("FrameY"), compound.m_128451_("FrameZ"));
        }
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
        if (compound.m_128441_("DeadlyEscapeCool")) {
            this.deadlyEscapeCool = compound.m_128451_("DeadlyEscapeCool");
        }
        if (compound.m_128441_("ProjectileHit")) {
            this.projectileHit = compound.m_128451_("ProjectileHit");
        }
        if (compound.m_128441_("MeleeHit")) {
            this.meleeHit = compound.m_128451_("MeleeHit");
        }
        if (compound.m_128441_("RecentlyHit")) {
            this.recentHitTime = compound.m_128451_("RecentlyHit");
        }
        if (compound.m_128441_("EyeType")) {
            this.setEyeType(compound.m_128451_("EyeType"));
        }
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, IDLE)) {
            return 0;
        }
        if (Objects.equals(animation, ATTACK)) {
            return 1;
        }
        if (Objects.equals(animation, SWIPE)) {
            return 2;
        }
        if (Objects.equals(animation, DEADLY_ESCAPE)) {
            return 3;
        }
        if (Objects.equals(animation, TELEPORT_IN)) {
            return 4;
        }
        if (Objects.equals(animation, TELEPORT_OUT)) {
            return 5;
        }
        if (Objects.equals(animation, DEATH)) {
            return 6;
        }
        return 0;
    }

    public List<AnimationState> getAnimations() {
        ArrayList<AnimationState> animationStates = new ArrayList<AnimationState>();
        animationStates.add(this.idleAnimationState);
        animationStates.add(this.attackAnimationState);
        animationStates.add(this.swipeAnimationState);
        animationStates.add(this.deadlyEscapeAnimationState);
        animationStates.add(this.teleportInAnimationState);
        animationStates.add(this.teleportOutAnimationState);
        animationStates.add(this.deathAnimationState);
        return animationStates;
    }

    public void stopAllAnimations() {
        for (AnimationState state : this.getAnimations()) {
            state.m_216973_();
        }
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public int getCurrentAnimation() {
        return (Integer)this.f_19804_.m_135370_(ANIM_STATE);
    }

    public boolean isCurrentAnimation(String animation) {
        return this.getCurrentAnimation() == this.getAnimationState(animation);
    }

    public void m_7350_(EntityDataAccessor<?> p_219422_) {
        if (ANIM_STATE.equals(p_219422_) && this.f_19853_.f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopMostAnimation(this.idleAnimationState);
                    break;
                }
                case 1: {
                    this.stopMostAnimation(this.attackAnimationState);
                    this.attackAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopMostAnimation(this.swipeAnimationState);
                    this.swipeAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopMostAnimation(this.deadlyEscapeAnimationState);
                    this.deadlyEscapeAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 4: {
                    this.stopMostAnimation(this.teleportInAnimationState);
                    this.teleportInAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 5: {
                    this.stopMostAnimation(this.teleportOutAnimationState);
                    this.teleportOutAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 6: {
                    this.stopMostAnimation(this.deathAnimationState);
                    this.deathAnimationState.m_216977_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_219422_);
    }

    private boolean getFlag(int mask) {
        byte i = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        return (i & mask) != 0;
    }

    private void setFlags(int mask, boolean value) {
        int i = ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(i & 0xFF)));
    }

    @Nullable
    public BlockPos getVoidFramePos() {
        return this.voidFrame;
    }

    public void setVoidFramePos(@Nullable BlockPos voidFrame) {
        this.voidFrame = voidFrame;
    }

    public boolean isMeleeAttacking() {
        return this.getFlag(1);
    }

    public void setMeleeAttacking(boolean attacking) {
        this.setFlags(1, attacking);
        this.attackTick = 0;
    }

    public boolean isTeleporting() {
        return this.getFlag(2);
    }

    public void setTeleporting(boolean teleporting) {
        this.setFlags(2, teleporting);
    }

    public boolean isDeadlyEscape() {
        return this.getFlag(4);
    }

    public void setDeadlyEscape(boolean escape) {
        this.setFlags(4, escape);
    }

    public int getEyeType() {
        return (Integer)this.f_19804_.m_135370_(EYE_TYPE);
    }

    public boolean hasEye() {
        return this.getEyeType() > 0;
    }

    public void setEyeType(int eyeType) {
        this.f_19804_.m_135381_(EYE_TYPE, (Object)Math.min(eyeType, 4));
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    protected void m_7840_(double p_19911_, boolean p_19912_, BlockState p_19913_, BlockPos p_19914_) {
        if (!this.isHiding()) {
            super.m_7840_(p_19911_, p_19912_, p_19913_, p_19914_);
        }
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    public void m_6457_(ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        if (((Boolean)MainConfig.SpecialBossBar.get()).booleanValue()) {
            this.bossInfo.m_6543_(pPlayer);
        }
    }

    public void m_6452_(ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.bossInfo.m_6539_(pPlayer);
    }

    public void m_7601_(BlockState p_33796_, Vec3 p_33797_) {
    }

    protected boolean m_7341_(Entity p_219462_) {
        return false;
    }

    public boolean m_6072_() {
        return false;
    }

    @Override
    public void m_6667_(DamageSource cause) {
        if (this.deathTime > 0) {
            super.m_6667_(cause);
        }
    }

    protected void m_6153_() {
        Level level;
        ++this.deathTime;
        this.setAnimationState(DEATH);
        if (this.deathTime < MathHelper.secondsToTicks(2) && (level = this.f_19853_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 16; ++i) {
                serverLevel.m_8767_((ParticleOptions)new MagicSmokeParticle.Option(0, 0, this.f_19853_.m_213780_().m_216332_(40, 80), 0.25f), this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0, this.f_19853_.m_213780_().m_188499_() ? 0.01 : -0.01, 0.1, this.f_19853_.m_213780_().m_188499_() ? 0.01 : -0.01, 0.5);
            }
        }
        this.m_6478_(MoverType.SELF, new Vec3(0.0, 0.0, 0.0));
        if (this.deathTime == 1) {
            this.m_6667_(this.deathBlow);
        }
        if (this.deathTime >= MathHelper.secondsToTicks(4)) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.ENDERSENT_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return (SoundEvent)ModSounds.ENDERSENT_HURT.get();
    }

    @Override
    public void stepSound() {
        this.m_5496_((SoundEvent)ModSounds.ENDERSENT_STEP.get(), 0.15f, 1.0f);
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.ENDERSENT_DEATH.get();
    }

    protected float m_6121_() {
        return 2.0f;
    }

    @Nullable
    public BlockEntity getVoidFrame() {
        if (this.getVoidFramePos() != null) {
            return this.f_19853_.m_7702_(this.getVoidFramePos());
        }
        return null;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7639_() != null && !MobUtil.areAllies((Entity)this, source.m_7639_())) {
            float threshold = this.m_21233_() * 0.025f;
            if (!ModDamageSource.physicalAttacks(source)) {
                if ((amount /= 2.0f) >= threshold) {
                    this.projectileHit += 1 + Mth.m_14143_((float)(amount / threshold));
                }
                ++this.projectileHit;
                if (this.projectileHit >= 7) {
                    this.projectileHit = 0;
                    this.recentHitTime = MathHelper.secondsToTicks(5);
                }
            } else {
                ++this.meleeHit;
                if ((this.f_19853_.m_213780_().m_188499_() || this.meleeHit >= 2) && (this.f_19853_.m_213780_().m_188499_() || this.meleeHit >= 3)) {
                    this.meleeHit = 0;
                    this.recentHitTime = MathHelper.secondsToTicks(4);
                }
            }
        }
        return super.m_6469_(source, amount);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        AttributeInstance health;
        SpawnGroupData data = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        if (this.getEyeType() > 0 && (health = this.m_21051_(Attributes.f_22276_)) != null) {
            health.m_22100_(229.99999999999997);
            this.m_21153_(this.m_21233_());
        }
        return data;
    }

    public Component m_7755_() {
        if (this.getEyeType() > 0) {
            return Component.m_237115_((String)("name.goety.endersent." + this.getEyeType()));
        }
        return super.m_7755_();
    }

    protected void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        super.m_7472_(pSource, pLooting, pRecentlyHit);
        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46135_) && this.hasEye()) {
            ItemEntity itementity2;
            ItemEntity itementity = this.m_19998_((ItemLike)Items.f_42545_);
            if (itementity != null) {
                itementity.m_32064_();
            }
            if ((itementity2 = this.m_19998_((ItemLike)ModItems.VOID_SHARD.get())) != null) {
                itementity2.m_146915_(true);
                itementity2.m_32064_();
            }
        }
    }

    public void idleTick() {
        if (this.isCurrentAnimation(IDLE) && !this.isHiding() && !this.f_267362_.m_267780_()) {
            ColorUtil colorUtil;
            BlockParticleOption option;
            BlockState blockState;
            BlockPos blockPos;
            ++this.idleTime;
            ColorUtil colorUtil1 = new ColorUtil(0x3C3C3E);
            float size = 2.5f;
            if (this.idleTime == 5) {
                blockPos = BlockPos.m_274561_((double)this.getXRight(), (double)(this.m_20186_() - 1.0), (double)this.getZRight());
                CameraShake.cameraShake(this.f_19853_, blockPos.m_252807_(), 15.0f, 0.1f, 0, 10);
                blockState = this.f_19853_.m_8055_(blockPos);
                option = new BlockParticleOption(ParticleTypes.f_123794_, blockState);
                colorUtil = new ColorUtil(this.f_19853_.m_8055_((BlockPos)blockPos).m_284242_((BlockGetter)this.f_19853_, (BlockPos)blockPos).f_283871_);
                this.m_5496_((SoundEvent)ModSounds.ENDERSENT_AMBIENT_SMASH.get(), this.m_6121_(), this.m_6100_());
                this.f_19853_.m_7106_((ParticleOptions)new CircleExplodeParticleOption(colorUtil.red(), colorUtil.green(), colorUtil.blue(), size, 1), this.getXRight(), BlockFinder.moveDownToGround((Entity)this), this.getZRight(), 0.0, 0.0, 0.0);
                ParticleUtil.circularParticles(this.f_19853_, (ParticleOptions)ModParticleTypes.BIG_CULT_SPELL.get(), blockPos.m_123341_(), (float)blockPos.m_123342_() + 1.0f, blockPos.m_123343_(), colorUtil1.red(), colorUtil1.green(), colorUtil1.blue(), size);
                ParticleUtil.circularParticles(this.f_19853_, (ParticleOptions)option, blockPos.m_123341_(), (float)blockPos.m_123342_() + 1.0f, blockPos.m_123343_(), 0.0, 0.0, 0.0, size);
            }
            if (this.idleTime == 63) {
                this.m_5496_((SoundEvent)ModSounds.ENDERSENT_AMBIENT_SMASH.get(), this.m_6121_(), this.m_6100_());
            }
            if (this.idleTime == 67) {
                blockPos = BlockPos.m_274561_((double)this.getXLeft(), (double)(this.m_20186_() - 1.0), (double)this.getZLeft());
                CameraShake.cameraShake(this.f_19853_, blockPos.m_252807_(), 15.0f, 0.1f, 0, 10);
                blockState = this.f_19853_.m_8055_(blockPos);
                option = new BlockParticleOption(ParticleTypes.f_123794_, blockState);
                colorUtil = new ColorUtil(this.f_19853_.m_8055_((BlockPos)blockPos).m_284242_((BlockGetter)this.f_19853_, (BlockPos)blockPos).f_283871_);
                this.f_19853_.m_7106_((ParticleOptions)new CircleExplodeParticleOption(colorUtil.red(), colorUtil.green(), colorUtil.blue(), size, 1), this.getXLeft(), BlockFinder.moveDownToGround((Entity)this), this.getZLeft(), 0.0, 0.0, 0.0);
                ParticleUtil.circularParticles(this.f_19853_, (ParticleOptions)ModParticleTypes.BIG_CULT_SPELL.get(), blockPos.m_123341_(), (float)blockPos.m_123342_() + 1.0f, blockPos.m_123343_(), colorUtil1.red(), colorUtil1.green(), colorUtil1.blue(), size);
                ParticleUtil.circularParticles(this.f_19853_, (ParticleOptions)option, blockPos.m_123341_(), (float)blockPos.m_123342_() + 1.0f, blockPos.m_123343_(), 0.0, 0.0, 0.0, size);
            }
            if (this.idleTime >= 119) {
                this.idleTime = 0;
            }
        } else {
            this.idleTime = 0;
        }
    }

    public void eyeTypeEffects() {
        if (this.getEyeType() == SEARING_EYE) {
            this.addEyeEffects(MobEffects.f_19607_);
            this.addEyeEffects((MobEffect)GoetyEffects.FIERY_AURA.get());
            this.addEyeEffects((MobEffect)GoetyEffects.RALLYING.get());
        } else if (this.getEyeType() == HALLOWED_EYE) {
            this.addEyeEffects((MobEffect)GoetyEffects.ALTRUISTIC.get());
            this.addEyeEffects((MobEffect)GoetyEffects.RADIANCE.get());
            this.addEyeEffects((MobEffect)GoetyEffects.SHIELDING.get());
        } else if (this.getEyeType() == TWISTED_EYE) {
            this.addEyeEffects(MobEffects.f_19596_);
            this.addEyeEffects((MobEffect)GoetyEffects.ELECTRIFIED.get());
            this.addEyeEffects((MobEffect)GoetyEffects.SWIRLING.get());
        } else if (this.getEyeType() == DREADFUL_EYE) {
            this.addEyeEffects((MobEffect)GoetyEffects.GRAVITY_PULSE.get());
            this.addEyeEffects((MobEffect)GoetyEffects.DEFLECTIVE.get());
            this.addEyeEffects((MobEffect)GoetyEffects.FROSTY_AURA.get());
        } else {
            this.addEyeEffects(MobEffects.f_19600_);
            this.addEyeEffects(MobEffects.f_19606_);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ % 5 == 0) {
            this.bossInfo.update();
        }
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
        MiscCapHelper.updateMobTarget((Mob)this);
        if (this.f_19853_.f_46443_) {
            this.idleAnimationState.m_246184_(!this.f_267362_.m_267780_() && !this.isHiding() && this.isCurrentAnimation(IDLE), this.f_19797_);
            if (this.isCurrentAnimation(DEADLY_ESCAPE)) {
                this.stopMostAnimation(this.deadlyEscapeAnimationState);
            }
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.isHiding() && !this.m_21224_() && this.f_19853_.f_46443_) {
            for (int i = 0; i < 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
            }
        }
        if (this.deadlyEscapeCool > 0) {
            if (this.isDeadlyEscape()) {
                this.setDeadlyEscape(false);
            }
            --this.deadlyEscapeCool;
        }
        if (this.recentHitTime > 0) {
            --this.recentHitTime;
        }
        this.idleTick();
        if (!this.f_19853_.f_46443_ && !this.m_21224_()) {
            AttributeInstance instance;
            BlockEntity blockEntity;
            this.m_21561_(this.m_5448_() != null);
            if (this.getEyeType() > 0 && !this.isHiding()) {
                this.eyeTypeEffects();
            }
            if ((blockEntity = this.getVoidFrame()) instanceof VoidFrameBlockEntity) {
                VoidFrameBlockEntity voidFrameBlock = (VoidFrameBlockEntity)blockEntity;
                voidFrameBlock.setCoolTick(0);
                if (this.m_5448_() == null && this.m_20238_(voidFrameBlock.m_58899_().m_252807_()) > (double)Mth.m_144944_((int)48) && this.f_19797_ % 10 == 0) {
                    Vec3 vec3 = voidFrameBlock.m_58899_().m_252807_();
                    this.m_21573_().m_26573_();
                    this.m_6021_(vec3.f_82479_, vec3.f_82480_ + 1.0, vec3.f_82481_);
                }
            }
            if (this.isMeleeAttacking()) {
                ++this.attackTick;
            } else if (this.isAttacking()) {
                if (this.isDeadlyEscape()) {
                    this.setAnimationState(DEADLY_ESCAPE);
                } else {
                    this.setAnimationState(IDLE);
                }
            }
            if (this.isCurrentAnimation(TELEPORT_IN)) {
                if (this.postTeleportTick <= 0) {
                    this.setAnimationState(IDLE);
                } else if (this.postTeleportTick == MathHelper.secondsToTicks(1.48f)) {
                    this.frontSmash();
                }
            }
            if ((instance = this.m_21051_(Attributes.f_22281_)) != null) {
                if (this.isCurrentAnimation(TELEPORT_IN)) {
                    if (this.m_21051_(Attributes.f_22281_) != null) {
                        instance.m_22130_(TELEPORT_ATTACK_MODIFIER);
                        instance.m_22118_(TELEPORT_ATTACK_MODIFIER);
                    }
                } else if (instance.m_22109_(TELEPORT_ATTACK_MODIFIER)) {
                    instance.m_22130_(TELEPORT_ATTACK_MODIFIER);
                }
                if (this.isCurrentAnimation(DEADLY_ESCAPE)) {
                    if (this.m_21051_(Attributes.f_22281_) != null) {
                        instance.m_22130_(DE_ATTACK_MODIFIER);
                        instance.m_22118_(DE_ATTACK_MODIFIER);
                    }
                } else if (instance.m_22109_(DE_ATTACK_MODIFIER)) {
                    instance.m_22130_(DE_ATTACK_MODIFIER);
                }
            }
            if (!this.isHiding()) {
                if (this.m_5448_() != null && !this.isTeleporting() && !this.isDeadlyEscape() && this.postTeleportTick <= 0) {
                    if (this.m_5448_().m_20270_((Entity)this) <= 8.0f && this.f_19853_.m_213780_().m_188499_() && this.recentHitTime > 0 && this.deadlyEscapeCool <= 0 && this.watchlingNumber() < 3) {
                        if (!this.isMeleeAttacking() && !this.isAttacking()) {
                            this.setAnimationState(DEADLY_ESCAPE);
                        }
                        this.setDeadlyEscape(true);
                    } else if (!this.m_217066_(this.m_5448_()) && !this.isMeleeAttacking() && !this.isAttacking() && this.recentHitTime > 0 && this.f_19853_.m_213780_().m_188499_() && this.teleportCool <= 0) {
                        this.teleportHideTime = MathHelper.secondsToTicks(this.f_19853_.m_213780_().m_216332_(3, 5));
                        this.setTeleporting(true);
                        this.setAnimationState(TELEPORT_OUT);
                    }
                }
                if (this.isDeadlyEscape() && this.isCurrentAnimation(DEADLY_ESCAPE)) {
                    this.setTeleporting(false);
                    this.deadlyEscape();
                } else if (this.isTeleporting()) {
                    this.setDeadlyEscape(false);
                    this.specialTeleport();
                }
            }
        }
    }

    @Override
    public boolean teleportHurt() {
        return true;
    }

    public void addEyeEffects(MobEffect effect) {
        this.addEyeEffects(effect, 0);
    }

    public void addEyeEffects(MobEffect effect, int level) {
        this.m_7292_(new MobEffectInstance(effect, 5, level, false, false));
    }

    public int watchlingNumber() {
        return this.f_19853_.m_6443_(WatchlingServant.class, this.m_20191_().m_82400_(64.0), predicate -> predicate.getTrueOwner() == this).size();
    }

    public boolean noWatchlings() {
        return this.watchlingNumber() <= 0;
    }

    public boolean isAttacking() {
        return this.isCurrentAnimation(ATTACK) || this.isCurrentAnimation(SWIPE);
    }

    @Override
    public int getHidingDuration() {
        if (this.isTeleporting()) {
            return this.teleportHideTime;
        }
        return MathHelper.secondsToTicks(5);
    }

    @Override
    public boolean shouldStopHiding() {
        return this.isDeadlyEscape() && this.noWatchlings();
    }

    public void specialTeleport() {
        ++this.preHidingTime;
        this.m_21573_().m_26573_();
        this.m_21566_().m_24988_(0.0f, 0.0f);
        if (this.m_5448_() != null) {
            MobUtil.instaLook((Mob)this, (Entity)this.m_5448_());
        }
        if (this.preHidingTime % 2 == 0) {
            this.m_5496_((SoundEvent)ModSounds.ENDERLING_TELEPORT_OUT.get(), 1.0f, 1.0f);
        }
        if (this.preHidingTime >= MathHelper.secondsToTicks(1.92f)) {
            this.startHide();
            this.preHidingTime = 0;
        }
    }

    public void deadlyEscape() {
        ++this.preHidingTime;
        this.m_21573_().m_26573_();
        this.m_21566_().m_24988_(0.0f, 0.0f);
        if (this.m_5448_() != null) {
            MobUtil.instaLook((Mob)this, (Entity)this.m_5448_());
        }
        if (this.preHidingTime == 1) {
            this.m_5496_((SoundEvent)ModSounds.ENDERSENT_DEADLY_ESCAPE.get(), this.m_6121_(), this.m_6100_());
        }
        if (this.preHidingTime == MathHelper.secondsToTicks(1.6f)) {
            this.frontSmash();
            this.summonWatchlings();
        }
        if (this.preHidingTime >= MathHelper.secondsToTicks(2)) {
            this.startHide();
            this.preHidingTime = 0;
        }
    }

    public void summonWatchlings() {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 6 && (i < 3 || serverLevel.m_213780_().m_188499_()); ++i) {
                WatchlingServant servant = new WatchlingServant((EntityType<? extends Owned>)((EntityType)ModEntityType.WATCHLING_SERVANT.get()), (Level)serverLevel);
                BlockPos blockPos = BlockFinder.SummonRadius(this.m_20183_(), (Entity)servant, (Level)serverLevel);
                servant.setTrueOwner((LivingEntity)this);
                servant.m_20035_(blockPos, 0.0f, 0.0f);
                servant.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(this.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                serverLevel.m_7967_((Entity)servant);
            }
        }
    }

    @Override
    public void teleportAfterHiding() {
        if (!this.isTeleporting()) {
            this.teleport(7.0);
        } else {
            if (this.m_5448_() != null) {
                this.teleportTowards((Entity)this.m_5448_(), 4.0);
            } else {
                this.teleportIn();
            }
            this.teleportCool = MathHelper.secondsToTicks(5);
            this.setTeleporting(false);
        }
        if (this.m_5448_() != null && !this.f_19853_.f_46443_) {
            MobUtil.instaLook((Mob)this, (Entity)this.m_5448_());
            ModNetwork.sentToTrackingEntity((Entity)this, new SInstaLookPacket(this.m_19879_(), this.m_5448_().m_19879_()));
        }
        if (this.isDeadlyEscape()) {
            this.deadlyEscapeCool = MathHelper.secondsToTicks(10);
            this.setDeadlyEscape(false);
        }
    }

    @Override
    public void teleportIn() {
        super.teleportIn();
        this.setAnimationState(TELEPORT_IN);
        this.m_5496_((SoundEvent)ModSounds.ENDERSENT_TELEPORT_SMASH.get(), this.m_6121_(), this.m_6100_());
        this.postTeleportTick = MathHelper.secondsToTicks(1.92f);
        if (this.isTeleporting()) {
            this.setTeleporting(false);
        }
    }

    @Override
    protected boolean teleport(double range) {
        if (!this.f_19853_.m_5776_() && this.m_6084_()) {
            for (int i = 0; i < 128; ++i) {
                EntityTeleportEvent.EnderEntity event;
                boolean flag = true;
                double d3 = this.m_20185_() + (this.m_217043_().m_188500_() - 0.5) * range;
                double d4 = this.m_20186_() + ((double)this.m_217043_().m_188503_(Mth.m_14107_((double)range)) - range / 2.0);
                if (this.m_5448_() != null) {
                    d4 = this.m_5448_().m_20186_();
                }
                double d5 = this.m_20189_() + (this.m_217043_().m_188500_() - 0.5) * range;
                BlockPos blockPos = BlockPos.m_274561_((double)d3, (double)d4, (double)d5);
                if (this.m_5448_() != null && i < 64) {
                    flag = BlockFinder.canSeeBlock((Entity)this.m_5448_(), blockPos);
                }
                if ((event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_())).isCanceled()) {
                    this.teleportIn();
                    return false;
                }
                if (!flag) continue;
                if (this.ownedTeleport(event.getTargetX(), event.getTargetY(), event.getTargetZ())) {
                    return true;
                }
                if (i != 127) continue;
                this.teleportIn();
                return false;
            }
        }
        return false;
    }

    @Override
    public void teleportTowards(Entity entity, double range) {
        if (!this.f_19853_.m_5776_() && this.m_6084_()) {
            if (entity == null) {
                this.teleportIn();
                return;
            }
            try {
                for (int i = 0; i < 128; ++i) {
                    double d3;
                    double d2;
                    int range2 = Mth.m_14107_((double)range);
                    double d1 = entity.m_20185_() + (double)this.f_19853_.m_213780_().m_216332_(-range2, range2);
                    EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)d1, (double)(d2 = entity.m_20186_()), (double)(d3 = entity.m_20189_() + (double)this.f_19853_.m_213780_().m_216332_(-range2, range2)));
                    if (event.isCanceled()) {
                        if (this.getHidingDuration() > 0) {
                            this.teleportIn();
                        } else {
                            this.teleportHits();
                        }
                    } else if (this.ownedTeleport(event.getTargetX(), event.getTargetY(), event.getTargetZ())) {
                        MobUtil.instaLook((Mob)this, entity);
                    } else {
                        if (i != 127) continue;
                        MobUtil.instaLook((Mob)this, entity);
                        if (this.getHidingDuration() > 0) {
                            this.teleportIn();
                        } else {
                            this.teleportHits();
                        }
                    }
                    break;
                }
            }
            catch (NullPointerException exception) {
                this.teleportIn();
            }
        }
    }

    public double getXLeft() {
        return this.getXFront() + MobUtil.getHorizontalLeftLookAngle((Entity)this).f_82479_;
    }

    public double getZLeft() {
        return this.getZFront() + MobUtil.getHorizontalLeftLookAngle((Entity)this).f_82481_;
    }

    public double getXRight() {
        return this.getXFront() + MobUtil.getHorizontalRightLookAngle((Entity)this).f_82479_;
    }

    public double getZRight() {
        return this.getZFront() + MobUtil.getHorizontalRightLookAngle((Entity)this).f_82481_;
    }

    public double getXFront() {
        return this.m_20185_() + this.getHorizontalLookAngle().f_82479_;
    }

    public double getZFront() {
        return this.m_20189_() + this.getHorizontalLookAngle().f_82481_;
    }

    public Vec3 getHorizontalLookAngle() {
        return this.m_20171_(0.0f, this.m_146908_());
    }

    public double m_142593_(LivingEntity livingEntity) {
        return this.m_20205_() * 4.0f * this.m_20205_() * 4.0f + livingEntity.m_20205_();
    }

    public boolean m_217066_(LivingEntity livingentity) {
        double d0 = this.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
        return d0 <= this.m_142593_(livingentity);
    }

    public void frontSmash() {
        LivingEntity target2;
        this.leftSmash();
        this.rightSmash();
        BlockPos blockPos = BlockPos.m_274561_((double)this.getXFront(), (double)(this.m_20186_() - 1.0), (double)this.getZFront());
        float size = this.isDeadlyEscape() ? 5.0f : 2.5f;
        AABB aabb = new AABB(blockPos).m_82400_((double)size);
        for (LivingEntity target2 : this.f_19853_.m_45976_(LivingEntity.class, aabb)) {
            if (target2 == this || MobUtil.areAllies((Entity)target2, (Entity)this)) continue;
            this.m_7327_((Entity)target2);
        }
        CameraShake.cameraShake(this.f_19853_, blockPos.m_252807_(), 20.0f, 0.2f, 0, 10);
        target2 = this.f_19853_;
        if (target2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)target2;
            if (this.isDeadlyEscape()) {
                ColorUtil colorUtil = new ColorUtil(15821289);
                serverLevel.m_8767_((ParticleOptions)new CircleExplodeParticleOption(colorUtil.red(), colorUtil.green(), colorUtil.blue(), size, 1), this.getXFront(), BlockFinder.moveDownToGround((Entity)this), this.getZFront(), 1, 0.0, 0.0, 0.0, 0.0);
                serverLevel.m_8767_((ParticleOptions)new VerticalCircleExplodeParticleOption(colorUtil.red(), colorUtil.green(), colorUtil.blue(), size, 1), this.getXFront(), BlockFinder.moveDownToGround((Entity)this), this.getZFront(), 1, 0.0, 0.0, 0.0, 0.0);
                ServerParticleUtil.circularParticles(serverLevel, (ParticleOptions)ModParticleTypes.BIG_CULT_SPELL.get(), this.getXFront(), BlockFinder.moveDownToGround((Entity)this) + 1.0, this.getZFront(), colorUtil.red(), colorUtil.green(), colorUtil.blue(), size);
            }
        }
    }

    public void leftSmash() {
        Level target2;
        BlockPos blockPos = BlockPos.m_274561_((double)this.getXLeft(), (double)(this.m_20186_() - 1.0), (double)this.getZLeft());
        float size = 2.5f;
        AABB aabb = new AABB(blockPos).m_82400_((double)size);
        for (Level target2 : this.f_19853_.m_45976_(LivingEntity.class, aabb)) {
            if (target2 == this || MobUtil.areAllies((Entity)target2, (Entity)this)) continue;
            this.m_7327_((Entity)target2);
        }
        target2 = this.f_19853_;
        if (target2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)target2;
            BlockState blockState = this.f_19853_.m_8055_(blockPos);
            BlockParticleOption option = new BlockParticleOption(ParticleTypes.f_123794_, blockState);
            ServerParticleUtil.circularParticles(serverLevel, (ParticleOptions)option, blockPos.m_123341_(), (float)blockPos.m_123342_() + 1.0f, blockPos.m_123343_(), 0.0, 0.0, 0.0, size);
            if (!this.isDeadlyEscape()) {
                ColorUtil colorUtil = new ColorUtil(serverLevel.m_8055_((BlockPos)blockPos).m_284242_((BlockGetter)serverLevel, (BlockPos)blockPos).f_283871_);
                serverLevel.m_8767_((ParticleOptions)new CircleExplodeParticleOption(colorUtil.red(), colorUtil.green(), colorUtil.blue(), size, 1), this.getXLeft(), BlockFinder.moveDownToGround((Entity)this), this.getZLeft(), 1, 0.0, 0.0, 0.0, 0.0);
                ColorUtil colorUtil1 = new ColorUtil(0x3C3C3E);
                ServerParticleUtil.circularParticles(serverLevel, (ParticleOptions)ModParticleTypes.BIG_CULT_SPELL.get(), blockPos.m_123341_(), (float)blockPos.m_123342_() + 1.0f, blockPos.m_123343_(), colorUtil1.red(), colorUtil1.green(), colorUtil1.blue(), size);
            }
        }
    }

    public void rightSmash() {
        Level target2;
        BlockPos blockPos = BlockPos.m_274561_((double)this.getXRight(), (double)(this.m_20186_() - 1.0), (double)this.getZRight());
        float size = 2.5f;
        AABB aabb = new AABB(blockPos).m_82400_((double)size);
        for (Level target2 : this.f_19853_.m_45976_(LivingEntity.class, aabb)) {
            if (target2 == this || MobUtil.areAllies((Entity)target2, (Entity)this)) continue;
            this.m_7327_((Entity)target2);
        }
        target2 = this.f_19853_;
        if (target2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)target2;
            BlockState blockState = this.f_19853_.m_8055_(blockPos);
            BlockParticleOption option = new BlockParticleOption(ParticleTypes.f_123794_, blockState);
            ServerParticleUtil.circularParticles(serverLevel, (ParticleOptions)option, blockPos.m_123341_(), (float)blockPos.m_123342_() + 1.0f, blockPos.m_123343_(), 0.0, 0.0, 0.0, size);
            if (!this.isDeadlyEscape()) {
                ColorUtil colorUtil = new ColorUtil(serverLevel.m_8055_((BlockPos)blockPos).m_284242_((BlockGetter)serverLevel, (BlockPos)blockPos).f_283871_);
                serverLevel.m_8767_((ParticleOptions)new CircleExplodeParticleOption(colorUtil.red(), colorUtil.green(), colorUtil.blue(), size, 1), this.getXRight(), BlockFinder.moveDownToGround((Entity)this), this.getZRight(), 1, 0.0, 0.0, 0.0, 0.0);
                ColorUtil colorUtil1 = new ColorUtil(0x3C3C3E);
                ServerParticleUtil.circularParticles(serverLevel, (ParticleOptions)ModParticleTypes.BIG_CULT_SPELL.get(), blockPos.m_123341_(), (float)blockPos.m_123342_() + 1.0f, blockPos.m_123343_(), colorUtil1.red(), colorUtil1.green(), colorUtil1.blue(), size);
            }
        }
    }

    @Override
    public boolean m_7327_(Entity entityIn) {
        Player player;
        boolean flag = super.m_7327_(entityIn);
        if ((this.f_19853_.m_213780_().m_188499_() || this.isDeadlyEscape() || this.isCurrentAnimation(TELEPORT_IN)) && entityIn instanceof Player && (player = (Player)entityIn).m_21254_()) {
            player.m_36384_(true);
        }
        if (entityIn instanceof Mob) {
            MobUtil.disableShield(entityIn);
        }
        return flag;
    }

    class AttackGoal
    extends MeleeAttackGoal {
        private final double moveSpeed;
        private int delayCounter;

        public AttackGoal(double moveSpeed) {
            super((PathfinderMob)Endersent.this, moveSpeed, true);
            this.moveSpeed = moveSpeed;
        }

        public boolean m_8036_() {
            return Endersent.this.m_5448_() != null && Endersent.this.m_5448_().m_6084_() && !Endersent.this.isHiding() && !Endersent.this.isTeleporting() && !Endersent.this.isDeadlyEscape() && Endersent.this.postTeleportTick <= 0;
        }

        public boolean m_8045_() {
            return super.m_8045_() && !Endersent.this.isHiding() && !Endersent.this.isTeleporting() && !Endersent.this.isDeadlyEscape() && Endersent.this.postTeleportTick <= 0;
        }

        public void m_8056_() {
            this.delayCounter = 0;
        }

        public void m_8041_() {
            Endersent.this.setMeleeAttacking(false);
            Endersent.this.attackTick = 0;
        }

        public void m_8037_() {
            LivingEntity livingentity = Endersent.this.m_5448_();
            if (livingentity == null) {
                this.m_8041_();
                return;
            }
            Endersent.this.m_21563_().m_24960_((Entity)livingentity, (float)Endersent.this.m_8085_(), (float)Endersent.this.m_8132_());
            if (--this.delayCounter <= 0) {
                this.delayCounter = 10;
                Endersent.this.m_21573_().m_5624_((Entity)livingentity, this.moveSpeed);
            }
            this.m_6739_(livingentity, Endersent.this.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_()));
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.m_6639_(enemy);
            boolean smash = Endersent.this.f_19796_.m_188499_();
            if (!Endersent.this.isMeleeAttacking() && distToEnemySqr <= d0) {
                Endersent.this.setMeleeAttacking(true);
                if (smash) {
                    Endersent.this.setAnimationState(SWIPE);
                    Endersent.this.m_5496_((SoundEvent)ModSounds.ENDERSENT_SWING.get(), Endersent.this.m_6121_(), Endersent.this.m_6100_());
                } else {
                    Endersent.this.setAnimationState(ATTACK);
                    Endersent.this.m_5496_((SoundEvent)ModSounds.ENDERSENT_ATTACK.get(), Endersent.this.m_6121_(), Endersent.this.m_6100_());
                }
            }
            if (Endersent.this.isMeleeAttacking()) {
                float seconds;
                float f = seconds = Endersent.this.isCurrentAnimation(ATTACK) ? 2.44f : 2.84f;
                if (Endersent.this.attackTick < MathHelper.secondsToTicks(seconds)) {
                    MobUtil.instaLook((Mob)Endersent.this, (Entity)enemy);
                    if (Endersent.this.isCurrentAnimation(SWIPE)) {
                        if (Endersent.this.attackTick == MathHelper.secondsToTicks(1)) {
                            this.massiveSweep((LivingEntity)Endersent.this, 4.5, 200.0);
                        }
                    } else if (Endersent.this.isCurrentAnimation(ATTACK) && Endersent.this.attackTick == MathHelper.secondsToTicks(1)) {
                        LivingEntity target2;
                        double x = Endersent.this.getXFront();
                        double z = Endersent.this.getZFront();
                        float size = 2.5f;
                        BlockPos blockPos = BlockPos.m_274561_((double)x, (double)(Endersent.this.m_20186_() - 1.0), (double)z);
                        AABB aabb = new AABB(blockPos).m_82400_((double)size);
                        for (LivingEntity target2 : Endersent.this.f_19853_.m_45976_(LivingEntity.class, aabb)) {
                            if (target2 == Endersent.this || MobUtil.areAllies((Entity)target2, (Entity)Endersent.this)) continue;
                            Endersent.this.m_7327_((Entity)target2);
                        }
                        CameraShake.cameraShake(Endersent.this.f_19853_, blockPos.m_252807_(), 15.0f, 0.1f, 0, 10);
                        target2 = Endersent.this.f_19853_;
                        if (target2 instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)target2;
                            BlockState blockState = serverLevel.m_8055_(blockPos);
                            BlockParticleOption option = new BlockParticleOption(ParticleTypes.f_123794_, blockState);
                            ServerParticleUtil.circularParticles(serverLevel, (ParticleOptions)option, blockPos.m_123341_(), (float)blockPos.m_123342_() + 1.0f, blockPos.m_123343_(), 0.0, 0.0, 0.0, size);
                            ColorUtil colorUtil = new ColorUtil(serverLevel.m_8055_((BlockPos)blockPos).m_284242_((BlockGetter)serverLevel, (BlockPos)blockPos).f_283871_);
                            serverLevel.m_8767_((ParticleOptions)new CircleExplodeParticleOption(colorUtil.red(), colorUtil.green(), colorUtil.blue(), size, 1), x, BlockFinder.moveDownToGround((Entity)Endersent.this), z, 1, 0.0, 0.0, 0.0, 0.0);
                            ColorUtil colorUtil1 = new ColorUtil(0x3C3C3E);
                            ServerParticleUtil.circularParticles(serverLevel, (ParticleOptions)ModParticleTypes.BIG_CULT_SPELL.get(), blockPos.m_123341_(), (float)blockPos.m_123342_() + 1.0f, blockPos.m_123343_(), colorUtil1.red(), colorUtil1.green(), colorUtil1.blue(), size);
                        }
                    }
                } else {
                    if (!Endersent.this.isHiding() && !Endersent.this.isDeadlyEscape() && Endersent.this.f_19853_.m_213780_().m_188501_() <= 0.3f) {
                        Endersent.this.startHide();
                        if (Endersent.this.f_19853_.m_213780_().m_188499_() && Endersent.this.watchlingNumber() <= 3) {
                            Endersent.this.summonWatchlings();
                        }
                    }
                    Endersent.this.setMeleeAttacking(false);
                }
            }
        }

        public void massiveSweep(LivingEntity source, double range, double arc) {
            List<LivingEntity> hits = MobUtil.getAttackableLivingEntitiesNearby(source, range, 1.0, range, range);
            for (LivingEntity target : hits) {
                float targetAngle = (float)((Math.atan2(target.m_20189_() - source.m_20189_(), target.m_20185_() - source.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
                float attackAngle = source.f_20883_ % 360.0f;
                if (targetAngle < 0.0f) {
                    targetAngle += 360.0f;
                }
                if (attackAngle < 0.0f) {
                    attackAngle += 360.0f;
                }
                float relativeAngle = targetAngle - attackAngle;
                float hitDistance = (float)Math.sqrt((target.m_20189_() - source.m_20189_()) * (target.m_20189_() - source.m_20189_()) + (target.m_20185_() - source.m_20185_()) * (target.m_20185_() - source.m_20185_())) - target.m_20205_() / 2.0f;
                if (!((double)hitDistance <= range && (double)relativeAngle <= arc / 2.0 && (double)relativeAngle >= -arc / 2.0 || (double)relativeAngle >= 360.0 - arc / 2.0) && !((double)relativeAngle <= -360.0 + arc / 2.0)) continue;
                Endersent.this.m_7327_((Entity)target);
            }
        }

        protected double m_6639_(LivingEntity livingEntity) {
            return this.f_25540_.m_142593_(livingEntity);
        }
    }
}

