/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.neutral;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ai.BackawayCrossbowGoal;
import com.Polarice3.Goety.common.entities.ai.CreatureBowAttackGoal;
import com.Polarice3.Goety.common.entities.ai.ModMeleeAttackGoal;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import java.util.EnumSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.fluids.FluidType;

public abstract class AbstractHauntedArmor
extends Summoned
implements CrossbowAttackMob,
RangedAttackMob {
    private static final UUID SPEED_MODIFIER_HOSTILE_UUID = UUID.fromString("5CD17E52-A79A-43D3-A529-90FDE04B181E");
    private static final AttributeModifier SPEED_MODIFIER_HOSTILE = new AttributeModifier(SPEED_MODIFIER_HOSTILE_UUID, "Aggression Speed", 0.5, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final EntityDataAccessor<Byte> FLAGS = SynchedEntityData.m_135353_(AbstractHauntedArmor.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> DATA_CHARGING_STATE = SynchedEntityData.m_135353_(AbstractHauntedArmor.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final CreatureBowAttackGoal<AbstractHauntedArmor> bowGoal = new CreatureBowAttackGoal<AbstractHauntedArmor>(this, 1.0, 20, 15.0f){

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && !AbstractHauntedArmor.this.isGuarding();
        }
    };
    private final BackawayCrossbowGoal<AbstractHauntedArmor> crossBowGoal = new BackawayCrossbowGoal<AbstractHauntedArmor>(this, 1.0, 16.0f){

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && !AbstractHauntedArmor.this.isGuarding();
        }
    };
    private final AttackGoal meleeGoal = new AttackGoal(this, 1.0, false);
    private int blockTime;
    private int coolTime;
    private int breakShield;

    public AbstractHauntedArmor(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
        this.reassessWeaponGoal();
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new GuardingGoal(this, 0.75, 20.0f));
        this.f_21345_.m_25352_(8, new Summoned.WanderGoal<AbstractHauntedArmor>(this, 1.0, 10.0f));
    }

    public float getStepHeight() {
        return 1.0f;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.HauntedArmorHealth.get()).doubleValue()).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22279_, 0.23).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.HauntedArmorDamage.get()).doubleValue()).m_22268_(Attributes.f_22278_, 0.75);
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.HauntedArmorHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.HauntedArmorDamage.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FLAGS, (Object)0);
        this.f_19804_.m_135372_(DATA_CHARGING_STATE, (Object)false);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("BlockTime")) {
            this.blockTime = compound.m_128451_("BlockTime");
        }
        if (compound.m_128441_("CoolTime")) {
            this.coolTime = compound.m_128451_("CoolTime");
        }
        this.reassessWeaponGoal();
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("BlockTime", this.blockTime);
        compound.m_128405_("CoolTime", this.coolTime);
    }

    public void reassessWeaponGoal() {
        if (!this.f_19853_.f_46443_) {
            this.f_21345_.m_25363_((Goal)this.meleeGoal);
            this.f_21345_.m_25363_(this.bowGoal);
            this.f_21345_.m_25363_(this.crossBowGoal);
            ItemStack itemstack = this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof ProjectileWeaponItem));
            if (itemstack.m_41720_() instanceof BowItem) {
                int i = 20;
                this.bowGoal.setMinAttackInterval(i);
                this.f_21345_.m_25352_(2, this.bowGoal);
            } else if (itemstack.m_41720_() instanceof CrossbowItem) {
                this.f_21345_.m_25352_(2, this.crossBowGoal);
            } else {
                this.f_21345_.m_25352_(2, (Goal)this.meleeGoal);
            }
        }
    }

    public void m_8061_(EquipmentSlot pSlot, ItemStack pStack) {
        super.m_8061_(pSlot, pStack);
        if (!this.f_19853_.f_46443_) {
            this.reassessWeaponGoal();
        }
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.m_213945_(worldIn.m_213780_(), worldIn.m_6436_(this.m_20183_()));
        this.m_213946_(worldIn.m_213780_(), difficultyIn);
        this.reassessWeaponGoal();
        return spawnDataIn;
    }

    @Override
    protected void m_213945_(RandomSource randomSource, DifficultyInstance difficulty) {
        this.m_8061_(EquipmentSlot.HEAD, ((Item)ModItems.CURSED_KNIGHT_HELMET.get()).m_7968_());
        this.m_8061_(EquipmentSlot.CHEST, ((Item)ModItems.CURSED_KNIGHT_CHESTPLATE.get()).m_7968_());
        this.m_8061_(EquipmentSlot.LEGS, ((Item)ModItems.CURSED_KNIGHT_LEGGINGS.get()).m_7968_());
        this.m_8061_(EquipmentSlot.FEET, ((Item)ModItems.CURSED_KNIGHT_BOOTS.get()).m_7968_());
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            if (equipmentSlot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
            this.m_21409_(equipmentSlot, 0.05f);
        }
        if (difficulty.m_19048_() == Difficulty.EASY) {
            this.m_8061_(EquipmentSlot.MAINHAND, Items.f_42383_.m_7968_());
        } else {
            this.m_8061_(EquipmentSlot.MAINHAND, ((Item)ModItems.FELL_BLADE.get()).m_7968_());
            this.m_21409_(EquipmentSlot.MAINHAND, 0.025f);
        }
        this.m_8061_(EquipmentSlot.OFFHAND, Items.f_42740_.m_7968_());
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    private boolean getFlags(int mask) {
        byte i = (Byte)this.f_19804_.m_135370_(FLAGS);
        return (i & mask) != 0;
    }

    private void setFlags(int mask, boolean value) {
        int i = ((Byte)this.f_19804_.m_135370_(FLAGS)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.f_19804_.m_135381_(FLAGS, (Object)((byte)(i & 0xFF)));
    }

    public void setGuarding(boolean guarding) {
        this.setFlags(1, guarding);
    }

    public boolean isGuarding() {
        return this.getFlags(1);
    }

    public void m_6504_(LivingEntity pTarget, float pDistanceFactor) {
        ItemStack itemstack = this.m_6298_(this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
        AbstractArrow abstractarrowentity = this.getArrow(itemstack, pDistanceFactor);
        Item item2 = this.m_21205_().m_41720_();
        if (item2 instanceof BowItem) {
            BowItem bowItem = (BowItem)item2;
            abstractarrowentity = bowItem.customArrow(abstractarrowentity);
        }
        double d0 = pTarget.m_20185_() - this.m_20185_();
        double d1 = pTarget.m_20227_(0.3333333333333333) - abstractarrowentity.m_20186_();
        double d2 = pTarget.m_20189_() - this.m_20189_();
        double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
        abstractarrowentity.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.f_19853_.m_46791_().m_19028_() * 4));
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.f_19853_.m_7967_((Entity)abstractarrowentity);
    }

    protected AbstractArrow getArrow(ItemStack pArrowStack, float pDistanceFactor) {
        return ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)pArrowStack, (float)pDistanceFactor);
    }

    public boolean m_5886_(ProjectileWeaponItem p_230280_1_) {
        return p_230280_1_ instanceof BowItem || p_230280_1_ instanceof CrossbowItem;
    }

    @Override
    public boolean isChargingCrossbow() {
        return (Boolean)this.f_19804_.m_135370_(DATA_CHARGING_STATE);
    }

    public void m_6136_(boolean isCharging) {
        this.f_19804_.m_135381_(DATA_CHARGING_STATE, (Object)isCharging);
    }

    public void m_5811_(LivingEntity p_230284_1_, ItemStack p_230284_2_, Projectile p_230284_3_, float p_230284_4_) {
        this.m_32322_((LivingEntity)this, p_230284_1_, p_230284_3_, p_230284_4_, 1.6f);
    }

    public void m_5847_() {
        this.f_20891_ = 0;
    }

    public HauntedArmPose getArmPose() {
        if (this.isGuarding()) {
            return HauntedArmPose.GUARD;
        }
        if (this.isChargingCrossbow()) {
            return HauntedArmPose.CROSSBOW_CHARGE;
        }
        if (this.m_5912_() && this.m_21093_(item -> item.m_41720_() instanceof CrossbowItem)) {
            return HauntedArmPose.CROSSBOW_HOLD;
        }
        if (this.m_5912_() && this.m_21093_(item -> item.m_41720_() instanceof BowItem)) {
            return HauntedArmPose.BOW;
        }
        if (this.m_5912_()) {
            return HauntedArmPose.ATTACK;
        }
        return HauntedArmPose.IDLE;
    }

    @Override
    public int xpReward() {
        return 10;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.HAUNTED_ARMOR_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource p_21239_) {
        if (!this.m_21275_(p_21239_)) {
            Item item = this.m_6844_(EquipmentSlot.CHEST).m_41720_();
            if (item instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)item;
                if (armorItem.m_40401_().m_7344_() == SoundEvents.f_11678_ || armorItem.m_40401_().m_7344_() == SoundEvents.f_11674_ || armorItem.m_40401_().m_7344_() == SoundEvents.f_11680_ || armorItem.m_40401_().m_7344_() == SoundEvents.f_11675_) {
                    return SoundEvents.f_11915_;
                }
            } else {
                return SoundEvents.f_11915_;
            }
            return (SoundEvent)ModSounds.HAUNTED_ARMOR_HURT.get();
        }
        return SoundEvents.f_12346_;
    }

    protected void m_6677_(DamageSource p_21160_) {
        if (this.breakShield <= 0) {
            super.m_6677_(p_21160_);
        }
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.HAUNTED_ARMOR_DEATH.get();
    }

    @Nullable
    protected SoundEvent getStepSound() {
        ArmorItem armorItem;
        Item item = this.m_6844_(EquipmentSlot.FEET).m_41720_();
        if (item instanceof ArmorItem && ((armorItem = (ArmorItem)item).m_40401_().m_7344_() == SoundEvents.f_11678_ || armorItem.m_40401_().m_7344_() == SoundEvents.f_11674_ || armorItem.m_40401_().m_7344_() == SoundEvents.f_11680_ || armorItem.m_40401_().m_7344_() == SoundEvents.f_11675_)) {
            return null;
        }
        return (SoundEvent)ModSounds.HAUNTED_ARMOR_STEP.get();
    }

    protected void m_7355_(BlockPos p_34316_, BlockState p_34317_) {
        if (this.getStepSound() != null) {
            this.m_5496_(this.getStepSound(), 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.4f);
        }
    }

    @Override
    public boolean m_7301_(MobEffectInstance pPotioneffect) {
        return pPotioneffect.m_19544_().m_19485_().containsKey(Attributes.f_22284_);
    }

    @Override
    public void m_6667_(DamageSource pCause) {
        super.m_6667_(pCause);
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 20; ++i) {
                ServerParticleUtil.addParticlesAroundSelf(serverLevel, (ParticleOptions)ParticleTypes.f_123762_, (Entity)this);
            }
        }
    }

    @Override
    public void m_8119_() {
        AttributeInstance attributeinstance;
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && (attributeinstance = this.m_21051_(Attributes.f_22279_)) != null) {
            if ((this.m_5448_() != null || this.m_5912_()) && !attributeinstance.m_22109_(SPEED_MODIFIER_HOSTILE)) {
                attributeinstance.m_22118_(SPEED_MODIFIER_HOSTILE);
            } else if (attributeinstance.m_22109_(SPEED_MODIFIER_HOSTILE)) {
                attributeinstance.m_22130_(SPEED_MODIFIER_HOSTILE);
            }
        }
        if (this.isGuarding()) {
            ++this.blockTime;
            int total = MathHelper.secondsToTicks(3 + this.f_19853_.f_46441_.m_188503_(3));
            if (this.blockTime > total) {
                this.coolTime = total * 2;
                this.setGuarding(false);
            }
        } else {
            this.blockTime = 0;
            if (this.coolTime > 0) {
                --this.coolTime;
            }
        }
        if (!this.m_20077_() && !this.isInFluidType((FluidType)ForgeMod.LAVA_TYPE.get())) {
            this.m_20095_();
        }
        if (this.breakShield > 0) {
            --this.breakShield;
        }
        if (!(!this.m_21515_() || this.m_21033_(EquipmentSlot.HEAD) || this.m_21033_(EquipmentSlot.CHEST) || this.m_21033_(EquipmentSlot.LEGS) || this.m_21033_(EquipmentSlot.FEET))) {
            this.m_6074_();
        }
        if (this.f_19853_.f_46443_) {
            for (int i = 0; i < 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        Level entity;
        ShieldBlockEvent ev;
        boolean flag = false;
        if (amount > 0.0f && this.m_21275_(source) && !(ev = ForgeHooks.onShieldBlock((LivingEntity)this, (DamageSource)source, (float)amount)).isCanceled()) {
            if (ev.shieldTakesDamage()) {
                this.m_7909_(amount);
            }
            amount -= ev.getBlockedDamage();
            if (!source.m_269533_(DamageTypeTags.f_268524_) && (entity = source.m_7640_()) instanceof LivingEntity) {
                this.m_6728_((LivingEntity)entity);
            }
            flag = true;
        }
        if (source.m_269533_(DamageTypeTags.f_268745_) && !source.m_276093_(DamageTypes.f_268546_)) {
            return false;
        }
        if (flag) {
            this.m_5496_(SoundEvents.f_12346_, 1.0f, 0.8f + this.f_19853_.f_46441_.m_188501_() * 0.4f);
            this.f_19853_.m_7605_((Entity)this, (byte)29);
            if (amount <= 1.0f) {
                return false;
            }
        }
        if (!(this.isGuarding() || this.coolTime <= 0 || this.canDisableShield(source) || source.m_269533_(DamageTypeTags.f_268490_))) {
            this.coolTime -= (int)(amount * 10.0f);
        }
        if ((entity = this.f_19853_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)entity;
            if (!this.m_21275_(source) && !this.m_6844_(EquipmentSlot.CHEST).m_41619_()) {
                int j = (int)Math.min(amount, 10.0f);
                for (int i = 0; i < j; ++i) {
                    ServerParticleUtil.addParticlesAroundSelf(serverLevel, (ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, this.m_6844_(EquipmentSlot.CHEST)), (Entity)this);
                }
            }
        }
        return super.m_6469_(source, amount);
    }

    public boolean canDisableShield(DamageSource damageSource) {
        Entity entity = damageSource.m_7640_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity.m_21205_().canDisableShield(this.f_20935_, (LivingEntity)this, livingEntity);
        }
        return false;
    }

    protected void m_6728_(LivingEntity p_36295_) {
        super.m_6728_(p_36295_);
        if (p_36295_.m_21205_().canDisableShield(this.f_20935_, (LivingEntity)this, p_36295_)) {
            this.disableShield(true);
        }
    }

    public void disableShield(boolean p_36385_) {
        float f = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)this) * 0.05f;
        if (p_36385_) {
            f += 0.75f;
        }
        if (this.f_19796_.m_188501_() < f) {
            this.coolTime = MathHelper.secondsToTicks(15);
            this.breakShield = 10;
            this.setGuarding(false);
            this.m_5810_();
            this.m_6674_(InteractionHand.OFF_HAND);
            this.m_5496_(SoundEvents.f_12347_, 2.0f, 0.8f + this.f_19853_.f_46441_.m_188501_() * 0.4f);
            this.f_19853_.m_7605_((Entity)this, (byte)30);
        }
    }

    protected void m_7909_(float p_36383_) {
        if (this.f_20935_.canPerformAction(ToolActions.SHIELD_BLOCK) && p_36383_ >= 3.0f) {
            int i = 1 + Mth.m_14143_((float)p_36383_);
            InteractionHand interactionhand = this.m_7655_();
            this.f_20935_.m_41622_(i, (LivingEntity)this, p_219739_ -> p_219739_.m_21190_(interactionhand));
            if (this.f_20935_.m_41619_()) {
                if (interactionhand == InteractionHand.MAIN_HAND) {
                    this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                } else {
                    this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                }
                this.f_20935_ = ItemStack.f_41583_;
                this.m_5496_(SoundEvents.f_12347_, 2.0f, 0.8f + this.f_19853_.f_46441_.m_188501_() * 0.4f);
            }
        }
    }

    public void m_7822_(byte p_20975_) {
        if (p_20975_ == 29) {
            this.m_5496_(SoundEvents.f_12346_, 1.0f, 0.8f + this.f_19853_.f_46441_.m_188501_() * 0.4f);
        } else if (p_20975_ == 30) {
            this.m_5496_(SoundEvents.f_12347_, 2.0f, 0.8f + this.f_19853_.f_46441_.m_188501_() * 0.4f);
            this.breakShield = 10;
        }
        super.m_7822_(p_20975_);
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        if (!this.f_19853_.f_46443_) {
            ItemStack itemstack = pPlayer.m_21120_(pHand);
            if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner() && itemstack.m_150930_((Item)ModItems.ECTOPLASM.get()) && this.m_21223_() < this.m_21233_()) {
                if (!pPlayer.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_5496_((SoundEvent)ModSounds.HAUNTED_ARMOR_AMBIENT.get(), 1.0f, 1.25f);
                this.m_5634_(2.0f);
                Level level = this.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    for (int i = 0; i < 7; ++i) {
                        double d0 = this.f_19796_.m_188583_() * 0.02;
                        double d1 = this.f_19796_.m_188583_() * 0.02;
                        double d2 = this.f_19796_.m_188583_() * 0.02;
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.HEAL_EFFECT.get()), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                    }
                }
                pPlayer.m_6674_(pHand);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public static class AttackGoal
    extends ModMeleeAttackGoal {
        private final AbstractHauntedArmor mob;

        public AttackGoal(AbstractHauntedArmor p_25552_, double speed, boolean needSight) {
            super(p_25552_, speed, needSight);
            this.mob = p_25552_;
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && !this.mob.isGuarding();
        }

        @Override
        public void m_8041_() {
            super.m_8041_();
            this.mob.m_21561_(false);
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            this.mob.m_21561_(true);
        }

        @Override
        protected double defaultAttackReachSqr(LivingEntity target) {
            return this.mob.m_20205_() * 2.5f * this.mob.m_20205_() * 2.5f + target.m_20205_();
        }
    }

    public static class GuardingGoal
    extends Goal {
        private final AbstractHauntedArmor mob;
        private final double speedModifier;
        private final float attackRadiusSqr;
        private int seeTime;
        private boolean strafingClockwise;
        private boolean strafingBackwards;
        private int strafingTime = -1;
        private int ticksUntilNextAttack;

        public GuardingGoal(AbstractHauntedArmor p_25792_, double speed, float radius) {
            this.mob = p_25792_;
            this.speedModifier = speed;
            this.attackRadiusSqr = radius * radius;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.mob.m_5448_() != null && this.mob.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof ShieldItem && !this.mob.m_21093_(itemstack -> itemstack.m_41720_() instanceof ProjectileWeaponItem) && this.mob.coolTime <= 0;
        }

        public boolean m_8045_() {
            return this.m_8036_() || !this.mob.m_21573_().m_26571_();
        }

        public void m_8056_() {
            super.m_8056_();
            this.ticksUntilNextAttack = 0;
            this.mob.m_6672_(InteractionHand.OFF_HAND);
            this.mob.setGuarding(true);
        }

        public void m_8041_() {
            super.m_8041_();
            this.mob.setGuarding(false);
            this.mob.m_5810_();
            this.mob.m_21573_().m_26573_();
            this.mob.m_21564_(0.0f);
            this.mob.m_21570_(0.0f);
            this.seeTime = 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity != null) {
                boolean flag1;
                double d0 = this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
                boolean flag = this.mob.m_21574_().m_148306_((Entity)livingentity);
                boolean bl = flag1 = this.seeTime > 0;
                if (flag != flag1) {
                    this.seeTime = 0;
                }
                this.seeTime = flag ? ++this.seeTime : --this.seeTime;
                if (!(d0 > (double)this.attackRadiusSqr) && this.seeTime >= 20) {
                    this.mob.m_21573_().m_26573_();
                    ++this.strafingTime;
                } else {
                    this.mob.m_21573_().m_5624_((Entity)livingentity, this.speedModifier);
                    this.strafingTime = -1;
                }
                if (this.strafingTime >= 20) {
                    if ((double)this.mob.m_217043_().m_188501_() < 0.3) {
                        boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                    }
                    if ((double)this.mob.m_217043_().m_188501_() < 0.3) {
                        this.strafingBackwards = !this.strafingBackwards;
                    }
                    this.strafingTime = 0;
                }
                if (this.strafingTime > -1) {
                    if (d0 > (double)(this.attackRadiusSqr * 0.75f)) {
                        this.strafingBackwards = false;
                    } else if (d0 < (double)(this.attackRadiusSqr * 0.25f)) {
                        this.strafingBackwards = true;
                    }
                    this.mob.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                    this.mob.m_21391_((Entity)livingentity, 30.0f, 30.0f);
                } else {
                    this.mob.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
                }
                this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
                this.checkAndPerformAttack(livingentity, d0);
            }
        }

        protected void checkAndPerformAttack(LivingEntity p_25557_, double p_25558_) {
            double d0 = this.getAttackReachSqr(p_25557_);
            if (p_25558_ <= d0 && this.ticksUntilNextAttack <= 0) {
                this.resetAttackCooldown();
                this.mob.m_6674_(InteractionHand.MAIN_HAND);
                this.mob.m_7327_((Entity)p_25557_);
            }
        }

        protected void resetAttackCooldown() {
            this.ticksUntilNextAttack = this.m_183277_(20);
        }

        protected double getAttackReachSqr(LivingEntity p_25556_) {
            return this.mob.m_20205_() * 2.0f * this.mob.m_20205_() * 2.0f + p_25556_.m_20205_();
        }
    }

    public static enum HauntedArmPose {
        IDLE,
        GUARD,
        BOW,
        CROSSBOW_HOLD,
        CROSSBOW_CHARGE,
        ATTACK;

    }
}

