/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.neutral;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.ally.undead.MuckWraithServant;
import com.Polarice3.Goety.common.entities.ally.undead.ReaperServant;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.AbstractSkeletonServant;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.MossySkeletonServant;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.VanguardServant;
import com.Polarice3.Goety.common.entities.ally.undead.zombie.BlackguardServant;
import com.Polarice3.Goety.common.entities.ally.undead.zombie.JungleZombieServant;
import com.Polarice3.Goety.common.entities.neutral.AbstractNecromancer;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.entities.projectiles.SoulBolt;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.magic.spells.SoulBoltSpell;
import com.Polarice3.Goety.config.MobsConfig;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import com.Polarice3.Goety.utils.SoundUtil;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class AbstractMossyNecromancer
extends AbstractNecromancer {
    public AbstractMossyNecromancer(EntityType<? extends AbstractSkeletonServant> type, Level level) {
        super(type, level);
    }

    @Override
    public void projectileGoal(int priority) {
        this.f_21345_.m_25352_(priority, (Goal)new AbstractNecromancer.NecromancerRangedGoal(this, 1.0, 20, 10.0f));
    }

    @Override
    public void summonSpells(int priority) {
        this.f_21345_.m_25352_(priority, (Goal)new SummonServantSpell());
        this.f_21345_.m_25352_(priority + 1, (Goal)new AbstractNecromancer.SummonUndeadGoal(this));
    }

    @Override
    public void m_6504_(@NotNull LivingEntity p_33317_, float p_33318_) {
        if (this.getNecroLevel() <= 0) {
            new SoulBoltSpell().mobSpellResult((LivingEntity)this, ((Item)ModItems.WILD_STAFF.get()).m_7968_());
        } else {
            for (int i = -this.getNecroLevel(); i <= this.getNecroLevel(); ++i) {
                Vec3 vector3d = this.m_20252_(1.0f);
                SoulBolt soulBolt = new SoulBolt((LivingEntity)this, vector3d.f_82479_ + (double)((float)i / 10.0f), vector3d.f_82480_, vector3d.f_82481_ + (double)((float)i / 10.0f), this.f_19853_);
                soulBolt.m_6034_(this.m_20185_() + vector3d.f_82479_ / 2.0, this.m_20188_() - 0.2, this.m_20189_() + vector3d.f_82481_ / 2.0);
                if (!this.f_19853_.m_7967_((Entity)soulBolt)) continue;
                SoundUtil.playSoulBolt((LivingEntity)this);
                this.m_6674_(InteractionHand.MAIN_HAND);
            }
        }
    }

    @Override
    public Summoned getDefaultSummon() {
        return new JungleZombieServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.JUNGLE_ZOMBIE_SERVANT.get()), this.f_19853_);
    }

    @Override
    public Summoned getSummon() {
        Summoned summoned = this.getDefaultSummon();
        if (this.getSummonList().stream().anyMatch(entityType -> entityType.m_204039_(ModTags.EntityTypes.ZOMBIE_SERVANTS)) && this.f_19853_.f_46441_.m_188499_()) {
            summoned = new JungleZombieServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.JUNGLE_ZOMBIE_SERVANT.get()), this.f_19853_);
        }
        if (this.getSummonList().stream().anyMatch(entityType -> entityType.m_204039_(ModTags.EntityTypes.SKELETON_SERVANTS)) && this.f_19853_.f_46441_.m_188499_()) {
            summoned = new MossySkeletonServant((EntityType<? extends AbstractSkeletonServant>)((EntityType)ModEntityType.MOSSY_SKELETON_SERVANT.get()), this.f_19853_);
        }
        if (this.getSummonList().contains(ModEntityType.WRAITH_SERVANT.get()) && this.f_19853_.f_46441_.m_188501_() <= 0.05f) {
            summoned = new MuckWraithServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.MUCK_WRAITH_SERVANT.get()), this.f_19853_);
        }
        if (this.getSummonList().contains(ModEntityType.REAPER_SERVANT.get()) && this.f_19853_.f_46441_.m_188501_() <= 0.05f) {
            summoned = new ReaperServant((EntityType<? extends Owned>)((EntityType)ModEntityType.REAPER_SERVANT.get()), this.f_19853_);
        }
        if (this.getSummonList().contains(ModEntityType.VANGUARD_SERVANT.get()) && this.f_19853_.f_46441_.m_188501_() <= 0.15f) {
            summoned = new VanguardServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.VANGUARD_SERVANT.get()), this.f_19853_);
        }
        if (this.getSummonList().contains(ModEntityType.BLACKGUARD_SERVANT.get()) && this.f_19853_.f_46441_.m_188501_() <= 0.05f) {
            summoned = new BlackguardServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.BLACKGUARD_SERVANT.get()), this.f_19853_);
        }
        return summoned;
    }

    @Override
    public boolean summonVariants() {
        return this.f_19853_.m_46801_(this.m_20183_());
    }

    public class SummonServantSpell
    extends AbstractNecromancer.SummoningSpellGoal {
        public SummonServantSpell() {
            super(AbstractMossyNecromancer.this);
        }

        @Override
        public boolean m_8036_() {
            Predicate<Entity> predicate = entity -> {
                IOwned owned;
                return entity.m_6084_() && entity instanceof IOwned && (owned = (IOwned)entity).getTrueOwner() == AbstractMossyNecromancer.this;
            };
            int i = AbstractMossyNecromancer.this.f_19853_.m_6443_(LivingEntity.class, AbstractMossyNecromancer.this.m_20191_().m_82377_(64.0, 16.0, 64.0), predicate).size();
            return super.m_8036_() && i < 6;
        }

        @Override
        protected void castSpell() {
            Level level = AbstractMossyNecromancer.this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i1 = 0; i1 < 2; ++i1) {
                    Summoned summonedentity = AbstractMossyNecromancer.this.getSummon();
                    BlockPos blockPos = BlockFinder.SummonRadius(AbstractMossyNecromancer.this.m_20183_(), (Entity)summonedentity, (Level)serverLevel);
                    summonedentity.setTrueOwner((LivingEntity)AbstractMossyNecromancer.this);
                    summonedentity.m_20035_(blockPos, 0.0f, 0.0f);
                    MobUtil.moveDownToGround((Entity)summonedentity);
                    if (((Boolean)MobsConfig.NecromancerSummonsLife.get()).booleanValue()) {
                        summonedentity.setLimitedLife(MobUtil.getSummonLifespan((Level)serverLevel));
                    }
                    summonedentity.m_21530_();
                    summonedentity.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(AbstractMossyNecromancer.this.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                    if (!serverLevel.m_7967_((Entity)summonedentity)) continue;
                    SoundUtil.playNecromancerSummon((Entity)summonedentity);
                    ColorUtil colorUtil = new ColorUtil(2804175);
                    ServerParticleUtil.windShockwaveParticle(serverLevel, colorUtil, 0.1f, 0.1f, 0.05f, -1, summonedentity.m_20182_());
                }
            }
        }

        @Override
        protected AbstractNecromancer.NecromancerSpellType getNecromancerSpellType() {
            return AbstractNecromancer.NecromancerSpellType.ZOMBIE;
        }
    }
}

