/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.neutral;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.client.particles.MagicSmokeParticle;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.ally.undead.ReaperServant;
import com.Polarice3.Goety.common.entities.ally.undead.WraithServant;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.AbstractSkeletonServant;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.VanguardServant;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.WitherSkeletonServant;
import com.Polarice3.Goety.common.entities.ally.undead.zombie.BlackguardServant;
import com.Polarice3.Goety.common.entities.neutral.AbstractNecromancer;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.entities.neutral.ZPiglinServant;
import com.Polarice3.Goety.common.entities.projectiles.WitherBolt;
import com.Polarice3.Goety.common.entities.util.FirePillar;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.items.revive.SoulJar;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.config.MobsConfig;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import com.Polarice3.Goety.utils.SoundUtil;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class AbstractWitherNecromancer
extends AbstractNecromancer {
    public AbstractWitherNecromancer(EntityType<? extends AbstractNecromancer> type, Level level) {
        super((EntityType<? extends AbstractSkeletonServant>)type, level);
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
    }

    @Override
    public void projectileGoal(int priority) {
        this.f_21345_.m_25352_(priority, (Goal)new WitherNecromancerRangedGoal(this, 1.0, 20, 12.0f));
    }

    @Override
    public void avoidGoal(int priority) {
    }

    @Override
    public void summonSpells(int priority) {
        this.f_21345_.m_25352_(priority + 1, (Goal)new SummonServantSpell());
        this.f_21345_.m_25352_(priority + 2, (Goal)new WitherSummonUndeadGoal());
        this.f_21345_.m_25352_(priority, (Goal)new SummonFirePillarsGoal());
        this.f_21345_.m_25352_(priority, (Goal)new SummonFireSurroundGoal());
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.WitherNecromancerHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.WitherNecromancerArmor.get()).doubleValue()).m_22268_(Attributes.f_22277_, ((Double)AttributesConfig.WitherNecromancerFollowRange.get()).doubleValue()).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.WitherNecromancerDamage.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.WitherNecromancerHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.WitherNecromancerArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22277_), (Double)AttributesConfig.WitherNecromancerFollowRange.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.NecromancerDamage.get());
    }

    @Override
    public Predicate<Entity> summonPredicate() {
        return entity -> entity instanceof AbstractWitherNecromancer;
    }

    @Override
    public int getSummonLimit(LivingEntity owner) {
        return (Integer)SpellConfig.WitherNecromancerLimit.get();
    }

    @Override
    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        float f1 = this.getNecroLevel();
        float size = 1.0f + Math.max(f1 * 0.15f, 0.0f);
        return 2.523f * size;
    }

    @Override
    public int xpReward() {
        return 40;
    }

    @Override
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.WITHER_NECROMANCER_AMBIENT.get();
    }

    @Override
    protected SoundEvent m_7975_(@NotNull DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.WITHER_NECROMANCER_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.WITHER_NECROMANCER_DEATH.get();
    }

    @Override
    protected SoundEvent getStepSound() {
        return SoundEvents.f_12562_;
    }

    @Override
    public void spellCastParticles() {
        for (int i = 0; i < this.f_19853_.f_46441_.m_188503_(35) + 10; ++i) {
            this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.TOTEM_EFFECT.get(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.45, 0.45, 0.45);
        }
    }

    @Override
    public void m_6504_(@NotNull LivingEntity p_33317_, float p_33318_) {
        Vec3 vector3d = this.m_20252_(1.0f);
        WitherBolt witherBolt = new WitherBolt((LivingEntity)this, vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_, this.f_19853_);
        witherBolt.m_5602_((Entity)this);
        witherBolt.m_6034_(this.m_20185_() + vector3d.f_82479_ / 2.0, this.m_20188_() - 0.2, this.m_20189_() + vector3d.f_82481_ / 2.0);
        witherBolt.rotateToMatchMovement();
        if (this.f_19853_.m_7967_((Entity)witherBolt)) {
            this.m_5496_(SoundEvents.f_12558_, 0.5f, 0.25f);
            this.m_216990_((SoundEvent)ModSounds.HELL_BOLT_SHOOT.get());
            this.m_6674_(InteractionHand.MAIN_HAND);
        }
    }

    @Override
    public boolean m_7327_(Entity p_34169_) {
        if (!super.m_7327_(p_34169_)) {
            return false;
        }
        if (p_34169_ instanceof LivingEntity) {
            ((LivingEntity)p_34169_).m_147207_(new MobEffectInstance(MobEffects.f_19615_, 200), (Entity)this);
        }
        return true;
    }

    @Override
    public boolean m_7301_(MobEffectInstance p_34192_) {
        return p_34192_.m_19544_() != MobEffects.f_19615_ && super.m_7301_(p_34192_);
    }

    @Override
    public void playLaughSound() {
        this.m_5496_((SoundEvent)ModSounds.NECROMANCER_LAUGH.get(), 1.0f, 0.05f);
    }

    @Override
    public Summoned getDefaultSummon() {
        return new WitherSkeletonServant((EntityType<? extends WitherSkeletonServant>)((EntityType)ModEntityType.WITHER_SKELETON_SERVANT.get()), this.f_19853_);
    }

    @Override
    public Summoned getSummon() {
        Summoned summoned = this.getDefaultSummon();
        if (this.getSummonList().stream().anyMatch(entityType -> entityType.m_204039_(ModTags.EntityTypes.ZOMBIE_SERVANTS)) && this.f_19853_.f_46441_.m_188499_()) {
            summoned = new ZPiglinServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.ZPIGLIN_SERVANT.get()), this.f_19853_);
        }
        if (this.getSummonList().stream().anyMatch(entityType -> entityType.m_204039_(ModTags.EntityTypes.SKELETON_SERVANTS)) && this.f_19853_.f_46441_.m_188499_()) {
            summoned = new WitherSkeletonServant((EntityType<? extends WitherSkeletonServant>)((EntityType)ModEntityType.WITHER_SKELETON_SERVANT.get()), this.f_19853_);
        }
        if (this.getSummonList().contains(ModEntityType.WRAITH_SERVANT.get()) && this.f_19853_.f_46441_.m_188501_() <= 0.05f) {
            summoned = new WraithServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.WRAITH_SERVANT.get()), this.f_19853_);
        }
        if (this.getSummonList().contains(ModEntityType.REAPER_SERVANT.get()) && this.f_19853_.f_46441_.m_188501_() <= 0.05f) {
            summoned = new ReaperServant((EntityType<? extends Owned>)((EntityType)ModEntityType.REAPER_SERVANT.get()), this.f_19853_);
        }
        if (this.getSummonList().contains(ModEntityType.VANGUARD_SERVANT.get()) && this.f_19853_.f_46441_.m_188501_() <= 0.15f) {
            summoned = new VanguardServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.VANGUARD_SERVANT.get()), this.f_19853_);
        }
        if (this.getSummonList().contains(ModEntityType.BLACKGUARD_SERVANT.get()) && this.f_19853_.f_46441_.m_188501_() <= 0.05f) {
            summoned = new BlackguardServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.BLACKGUARD_SERVANT.get()), this.f_19853_);
        }
        return summoned;
    }

    @Override
    public void setNecroLevel(int shot) {
        int i = Mth.m_14045_((int)shot, (int)0, (int)2);
        this.f_19804_.m_135381_(LEVEL, (Object)i);
        AttributeInstance attributeInstance = this.m_21051_(Attributes.f_22276_);
        if (attributeInstance != null) {
            attributeInstance.m_22100_((Double)AttributesConfig.WitherNecromancerHealth.get() * (double)Math.max((float)i * 1.25f, 1.0f));
        }
        this.m_20090_();
        this.m_6210_();
    }

    @Override
    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        if (!this.f_19853_.f_46443_) {
            ItemStack itemstack = pPlayer.m_21120_(pHand);
            if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner()) {
                if (SoulJar.isWither(itemstack)) {
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    if (this.getNecroLevel() < 2) {
                        this.setNecroLevel(this.getNecroLevel() + 1);
                    }
                    this.m_5634_(((Double)AttributesConfig.WitherNecromancerHealth.get()).floatValue());
                    Level level = this.f_19853_;
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        for (int i = 0; i < 7; ++i) {
                            double d0 = this.f_19796_.m_188583_() * 0.02;
                            double d1 = this.f_19796_.m_188583_() * 0.02;
                            double d2 = this.f_19796_.m_188583_() * 0.02;
                            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_235898_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                        }
                    }
                    this.playLaughSound();
                    return InteractionResult.SUCCESS;
                }
                if (!itemstack.m_150930_((Item)ModItems.SOUL_JAR.get())) {
                    return super.m_6071_(pPlayer, pHand);
                }
            }
        }
        return InteractionResult.PASS;
    }

    public class WitherNecromancerRangedGoal
    extends AbstractNecromancer.NecromancerRangedGoal {
        public WitherNecromancerRangedGoal(AbstractNecromancer mob, double speed, int attackInterval, float attackRadius) {
            super(mob, speed, attackInterval, attackRadius);
        }

        @Override
        public boolean m_8036_() {
            LivingEntity livingentity = AbstractWitherNecromancer.this.m_5448_();
            if (livingentity != null) {
                return super.m_8036_() && AbstractWitherNecromancer.this.m_142582_((Entity)livingentity);
            }
            return false;
        }
    }

    public class SummonServantSpell
    extends AbstractNecromancer.SummoningSpellGoal {
        @Override
        public boolean m_8036_() {
            Predicate<Entity> predicate = entity -> {
                IOwned owned;
                return entity.m_6084_() && entity instanceof IOwned && (owned = (IOwned)entity).getTrueOwner() == AbstractWitherNecromancer.this;
            };
            int i = AbstractWitherNecromancer.this.f_19853_.m_6443_(LivingEntity.class, AbstractWitherNecromancer.this.m_20191_().m_82377_(64.0, 16.0, 64.0), predicate).size();
            return super.m_8036_() && i < 6;
        }

        @Override
        public void m_8037_() {
            --this.spellTime;
            if (this.spellTime == 10) {
                if (this.getCastSound() != null) {
                    AbstractWitherNecromancer.this.m_5496_(this.getCastSound(), 1.0f, 1.0f);
                }
                AbstractWitherNecromancer.this.m_5496_((SoundEvent)ModSounds.NECROMANCER_LAUGH.get(), 2.0f, 0.05f);
                this.castSpell();
                AbstractWitherNecromancer.this.setNecromancerSpellType(AbstractNecromancer.NecromancerSpellType.NONE);
            }
        }

        @Override
        protected void castSpell() {
            Level level = AbstractWitherNecromancer.this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i1 = 0; i1 < 2; ++i1) {
                    Summoned summoned = AbstractWitherNecromancer.this.getSummon();
                    BlockPos blockPos = BlockFinder.SummonRadius(AbstractWitherNecromancer.this.m_20183_(), (Entity)summoned, (Level)serverLevel);
                    summoned.setTrueOwner((LivingEntity)AbstractWitherNecromancer.this);
                    summoned.m_20035_(blockPos, 0.0f, 0.0f);
                    MobUtil.moveDownToGround((Entity)summoned);
                    if (!AbstractWitherNecromancer.this.m_6095_().m_204039_(ModTags.EntityTypes.MINI_BOSSES) && ((Boolean)MobsConfig.NecromancerSummonsLife.get()).booleanValue()) {
                        summoned.setLimitedLife(MobUtil.getSummonLifespan((Level)serverLevel));
                    }
                    summoned.m_21530_();
                    summoned.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(AbstractWitherNecromancer.this.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                    if (!serverLevel.m_7967_((Entity)summoned)) continue;
                    SoundUtil.playNecromancerSummon((Entity)summoned);
                    ColorUtil colorUtil = new ColorUtil(2804175);
                    ServerParticleUtil.windShockwaveParticle(serverLevel, colorUtil, 0.1f, 0.1f, 0.05f, -1, summoned.m_20182_());
                    for (int i2 = 0; i2 < serverLevel.m_213780_().m_188503_(10) + 10; ++i2) {
                        serverLevel.m_8767_((ParticleOptions)new MagicSmokeParticle.Option(1552608, 0xFFFFFF, 10 + serverLevel.m_213780_().m_188503_(10), 0.2f), summoned.m_20208_(1.5), summoned.m_20187_(), summoned.m_20262_(1.5), 0, 0.0, 0.0, 0.0, 1.0);
                    }
                }
            }
        }

        @Override
        protected int getCastingInterval() {
            return 200;
        }

        @Override
        protected AbstractNecromancer.NecromancerSpellType getNecromancerSpellType() {
            return AbstractNecromancer.NecromancerSpellType.ZOMBIE;
        }
    }

    public class WitherSummonUndeadGoal
    extends AbstractNecromancer.SummonUndeadGoal {
        @Override
        public void playLaughSound() {
            AbstractWitherNecromancer.this.m_5496_((SoundEvent)ModSounds.NECROMANCER_LAUGH.get(), 2.0f, 0.05f);
        }
    }

    public class SummonFirePillarsGoal
    extends Goal {
        protected int spellTime;

        public boolean m_8036_() {
            LivingEntity target = AbstractWitherNecromancer.this.m_5448_();
            if (AbstractWitherNecromancer.this.isSpellCasting()) {
                return false;
            }
            return target != null && target.m_6084_() && AbstractWitherNecromancer.this.f_19796_.m_188499_() && AbstractWitherNecromancer.this.idleSpellCool <= 0;
        }

        public boolean m_8045_() {
            return this.spellTime > 0;
        }

        public void m_8056_() {
            this.spellTime = MathHelper.secondsToTicks(3);
            AbstractWitherNecromancer.this.setSpellCooldown(AbstractWitherNecromancer.this.getSpellCooldown() + 60);
            AbstractWitherNecromancer.this.m_5496_((SoundEvent)ModSounds.RUMBLE.get(), 1.0f, 1.0f);
            AbstractWitherNecromancer.this.setSpellCasting(true);
            AbstractWitherNecromancer.this.setNecromancerSpellType(AbstractNecromancer.NecromancerSpellType.CLOUD);
            AbstractWitherNecromancer.this.setAnimationState(AbstractNecromancer.SPELL_ANIM);
            Level level = AbstractWitherNecromancer.this.f_19853_;
            if (level instanceof ServerLevel) {
                FirePillar flames;
                float f2;
                int k;
                ServerLevel serverLevel = (ServerLevel)level;
                int warmUp = 20;
                int duration = 180;
                Vec3 vector3d = AbstractWitherNecromancer.this.m_20252_(1.0f);
                float f = (float)Mth.m_14136_((double)(vector3d.f_82481_ - AbstractWitherNecromancer.this.m_20189_()), (double)(vector3d.f_82479_ - AbstractWitherNecromancer.this.m_20185_()));
                for (k = 0; k < 8; ++k) {
                    f2 = f + (float)k * (float)Math.PI * 0.25f + 1.0f;
                    flames = new FirePillar((Level)serverLevel, AbstractWitherNecromancer.this.m_20185_() + (double)Mth.m_14089_((float)f2), AbstractWitherNecromancer.this.m_20186_(), AbstractWitherNecromancer.this.m_20189_() + (double)Mth.m_14031_((float)f2));
                    flames.setOwner((LivingEntity)AbstractWitherNecromancer.this);
                    flames.setDuration(duration);
                    flames.setWarmUp(warmUp);
                    MobUtil.moveDownToGround(flames);
                    serverLevel.m_7967_((Entity)flames);
                }
                for (k = 0; k < 8; ++k) {
                    f2 = f + (float)k * (float)Math.PI * 0.25f + 3.0f;
                    flames = new FirePillar((Level)serverLevel, AbstractWitherNecromancer.this.m_20185_() + (double)Mth.m_14089_((float)f2) * 3.0, AbstractWitherNecromancer.this.m_20186_(), AbstractWitherNecromancer.this.m_20189_() + (double)Mth.m_14031_((float)f2) * 3.0);
                    flames.setOwner((LivingEntity)AbstractWitherNecromancer.this);
                    flames.setDuration(duration);
                    flames.setWarmUp(warmUp);
                    MobUtil.moveDownToGround(flames);
                    serverLevel.m_7967_((Entity)flames);
                }
                for (k = 0; k < 8; ++k) {
                    f2 = f + (float)k * (float)Math.PI * 0.25f + 6.0f;
                    flames = new FirePillar((Level)serverLevel, AbstractWitherNecromancer.this.m_20185_() + (double)Mth.m_14089_((float)f2) * 6.0, AbstractWitherNecromancer.this.m_20186_(), AbstractWitherNecromancer.this.m_20189_() + (double)Mth.m_14031_((float)f2) * 6.0);
                    flames.setOwner((LivingEntity)AbstractWitherNecromancer.this);
                    flames.setDuration(duration);
                    flames.setWarmUp(warmUp);
                    MobUtil.moveDownToGround(flames);
                    serverLevel.m_7967_((Entity)flames);
                }
                for (k = 0; k < 16; ++k) {
                    f2 = f + (float)k * (float)Math.PI * 0.25f + 9.0f;
                    flames = new FirePillar((Level)serverLevel, AbstractWitherNecromancer.this.m_20185_() + (double)Mth.m_14089_((float)f2) * 9.0, AbstractWitherNecromancer.this.m_20186_(), AbstractWitherNecromancer.this.m_20189_() + (double)Mth.m_14031_((float)f2) * 9.0);
                    flames.setOwner((LivingEntity)AbstractWitherNecromancer.this);
                    flames.setDuration(duration);
                    flames.setWarmUp(warmUp);
                    MobUtil.moveDownToGround(flames);
                    serverLevel.m_7967_((Entity)flames);
                }
            }
        }

        public void m_8041_() {
            super.m_8041_();
            AbstractWitherNecromancer.this.setSpellCasting(false);
            AbstractWitherNecromancer.this.setAnimationState(AbstractNecromancer.IDLE);
        }

        public void m_8037_() {
            --this.spellTime;
            if (this.spellTime == 0) {
                AbstractWitherNecromancer.this.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.TANGLED.get(), 180, 0, false, false));
                AbstractWitherNecromancer.this.setNecromancerSpellType(AbstractNecromancer.NecromancerSpellType.NONE);
                AbstractWitherNecromancer.this.idleSpellCool = MathHelper.secondsToTicks(10);
            }
        }

        public boolean m_183429_() {
            return true;
        }
    }

    public class SummonFireSurroundGoal
    extends Goal {
        protected int spellTime;

        public boolean m_8036_() {
            LivingEntity target = AbstractWitherNecromancer.this.m_5448_();
            if (AbstractWitherNecromancer.this.isSpellCasting()) {
                return false;
            }
            return target != null && target.m_6084_() && AbstractWitherNecromancer.this.f_19796_.m_188499_() && AbstractWitherNecromancer.this.idleSpellCool <= 0;
        }

        public boolean m_8045_() {
            LivingEntity target = AbstractWitherNecromancer.this.m_5448_();
            return this.spellTime > 0 && target != null && target.m_6084_();
        }

        public void m_8056_() {
            this.spellTime = MathHelper.secondsToTicks(3);
            AbstractWitherNecromancer.this.setSpellCooldown(AbstractWitherNecromancer.this.getSpellCooldown() + 60);
            AbstractWitherNecromancer.this.m_5496_((SoundEvent)ModSounds.RUMBLE.get(), 1.0f, 1.0f);
            AbstractWitherNecromancer.this.setSpellCasting(true);
            AbstractWitherNecromancer.this.setNecromancerSpellType(AbstractNecromancer.NecromancerSpellType.CLOUD);
            AbstractWitherNecromancer.this.setAnimationState(AbstractNecromancer.SPELL_ANIM);
            LivingEntity target = AbstractWitherNecromancer.this.m_5448_();
            Level level = AbstractWitherNecromancer.this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (target != null && target.m_6084_()) {
                    int warmUp = 20;
                    int duration = 180;
                    List<Vec3> vec3s = BlockFinder.buildOuterBlockCircle(target.m_20182_(), 6.0);
                    for (Vec3 vec3 : vec3s) {
                        FirePillar flames = new FirePillar((Level)serverLevel, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                        flames.setOwner((LivingEntity)AbstractWitherNecromancer.this);
                        flames.setDuration(duration);
                        flames.setWarmUp(warmUp);
                        MobUtil.moveDownToGround(flames);
                        serverLevel.m_7967_((Entity)flames);
                    }
                }
            }
        }

        public void m_8041_() {
            super.m_8041_();
            AbstractWitherNecromancer.this.setSpellCasting(false);
            AbstractWitherNecromancer.this.setAnimationState(AbstractNecromancer.IDLE);
            AbstractWitherNecromancer.this.setNecromancerSpellType(AbstractNecromancer.NecromancerSpellType.NONE);
            AbstractWitherNecromancer.this.idleSpellCool = MathHelper.secondsToTicks(10);
        }

        public void m_8037_() {
            --this.spellTime;
        }

        public boolean m_183429_() {
            return true;
        }
    }
}

