/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.neutral;

import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ai.NeutralZombieAttackGoal;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.ally.illager.VindicatorServant;
import com.Polarice3.Goety.common.entities.ally.undead.zombie.ZombieServant;
import com.Polarice3.Goety.common.entities.neutral.IRavager;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;

public class AbstractZombieVindicator
extends ZombieServant {
    private static final EntityDataAccessor<Boolean> DATA_CONVERTING_ID = SynchedEntityData.m_135353_(AbstractZombieVindicator.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int villagerConversionTime;
    @Nullable
    private UUID conversionStarter;

    public AbstractZombieVindicator(EntityType<? extends ZombieServant> type, Level worldIn) {
        super((EntityType<? extends Summoned>)type, worldIn);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.ZombieVindicatorHealth.get()).doubleValue()).m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, (double)0.23f).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.ZombieVindicatorDamage.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.ZombieVindicatorArmor.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.ZombieVindicatorHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.ZombieVindicatorArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.ZombieVindicatorDamage.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CONVERTING_ID, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("ConversionTime", this.isConverting() ? this.villagerConversionTime : -1);
        if (this.conversionStarter != null) {
            pCompound.m_128362_("ConversionPlayer", this.conversionStarter);
        }
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128425_("ConversionTime", 99) && pCompound.m_128451_("ConversionTime") > -1) {
            this.startConverting(pCompound.m_128403_("ConversionPlayer") ? pCompound.m_128342_("ConversionPlayer") : null, pCompound.m_128451_("ConversionTime"));
        }
    }

    @Override
    public void m_8119_() {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.m_6084_() && this.isConverting()) {
                int i = this.getConversionProgress();
                this.villagerConversionTime -= i;
                if (this.villagerConversionTime <= 0 && ForgeEventFactory.canLivingConvert((LivingEntity)this, (EntityType)((EntityType)ModEntityType.VINDICATOR_SERVANT.get()), timer -> {
                    this.villagerConversionTime = timer;
                })) {
                    this.finishConversion(serverLevel);
                }
            }
        }
        super.m_8119_();
    }

    public boolean canConvert() {
        return this.isNatural();
    }

    @Override
    public boolean isUnderWaterConverting() {
        return false;
    }

    @Override
    public boolean m_6162_() {
        return false;
    }

    @Override
    public void m_6863_(boolean pChildZombie) {
    }

    @Override
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12615_;
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12646_;
    }

    @Override
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12645_;
    }

    @Override
    protected SoundEvent getStepSound() {
        return SoundEvents.f_12647_;
    }

    @Override
    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    @Override
    protected boolean convertsInWater() {
        return false;
    }

    @Override
    protected void handleAttributes(float difficulty) {
        Objects.requireNonNull(this.m_21051_(Attributes.f_22278_)).m_22125_(new AttributeModifier("random spawn bonus", this.f_19796_.m_188500_() * (double)0.05f, AttributeModifier.Operation.ADDITION));
        double d0 = this.f_19796_.m_188500_() * 1.5 * (double)difficulty;
        if (d0 > 1.0) {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22277_)).m_22125_(new AttributeModifier("random zombie-spawn bonus", d0, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
    }

    @Override
    protected void m_213945_(RandomSource p_219149_, DifficultyInstance p_219150_) {
        if (this.canSpawnArmor()) {
            super.m_213945_(p_219149_, p_219150_);
        }
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42386_));
    }

    public boolean isConverting() {
        return (Boolean)this.m_20088_().m_135370_(DATA_CONVERTING_ID);
    }

    private void startConverting(@Nullable UUID p_34384_, int p_34385_) {
        this.conversionStarter = p_34384_;
        this.villagerConversionTime = p_34385_;
        this.m_20088_().m_135381_(DATA_CONVERTING_ID, (Object)true);
        this.m_21195_(MobEffects.f_19613_);
        this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, p_34385_, Math.min(this.m_9236_().m_46791_().m_19028_() - 1, 0)));
        this.f_19853_.m_7605_((Entity)this, (byte)16);
    }

    public void m_7822_(byte p_34372_) {
        if (p_34372_ == 16) {
            if (!this.m_20067_()) {
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20188_(), this.m_20189_(), SoundEvents.f_12644_, this.m_5720_(), 1.0f + this.f_19796_.m_188501_(), this.f_19796_.m_188501_() * 0.7f + 0.3f, false);
            }
        } else {
            super.m_7822_(p_34372_);
        }
    }

    private void finishConversion(ServerLevel serverLevel) {
        Entity servant;
        Player player = null;
        if (this.conversionStarter != null) {
            player = serverLevel.m_46003_(this.conversionStarter);
        }
        if ((servant = MobUtil.convertTo((Entity)this, (EntityType)ModEntityType.VINDICATOR_SERVANT.get(), true, player)) instanceof VindicatorServant) {
            VindicatorServant vindicator = (VindicatorServant)servant;
            vindicator.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(servant.m_20183_()), MobSpawnType.CONVERSION, null, null);
            vindicator.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0));
            if (!this.m_20067_()) {
                serverLevel.m_5898_((Player)null, 1027, this.m_20183_(), 0);
            }
            ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)vindicator);
        }
    }

    private int getConversionProgress() {
        int i = 1;
        if (this.f_19796_.m_188501_() < 0.01f) {
            int j = 0;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int k = (int)this.m_20185_() - 4; k < (int)this.m_20185_() + 4 && j < 14; ++k) {
                for (int l = (int)this.m_20186_() - 4; l < (int)this.m_20186_() + 4 && j < 14; ++l) {
                    for (int i1 = (int)this.m_20189_() - 4; i1 < (int)this.m_20189_() + 4 && j < 14; ++i1) {
                        BlockState blockstate = this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos.m_122178_(k, l, i1));
                        if (!blockstate.m_60713_(Blocks.f_50183_) && !(blockstate.m_60734_() instanceof BedBlock)) continue;
                        if (this.f_19796_.m_188501_() < 0.3f) {
                            ++i;
                        }
                        ++j;
                    }
                }
            }
        }
        return i;
    }

    @Override
    public InteractionResult m_6071_(Player p_34394_, InteractionHand pHand) {
        ItemStack itemstack = p_34394_.m_21120_(pHand);
        if (!this.f_19853_.f_46443_ && this.canConvert() && itemstack.m_150930_(Items.f_42436_)) {
            if (this.m_21023_(MobEffects.f_19613_)) {
                if (!p_34394_.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.startConverting(p_34394_.m_20148_(), this.f_19796_.m_188503_(2401) + 3600);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6071_(p_34394_, pHand);
    }

    public static class VindicatorMeleeAttackGoal
    extends NeutralZombieAttackGoal {
        public VindicatorMeleeAttackGoal(AbstractZombieVindicator p_34123_) {
            super(p_34123_, 1.0, false);
        }

        @Override
        protected double getAttackReachSqr(LivingEntity p_34125_) {
            if (this.mob.m_20202_() instanceof IRavager) {
                float f = this.mob.m_20202_().m_20205_() - 0.1f;
                return f * 2.0f * f * 2.0f + p_34125_.m_20205_();
            }
            return super.getAttackReachSqr(p_34125_);
        }
    }
}

