/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.neutral;

import com.Polarice3.Goety.client.particles.CircleExplodeParticleOption;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ai.AvoidTargetGoal;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.neutral.BlazeServant;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.entities.projectiles.ShieldDebris;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.items.revive.BlazingHelm;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.config.MobsConfig;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModMobType;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;

public class Wildfire
extends Summoned {
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(Wildfire.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SHIELDS = SynchedEntityData.m_135353_(Wildfire.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> SHIELD_HEALTH = SynchedEntityData.m_135353_(Wildfire.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static String IDLE = "idle";
    public static String SHOCKWAVE = "shockwave";
    public static String SHOOT = "shoot";
    public int regenShieldTick;
    protected int summonCooldown;
    protected int shockwaveCooldown;
    protected int fireHealCool;
    protected int fleeingCool;
    protected float extraFireballDamage = 0.0f;
    public AnimationState spinAnimationState = new AnimationState();
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState shockwaveAnimationState = new AnimationState();
    public AnimationState shootAnimationState = new AnimationState();

    public Wildfire(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new SummonBlazes());
        this.f_21345_.m_25352_(2, (Goal)new ShockwaveAttackGoal());
        this.f_21345_.m_25352_(3, (Goal)new ShootGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new SeekFireGoal());
        this.f_21345_.m_25352_(6, (Goal)new AvoidTargetGoal<LivingEntity>((PathfinderMob)this, LivingEntity.class, 10.0f, 1.0, (double)1.3f){

            public boolean m_8036_() {
                return super.m_8036_() && !(Wildfire.this.f_19853_.m_8055_(Wildfire.this.m_20183_()).m_60734_() instanceof BaseFireBlock) && Wildfire.this.getFleeingCool() <= 0;
            }

            @Override
            public boolean m_8045_() {
                return super.m_8045_() && !(Wildfire.this.f_19853_.m_8055_(Wildfire.this.m_20183_()).m_60734_() instanceof BaseFireBlock);
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                Wildfire.this.setFleeingCool(MathHelper.secondsToTicks(5));
            }
        });
        this.f_21345_.m_25352_(7, new Summoned.WanderGoal<Wildfire>(this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new IdleGoal());
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    @Override
    public void followGoal() {
        this.f_21345_.m_25352_(4, new Summoned.FollowOwnerGoal<Wildfire>(this, 1.0, 10.0f, 2.0f));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.WildfireHealth.get()).doubleValue()).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.WildfireMeleeDamage.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.WildfireArmor.get()).doubleValue()).m_22268_(Attributes.f_22279_, 0.28).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22277_, 48.0);
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.WildfireHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.WildfireMeleeDamage.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.WildfireArmor.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIM_STATE, (Object)0);
        this.f_19804_.m_135372_(SHIELDS, (Object)4);
        this.f_19804_.m_135372_(SHIELD_HEALTH, (Object)Float.valueOf(((Double)AttributesConfig.WildfireShieldHealth.get()).floatValue()));
    }

    public void m_7350_(EntityDataAccessor<?> accessor) {
        if (ANIM_STATE.equals(accessor) && this.f_19853_.f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.idleAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.idleAnimationState);
                    break;
                }
                case 2: {
                    this.shockwaveAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.shockwaveAnimationState);
                    break;
                }
                case 3: {
                    this.shootAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.shootAnimationState);
                }
            }
        }
        super.m_7350_(accessor);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Shields", this.getShields());
        pCompound.m_128405_("RegenShieldTick", this.getRegenShieldTick());
        pCompound.m_128405_("SummonCool", this.getSummonCooldown());
        pCompound.m_128405_("ShockwaveCool", this.getShockwaveCooldown());
        pCompound.m_128405_("FireHealCool", this.getFireHealCool());
        pCompound.m_128405_("FleeingCool", this.getFleeingCool());
        pCompound.m_128350_("ShieldHealth", this.getShieldHealth());
        pCompound.m_128350_("FireballDamage", this.getFireBallDamage());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("Shields")) {
            this.setShields(pCompound.m_128451_("Shields"));
        }
        if (pCompound.m_128441_("RegenShieldTick")) {
            this.setRegenShieldTick(pCompound.m_128451_("RegenShieldTick"));
        }
        if (pCompound.m_128441_("SummonCool")) {
            this.setSummonCooldown(pCompound.m_128451_("SummonCool"));
        }
        if (pCompound.m_128441_("ShockwaveCool")) {
            this.setShockwaveCooldown(pCompound.m_128451_("ShockwaveCool"));
        }
        if (pCompound.m_128441_("FireHealCool")) {
            this.setFireHealCool(pCompound.m_128451_("FireHealCool"));
        }
        if (pCompound.m_128441_("FleeingCool")) {
            this.setFleeingCool(pCompound.m_128451_("FleeingCool"));
        }
        if (pCompound.m_128441_("ShieldHealth")) {
            this.setShieldHealth(pCompound.m_128457_("ShieldHealth"));
        }
        if (pCompound.m_128441_("FireballDamage")) {
            this.setFireBallDamage(pCompound.m_128457_("FireballDamage"));
        }
    }

    public MobType m_6336_() {
        return ModMobType.NETHER;
    }

    public float m_213856_() {
        return 1.0f;
    }

    @Override
    public int xpReward() {
        return 20;
    }

    @Override
    protected void m_213945_(RandomSource p_217055_, DifficultyInstance p_217056_) {
    }

    @Override
    public Predicate<Entity> summonPredicate() {
        return entity -> entity instanceof Wildfire;
    }

    @Override
    public int getSummonLimit(LivingEntity owner) {
        return (Integer)SpellConfig.WildfireLimit.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.WILDFIRE_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return (SoundEvent)ModSounds.WILDFIRE_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.WILDFIRE_DEATH.get();
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
        this.m_5496_((SoundEvent)ModSounds.WILDFIRE_STEP.get(), 0.3f, 1.0f);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "idle")) {
            return 1;
        }
        if (Objects.equals(animation, "shockwave")) {
            return 2;
        }
        if (Objects.equals(animation, "shoot")) {
            return 3;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.idleAnimationState);
        list.add(this.shockwaveAnimationState);
        list.add(this.shootAnimationState);
        return list;
    }

    public int getCurrentAnimation() {
        return (Integer)this.f_19804_.m_135370_(ANIM_STATE);
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAllAnimations()) {
            state.m_216973_();
        }
    }

    public int getShields() {
        return Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(SHIELDS)), (int)0, (int)4);
    }

    public void setShields(int shields) {
        this.f_19804_.m_135381_(SHIELDS, (Object)shields);
    }

    public float getShieldHealth() {
        return ((Float)this.f_19804_.m_135370_(SHIELD_HEALTH)).floatValue();
    }

    public void setShieldHealth(float shieldHealth) {
        this.f_19804_.m_135381_(SHIELD_HEALTH, (Object)Float.valueOf(Mth.m_14036_((float)shieldHealth, (float)0.0f, (float)((Double)AttributesConfig.WildfireShieldHealth.get()).floatValue())));
    }

    public void healShield(float amount) {
        if (this.getShields() > 0) {
            this.setShieldHealth(this.getShieldHealth() + amount);
        }
    }

    public void breakShield() {
        Level level;
        if (this.getShields() > 0) {
            this.setShields(this.getShields() - 1);
            this.setShieldHealth(((Double)AttributesConfig.WildfireShieldHealth.get()).floatValue());
            this.f_19802_ = 20;
            this.setRegenShieldTick(MathHelper.secondsToTicks(7));
            this.m_5496_((SoundEvent)ModSounds.WILDFIRE_SHIELD_BREAK.get(), 1.2f, 1.0f);
            this.m_5496_((SoundEvent)ModSounds.WILDFIRE_SHIELD_BREAK_VOCAL.get(), 1.2f, 1.0f);
        }
        if ((level = this.f_19853_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ItemParticleOption particleOptions = new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_42585_));
            for (int i = 0; i < 10; ++i) {
                ServerParticleUtil.addParticlesAroundMiddleSelf(serverLevel, (ParticleOptions)particleOptions, (Entity)this);
            }
        }
    }

    public void addShield() {
        if (this.getShields() < 4) {
            this.setShields(this.getShields() + 1);
            this.setShieldHealth(((Double)AttributesConfig.WildfireShieldHealth.get()).floatValue());
            this.setRegenShieldTick(MathHelper.secondsToTicks(7));
            this.m_5496_((SoundEvent)ModSounds.WILDFIRE_SHIELD_REGEN.get(), 2.0f, 1.0f);
        }
    }

    public void setRegenShieldTick(int regenShieldTick) {
        this.regenShieldTick = regenShieldTick;
    }

    public int getRegenShieldTick() {
        return this.regenShieldTick;
    }

    public void setSummonCooldown(int summonCooldown) {
        this.summonCooldown = summonCooldown;
    }

    public int getSummonCooldown() {
        return this.summonCooldown;
    }

    public void setShockwaveCooldown(int shockwaveCooldown) {
        this.shockwaveCooldown = shockwaveCooldown;
    }

    public int getShockwaveCooldown() {
        return this.shockwaveCooldown;
    }

    public void setFireHealCool(int fireHealCool) {
        this.fireHealCool = fireHealCool;
    }

    public int getFireHealCool() {
        return this.fireHealCool;
    }

    public void setFleeingCool(int fleeingCool) {
        this.fleeingCool = fleeingCool;
    }

    public int getFleeingCool() {
        return this.fleeingCool;
    }

    public float getFireBallDamage() {
        return this.extraFireballDamage;
    }

    public void setFireBallDamage(float damage) {
        this.extraFireballDamage = damage;
    }

    public boolean m_6126_() {
        return true;
    }

    public boolean m_142535_(float p_149683_, float p_149684_, DamageSource p_149685_) {
        return false;
    }

    @Override
    public boolean canUpdateMove() {
        return true;
    }

    public boolean canAnimateMove() {
        return this.getCurrentAnimation() != this.getAnimationState(SHOCKWAVE);
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (this.getShields() > 0 && !source.m_269533_(DamageTypeTags.f_268738_) && !this.m_6673_(source)) {
            Entity entity;
            if (source.m_7639_() != null && (entity = source.m_7639_()) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                this.m_6703_(livingEntity);
                if (!source.m_269533_(DamageTypeTags.f_268415_)) {
                    double d0 = livingEntity.m_20185_() - this.m_20185_();
                    double d1 = livingEntity.m_20189_() - this.m_20189_();
                    while (d0 * d0 + d1 * d1 < 1.0E-4) {
                        d0 = (Math.random() - Math.random()) * 0.01;
                        d1 = (Math.random() - Math.random()) * 0.01;
                    }
                    this.m_147240_(0.4f, d0, d1);
                }
            }
            amount = this.m_21161_(source, amount);
            amount = this.m_6515_(source, amount);
            this.setShieldHealth(this.getShieldHealth() - amount);
            if (this.getShieldHealth() <= 0.0f) {
                this.breakShield();
            } else {
                this.m_6677_(source);
            }
            return false;
        }
        if (source.m_269533_(DamageTypeTags.f_268745_) && this.getFireHealCool() <= 0) {
            this.m_5634_(amount);
            this.healShield(amount);
            this.setFireHealCool(10);
            return false;
        }
        return super.m_6469_(source, amount);
    }

    @Override
    public void m_6667_(DamageSource pCause) {
        if (this.getTrueOwner() != null && ((Boolean)MobsConfig.WildfireBlazingHelm.get()).booleanValue()) {
            ItemStack itemStack = new ItemStack((ItemLike)ModItems.BLAZING_HELM.get());
            BlazingHelm.setOwnerName(this.getTrueOwner(), itemStack);
            BlazingHelm.setSummon((Entity)this, itemStack);
            ItemEntity itemEntity = this.m_19983_(itemStack);
            if (itemEntity != null) {
                itemEntity.m_32064_();
            }
        }
        super.m_6667_(pCause);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.m_20096_() && this.m_20184_().f_82480_ < 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
        }
        if (this.f_19853_.f_46443_) {
            this.spinAnimationState.m_216982_(this.f_19797_);
            for (int i = 0; i < 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
                if (!(this.f_19853_.f_46441_.m_188501_() <= 0.25f)) continue;
                this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.BIG_FIRE.get(), this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
        } else {
            LivingEntity follow = null;
            if (this.m_5448_() != null) {
                follow = this.m_5448_();
            } else if (this.getTrueOwner() != null && this.isFollowing()) {
                follow = this.getTrueOwner();
            }
            if (follow != null && (!this.m_20096_() && this.steepDropBelow() || follow.m_20186_() > this.m_20186_() + 3.0 || this.m_20186_() < follow.m_20186_() || (double)this.m_20270_((Entity)follow) >= 16.0)) {
                if (this.m_20186_() < follow.m_20186_() + 5.0) {
                    this.m_20334_(0.0, 0.04, 0.0);
                } else {
                    this.m_20334_(0.0, -0.01, 0.0);
                }
                if (!this.isStaying()) {
                    double x = follow.m_20185_() - this.m_20185_();
                    double y = follow.m_20186_() - this.m_20186_();
                    double z = follow.m_20189_() - this.m_20189_();
                    double d = Math.sqrt(x * x + y * y + z * z);
                    this.m_20256_(this.m_20184_().m_82520_(x / d * 0.2, y / d * 0.2, z / d * 0.2).m_82490_(0.4));
                }
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3(follow.m_20185_(), follow.m_20188_(), follow.m_20189_()));
            }
        }
        if (this.getShields() < 4 && this.getRegenShieldTick() > 0) {
            --this.regenShieldTick;
            if (this.getRegenShieldTick() <= 0) {
                this.addShield();
            }
        }
        if (this.getShields() > 0 && this.getShieldHealth() <= 0.0f) {
            this.breakShield();
        }
        if (this.getSummonCooldown() > 0) {
            --this.summonCooldown;
        }
        if (this.getShockwaveCooldown() > 0) {
            --this.shockwaveCooldown;
        }
        if (this.getFireHealCool() > 0) {
            --this.fireHealCool;
        }
        if (this.getFleeingCool() > 0) {
            --this.fleeingCool;
        }
    }

    public boolean steepDropBelow() {
        boolean blockBeneath = false;
        for (int i = 0; i < 8; ++i) {
            if (this.f_19853_.m_8055_(new BlockPos(this.m_20183_().m_123341_(), this.m_20183_().m_123342_() - i, this.m_20183_().m_123343_())).m_60795_()) continue;
            blockBeneath = true;
        }
        return !blockBeneath;
    }

    @Override
    public void tryKill(Player player) {
        if (this.killChance <= 0) {
            this.warnKill(player);
        } else {
            super.tryKill(player);
        }
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        if (!this.f_19853_.f_46443_) {
            ItemStack itemstack = pPlayer.m_21120_(pHand);
            Item item = itemstack.m_41720_();
            if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner() && (itemstack.m_204117_(Tags.Items.RODS_BLAZE) || item == Items.f_42593_) && this.m_21223_() < this.m_21233_()) {
                if (!pPlayer.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_5496_((SoundEvent)ModSounds.WILDFIRE_AMBIENT.get(), 1.0f, 1.25f);
                float healAmount = 1.0f;
                if (itemstack.m_204117_(Tags.Items.RODS_BLAZE)) {
                    healAmount = 4.0f;
                }
                this.m_5634_(healAmount);
                Level level = this.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    for (int i = 0; i < 7; ++i) {
                        double d0 = this.f_19796_.m_188583_() * 0.02;
                        double d1 = this.f_19796_.m_188583_() * 0.02;
                        double d2 = this.f_19796_.m_188583_() * 0.02;
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.HEAL_EFFECT.get()), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                    }
                }
                pPlayer.m_6674_(pHand);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public class SummonBlazes
    extends Goal {
        public boolean m_8036_() {
            Predicate<Entity> predicate = entity -> {
                BlazeServant blazeServant;
                return entity.m_6084_() && entity instanceof BlazeServant && (blazeServant = (BlazeServant)entity).getTrueOwner() instanceof Wildfire;
            };
            int i = Wildfire.this.f_19853_.m_6443_(LivingEntity.class, Wildfire.this.m_20191_().m_82377_(32.0, 16.0, 32.0), predicate).size();
            return i < 4 && Wildfire.this.getSummonCooldown() <= 0 && Wildfire.this.m_5448_() != null && (double)Wildfire.this.m_5448_().m_20270_((Entity)Wildfire.this) > 10.0;
        }

        public void m_8056_() {
            super.m_8056_();
            Level level = Wildfire.this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i1 = 0; i1 < 1 + serverLevel.f_46441_.m_188503_(1); ++i1) {
                    BlazeServant blazeServant = new BlazeServant((EntityType<? extends Owned>)((EntityType)ModEntityType.BLAZE_SERVANT.get()), (Level)serverLevel);
                    BlockPos blockPos = BlockFinder.SummonFlyingRadius(Wildfire.this.m_20183_(), (LivingEntity)blazeServant, (Level)serverLevel, 3);
                    blazeServant.setTrueOwner((LivingEntity)Wildfire.this);
                    blazeServant.m_20035_(blockPos, Wildfire.this.m_146908_(), Wildfire.this.m_146909_());
                    if (((Boolean)MobsConfig.WildfireSummonsLife.get()).booleanValue()) {
                        blazeServant.setLimitedLife(MobUtil.getSummonLifespan((Level)serverLevel));
                    }
                    blazeServant.m_21530_();
                    blazeServant.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(blockPos), MobSpawnType.MOB_SUMMONED, null, null);
                    if (!serverLevel.m_7967_((Entity)blazeServant)) continue;
                    for (int i = 0; i < serverLevel.f_46441_.m_188503_(10) + 10; ++i) {
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.SUMMON.get()), blazeServant.m_20208_(1.5), blazeServant.m_20187_(), blazeServant.m_20262_(1.5), 0, 0.0, 0.0, 0.0, 1.0);
                    }
                    ColorUtil colorUtil = new ColorUtil(0xFFFFFF);
                    ServerParticleUtil.windShockwaveParticle(serverLevel, colorUtil, 0.1f, 0.1f, 0.05f, -1, blazeServant.m_20182_());
                }
                Wildfire.this.setSummonCooldown(MathHelper.secondsToTicks(7));
            }
        }
    }

    public class ShockwaveAttackGoal
    extends Goal {
        private int attackTime = 0;

        public ShockwaveAttackGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (Wildfire.this.m_5448_() != null && Wildfire.this.getShockwaveCooldown() <= 0 && Wildfire.this.f_19853_.f_46441_.m_188501_() <= 0.4f) {
                return (double)Wildfire.this.m_5448_().m_20270_((Entity)Wildfire.this) <= 4.0;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.attackTime < MathHelper.secondsToTicks(2.4f);
        }

        public void m_8056_() {
            super.m_8056_();
            Wildfire.this.m_216990_((SoundEvent)ModSounds.WILDFIRE_SHOCKWAVE.get());
            Wildfire.this.setAnimationState(SHOCKWAVE);
            Wildfire.this.m_21573_().m_26573_();
            this.attackTime = 0;
        }

        public void m_8041_() {
            this.attackTime = 0;
            Wildfire.this.setAnimationState(0);
            Wildfire.this.setShockwaveCooldown(MathHelper.secondsToTicks(4));
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            Wildfire.this.m_21573_().m_26573_();
            ++this.attackTime;
            if (Wildfire.this.m_5448_() != null) {
                Wildfire.this.m_21563_().m_24960_((Entity)Wildfire.this.m_5448_(), 30.0f, 30.0f);
            }
            if (this.attackTime == 25) {
                this.shockwave();
                Level level = Wildfire.this.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    Vec3 vec3 = Wildfire.this.m_20182_();
                    ColorUtil colorUtil = new ColorUtil(14523414);
                    serverLevel.m_8767_((ParticleOptions)new CircleExplodeParticleOption(colorUtil.red, colorUtil.green, colorUtil.blue, 2.0f, 1), vec3.f_82479_, BlockFinder.moveDownToGround((Entity)Wildfire.this) + 0.5, vec3.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }

        public void shockwave() {
            for (LivingEntity target : Wildfire.this.f_19853_.m_45976_(LivingEntity.class, Wildfire.this.m_20191_().m_82400_(3.0))) {
                if (target == Wildfire.this || MobUtil.areAllies((Entity)Wildfire.this, (Entity)target) || !Wildfire.this.m_7327_((Entity)target)) continue;
                double d0 = target.m_20185_() - Wildfire.this.m_20185_();
                double d1 = target.m_20189_() - Wildfire.this.m_20189_();
                double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
                MobUtil.push((Entity)target, d0 / d2 * 5.0, 0.2, d1 / d2 * 5.0);
            }
        }
    }

    public static class ShootGoal
    extends Goal {
        private final Wildfire mob;
        @Nullable
        private LivingEntity target;
        private int attackTime = -1;

        public ShootGoal(Wildfire mob) {
            this.mob = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity != null && livingentity.m_6084_()) {
                this.target = livingentity;
                float distance = this.mob.m_21223_() <= this.mob.m_21233_() * 0.7f ? 9.0f : 2.0f;
                return this.mob.m_142582_((Entity)this.target) && (this.mob.m_20270_((Entity)this.target) > distance || this.mob.getFleeingCool() > 0);
            }
            return false;
        }

        public boolean m_8045_() {
            float distance = this.mob.m_21223_() <= this.mob.m_21233_() * 0.7f ? 9.0f : 2.0f;
            return this.m_8036_() || this.target != null && this.target.m_6084_() && (this.mob.m_20270_((Entity)this.target) > distance || this.mob.getFleeingCool() > 0) || this.attackTime > 1;
        }

        public void m_8056_() {
            super.m_8056_();
            this.mob.m_5496_((SoundEvent)ModSounds.WILDFIRE_PRE_ATTACK.get(), 1.3f, 1.0f);
        }

        public void m_8041_() {
            this.target = null;
            this.attackTime = -1;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            if (this.attackTime <= 0 && this.target != null && this.target.m_20270_((Entity)this.mob) > 10.0f) {
                this.mob.m_21573_().m_5624_((Entity)this.target, (double)1.3f);
                this.mob.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
            } else {
                this.mob.m_21573_().m_26573_();
                if (this.target != null) {
                    MobUtil.instaLook((Mob)this.mob, (Entity)this.target);
                }
                ++this.attackTime;
                if (this.attackTime >= 1) {
                    this.mob.setAnimationState(SHOOT);
                }
                if (this.attackTime == 5) {
                    float damage = ((Double)AttributesConfig.WildfireRangeDamage.get()).floatValue() + this.mob.getFireBallDamage();
                    Vec3 vector3d = this.mob.m_20252_(1.0f);
                    ShieldDebris fireball = new ShieldDebris(this.mob.f_19853_, (LivingEntity)this.mob, vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_);
                    fireball.m_6686_(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_, 1.0f, 0.0f);
                    fireball.m_5602_((Entity)this.mob);
                    fireball.m_6034_(this.mob.m_20185_() + vector3d.f_82479_ / 2.0, this.mob.m_20188_() - 0.2, this.mob.m_20189_() + vector3d.f_82481_ / 2.0);
                    fireball.setDamage(damage);
                    this.mob.f_19853_.m_7967_((Entity)fireball);
                    this.mob.m_216990_((SoundEvent)ModSounds.WILDFIRE_SHOOT.get());
                }
                if (this.attackTime >= 24) {
                    this.attackTime = 0;
                    this.mob.setAnimationState(0);
                }
            }
        }
    }

    public class SeekFireGoal
    extends MoveToBlockGoal {
        public SeekFireGoal() {
            super((PathfinderMob)Wildfire.this, 1.3, 16);
        }

        public boolean m_8036_() {
            return Wildfire.this.m_21223_() < Wildfire.this.m_21233_() && super.m_8036_();
        }

        protected boolean m_6465_(LevelReader p_25153_, BlockPos p_25154_) {
            BlockState blockstate = p_25153_.m_8055_(p_25154_);
            return blockstate.m_60734_() instanceof BaseFireBlock;
        }
    }

    public class IdleGoal
    extends Goal {
        public IdleGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return Wildfire.this.m_6084_() && !Wildfire.this.isMoving();
        }

        public void m_8041_() {
            super.m_8041_();
            Wildfire.this.setAnimationState(0);
        }

        public void m_8037_() {
            Wildfire.this.setAnimationState(IDLE);
        }
    }
}

