/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.boss.Apostle;
import com.Polarice3.Goety.common.entities.projectiles.ExplosiveProjectile;
import com.Polarice3.Goety.config.MobsConfig;
import com.Polarice3.Goety.utils.ExplosionUtil;
import com.Polarice3.Goety.utils.LootingExplosion;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class NetherMeteor
extends ExplosiveProjectile {
    public NetherMeteor(EntityType<? extends ExplosiveProjectile> type, Level world) {
        super(type, world);
    }

    public NetherMeteor(Level worldIn, double x, double y, double z, double accelX, double accelY, double accelZ) {
        super((EntityType<? extends ExplosiveProjectile>)((EntityType)ModEntityType.NETHER_METEOR.get()), x, y, z, accelX, accelY, accelZ, worldIn);
    }

    public NetherMeteor(Level worldIn, LivingEntity shooter, double accelX, double accelY, double accelZ) {
        super((EntityType<? extends ExplosiveProjectile>)((EntityType)ModEntityType.NETHER_METEOR.get()), shooter, accelX, accelY, accelZ, worldIn);
    }

    @Override
    public void defaultExplosionAndDamage() {
        this.f_19804_.m_135372_(DATA_EXPLOSION, (Object)Float.valueOf(4.0f));
        this.f_19804_.m_135372_(DATA_DAMAGE, (Object)Float.valueOf(6.0f));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        Vec3 vector3d = this.m_20184_();
        double d0 = this.m_20185_() + vector3d.f_82479_;
        double d1 = this.m_20186_() + vector3d.f_82480_;
        double d2 = this.m_20189_() + vector3d.f_82481_;
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, d0 + this.f_19853_.f_46441_.m_188500_() / 2.0, d1 + 0.5, d2 + this.f_19853_.f_46441_.m_188500_() / 2.0, 0.0, 0.0, 0.0);
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d0 + this.f_19853_.f_46441_.m_188500_() / 2.0, d1 + 0.5, d2 + this.f_19853_.f_46441_.m_188500_() / 2.0, 0.0, 0.0, 0.0);
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (!this.f_19853_.f_46443_) {
            Entity entity;
            boolean flag = this.isDangerous();
            Explosion.BlockInteraction interaction = flag ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP;
            ExplosionUtil.lootExplode(this.f_19853_, (Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getExplosionPower(), flag, interaction, LootingExplosion.Mode.LOOT);
            if (((Boolean)MobsConfig.ApocalypseMode.get()).booleanValue() && flag && (entity = this.m_19749_()) instanceof Apostle) {
                Apostle apostle = (Apostle)entity;
                apostle.netherSpreaderUtil.clear();
                for (int i = 0; i < 5; ++i) {
                    int range = Mth.m_14143_((float)this.getExplosionPower());
                    int x = this.f_19796_.m_216339_(-range, range);
                    int y = this.f_19796_.m_216339_(-range, -(range / 2));
                    int z = this.f_19796_.m_216339_(-range, range);
                    BlockPos blockPos = this.m_20183_().m_7495_().m_7918_(x, y, z);
                    apostle.netherSpreaderUtil.addCursors(blockPos, 10);
                }
            }
            this.m_146870_();
        }
    }

    protected void m_5790_(EntityHitResult pResult) {
        super.m_5790_(pResult);
        if (!this.f_19853_.f_46443_) {
            Entity entity = pResult.m_82443_();
            Entity entity1 = this.m_19749_();
            entity.m_6469_(ModDamageSource.hellfire((Entity)this, this.m_19749_()), this.getDamage() + this.getExtraDamage());
            if (entity1 instanceof LivingEntity) {
                this.m_19970_((LivingEntity)entity1, entity);
            }
        }
    }

    @Override
    protected boolean m_5603_(Entity pEntity) {
        Entity entity = this.m_19749_();
        if (entity instanceof IOwned) {
            IOwned owner = (IOwned)entity;
            if (pEntity instanceof IOwned) {
                IOwned entity2 = (IOwned)pEntity;
                if (owner.getTrueOwner() == entity2.getTrueOwner()) {
                    return false;
                }
            }
            if (owner.getTrueOwner() == pEntity) {
                return false;
            }
        }
        if (MobUtil.areAllies(this.m_19749_(), pEntity)) {
            return false;
        }
        return super.m_5603_(pEntity);
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_6128_() {
        return true;
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    protected ParticleOptions m_5967_() {
        return ParticleTypes.f_123755_;
    }

    protected boolean m_5931_() {
        return false;
    }
}

