/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.network.NetworkHooks;

public class Pyroclast
extends ThrowableProjectile {
    public static final EntityDataAccessor<Boolean> DATA_DANGEROUS = SynchedEntityData.m_135353_(Pyroclast.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public float explosionPower = 1.5f;
    public int potency = 0;
    public int flaming = 0;

    public Pyroclast(EntityType<? extends ThrowableProjectile> p_37466_, Level p_37467_) {
        super(p_37466_, p_37467_);
    }

    public Pyroclast(double p_37457_, double p_37458_, double p_37459_, Level p_37460_) {
        super((EntityType)ModEntityType.PYROCLAST.get(), p_37457_, p_37458_, p_37459_, p_37460_);
    }

    public Pyroclast(LivingEntity p_37463_, Level p_37464_) {
        super((EntityType)ModEntityType.PYROCLAST.get(), p_37463_, p_37464_);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_DANGEROUS, (Object)false);
    }

    public boolean isDangerous() {
        return (Boolean)this.f_19804_.m_135370_(DATA_DANGEROUS);
    }

    public void setDangerous(boolean pDangerous) {
        this.f_19804_.m_135381_(DATA_DANGEROUS, (Object)pDangerous);
    }

    public void setExplosionPower(float pExplosionPower) {
        this.explosionPower = pExplosionPower;
    }

    public float getExplosionPower() {
        return this.explosionPower;
    }

    public void setPotency(int potency) {
        this.potency = potency;
    }

    public int getPotency() {
        return this.potency;
    }

    public void setFlaming(int flaming) {
        this.flaming = flaming;
    }

    public int getFlaming() {
        return this.flaming;
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128350_("ExplosionPower", this.getExplosionPower());
        pCompound.m_128405_("Potency", this.getPotency());
        pCompound.m_128405_("Flaming", this.getFlaming());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128425_("ExplosionPower", 99)) {
            this.setExplosionPower(pCompound.m_128457_("ExplosionPower"));
        }
        if (pCompound.m_128441_("Potency")) {
            this.setPotency(pCompound.m_128451_("Potency"));
        }
        if (pCompound.m_128441_("Flaming")) {
            this.setFlaming(pCompound.m_128451_("Flaming"));
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            for (Entity entity : this.f_19853_.m_45976_(Entity.class, this.m_20191_().m_82400_(1.0))) {
                if (!this.m_5603_(entity)) continue;
                this.explode();
                this.hitEntity(entity);
            }
        }
        Vec3 vector3d = this.m_20184_();
        double d0 = this.m_20185_() + vector3d.f_82479_;
        double d1 = this.m_20186_() + vector3d.f_82480_;
        double d2 = this.m_20189_() + vector3d.f_82481_;
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, d0 + this.f_19853_.f_46441_.m_188500_() / 2.0, d1 + 0.5, d2 + this.f_19853_.f_46441_.m_188500_() / 2.0, 0.0, 0.0, 0.0);
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d0 + this.f_19853_.f_46441_.m_188500_() / 2.0, d1 + 0.5, d2 + this.f_19853_.f_46441_.m_188500_() / 2.0, 0.0, 0.0, 0.0);
    }

    public void explode() {
        if (!this.f_19853_.f_46443_) {
            Entity owner = this.m_19749_();
            boolean flag = this.isDangerous();
            if (owner instanceof Player && !((Boolean)SpellConfig.PyroclastGriefing.get()).booleanValue()) {
                flag = false;
            }
            this.f_19853_.m_255391_(owner, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.explosionPower, flag, flag ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE);
            this.m_146870_();
        }
    }

    protected void m_6532_(HitResult pResult) {
        super.m_6532_(pResult);
        this.explode();
    }

    public void hitEntity(Entity entity) {
        Entity entity1 = this.m_19749_();
        float damage = 6.0f;
        if (entity1 instanceof Player) {
            damage = ((Double)SpellConfig.PyroclastDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
        }
        entity.m_6469_(ModDamageSource.modFireball(this.m_19749_(), this.f_19853_), damage + (float)this.potency);
        if (this.flaming != 0) {
            entity.m_20254_(5 * this.flaming);
        }
        if (entity1 instanceof LivingEntity) {
            this.m_19970_((LivingEntity)entity1, entity);
        }
    }

    protected void m_5790_(EntityHitResult pResult) {
        super.m_5790_(pResult);
        if (!this.f_19853_.f_46443_) {
            Entity entity = pResult.m_82443_();
            this.hitEntity(entity);
        }
    }

    protected boolean m_5603_(Entity pEntity) {
        if (this.m_19749_() != null) {
            PartEntity partEntity;
            Projectile projectile;
            if (pEntity == this.m_19749_()) {
                return false;
            }
            if (this.m_19749_().m_20365_(pEntity)) {
                return false;
            }
            if (pEntity instanceof Projectile && (projectile = (Projectile)pEntity).m_19749_() == this.m_19749_()) {
                return false;
            }
            if (MobUtil.areAllies(pEntity, this.m_19749_())) {
                return false;
            }
            if (pEntity instanceof PartEntity && (partEntity = (PartEntity)pEntity).getParent() == pEntity) {
                return false;
            }
            Entity entity = this.m_19749_();
            if (entity instanceof IOwned) {
                IOwned owned = (IOwned)entity;
                if (pEntity instanceof IOwned) {
                    IOwned owned1 = (IOwned)pEntity;
                    if (owned.getTrueOwner() == owned1.getTrueOwner()) {
                        return false;
                    }
                } else if (owned.getTrueOwner() == pEntity) {
                    return false;
                }
            }
        }
        return !pEntity.m_5833_() && pEntity.m_6084_() && pEntity.m_6087_() || this.m_19749_() == null;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

