/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.projectiles.SnarelingGoop;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.Arrays;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class SnarelingShot
extends ThrowableProjectile {
    private final Vec3[] trailPositions = new Vec3[64];
    private int trailPointer = -1;

    public SnarelingShot(EntityType<? extends ThrowableProjectile> p_37466_, Level p_37467_) {
        super(p_37466_, p_37467_);
    }

    public SnarelingShot(double p_37457_, double p_37458_, double p_37459_, Level p_37460_) {
        super((EntityType)ModEntityType.SNARELING_SHOT.get(), p_37457_, p_37458_, p_37459_, p_37460_);
    }

    public SnarelingShot(LivingEntity p_37463_, Level p_37464_) {
        super((EntityType)ModEntityType.SNARELING_SHOT.get(), p_37463_, p_37464_);
    }

    public void m_8119_() {
        super.m_8119_();
        Vec3 vec3 = this.m_20184_();
        double d0 = this.m_20185_() + vec3.f_82479_;
        double d1 = this.m_20186_() + vec3.f_82480_;
        double d2 = this.m_20189_() + vec3.f_82481_;
        ColorUtil colorUtil = new ColorUtil(14611530);
        for (int i = 0; i < 2; ++i) {
            this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.GOO_STAIN.get(), d0 + this.f_19796_.m_188583_() / 2.0, d1 + 0.5 + this.f_19796_.m_188583_() / 2.0, d2 + this.f_19796_.m_188583_() / 2.0, (double)colorUtil.red(), (double)colorUtil.green(), (double)colorUtil.blue());
        }
        Vec3 trailAt = this.m_20182_().m_82520_(0.0, (double)(this.m_20206_() / 2.0f), 0.0);
        if (this.trailPointer == -1) {
            Arrays.fill(this.trailPositions, trailAt);
        }
        if (++this.trailPointer == this.trailPositions.length) {
            this.trailPointer = 0;
        }
        this.trailPositions[this.trailPointer] = trailAt;
    }

    protected void m_6532_(HitResult pResult) {
        super.m_6532_(pResult);
        if (!this.f_19853_.f_46443_) {
            Level level;
            Vec3 vec3 = this.m_20182_();
            if (pResult instanceof EntityHitResult) {
                EntityHitResult entityHitResult = (EntityHitResult)pResult;
                vec3 = entityHitResult.m_82443_().m_20182_();
            }
            if ((level = this.f_19853_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i <= 16; ++i) {
                    ColorUtil colorUtil = new ColorUtil(14611530);
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.GOO_STAIN.get()), this.m_20208_(0.5), this.m_20186_(), this.m_20262_(0.5), 0, (double)colorUtil.red(), (double)colorUtil.green(), (double)colorUtil.blue(), 1.0);
                }
            }
            SnarelingGoop goop = new SnarelingGoop((EntityType)ModEntityType.SNARELING_GOOP.get(), this.f_19853_);
            Entity entity = this.m_19749_();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                goop.setOwner(livingEntity);
            }
            goop.setLifeSpan(MathHelper.secondsToTicks(3));
            goop.m_146884_(vec3);
            this.f_19853_.m_7967_((Entity)goop);
            this.m_146870_();
        }
    }

    protected boolean m_5603_(Entity pEntity) {
        if (this.m_19749_() != null) {
            Mob mob;
            Entity entity = this.m_19749_();
            if (entity instanceof Mob && (mob = (Mob)entity).m_5448_() == pEntity) {
                return super.m_5603_(pEntity);
            }
            if (MobUtil.areAllies(this.m_19749_(), pEntity)) {
                return false;
            }
            if (this.m_19749_() instanceof Enemy && pEntity instanceof Enemy) {
                return false;
            }
            if (pEntity instanceof IOwned) {
                IOwned owned0 = (IOwned)pEntity;
                Entity entity2 = this.m_19749_();
                if (entity2 instanceof IOwned) {
                    IOwned owned1 = (IOwned)entity2;
                    return !MobUtil.ownerStack(owned0, owned1);
                }
            }
        }
        return super.m_5603_(pEntity);
    }

    public Vec3 getTrailPosition(int pointer, float partialTick) {
        if (this.m_213877_()) {
            partialTick = 1.0f;
        }
        int i = this.trailPointer - pointer & 0x3F;
        int j = this.trailPointer - pointer - 1 & 0x3F;
        Vec3 d0 = this.trailPositions[j];
        Vec3 d1 = this.trailPositions[i].m_82546_(d0);
        return d0.m_82549_(d1.m_82490_((double)partialTick));
    }

    public boolean hasTrail() {
        return this.trailPointer != -1;
    }

    protected void m_8097_() {
    }

    public void m_7601_(BlockState p_33796_, Vec3 p_33797_) {
        if (!p_33796_.m_60713_(Blocks.f_50033_)) {
            super.m_7601_(p_33796_, p_33797_);
        }
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

