/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.utils.EntityFinder;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.Tags;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public abstract class SpellEntity
extends Entity
implements OwnableEntity {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.m_135353_(SpellEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<Integer> OWNER_CLIENT_ID = SynchedEntityData.m_135353_(SpellEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Optional<UUID>> TARGET_UNIQUE_ID = SynchedEntityData.m_135353_(SpellEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<Integer> TARGET_CLIENT_ID = SynchedEntityData.m_135353_(SpellEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Float> DATA_EXTRA_DAMAGE = SynchedEntityData.m_135353_(SpellEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public boolean staff = false;

    public SpellEntity(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OWNER_UNIQUE_ID, Optional.empty());
        this.f_19804_.m_135372_(OWNER_CLIENT_ID, (Object)-1);
        this.f_19804_.m_135372_(TARGET_UNIQUE_ID, Optional.empty());
        this.f_19804_.m_135372_(TARGET_CLIENT_ID, (Object)-1);
        this.f_19804_.m_135372_(DATA_EXTRA_DAMAGE, (Object)Float.valueOf(0.0f));
    }

    public void m_7378_(CompoundTag compound) {
        if (compound.m_128441_("Owner")) {
            this.setOwnerId(compound.m_128342_("Owner"));
        }
        if (compound.m_128441_("OwnerClient")) {
            this.setOwnerClientId(compound.m_128451_("OwnerClient"));
        }
        if (compound.m_128403_("Target")) {
            this.setTargetId(compound.m_128342_("Target"));
        }
        if (compound.m_128441_("TargetClient")) {
            this.setTargetClientId(compound.m_128451_("TargetClient"));
        }
        if (compound.m_128441_("ExtraDamage")) {
            this.setExtraDamage(compound.m_128457_("ExtraDamage"));
        }
        if (compound.m_128441_("staff")) {
            this.staff = compound.m_128471_("staff");
        }
    }

    public void m_7380_(CompoundTag compound) {
        if (this.getOwnerId() != null) {
            compound.m_128362_("Owner", this.getOwnerId());
        }
        if (this.getOwnerClientId() > -1) {
            compound.m_128405_("OwnerClient", this.getOwnerClientId());
        }
        if (this.getTargetId() != null) {
            compound.m_128362_("Target", this.getTargetId());
        }
        if (this.getTargetClientId() > -1) {
            compound.m_128405_("TargetClient", this.getTargetClientId());
        }
        compound.m_128350_("ExtraDamage", this.getExtraDamage());
        compound.m_128379_("staff", this.isStaff());
    }

    public void setStaff(boolean staff) {
        this.staff = staff;
    }

    public boolean isStaff() {
        return this.staff;
    }

    @Nullable
    public LivingEntity m_269323_() {
        LivingEntity living;
        Entity entity;
        if (!this.f_19853_.f_46443_) {
            UUID uuid = this.getOwnerId();
            return uuid == null ? null : EntityFinder.getLivingEntityByUuiD(uuid);
        }
        int id = this.getOwnerClientId();
        return id <= -1 ? null : ((entity = this.f_19853_.m_6815_(this.getOwnerClientId())) instanceof LivingEntity ? (living = (LivingEntity)entity) : null);
    }

    @Nullable
    public UUID m_21805_() {
        return this.getOwnerId();
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.f_19804_.m_135381_(OWNER_UNIQUE_ID, Optional.ofNullable(p_184754_1_));
    }

    public int getOwnerClientId() {
        return (Integer)this.f_19804_.m_135370_(OWNER_CLIENT_ID);
    }

    public void setOwnerClientId(int id) {
        this.f_19804_.m_135381_(OWNER_CLIENT_ID, (Object)id);
    }

    @Nullable
    public LivingEntity getTarget() {
        LivingEntity living;
        Entity entity;
        if (!this.f_19853_.f_46443_) {
            UUID uuid = this.getTargetId();
            return uuid == null ? null : EntityFinder.getLivingEntityByUuiD(uuid);
        }
        int id = this.getTargetClientId();
        return id <= -1 ? null : ((entity = this.f_19853_.m_6815_(this.getTargetClientId())) instanceof LivingEntity ? (living = (LivingEntity)entity) : null);
    }

    @Nullable
    public UUID getTargetId() {
        return ((Optional)this.f_19804_.m_135370_(TARGET_UNIQUE_ID)).orElse(null);
    }

    public void setTargetId(@Nullable UUID p_184754_1_) {
        this.f_19804_.m_135381_(TARGET_UNIQUE_ID, Optional.ofNullable(p_184754_1_));
    }

    public int getTargetClientId() {
        return (Integer)this.f_19804_.m_135370_(TARGET_CLIENT_ID);
    }

    public void setTargetClientId(int id) {
        this.f_19804_.m_135381_(TARGET_CLIENT_ID, (Object)id);
    }

    public void setOwner(LivingEntity livingEntity) {
        if (livingEntity != null) {
            this.setOwnerId(livingEntity.m_20148_());
            this.setOwnerClientId(livingEntity.m_19879_());
        }
    }

    public void setTarget(@Nullable LivingEntity livingEntity) {
        if (livingEntity != null) {
            this.setTargetId(livingEntity.m_20148_());
            this.setTargetClientId(livingEntity.m_19879_());
        }
    }

    public float getExtraDamage() {
        return ((Float)this.f_19804_.m_135370_(DATA_EXTRA_DAMAGE)).floatValue();
    }

    public void setExtraDamage(float pDamage) {
        this.f_19804_.m_135381_(DATA_EXTRA_DAMAGE, (Object)Float.valueOf(pDamage));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_269323_() != null && this.m_269323_().m_6095_().m_204039_(Tags.EntityTypes.BOSSES) && this.m_269323_().m_21224_()) {
            this.m_146870_();
        }
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

