/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.client.particles.CircleExplodeParticleOption;
import com.Polarice3.Goety.client.particles.DustCloudParticleOption;
import com.Polarice3.Goety.client.particles.SparkleParticleOption;
import com.Polarice3.Goety.client.particles.VerticalCircleExplodeParticleOption;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.projectiles.SpellEntity;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import com.Polarice3.Goety.utils.SpellExplosion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VoidShock
extends SpellEntity {
    public boolean hasTarget = false;
    public boolean explode = true;
    public double xPower;
    public double yPower;
    public double zPower;
    public double badMath = 1.0;
    public float extraRadius = 0.0f;
    public float baseDamage = ((Double)SpellConfig.VoidShockDamage.get()).floatValue() * ((Integer)SpellConfig.SpellDamageMultiplier.get()).floatValue();
    public int life;
    public int initTime = MathHelper.secondsToTicks(2);
    private Vec3[] trailPositions = new Vec3[64];
    private int trailPointer = -1;

    public VoidShock(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    public VoidShock(LivingEntity owner, LivingEntity target, Level level) {
        this((EntityType)ModEntityType.VOID_SHOCK.get(), level);
        if (owner != null) {
            this.setOwner(owner);
        }
        if (target != null) {
            this.setTarget(target);
        }
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("Explode")) {
            this.setExplode(pCompound.m_128471_("Explode"));
        }
        if (pCompound.m_128441_("BaseDamage")) {
            this.baseDamage = pCompound.m_128457_("BaseDamage");
        }
        if (pCompound.m_128441_("ExtraRadius")) {
            this.setExtraRadius(pCompound.m_128457_("ExtraRadius"));
        }
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("Explode", this.isExplode());
        pCompound.m_128350_("BaseDamage", this.baseDamage);
        pCompound.m_128350_("ExtraRadius", this.getExtraRadius());
    }

    public float getExtraRadius() {
        return this.extraRadius;
    }

    public void setExtraRadius(float radius) {
        this.extraRadius = radius;
    }

    public boolean m_6783_(double p_36966_) {
        double d0 = this.m_20191_().m_82309_() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return p_36966_ < (d0 *= 64.0) * d0;
    }

    public void m_6001_(double p_36984_, double p_36985_, double p_36986_) {
        this.m_20334_(p_36984_, p_36985_, p_36986_);
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            double d0 = Math.sqrt(p_36984_ * p_36984_ + p_36986_ * p_36986_);
            this.m_146922_((float)(Mth.m_14136_((double)p_36984_, (double)p_36986_) * 57.2957763671875));
            this.m_146926_((float)(Mth.m_14136_((double)p_36985_, (double)d0) * 57.2957763671875));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
    }

    public void signalTo(Vec3 vec3, int initTime) {
        double d0 = vec3.f_82479_;
        double d1 = vec3.f_82480_;
        double d2 = vec3.f_82481_;
        double d3 = d0 - this.m_20185_();
        double d4 = d1 - this.m_20186_();
        double d5 = d2 - this.m_20189_();
        this.xPower = d3 * 0.1;
        this.yPower = d4 * 0.1;
        this.zPower = d5 * 0.1;
        this.initTime = initTime;
        this.life = 0;
    }

    public void setPower(Vec3 vec3, int initTime) {
        this.xPower = vec3.f_82479_ * 0.1;
        this.yPower = vec3.f_82480_ * 0.1;
        this.zPower = vec3.f_82481_ * 0.1;
        this.initTime = initTime;
        this.life = 0;
    }

    public void setBaseDamage(float baseDamage) {
        this.baseDamage = baseDamage;
    }

    public void setExplode(boolean explode) {
        this.explode = explode;
    }

    public boolean isExplode() {
        return this.explode;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        Vec3 vec3 = this.m_20184_();
        double d0 = this.m_20185_() + vec3.f_82479_;
        double d1 = this.m_20186_() + vec3.f_82480_;
        double d2 = this.m_20189_() + vec3.f_82481_;
        double d3 = vec3.m_165924_();
        this.m_146926_(MathHelper.lerpRotation(this.f_19860_, (float)(Mth.m_14136_((double)vec3.f_82480_, (double)d3) * 57.2957763671875)));
        this.m_146922_(MathHelper.lerpRotation(this.f_19859_, (float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875)));
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, d0 - vec3.f_82479_ * 0.25 + this.f_19796_.m_188500_() * 0.6 - 0.3, d1 - vec3.f_82480_ * 0.25 - 0.5, d2 - vec3.f_82481_ * 0.25 + this.f_19796_.m_188500_() * 0.6 - 0.3, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        Vec3 trailAt = this.m_20182_().m_82520_(0.0, 0.0, 0.0);
        if (this.trailPointer == -1) {
            Arrays.fill(this.trailPositions, trailAt);
        }
        if (++this.trailPointer == this.trailPositions.length) {
            this.trailPointer = 0;
        }
        this.trailPositions[this.trailPointer] = trailAt;
        ++this.life;
        if (!this.f_19853_.f_46443_) {
            this.m_6034_(d0, d1, d2);
            if (this.life >= this.initTime) {
                HitResult hitresult;
                if (!this.hasTarget) {
                    if (this.getTarget() != null) {
                        LivingEntity target = this.getTarget();
                        double dx = this.m_20185_() - target.m_20185_();
                        double dy = this.m_20186_() - target.m_20186_();
                        double dz = this.m_20189_() - target.m_20189_();
                        double ds = Math.sqrt(dx * dx + dy * dy + dz * dz);
                        double velocity = 5.0;
                        this.xPower = -(dx / ds * velocity * 0.2);
                        this.yPower = -(dy / ds * velocity * 0.2);
                        this.zPower = -(dz / ds * velocity * 0.2);
                        this.hasTarget = true;
                        this.f_19853_.m_7605_((Entity)this, (byte)4);
                        Level level = this.f_19853_;
                        if (level instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            ColorUtil colorUtil = new ColorUtil(0xFFFFFF);
                            Vec3 vec31 = this.m_20182_();
                            serverLevel.m_8767_((ParticleOptions)new SparkleParticleOption(4.0f, colorUtil, 2), vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, 0, 0.0, 0.0, 0.0, 1.0);
                        }
                    } else if (this.m_269323_() != null) {
                        LivingEntity dx = this.m_269323_();
                        if (dx instanceof Mob) {
                            Mob mob = (Mob)dx;
                            if (mob.m_5448_() != null) {
                                this.setTarget(mob.m_5448_());
                            }
                        } else {
                            ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
                            for (Entity entity1 : this.m_9236_().m_45976_(Entity.class, this.m_20191_().m_82400_(16.0))) {
                                PartEntity partEntity;
                                Entity entity;
                                LivingEntity livingEntity = null;
                                if (entity1 instanceof PartEntity && (entity = (partEntity = (PartEntity)entity1).getParent()) instanceof LivingEntity) {
                                    LivingEntity living;
                                    livingEntity = living = (LivingEntity)entity;
                                } else if (entity1 instanceof LivingEntity) {
                                    LivingEntity living;
                                    livingEntity = living = (LivingEntity)entity1;
                                }
                                if (livingEntity == null || !MobUtil.ownedPredicate(this).test(livingEntity)) continue;
                                list.add(livingEntity);
                            }
                            list.sort(Comparator.comparingDouble(arg_0 -> ((VoidShock)this).m_20270_(arg_0)));
                            if (list.stream().findFirst().isPresent()) {
                                LivingEntity livingEntity = (LivingEntity)list.stream().findFirst().get();
                                this.setTarget(livingEntity);
                            }
                        }
                    }
                }
                if (this.f_19853_.m_46749_(this.m_20183_()) && (hitresult = ProjectileUtil.m_278158_((Entity)this, this::canHitEntity)).m_6662_() != HitResult.Type.MISS) {
                    this.onHit(hitresult);
                }
            } else if (this.life <= 20) {
                this.badMath = Math.max(this.badMath - 0.01, 0.0);
                this.xPower *= this.badMath;
                this.yPower *= this.badMath;
                this.zPower *= this.badMath;
            }
            this.m_20334_(this.xPower, this.yPower, this.zPower);
            if (this.life >= this.initTime + MathHelper.secondsToTicks(5)) {
                this.m_146870_();
            }
        } else {
            this.m_20343_(d0, d1, d2);
        }
    }

    protected void onHit(HitResult pResult) {
        Level level;
        if (pResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)pResult;
            if (!this.isExplode()) {
                this.onHitEntity(entityHitResult);
            }
        }
        if ((level = this.f_19853_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.isExplode()) {
                Vec3 vec3 = Vec3.m_82512_((Vec3i)this.m_20183_());
                if (pResult instanceof BlockHitResult) {
                    BlockHitResult blockHitResult = (BlockHitResult)pResult;
                    BlockPos blockpos = blockHitResult.m_82425_().m_121945_(blockHitResult.m_82434_());
                    if (BlockFinder.canBeReplaced((Level)serverLevel, blockpos)) {
                        vec3 = Vec3.m_82512_((Vec3i)blockpos);
                    }
                } else if (pResult instanceof EntityHitResult) {
                    EntityHitResult entityHitResult = (EntityHitResult)pResult;
                    Entity entity1 = entityHitResult.m_82443_();
                    vec3 = Vec3.m_82512_((Vec3i)entity1.m_20183_());
                }
                float damage = this.baseDamage + this.getExtraDamage();
                new SpellExplosion((Level)serverLevel, (Entity)(this.m_269323_() != null ? this.m_269323_() : this), this.m_269291_().m_269104_((Entity)this, (Entity)this.m_269323_()), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1.5f + this.getExtraRadius(), damage){

                    @Override
                    public void explodeHurt(Entity target, DamageSource damageSource, double x, double y, double z, double seen, float actualDamage) {
                        LivingEntity livingEntity;
                        super.explodeHurt(target, damageSource, x, y, z, seen, actualDamage);
                        if (target.f_19853_.m_213780_().m_188501_() <= 0.25f && target instanceof LivingEntity && !(livingEntity = (LivingEntity)target).m_21023_((MobEffect)GoetyEffects.VOID_TOUCHED.get())) {
                            livingEntity.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.VOID_TOUCHED.get(), MathHelper.secondsToTicks(3), 2, false, true));
                        }
                    }
                };
                ColorUtil colorUtil = new ColorUtil(11600856);
                serverLevel.m_8767_((ParticleOptions)new CircleExplodeParticleOption(colorUtil.red, colorUtil.green, colorUtil.blue, 1.5f, 1), vec3.f_82479_, BlockFinder.moveDownToGround(this), vec3.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                serverLevel.m_8767_((ParticleOptions)new CircleExplodeParticleOption(colorUtil.red, colorUtil.green, colorUtil.blue, 3.0f, 1), vec3.f_82479_, BlockFinder.moveDownToGround(this), vec3.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                serverLevel.m_8767_((ParticleOptions)new VerticalCircleExplodeParticleOption(colorUtil.red, colorUtil.green, colorUtil.blue, 1.5f, 1), vec3.f_82479_, BlockFinder.moveDownToGround(this), vec3.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                serverLevel.m_8767_((ParticleOptions)new VerticalCircleExplodeParticleOption(colorUtil.red, colorUtil.green, colorUtil.blue, 3.0f, 1), vec3.f_82479_, BlockFinder.moveDownToGround(this), vec3.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                DustCloudParticleOption cloudParticleOptions = new DustCloudParticleOption(new Vector3f((Vector3fc)Vec3.m_82501_((int)0xFF55FF).m_252839_()), 1.0f);
                for (int i = 0; i < 2; ++i) {
                    ServerParticleUtil.circularParticles(serverLevel, (ParticleOptions)cloudParticleOptions, vec3.f_82479_, this.m_20186_() + 0.25, vec3.f_82481_, 0.0, 0.14, 0.0, 1.0f);
                }
                this.m_5496_((SoundEvent)ModSounds.FUNGUS_EXPLOSION.get(), 1.0f, 0.6f + serverLevel.m_213780_().m_188501_() * 0.4f);
            }
            this.m_146870_();
        }
    }

    protected void onHitEntity(EntityHitResult pResult) {
        if (!this.f_19853_.f_46443_) {
            Entity entity = pResult.m_82443_();
            LivingEntity entity1 = this.m_269323_();
            float damage = this.baseDamage + this.getExtraDamage();
            entity.m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)entity1), damage);
            if (entity1 instanceof LivingEntity) {
                LivingEntity living = entity1;
                this.m_19970_(living, entity);
                if (EntitySelector.f_20406_.test(living) && living.f_19853_.m_213780_().m_188501_() <= 0.25f && !living.m_21023_((MobEffect)GoetyEffects.VOID_TOUCHED.get())) {
                    living.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.VOID_TOUCHED.get(), MathHelper.secondsToTicks(3), 2, false, true));
                }
            }
        }
    }

    public Vec3 getTrailPosition(int pointer, float partialTick) {
        if (this.m_213877_()) {
            partialTick = 1.0f;
        }
        int i = this.trailPointer - pointer & 0x3F;
        int j = this.trailPointer - pointer - 1 & 0x3F;
        Vec3 d0 = this.trailPositions[j];
        Vec3 d1 = this.trailPositions[i].m_82546_(d0);
        return d0.m_82549_(d1.m_82490_((double)partialTick));
    }

    public boolean hasTrail() {
        return this.trailPointer != -1 && this.hasTarget;
    }

    public float m_213856_() {
        return 1.0f;
    }

    public boolean m_6097_() {
        return false;
    }

    public void m_7822_(byte pId) {
        if (pId == 4) {
            this.hasTarget = true;
        } else {
            super.m_7822_(pId);
        }
    }

    protected boolean canHitEntity(Entity pEntity) {
        if (this.m_269323_() != null) {
            SpellEntity spellEntity;
            Projectile projectile;
            Mob mob;
            if (pEntity == this.m_269323_()) {
                return false;
            }
            LivingEntity livingEntity = this.m_269323_();
            if (livingEntity instanceof Mob && (mob = (Mob)livingEntity).m_5448_() == pEntity) {
                return true;
            }
            if (MobUtil.areAllies((Entity)this.m_269323_(), pEntity)) {
                return false;
            }
            if (MobUtil.areAllies(this, pEntity)) {
                return false;
            }
            if (pEntity instanceof Projectile && (projectile = (Projectile)pEntity).m_19749_() == this.m_269323_()) {
                return false;
            }
            if (pEntity instanceof SpellEntity && (spellEntity = (SpellEntity)pEntity).m_269323_() == this.m_269323_()) {
                return false;
            }
            if (pEntity instanceof IOwned) {
                IOwned owned0 = (IOwned)pEntity;
                LivingEntity livingEntity2 = this.m_269323_();
                if (livingEntity2 instanceof IOwned) {
                    IOwned owned1 = (IOwned)livingEntity2;
                    return !MobUtil.ownerStack(owned0, owned1);
                }
            }
        }
        return true;
    }
}

